/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.compression;

import com.sun.j3d.utils.compression.CompressionStreamElement;

class CommandStream {
    static final int SET_NORM = 192;
    static final int SET_COLOR = 128;
    static final int VERTEX = 64;
    static final int MESH_B_R = 32;
    static final int SET_STATE = 24;
    static final int SET_TABLE = 16;
    static final int V_NO_OP = 1;
    static final int POSITION_TABLE = 0;
    static final int COLOR_TABLE = 1;
    static final int NORMAL_TABLE = 2;
    private byte[] bytes;
    private int byteOffset;
    private int bitOffset;
    private long lastBody;
    private int lastBodyLength;

    CommandStream() {
        this(65536);
    }

    CommandStream(int n2) {
        this.bytes = new byte[n2];
        this.clear();
    }

    void clear() {
        this.bytes[0] = 0;
        this.bitOffset = 0;
        this.byteOffset = 0;
        this.lastBody = 0L;
        this.lastBodyLength = 5;
    }

    void addCommand(int n2, int n3, long l2, int n4) {
        this.addByte(n2, n3);
        this.addLong(this.lastBody, this.lastBodyLength);
        this.lastBody = l2;
        this.lastBodyLength = n4;
    }

    private void addByte(int n2, int n3) {
        int n4 = 8 - this.bitOffset;
        n2 &= (int)CompressionStreamElement.lengthMask[n3];
        if (n3 <= n4) {
            int n5 = this.byteOffset;
            this.bytes[n5] = (byte)(this.bytes[n5] | n2 << n4 - n3);
            this.bitOffset += n3;
            return;
        }
        if (this.bytes.length == this.byteOffset + 1) {
            byte[] byArray = new byte[this.bytes.length * 2];
            System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
            this.bytes = byArray;
        }
        this.bitOffset = n3 - n4;
        int n6 = this.byteOffset++;
        this.bytes[n6] = (byte)(this.bytes[n6] | n2 >>> this.bitOffset);
        this.bytes[this.byteOffset] = (byte)(n2 << 8 - this.bitOffset);
    }

    private void addLong(long l2, int n2) {
        int n3 = n2 / 8;
        int n4 = n2 - n3 * 8;
        if (n4 > 0) {
            this.addByte((int)(l2 >>> n3 * 8), n4);
        }
        while (n3 > 0) {
            this.addByte((int)(l2 >>> (n3 - 1) * 8 & 0xFFL), 8);
            --n3;
        }
    }

    void end() {
        int n2;
        this.addByte(1, 8);
        this.addLong(this.lastBody, this.lastBodyLength);
        int n3 = (this.byteOffset + 1) % 8;
        if (n3 == 0 && this.bitOffset == 8) {
            return;
        }
        this.addByte(1, 8);
        n3 = (this.byteOffset + 1) % 8;
        if (n3 == 0) {
            n2 = 8 - this.bitOffset;
        } else {
            int n4 = 8 - n3;
            n2 = 8 * n4 + (8 - this.bitOffset);
        }
        if (n2 < 5) {
            n2 += 64;
        }
        if (n2 < 37) {
            this.addLong(n2 - 5 << n2 - 5, n2);
            return;
        }
        this.addLong(0x980000L, 24);
        n2 -= 24;
        this.addByte(1, 8);
        this.addLong((n2 -= 8) - 5 << n2 - 5, n2);
    }

    int getByteCount() {
        if (this.byteOffset + this.bitOffset == 0) {
            return 0;
        }
        return this.byteOffset + 1;
    }

    byte[] getBytes() {
        return this.bytes;
    }
}

