/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.compression;

import com.sun.j3d.utils.compression.CommandStream;
import com.sun.j3d.utils.compression.HuffmanNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;

class HuffmanTable {
    private static final int MAX_TAG_LENGTH = 6;
    private HuffmanNode[] positions;
    private HuffmanNode[] normals;
    private HuffmanNode[] colors = new HuffmanNode[544];

    HuffmanTable() {
        this.positions = new HuffmanNode[544];
        this.normals = new HuffmanNode[112];
    }

    private final int getPositionIndex(int n2, int n3, boolean bl) {
        return (bl ? 1 : 0) * 272 + n2 * 16 + n3;
    }

    private final int getNormalIndex(int n2, int n3, boolean bl) {
        return (bl ? 1 : 0) * 56 + n2 * 7 + n3;
    }

    private final int getColorIndex(int n2, int n3, boolean bl) {
        return this.getPositionIndex(n2, n3, bl);
    }

    void addPositionEntry(int n2, int n3, boolean bl) {
        this.addEntry(this.positions, this.getPositionIndex(n2, n3, bl), n2, n3, bl);
    }

    HuffmanNode getPositionEntry(int n2, int n3, boolean bl) {
        return this.getEntry(this.positions, this.getPositionIndex(n2, n3, bl));
    }

    void addColorEntry(int n2, int n3, boolean bl) {
        this.addEntry(this.colors, this.getColorIndex(n2, n3, bl), n2, n3, bl);
    }

    HuffmanNode getColorEntry(int n2, int n3, boolean bl) {
        return this.getEntry(this.colors, this.getColorIndex(n2, n3, bl));
    }

    void addNormalEntry(int n2, int n3, boolean bl) {
        this.addEntry(this.normals, this.getNormalIndex(n2, n3, bl), n2, n3, bl);
    }

    HuffmanNode getNormalEntry(int n2, int n3, boolean bl) {
        return this.getEntry(this.normals, this.getNormalIndex(n2, n3, bl));
    }

    private void addEntry(HuffmanNode[] huffmanNodeArray, int n2, int n3, int n4, boolean bl) {
        if (huffmanNodeArray[n2] == null) {
            huffmanNodeArray[n2] = new HuffmanNode(n3, n4, bl);
        } else if (huffmanNodeArray[n2].cleared()) {
            huffmanNodeArray[n2].set(n3, n4, bl);
        }
        huffmanNodeArray[n2].addCount();
    }

    private HuffmanNode getEntry(HuffmanNode[] huffmanNodeArray, int n2) {
        HuffmanNode huffmanNode = huffmanNodeArray[n2];
        while (huffmanNode.merged()) {
            huffmanNode = huffmanNode.getMergeNode();
        }
        return huffmanNode;
    }

    private void getEntries(HuffmanNode[] huffmanNodeArray, Collection collection) {
        for (int i2 = 0; i2 < huffmanNodeArray.length; ++i2) {
            if (huffmanNodeArray[i2] == null || huffmanNodeArray[i2].cleared() || !huffmanNodeArray[i2].hasCount() || huffmanNodeArray[i2].merged()) continue;
            collection.add(huffmanNodeArray[i2]);
        }
    }

    void clear() {
        int n2;
        for (n2 = 0; n2 < this.positions.length; ++n2) {
            if (this.positions[n2] == null) continue;
            this.positions[n2].clear();
        }
        for (n2 = 0; n2 < this.colors.length; ++n2) {
            if (this.colors[n2] == null) continue;
            this.colors[n2].clear();
        }
        for (n2 = 0; n2 < this.normals.length; ++n2) {
            if (this.normals[n2] == null) continue;
            this.normals[n2].clear();
        }
    }

    void computeTags() {
        LinkedList linkedList = new LinkedList();
        this.getEntries(this.positions, linkedList);
        this.computeTags(linkedList, 3);
        linkedList.clear();
        this.getEntries(this.colors, linkedList);
        this.computeTags(linkedList, 3);
        linkedList.clear();
        this.getEntries(this.normals, linkedList);
        this.computeTags(linkedList, 2);
    }

    private void computeTags(LinkedList linkedList, int n2) {
        if (linkedList.isEmpty()) {
            return;
        }
        while (true) {
            Collections.sort(linkedList, HuffmanNode.frequencyComparator);
            HuffmanNode huffmanNode = (HuffmanNode)linkedList.removeFirst();
            while (linkedList.size() > 0) {
                HuffmanNode huffmanNode2 = (HuffmanNode)linkedList.removeFirst();
                HuffmanNode huffmanNode3 = new HuffmanNode();
                huffmanNode3.addChildren(huffmanNode, huffmanNode2);
                this.addNodeInOrder(linkedList, huffmanNode3, HuffmanNode.frequencyComparator);
                huffmanNode = (HuffmanNode)linkedList.removeFirst();
            }
            huffmanNode.collectLeaves(0, 0, linkedList);
            Collections.sort(linkedList, HuffmanNode.tagLengthComparator);
            if (((HuffmanNode)linkedList.getFirst()).tagLength <= 6) break;
            this.merge(linkedList);
        }
        this.expand(linkedList, n2);
    }

    private void merge(LinkedList linkedList) {
        ListIterator<HuffmanNode> listIterator = linkedList.listIterator(0);
        boolean bl = false;
        while (listIterator.hasNext()) {
            HuffmanNode huffmanNode = (HuffmanNode)listIterator.next();
            if (huffmanNode.unmergeable()) continue;
            listIterator.remove();
            while (listIterator.hasNext()) {
                HuffmanNode huffmanNode2 = (HuffmanNode)listIterator.next();
                if (!huffmanNode.mergeInto(huffmanNode2)) continue;
                listIterator.remove();
                while (listIterator.hasNext()) {
                    HuffmanNode huffmanNode3 = (HuffmanNode)listIterator.next();
                    if (!huffmanNode2.tokenEquals(huffmanNode3)) continue;
                    huffmanNode2.mergeInto(huffmanNode3);
                    return;
                }
                listIterator.add(huffmanNode2);
                return;
            }
            huffmanNode.setUnmergeable();
            listIterator.add(huffmanNode);
            listIterator = linkedList.listIterator(0);
        }
    }

    private void expand(LinkedList linkedList, int n2) {
        for (HuffmanNode huffmanNode : linkedList) {
            while (huffmanNode.tagLength + n2 * (huffmanNode.dataLength - huffmanNode.shift) < 6) {
                huffmanNode.incrementLength();
            }
        }
    }

    private void addNodeInOrder(LinkedList linkedList, HuffmanNode huffmanNode, Comparator comparator) {
        ListIterator<HuffmanNode> listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            HuffmanNode huffmanNode2 = (HuffmanNode)listIterator.next();
            if (comparator.compare(huffmanNode2, huffmanNode) <= 0) continue;
            huffmanNode2 = (HuffmanNode)listIterator.previous();
            break;
        }
        listIterator.add(huffmanNode);
    }

    void outputCommands(CommandStream commandStream) {
        LinkedList linkedList = new LinkedList();
        this.getEntries(this.positions, linkedList);
        this.outputCommands(linkedList, commandStream, 0);
        linkedList.clear();
        this.getEntries(this.colors, linkedList);
        this.outputCommands(linkedList, commandStream, 1);
        linkedList.clear();
        this.getEntries(this.normals, linkedList);
        this.outputCommands(linkedList, commandStream, 2);
    }

    private void outputCommands(Collection collection, CommandStream commandStream, int n2) {
        for (HuffmanNode huffmanNode : collection) {
            int n3 = 1 << huffmanNode.tagLength | huffmanNode.tag;
            int n4 = huffmanNode.dataLength == 16 ? 0 : huffmanNode.dataLength;
            int n5 = 0x10 | n2 << 1 | n3 >> 6;
            long l2 = (n3 & 0x3F) << 9 | n4 << 5 | (huffmanNode.absolute ? 16 : 0) | huffmanNode.shift;
            commandStream.addCommand(n5, 8, l2, 15);
        }
    }

    void print(String string, Collection collection) {
        System.out.println(string + "\nentries: " + collection.size() + "\n");
        for (HuffmanNode huffmanNode : collection) {
            System.out.println(huffmanNode.toString() + "\n");
        }
    }

    void print() {
        LinkedList linkedList = new LinkedList();
        this.getEntries(this.positions, linkedList);
        Collections.sort(linkedList, HuffmanNode.frequencyComparator);
        this.print("\nposition tokens and tags", linkedList);
        linkedList.clear();
        this.getEntries(this.colors, linkedList);
        Collections.sort(linkedList, HuffmanNode.frequencyComparator);
        this.print("\ncolor tokens and tags", linkedList);
        linkedList.clear();
        this.getEntries(this.normals, linkedList);
        Collections.sort(linkedList, HuffmanNode.frequencyComparator);
        this.print("\nnormal tokens and tags", linkedList);
    }
}

