/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Numerics;
import com.sun.j3d.utils.geometry.Triangulator;

class BottleNeck {
    BottleNeck() {
    }

    static boolean checkArea(Triangulator triangulator, int n2, int n3) {
        int n4;
        int n5;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n6 = triangulator.fetchData(n2);
        int n7 = triangulator.fetchNextData(n2);
        int n8 = triangulator.fetchData(n7);
        while (n7 != n3) {
            n5 = triangulator.fetchNextData(n7);
            n4 = triangulator.fetchData(n5);
            d2 = Numerics.stableDet2D(triangulator, n6, n8, n4);
            d3 += d2;
            n7 = n5;
            n8 = n4;
        }
        if (Numerics.le(d3, 1.0E-8)) {
            return false;
        }
        n7 = triangulator.fetchNextData(n3);
        n8 = triangulator.fetchData(n7);
        while (n7 != n2) {
            n5 = triangulator.fetchNextData(n7);
            n4 = triangulator.fetchData(n5);
            d2 = Numerics.stableDet2D(triangulator, n6, n8, n4);
            d4 += d2;
            n7 = n5;
            n8 = n4;
        }
        return !Numerics.le(d4, 1.0E-8);
    }

    static boolean checkBottleNeck(Triangulator triangulator, int n2, int n3, int n4, int n5) {
        boolean bl;
        int n6 = n2;
        int n7 = triangulator.fetchPrevData(n5);
        int n8 = triangulator.fetchData(n7);
        if (n8 != n3 && n8 != n4 && (bl = Numerics.pntInTriangle(triangulator, n2, n3, n4, n8))) {
            return true;
        }
        bl = n3 <= n4 ? (n6 <= n8 ? Numerics.segIntersect(triangulator, n3, n4, n6, n8, -1) : Numerics.segIntersect(triangulator, n3, n4, n8, n6, -1)) : (n6 <= n8 ? Numerics.segIntersect(triangulator, n4, n3, n6, n8, -1) : Numerics.segIntersect(triangulator, n4, n3, n8, n6, -1));
        if (bl) {
            return true;
        }
        n7 = triangulator.fetchNextData(n5);
        n8 = triangulator.fetchData(n7);
        if (n8 != n3 && n8 != n4 && (bl = Numerics.pntInTriangle(triangulator, n2, n3, n4, n8))) {
            return true;
        }
        bl = n3 <= n4 ? (n6 <= n8 ? Numerics.segIntersect(triangulator, n3, n4, n6, n8, -1) : Numerics.segIntersect(triangulator, n3, n4, n8, n6, -1)) : (n6 <= n8 ? Numerics.segIntersect(triangulator, n4, n3, n6, n8, -1) : Numerics.segIntersect(triangulator, n4, n3, n8, n6, -1));
        if (bl) {
            return true;
        }
        n7 = triangulator.fetchNextData(n5);
        n8 = triangulator.fetchData(n7);
        while (n7 != n5) {
            if (n6 == n8 && BottleNeck.checkArea(triangulator, n5, n7)) {
                return true;
            }
            n7 = triangulator.fetchNextData(n7);
            n8 = triangulator.fetchData(n7);
        }
        return false;
    }
}

