/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeomBuffer;
import com.sun.j3d.utils.geometry.Primitive;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Vector3f;

public class Box
extends Primitive {
    public static final int FRONT = 0;
    public static final int BACK = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    float xDim;
    float yDim;
    float zDim;
    int numTexUnit = 1;
    private static final float[] verts = new float[]{1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f};
    private static final double[] tcoords = new double[]{1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0};
    private static final Vector3f[] normals = new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f)};

    public Box() {
        this(1.0f, 1.0f, 1.0f, 1, null);
    }

    public Box(float f2, float f3, float f4, Appearance appearance) {
        this(f2, f3, f4, 1, appearance);
    }

    public Box(float f2, float f3, float f4, int n2, Appearance appearance, int n3) {
        this.xDim = f2;
        this.yDim = f3;
        this.zDim = f4;
        this.flags = n2;
        boolean bl = (this.flags & 8) != 0;
        double d2 = (this.flags & 4) != 0 ? -1.0 : 1.0;
        Shape3D[] shape3DArray = new Shape3D[6];
        GeomBuffer geomBuffer = null;
        for (int i2 = 0; i2 <= 5; ++i2) {
            geomBuffer = this.getCachedGeometry(8, f2, f3, f4, i2, i2, n2);
            if (geomBuffer != null) {
                shape3DArray[i2] = new Shape3D(geomBuffer.getComputedGeometry());
                this.numVerts += geomBuffer.getNumVerts();
                this.numTris += geomBuffer.getNumTris();
            } else {
                int n4;
                GeomBuffer geomBuffer2 = new GeomBuffer(4, n3);
                geomBuffer2.begin(1);
                for (n4 = 0; n4 < 2; ++n4) {
                    geomBuffer2.normal3d((double)Box.normals[i2].x * d2, (double)Box.normals[i2].y * d2, (double)Box.normals[i2].z * d2);
                    if (bl) {
                        geomBuffer2.texCoord2d(tcoords[i2 * 8 + n4 * 2], 1.0 - tcoords[i2 * 8 + n4 * 2 + 1]);
                    } else {
                        geomBuffer2.texCoord2d(tcoords[i2 * 8 + n4 * 2], tcoords[i2 * 8 + n4 * 2 + 1]);
                    }
                    geomBuffer2.vertex3d((double)verts[i2 * 12 + n4 * 3] * (double)f2, (double)verts[i2 * 12 + n4 * 3 + 1] * (double)f3, (double)verts[i2 * 12 + n4 * 3 + 2] * (double)f4);
                }
                for (n4 = 3; n4 > 1; --n4) {
                    geomBuffer2.normal3d((double)Box.normals[i2].x * d2, (double)Box.normals[i2].y * d2, (double)Box.normals[i2].z * d2);
                    if (bl) {
                        geomBuffer2.texCoord2d(tcoords[i2 * 8 + n4 * 2], 1.0 - tcoords[i2 * 8 + n4 * 2 + 1]);
                    } else {
                        geomBuffer2.texCoord2d(tcoords[i2 * 8 + n4 * 2], tcoords[i2 * 8 + n4 * 2 + 1]);
                    }
                    geomBuffer2.vertex3d((double)verts[i2 * 12 + n4 * 3] * (double)f2, (double)verts[i2 * 12 + n4 * 3 + 1] * (double)f3, (double)verts[i2 * 12 + n4 * 3 + 2] * (double)f4);
                }
                geomBuffer2.end();
                shape3DArray[i2] = new Shape3D(geomBuffer2.getGeom(this.flags));
                this.numVerts = geomBuffer2.getNumVerts();
                this.numTris = geomBuffer2.getNumTris();
                if ((n2 & 0x10) == 0) {
                    this.cacheGeometry(8, f2, f3, f4, i2, i2, n2, geomBuffer2);
                }
            }
            if ((this.flags & 0x40) != 0) {
                shape3DArray[i2].setCapability(14);
                shape3DArray[i2].setCapability(15);
            }
            if ((this.flags & 0x20) != 0) {
                shape3DArray[i2].setCapability(12);
            }
            this.addChild(shape3DArray[i2]);
        }
        if (appearance == null) {
            this.setAppearance();
        } else {
            this.setAppearance(appearance);
        }
    }

    public Box(float f2, float f3, float f4, int n2, Appearance appearance) {
        this(f2, f3, f4, n2, appearance, 1);
    }

    public Shape3D getShape(int n2) {
        if (n2 >= 0 && n2 <= 5) {
            return (Shape3D)this.getChild(n2);
        }
        return null;
    }

    public void setAppearance(Appearance appearance) {
        ((Shape3D)this.getChild(4)).setAppearance(appearance);
        ((Shape3D)this.getChild(3)).setAppearance(appearance);
        ((Shape3D)this.getChild(2)).setAppearance(appearance);
        ((Shape3D)this.getChild(0)).setAppearance(appearance);
        ((Shape3D)this.getChild(1)).setAppearance(appearance);
        ((Shape3D)this.getChild(5)).setAppearance(appearance);
    }

    public Appearance getAppearance(int n2) {
        if (n2 > 5 || n2 < 0) {
            return null;
        }
        return this.getShape(n2).getAppearance();
    }

    public Node cloneNode(boolean bl) {
        Box box = new Box(this.xDim, this.yDim, this.zDim, this.flags, this.getAppearance());
        box.duplicateNode(this, bl);
        return box;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
    }

    public float getXdimension() {
        return this.xDim;
    }

    public float getYdimension() {
        return this.yDim;
    }

    public float getZdimension() {
        return this.zDim;
    }
}

