/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Triangulator;
import javax.vecmath.Point2f;

class Clean {
    Clean() {
    }

    static void initPUnsorted(Triangulator triangulator, int n2) {
        if (n2 > triangulator.maxNumPUnsorted) {
            triangulator.maxNumPUnsorted = n2;
            triangulator.pUnsorted = new Point2f[triangulator.maxNumPUnsorted];
            for (int i2 = 0; i2 < triangulator.maxNumPUnsorted; ++i2) {
                triangulator.pUnsorted[i2] = new Point2f();
            }
        }
    }

    static int cleanPolyhedralFace(Triangulator triangulator, int n2, int n3) {
        int n4;
        int n5;
        Clean.initPUnsorted(triangulator, triangulator.numPoints);
        for (n5 = 0; n5 < triangulator.numPoints; ++n5) {
            triangulator.pUnsorted[n5].set(triangulator.points[n5]);
        }
        Clean.sort(triangulator.points, triangulator.numPoints);
        n5 = 0;
        for (n4 = 1; n4 < triangulator.numPoints; ++n4) {
            if (Clean.pComp(triangulator.points[n5], triangulator.points[n4]) == 0) continue;
            triangulator.points[++n5] = triangulator.points[n4];
        }
        int n6 = n5 + 1;
        int n7 = triangulator.numPoints - n6;
        for (n5 = n2; n5 < n3; ++n5) {
            int n8 = triangulator.loops[n5];
            int n9 = triangulator.fetchNextData(n8);
            int n10 = triangulator.fetchData(n9);
            while (n9 != n8) {
                n4 = Clean.findPInd(triangulator.points, n6, triangulator.pUnsorted[n10]);
                triangulator.updateIndex(n9, n4);
                n9 = triangulator.fetchNextData(n9);
                n10 = triangulator.fetchData(n9);
            }
            n4 = Clean.findPInd(triangulator.points, n6, triangulator.pUnsorted[n10]);
            triangulator.updateIndex(n9, n4);
        }
        triangulator.numPoints = n6;
        return n7;
    }

    static void sort(Point2f[] point2fArray, int n2) {
        Point2f point2f = new Point2f();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = i2 + 1; i3 < n2; ++i3) {
                if (Clean.pComp(point2fArray[i2], point2fArray[i3]) <= 0) continue;
                point2f.set(point2fArray[i2]);
                point2fArray[i2].set(point2fArray[i3]);
                point2fArray[i3].set(point2f);
            }
        }
    }

    static int findPInd(Point2f[] point2fArray, int n2, Point2f point2f) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (point2f.x != point2fArray[i2].x || point2f.y != point2fArray[i2].y) continue;
            return i2;
        }
        return -1;
    }

    static int pComp(Point2f point2f, Point2f point2f2) {
        if (point2f.x < point2f2.x) {
            return -1;
        }
        if (point2f.x > point2f2.x) {
            return 1;
        }
        if (point2f.y < point2f2.y) {
            return -1;
        }
        if (point2f.y > point2f2.y) {
            return 1;
        }
        return 0;
    }
}

