/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import javax.media.j3d.GeometryArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;

class GeomBuffer {
    static final int QUAD_STRIP = 1;
    static final int TRIANGLES = 2;
    static final int QUADS = 4;
    static final int TRIANGLE_FAN = 16;
    static final int TRIANGLE_STRIP = 32;
    private int flags;
    Point3f[] pts = null;
    Vector3f[] normals = null;
    TexCoord2f[] tcoords = null;
    int currVertCnt;
    int currPrimCnt;
    int[] currPrimType = null;
    int[] currPrimStartVertex = null;
    int[] currPrimEndVertex = null;
    GeometryArray geometry;
    int numVerts = 0;
    int numTris = 0;
    int numTexUnit = 1;
    int[] texCoordSetMap = null;
    static final int debug = 0;

    GeomBuffer(int n2, int n3) {
        this.numTexUnit = n3;
        this.pts = new Point3f[n2];
        this.normals = new Vector3f[n2];
        this.tcoords = new TexCoord2f[n2];
        this.currPrimType = new int[n2 / 3];
        this.currPrimStartVertex = new int[n2 / 3];
        this.currPrimEndVertex = new int[n2 / 3];
        this.currVertCnt = 0;
        this.currPrimCnt = 0;
        this.texCoordSetMap = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            this.texCoordSetMap[i2] = 0;
        }
    }

    GeomBuffer(int n2) {
        this(n2, 1);
    }

    GeometryArray getGeom(int n2) {
        GeometryArray geometryArray = null;
        this.flags = n2;
        this.numTris = 0;
        switch (this.currPrimType[0]) {
            case 2: {
                geometryArray = this.processTriangles();
                break;
            }
            case 4: {
                geometryArray = this.processQuads();
                break;
            }
            case 1: 
            case 32: {
                geometryArray = this.processQuadStrips();
                break;
            }
            case 16: {
                geometryArray = this.processTriangleFan();
            }
        }
        if (geometryArray != null && (this.flags & 0x20) != 0) {
            geometryArray.setCapability(18);
            geometryArray.setCapability(17);
            geometryArray.setCapability(8);
            geometryArray.setCapability(0);
        }
        return geometryArray;
    }

    void begin(int n2) {
        this.currPrimType[this.currPrimCnt] = n2;
        this.currPrimStartVertex[this.currPrimCnt] = this.currVertCnt;
    }

    void end() {
        this.currPrimEndVertex[this.currPrimCnt] = this.currVertCnt;
        ++this.currPrimCnt;
    }

    void vertex3d(double d2, double d3, double d4) {
        this.pts[this.currVertCnt] = new Point3f((float)d2, (float)d3, (float)d4);
        ++this.currVertCnt;
    }

    void normal3d(double d2, double d3, double d4) {
        double d5 = d2 * d2 + d3 * d3 + d4 * d4;
        if (Math.abs(d5 - 1.0) > 0.001) {
            double d6 = Math.sqrt(d5);
            if (d6 > 1.0E-6) {
                d2 /= d6;
                d3 /= d6;
                d4 /= d6;
            } else {
                d4 = 0.0;
                d3 = 0.0;
                d2 = 1.0;
            }
        }
        this.normals[this.currVertCnt] = new Vector3f((float)d2, (float)d3, (float)d4);
    }

    void texCoord2d(double d2, double d3) {
        this.tcoords[this.currVertCnt] = new TexCoord2f((float)d2, (float)d3);
    }

    TexCoord2f[] getTexCoords() {
        return this.tcoords;
    }

    GeometryArray getComputedGeometry() {
        return this.geometry;
    }

    int getNumTris() {
        return this.numTris;
    }

    int getNumVerts() {
        return this.numVerts;
    }

    private GeometryArray processQuadStrips() {
        int n2;
        TriangleStripArray triangleStripArray = null;
        int n3 = 0;
        int[] nArray = new int[this.currPrimCnt];
        for (n2 = 0; n2 < this.currPrimCnt; ++n2) {
            nArray[n2] = this.currPrimEndVertex[n2] - this.currPrimStartVertex[n2];
            n3 += nArray[n2];
        }
        int n4 = 1;
        if ((this.flags & 1) != 0) {
            n4 |= 2;
        }
        if ((this.flags & 2) != 0) {
            n4 |= 0x20;
        }
        triangleStripArray = new TriangleStripArray(n3, n4, 1, this.texCoordSetMap, nArray);
        Point3f[] point3fArray = new Point3f[n3];
        Vector3f[] vector3fArray = new Vector3f[n3];
        TexCoord2f[] texCoord2fArray = new TexCoord2f[n3];
        int n5 = 0;
        for (n2 = 0; n2 < this.currPrimCnt; ++n2) {
            for (int i2 = this.currPrimStartVertex[n2]; i2 < this.currPrimEndVertex[n2]; ++i2) {
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n5++, this.pts, this.normals, this.tcoords, i2);
            }
        }
        this.numVerts = n5;
        this.numTris += n3 - this.currPrimCnt * 2;
        triangleStripArray.setCoordinates(0, point3fArray);
        if ((this.flags & 1) != 0) {
            triangleStripArray.setNormals(0, vector3fArray);
        }
        if ((this.flags & 2) != 0) {
            triangleStripArray.setTextureCoordinates(0, 0, texCoord2fArray);
        }
        this.geometry = triangleStripArray;
        return triangleStripArray;
    }

    private GeometryArray processQuads() {
        int n2;
        QuadArray quadArray = null;
        int n3 = 0;
        for (n2 = 0; n2 < this.currPrimCnt; ++n2) {
            n3 += this.currPrimEndVertex[n2] - this.currPrimStartVertex[n2];
        }
        quadArray = (this.flags & 1) != 0 && (this.flags & 2) != 0 ? new QuadArray(n3, 35, 1, this.texCoordSetMap) : ((this.flags & 1) == 0 && (this.flags & 2) != 0 ? new QuadArray(n3, 33, 1, this.texCoordSetMap) : ((this.flags & 1) != 0 && (this.flags & 2) == 0 ? new QuadArray(n3, 3) : new QuadArray(n3, 1)));
        Point3f[] point3fArray = new Point3f[n3];
        Vector3f[] vector3fArray = new Vector3f[n3];
        TexCoord2f[] texCoord2fArray = new TexCoord2f[n3];
        int n4 = 0;
        for (n2 = 0; n2 < this.currPrimCnt; ++n2) {
            for (int i2 = this.currPrimStartVertex[n2]; i2 < this.currPrimEndVertex[n2] - 3; i2 += 4) {
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n4++, this.pts, this.normals, this.tcoords, i2);
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n4++, this.pts, this.normals, this.tcoords, i2 + 1);
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n4++, this.pts, this.normals, this.tcoords, i2 + 2);
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n4++, this.pts, this.normals, this.tcoords, i2 + 3);
                this.numTris += 2;
            }
        }
        this.numVerts = n4;
        quadArray.setCoordinates(0, point3fArray);
        if ((this.flags & 1) != 0) {
            quadArray.setNormals(0, vector3fArray);
        }
        if ((this.flags & 2) != 0) {
            quadArray.setTextureCoordinates(0, 0, texCoord2fArray);
        }
        this.geometry = quadArray;
        return quadArray;
    }

    private GeometryArray processTriangles() {
        int n2;
        TriangleArray triangleArray = null;
        int n3 = 0;
        for (n2 = 0; n2 < this.currPrimCnt; ++n2) {
            n3 += this.currPrimEndVertex[n2] - this.currPrimStartVertex[n2];
        }
        triangleArray = (this.flags & 1) != 0 && (this.flags & 2) != 0 ? new TriangleArray(n3, 35, 1, this.texCoordSetMap) : ((this.flags & 1) == 0 && (this.flags & 2) != 0 ? new TriangleArray(n3, 33, 1, this.texCoordSetMap) : ((this.flags & 1) != 0 && (this.flags & 2) == 0 ? new TriangleArray(n3, 3) : new TriangleArray(n3, 1)));
        Point3f[] point3fArray = new Point3f[n3];
        Vector3f[] vector3fArray = new Vector3f[n3];
        TexCoord2f[] texCoord2fArray = new TexCoord2f[n3];
        int n4 = 0;
        for (n2 = 0; n2 < this.currPrimCnt; ++n2) {
            for (int i2 = this.currPrimStartVertex[n2]; i2 < this.currPrimEndVertex[n2] - 2; i2 += 3) {
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n4++, this.pts, this.normals, this.tcoords, i2);
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n4++, this.pts, this.normals, this.tcoords, i2 + 1);
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n4++, this.pts, this.normals, this.tcoords, i2 + 2);
                ++this.numTris;
            }
        }
        this.numVerts = n4;
        triangleArray.setCoordinates(0, point3fArray);
        if ((this.flags & 1) != 0) {
            triangleArray.setNormals(0, vector3fArray);
        }
        if ((this.flags & 2) != 0) {
            triangleArray.setTextureCoordinates(0, 0, texCoord2fArray);
        }
        this.geometry = triangleArray;
        return triangleArray;
    }

    private GeometryArray processTriangleFan() {
        int n2;
        TriangleFanArray triangleFanArray = null;
        int n3 = 0;
        int[] nArray = new int[this.currPrimCnt];
        for (n2 = 0; n2 < this.currPrimCnt; ++n2) {
            nArray[n2] = this.currPrimEndVertex[n2] - this.currPrimStartVertex[n2];
            n3 += nArray[n2];
        }
        int n4 = 1;
        if ((this.flags & 1) != 0) {
            n4 |= 2;
        }
        if ((this.flags & 2) != 0) {
            n4 |= 0x20;
        }
        triangleFanArray = new TriangleFanArray(n3, n4, 1, this.texCoordSetMap, nArray);
        Point3f[] point3fArray = new Point3f[n3];
        Vector3f[] vector3fArray = new Vector3f[n3];
        TexCoord2f[] texCoord2fArray = new TexCoord2f[n3];
        int n5 = 0;
        for (n2 = 0; n2 < this.currPrimCnt; ++n2) {
            for (int i2 = this.currPrimStartVertex[n2]; i2 < this.currPrimEndVertex[n2]; ++i2) {
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n5++, this.pts, this.normals, this.tcoords, i2);
            }
        }
        for (n2 = 0; n2 < point3fArray.length; ++n2) {
        }
        this.numVerts = n5;
        this.numTris = n3 - this.currPrimCnt * 2;
        triangleFanArray.setCoordinates(0, point3fArray);
        if ((this.flags & 1) != 0) {
            triangleFanArray.setNormals(0, vector3fArray);
        }
        if ((this.flags & 2) != 0) {
            triangleFanArray.setTextureCoordinates(0, 0, texCoord2fArray);
        }
        this.geometry = triangleFanArray;
        return triangleFanArray;
    }

    void outVertex(Point3f[] point3fArray, Vector3f[] vector3fArray, TexCoord2f[] texCoord2fArray, int n2, Point3f[] point3fArray2, Vector3f[] vector3fArray2, TexCoord2f[] texCoord2fArray2, int n3) {
        point3fArray[n2] = new Point3f(point3fArray2[n3]);
        if ((this.flags & 1) != 0) {
            vector3fArray[n2] = new Vector3f(vector3fArray2[n3]);
        }
        if ((this.flags & 2) != 0) {
            texCoord2fArray[n2] = new TexCoord2f(texCoord2fArray2[n3]);
        }
    }
}

