/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.internal.BufferWrapper;
import com.sun.j3d.internal.ByteBufferWrapper;
import com.sun.j3d.internal.DoubleBufferWrapper;
import com.sun.j3d.internal.FloatBufferWrapper;
import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.geometry.GeometryInfo;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryStripArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.QuadArray;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.TexCoord4f;
import javax.vecmath.Vector3f;

class GeometryInfoGenerator {
    GeometryInfoGenerator() {
    }

    public static void create(GeometryInfo geometryInfo, GeometryArray geometryArray) {
        if (geometryArray instanceof GeometryStripArray) {
            GeometryInfoGenerator.create(geometryInfo, (GeometryStripArray)geometryArray);
        } else if (geometryArray instanceof TriangleArray) {
            geometryInfo.reset(1);
            GeometryInfoGenerator.processGeometryArray(geometryInfo, geometryArray);
        } else if (geometryArray instanceof QuadArray) {
            geometryInfo.reset(2);
            GeometryInfoGenerator.processGeometryArray(geometryInfo, geometryArray);
        } else if (geometryArray instanceof IndexedGeometryArray) {
            GeometryInfoGenerator.create(geometryInfo, (IndexedGeometryArray)geometryArray);
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfoGenerator0"));
        }
    }

    private static void create(GeometryInfo geometryInfo, GeometryStripArray geometryStripArray) {
        if (geometryStripArray instanceof TriangleFanArray) {
            geometryInfo.reset(3);
        } else if (geometryStripArray instanceof TriangleStripArray) {
            geometryInfo.reset(4);
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfoGenerator0"));
        }
        GeometryInfoGenerator.processGeometryArray(geometryInfo, geometryStripArray);
        GeometryInfoGenerator.processStripArray(geometryInfo, geometryStripArray);
    }

    private static void create(GeometryInfo geometryInfo, IndexedGeometryArray indexedGeometryArray) {
        if (indexedGeometryArray instanceof IndexedQuadArray) {
            geometryInfo.reset(2);
        } else if (indexedGeometryArray instanceof IndexedTriangleArray) {
            geometryInfo.reset(1);
        } else if (indexedGeometryArray instanceof IndexedTriangleFanArray) {
            geometryInfo.reset(3);
            GeometryInfoGenerator.processIndexStripArray(geometryInfo, (IndexedGeometryStripArray)indexedGeometryArray);
        } else if (indexedGeometryArray instanceof IndexedTriangleStripArray) {
            geometryInfo.reset(4);
            GeometryInfoGenerator.processIndexStripArray(geometryInfo, (IndexedGeometryStripArray)indexedGeometryArray);
        }
        GeometryInfoGenerator.processGeometryArray(geometryInfo, indexedGeometryArray);
        GeometryInfoGenerator.processIndexedArray(geometryInfo, indexedGeometryArray);
    }

    private static void processGeometryArray(GeometryInfo geometryInfo, GeometryArray geometryArray) {
        block153: {
            Object[] objectArray;
            Object object;
            Object object2;
            boolean bl;
            boolean bl2;
            int n2;
            int n3;
            int n4;
            int n5;
            block161: {
                Color3f[] color3fArray;
                block164: {
                    int n6;
                    block162: {
                        block163: {
                            block157: {
                                Color4f[] color4fArray;
                                block160: {
                                    int n7;
                                    block158: {
                                        block159: {
                                            Point3f[] point3fArray;
                                            block156: {
                                                int n8;
                                                block154: {
                                                    Object[] objectArray2;
                                                    block155: {
                                                        block152: {
                                                            int n9;
                                                            Cloneable[] cloneableArray;
                                                            float[] fArray;
                                                            Cloneable[] cloneableArray2;
                                                            n5 = geometryArray.getVertexFormat();
                                                            n4 = geometryArray.getTexCoordSetCount();
                                                            if (geometryArray instanceof GeometryStripArray) {
                                                                GeometryStripArray geometryStripArray = (GeometryStripArray)geometryArray;
                                                                int[] nArray = new int[geometryStripArray.getNumStrips()];
                                                                geometryStripArray.getStripVertexCounts(nArray);
                                                                n3 = 0;
                                                                for (n2 = 0; n2 < nArray.length; ++n2) {
                                                                    n3 += nArray[n2];
                                                                }
                                                            } else {
                                                                n3 = geometryArray instanceof IndexedGeometryArray ? geometryArray.getVertexCount() : geometryArray.getValidVertexCount();
                                                            }
                                                            if ((n5 & 0x100) == 0) break block152;
                                                            int n10 = 3;
                                                            if ((n5 & 2) != 0) {
                                                                n10 += 3;
                                                            }
                                                            if ((n5 & 0xC) == 12) {
                                                                n10 += 4;
                                                            } else if ((n5 & 4) != 0) {
                                                                n10 += 3;
                                                            }
                                                            if ((n5 & 0x20) != 0) {
                                                                n10 += 2 * n4;
                                                            } else if ((n5 & 0x40) != 0) {
                                                                n10 += 3 * n4;
                                                            } else if ((n5 & 0x400) != 0) {
                                                                n10 += 4 * n4;
                                                            }
                                                            int n11 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                                                            if ((n5 & 0x800) != 0) {
                                                                J3DBuffer j3DBuffer = geometryArray.getInterleavedVertexBuffer();
                                                                cloneableArray2 = new FloatBufferWrapper(j3DBuffer);
                                                                fArray = new float[cloneableArray2.limit()];
                                                                cloneableArray2.position(0);
                                                                cloneableArray2.get(fArray);
                                                            } else {
                                                                fArray = geometryArray.getInterleavedVertices();
                                                            }
                                                            int n12 = 0;
                                                            if ((n5 & 0x20) != 0) {
                                                                geometryInfo.setTextureCoordinateParams(n4, 2);
                                                                cloneableArray2 = (Cloneable[])new int[geometryArray.getTexCoordSetMapLength()];
                                                                geometryArray.getTexCoordSetMap((int[])cloneableArray2);
                                                                geometryInfo.setTexCoordSetMap((int[])cloneableArray2);
                                                                for (n2 = 0; n2 < n4; ++n2) {
                                                                    cloneableArray = new TexCoord2f[n3];
                                                                    for (n9 = 0; n9 < n3; ++n9) {
                                                                        cloneableArray[n9] = new TexCoord2f(fArray[n10 * (n9 + n11) + n12], fArray[n10 * (n9 + n11) + n12 + 1]);
                                                                    }
                                                                    geometryInfo.setTextureCoordinates(n2, (TexCoord2f[])cloneableArray);
                                                                    n12 += 2;
                                                                }
                                                            } else if ((n5 & 0x40) != 0) {
                                                                geometryInfo.setTextureCoordinateParams(n4, 3);
                                                                cloneableArray2 = (Cloneable[])new int[geometryArray.getTexCoordSetMapLength()];
                                                                geometryArray.getTexCoordSetMap((int[])cloneableArray2);
                                                                geometryInfo.setTexCoordSetMap((int[])cloneableArray2);
                                                                for (n2 = 0; n2 < n4; ++n2) {
                                                                    cloneableArray = new TexCoord3f[n3];
                                                                    for (n9 = 0; n9 < n3; ++n9) {
                                                                        cloneableArray[n9] = new TexCoord3f(fArray[n10 * (n9 + n11) + n12], fArray[n10 * (n9 + n11) + n12 + 1], fArray[n10 * (n9 + n11) + n12 + 2]);
                                                                    }
                                                                    geometryInfo.setTextureCoordinates(n2, (TexCoord3f[])cloneableArray);
                                                                    n12 += 3;
                                                                }
                                                            } else if ((n5 & 0x400) != 0) {
                                                                geometryInfo.setTextureCoordinateParams(n4, 4);
                                                                cloneableArray2 = (Cloneable[])new int[geometryArray.getTexCoordSetMapLength()];
                                                                geometryArray.getTexCoordSetMap((int[])cloneableArray2);
                                                                geometryInfo.setTexCoordSetMap((int[])cloneableArray2);
                                                                for (n2 = 0; n2 < n4; ++n2) {
                                                                    cloneableArray = new TexCoord4f[n3];
                                                                    for (n9 = 0; n9 < n3; ++n9) {
                                                                        cloneableArray[n9] = new TexCoord4f(fArray[n10 * (n9 + n11) + n12], fArray[n10 * (n9 + n11) + n12 + 1], fArray[n10 * (n9 + n11) + n12 + 2], fArray[n10 * (n9 + n11) + n12 + 3]);
                                                                    }
                                                                    geometryInfo.setTextureCoordinates(n2, (TexCoord4f[])cloneableArray);
                                                                    n12 += 4;
                                                                }
                                                            }
                                                            if ((n5 & 0xC) == 12) {
                                                                cloneableArray2 = new Color4f[n3];
                                                                for (n2 = 0; n2 < n3; ++n2) {
                                                                    cloneableArray2[n2] = new Color4f(fArray[n10 * (n2 + n11) + n12], fArray[n10 * (n2 + n11) + n12 + 1], fArray[n10 * (n2 + n11) + n12 + 2], fArray[n10 * (n2 + n11) + n12 + 3]);
                                                                }
                                                                geometryInfo.setColors((Color4f[])cloneableArray2);
                                                                n12 += 4;
                                                            } else if ((n5 & 4) != 0) {
                                                                cloneableArray2 = new Color3f[n3];
                                                                for (n2 = 0; n2 < n3; ++n2) {
                                                                    cloneableArray2[n2] = new Color3f(fArray[n10 * (n2 + n11) + n12], fArray[n10 * (n2 + n11) + n12 + 1], fArray[n10 * (n2 + n11) + n12 + 2]);
                                                                }
                                                                geometryInfo.setColors((Color3f[])cloneableArray2);
                                                                n12 += 3;
                                                            }
                                                            if ((n5 & 2) != 0) {
                                                                cloneableArray2 = new Vector3f[n3];
                                                                for (n2 = 0; n2 < n3; ++n2) {
                                                                    cloneableArray2[n2] = new Vector3f(fArray[n10 * (n2 + n11) + n12], fArray[n10 * (n2 + n11) + n12 + 1], fArray[n10 * (n2 + n11) + n12 + 2]);
                                                                }
                                                                geometryInfo.setNormals((Vector3f[])cloneableArray2);
                                                                n12 += 3;
                                                            }
                                                            cloneableArray2 = new Point3f[n3];
                                                            for (n2 = 0; n2 < n3; ++n2) {
                                                                cloneableArray2[n2] = new Point3f(fArray[n10 * (n2 + n11) + n12], fArray[n10 * (n2 + n11) + n12 + 1], fArray[n10 * (n2 + n11) + n12 + 2]);
                                                            }
                                                            geometryInfo.setCoordinates((Point3f[])cloneableArray2);
                                                            break block153;
                                                        }
                                                        bl2 = (n5 & 0x80) != 0;
                                                        bl = (n5 & 0x800) != 0;
                                                        point3fArray = null;
                                                        if (!bl2) break block154;
                                                        n8 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialCoordIndex() : 0;
                                                        if (!bl) break block155;
                                                        objectArray2 = geometryArray.getCoordRefBuffer();
                                                        switch (BufferWrapper.getBufferType((J3DBuffer)objectArray2)) {
                                                            case 3: {
                                                                object2 = new FloatBufferWrapper((J3DBuffer)objectArray2);
                                                                object = new float[n3 * 3];
                                                                object2.position(n8 * 3);
                                                                object2.get((float[])object, 0, n3 * 3);
                                                                point3fArray = new Point3f[n3];
                                                                for (n2 = 0; n2 < n3; ++n2) {
                                                                    point3fArray[n2] = new Point3f((float)object[n2 * 3 + 0], (float)object[n2 * 3 + 1], (float)object[n2 * 3 + 2]);
                                                                }
                                                                break block156;
                                                            }
                                                            case 4: {
                                                                object2 = new DoubleBufferWrapper((J3DBuffer)objectArray2);
                                                                object = new double[n3 * 3];
                                                                object2.position(n8 * 3);
                                                                object2.get((double[])object, 0, n3 * 3);
                                                                point3fArray = new Point3f[n3];
                                                                for (n2 = 0; n2 < n3; ++n2) {
                                                                    point3fArray[n2] = new Point3f((float)object[n2 * 3 + 0], (float)object[n2 * 3 + 1], (float)object[n2 * 3 + 2]);
                                                                }
                                                                break;
                                                            }
                                                        }
                                                        break block156;
                                                    }
                                                    if (geometryArray.getCoordRef3f() != null) {
                                                        if (n8 != 0) {
                                                            objectArray2 = geometryArray.getCoordRef3f();
                                                            point3fArray = new Point3f[n3];
                                                            for (n2 = 0; n2 < n3; ++n2) {
                                                                point3fArray[n2] = new Point3f((Point3f)objectArray2[n2 + n8]);
                                                            }
                                                        } else {
                                                            point3fArray = geometryArray.getCoordRef3f();
                                                        }
                                                    } else if (geometryArray.getCoordRef3d() != null) {
                                                        objectArray2 = geometryArray.getCoordRef3d();
                                                        point3fArray = new Point3f[n3];
                                                        for (n2 = 0; n2 < n3; ++n2) {
                                                            point3fArray[n2] = new Point3f((Point3d)objectArray2[n2 + n8]);
                                                        }
                                                    } else if (geometryArray.getCoordRefFloat() != null) {
                                                        objectArray2 = geometryArray.getCoordRefFloat();
                                                        point3fArray = new Point3f[n3];
                                                        for (n2 = 0; n2 < n3; ++n2) {
                                                            point3fArray[n2] = new Point3f((float)objectArray2[(n2 + n8) * 3], (float)objectArray2[(n2 + n8) * 3 + 1], (float)objectArray2[(n2 + n8) * 3 + 2]);
                                                        }
                                                    } else if (geometryArray.getCoordRefDouble() != null) {
                                                        objectArray2 = geometryArray.getCoordRefDouble();
                                                        point3fArray = new Point3f[n3];
                                                        for (n2 = 0; n2 < n3; ++n2) {
                                                            point3fArray[n2] = new Point3f((float)objectArray2[(n2 + n8) * 3], (float)objectArray2[(n2 + n8) * 3 + 1], (float)objectArray2[(n2 + n8) * 3 + 2]);
                                                        }
                                                    }
                                                    break block156;
                                                }
                                                n8 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                                                point3fArray = new Point3f[n3];
                                                for (n2 = 0; n2 < n3; ++n2) {
                                                    point3fArray[n2] = new Point3f();
                                                }
                                                geometryArray.getCoordinates(n8, point3fArray);
                                            }
                                            geometryInfo.setCoordinates(point3fArray);
                                            if ((n5 & 2) != 0) {
                                                int n13;
                                                Vector3f[] vector3fArray = null;
                                                if (bl2) {
                                                    n13 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialNormalIndex() : 0;
                                                    if (bl) {
                                                        object2 = geometryArray.getNormalRefBuffer();
                                                        if (BufferWrapper.getBufferType((J3DBuffer)object2) == 3) {
                                                            object = new FloatBufferWrapper((J3DBuffer)object2);
                                                            objectArray = new float[n3 * 3];
                                                            ((BufferWrapper)object).position(n13 * 3);
                                                            ((FloatBufferWrapper)object).get((float[])objectArray, 0, n3 * 3);
                                                            vector3fArray = new Vector3f[n3];
                                                            for (n2 = 0; n2 < n3; ++n2) {
                                                                vector3fArray[n2] = new Vector3f(objectArray[n2 * 3 + 0], objectArray[n2 * 3 + 1], objectArray[n2 * 3 + 2]);
                                                            }
                                                        }
                                                    } else if (geometryArray.getNormalRef3f() != null) {
                                                        if (n13 != 0) {
                                                            object2 = geometryArray.getNormalRef3f();
                                                            vector3fArray = new Vector3f[n3];
                                                            for (n2 = 0; n2 < n3; ++n2) {
                                                                vector3fArray[n2] = new Vector3f(object2[n2 + n13]);
                                                            }
                                                        } else {
                                                            vector3fArray = geometryArray.getNormalRef3f();
                                                        }
                                                    } else if (geometryArray.getNormalRefFloat() != null) {
                                                        object2 = geometryArray.getNormalRefFloat();
                                                        vector3fArray = new Vector3f[n3];
                                                        for (n2 = 0; n2 < n3; ++n2) {
                                                            vector3fArray[n2] = new Vector3f((float)object2[(n2 + n13) * 3], (float)object2[(n2 + n13) * 3 + 1], (float)object2[(n2 + n13) * 3 + 2]);
                                                        }
                                                    }
                                                } else {
                                                    n13 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                                                    vector3fArray = new Vector3f[n3];
                                                    for (n2 = 0; n2 < n3; ++n2) {
                                                        vector3fArray[n2] = new Vector3f();
                                                    }
                                                    geometryArray.getNormals(n13, vector3fArray);
                                                }
                                                geometryInfo.setNormals(vector3fArray);
                                            }
                                            if ((n5 & 0xC) != 12) break block157;
                                            color4fArray = null;
                                            if (!bl2) break block158;
                                            n7 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialColorIndex() : 0;
                                            if (!bl) break block159;
                                            object2 = geometryArray.getColorRefBuffer();
                                            switch (BufferWrapper.getBufferType((J3DBuffer)object2)) {
                                                case 3: {
                                                    object = new FloatBufferWrapper((J3DBuffer)object2);
                                                    objectArray = new float[n3 * 4];
                                                    ((BufferWrapper)object).position(n7 * 4);
                                                    ((FloatBufferWrapper)object).get((float[])objectArray, 0, n3 * 4);
                                                    color4fArray = new Color4f[n3];
                                                    for (n2 = 0; n2 < n3; ++n2) {
                                                        color4fArray[n2] = new Color4f(objectArray[n2 * 4 + 0], objectArray[n2 * 4 + 1], objectArray[n2 * 4 + 2], objectArray[n2 * 4 + 3]);
                                                    }
                                                    break block160;
                                                }
                                                case 2: {
                                                    object = new ByteBufferWrapper((J3DBuffer)object2);
                                                    objectArray = new byte[n3 * 4];
                                                    ((BufferWrapper)object).position(n7 * 4);
                                                    ((ByteBufferWrapper)object).get((byte[])objectArray, 0, n3 * 4);
                                                    color4fArray = new Color4f[n3];
                                                    for (n2 = 0; n2 < n3; ++n2) {
                                                        color4fArray[n2] = new Color4f((float)(objectArray[n2 * 4 + 0] & 0xFF) / 255.0f, (float)(objectArray[n2 * 4 + 1] & 0xFF) / 255.0f, (float)(objectArray[n2 * 4 + 2] & 0xFF) / 255.0f, (float)(objectArray[n2 * 4 + 3] & 0xFF) / 255.0f);
                                                    }
                                                    break;
                                                }
                                            }
                                            break block160;
                                        }
                                        if (geometryArray.getColorRef4f() != null) {
                                            if (n7 != 0) {
                                                object2 = geometryArray.getColorRef4f();
                                                color4fArray = new Color4f[n3];
                                                for (n2 = 0; n2 < n3; ++n2) {
                                                    color4fArray[n2] = new Color4f((Color4f)((Object)object2[n2 + n7]));
                                                }
                                            } else {
                                                color4fArray = geometryArray.getColorRef4f();
                                            }
                                        } else if (geometryArray.getColorRefFloat() != null) {
                                            object2 = geometryArray.getColorRefFloat();
                                            color4fArray = new Color4f[n3];
                                            for (n2 = 0; n2 < n3; ++n2) {
                                                color4fArray[n2] = new Color4f((float)object2[(n2 + n7) * 4 + 0], (float)object2[(n2 + n7) * 4 + 1], (float)object2[(n2 + n7) * 4 + 2], (float)object2[(n2 + n7) * 4 + 3]);
                                            }
                                        } else if (geometryArray.getColorRefByte() != null) {
                                            object2 = geometryArray.getColorRefByte();
                                            color4fArray = new Color4f[n3];
                                            for (n2 = 0; n2 < n3; ++n2) {
                                                color4fArray[n2] = new Color4f((float)(object2[(n2 + n7) * 4 + 0] & 0xFF) / 255.0f, (float)(object2[(n2 + n7) * 4 + 1] & 0xFF) / 255.0f, (float)(object2[(n2 + n7) * 4 + 2] & 0xFF) / 255.0f, (float)(object2[(n2 + n7) * 4 + 3] & 0xFF) / 255.0f);
                                            }
                                        } else if (geometryArray.getColorRef4b() != null) {
                                            object2 = geometryArray.getColorRef4b();
                                            color4fArray = new Color4f[n3];
                                            for (n2 = 0; n2 < n3; ++n2) {
                                                color4fArray[n2] = new Color4f((float)(((Color4b)((Object)object2[n2 + n7])).x & 0xFF) / 255.0f, (float)(((Color4b)((Object)object2[n2 + n7])).y & 0xFF) / 255.0f, (float)(((Color4b)((Object)object2[n2 + n7])).z & 0xFF) / 255.0f, (float)(((Color4b)((Object)object2[n2 + n7])).w & 0xFF) / 255.0f);
                                            }
                                        }
                                        break block160;
                                    }
                                    n7 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                                    color4fArray = new Color4f[n3];
                                    for (n2 = 0; n2 < n3; ++n2) {
                                        color4fArray[n2] = new Color4f();
                                    }
                                    geometryArray.getColors(n7, color4fArray);
                                }
                                geometryInfo.setColors(color4fArray);
                                break block161;
                            }
                            if ((n5 & 4) == 0) break block161;
                            color3fArray = null;
                            if (!bl2) break block162;
                            n6 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialColorIndex() : 0;
                            if (!bl) break block163;
                            object2 = geometryArray.getColorRefBuffer();
                            switch (BufferWrapper.getBufferType((J3DBuffer)object2)) {
                                case 3: {
                                    object = new FloatBufferWrapper((J3DBuffer)object2);
                                    objectArray = new float[n3 * 3];
                                    ((BufferWrapper)object).position(n6 * 3);
                                    ((FloatBufferWrapper)object).get((float[])objectArray, 0, n3 * 3);
                                    color3fArray = new Color3f[n3];
                                    for (n2 = 0; n2 < n3; ++n2) {
                                        color3fArray[n2] = new Color3f(objectArray[n2 * 3 + 0], objectArray[n2 * 3 + 1], objectArray[n2 * 3 + 2]);
                                    }
                                    break block164;
                                }
                                case 2: {
                                    object = new ByteBufferWrapper((J3DBuffer)object2);
                                    objectArray = new byte[n3 * 3];
                                    ((BufferWrapper)object).position(n6 * 3);
                                    ((ByteBufferWrapper)object).get((byte[])objectArray, 0, n3 * 3);
                                    color3fArray = new Color3f[n3];
                                    for (n2 = 0; n2 < n3; ++n2) {
                                        color3fArray[n2] = new Color3f((float)(objectArray[n2 * 3 + 0] & 0xFF) / 255.0f, (float)(objectArray[n2 * 3 + 1] & 0xFF) / 255.0f, (float)(objectArray[n2 * 3 + 2] & 0xFF) / 255.0f);
                                    }
                                    break;
                                }
                            }
                            break block164;
                        }
                        if (geometryArray.getColorRef3f() != null) {
                            if (n6 != 0) {
                                object2 = geometryArray.getColorRef3f();
                                color3fArray = new Color3f[n3];
                                for (n2 = 0; n2 < n3; ++n2) {
                                    color3fArray[n2] = new Color3f((Color3f)((Object)object2[n2 + n6]));
                                }
                            } else {
                                color3fArray = geometryArray.getColorRef3f();
                            }
                        } else if (geometryArray.getColorRefFloat() != null) {
                            object2 = geometryArray.getColorRefFloat();
                            color3fArray = new Color3f[n3];
                            for (n2 = 0; n2 < n3; ++n2) {
                                color3fArray[n2] = new Color3f((float)object2[(n2 + n6) * 3 + 0], (float)object2[(n2 + n6) * 3 + 1], (float)object2[(n2 + n6) * 3 + 2]);
                            }
                        } else if (geometryArray.getColorRefByte() != null) {
                            object2 = geometryArray.getColorRefByte();
                            color3fArray = new Color3f[n3];
                            for (n2 = 0; n2 < n3; ++n2) {
                                color3fArray[n2] = new Color3f((float)(object2[(n2 + n6) * 3 + 0] & 0xFF) / 255.0f, (float)(object2[(n2 + n6) * 3 + 1] & 0xFF) / 255.0f, (float)(object2[(n2 + n6) * 3 + 2] & 0xFF) / 255.0f);
                            }
                        } else if (geometryArray.getColorRef3b() != null) {
                            object2 = geometryArray.getColorRef3b();
                            color3fArray = new Color3f[n3];
                            for (n2 = 0; n2 < n3; ++n2) {
                                color3fArray[n2] = new Color3f((float)(((Color3b)((Object)object2[n2 + n6])).x & 0xFF) / 255.0f, (float)(((Color3b)((Object)object2[n2 + n6])).y & 0xFF) / 255.0f, (float)(((Color3b)((Object)object2[n2 + n6])).z & 0xFF) / 255.0f);
                            }
                        }
                        break block164;
                    }
                    n6 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                    color3fArray = new Color3f[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        color3fArray[n2] = new Color3f();
                    }
                    geometryArray.getColors(n6, color3fArray);
                }
                geometryInfo.setColors(color3fArray);
            }
            if ((n5 & 0x400) != 0) {
                geometryInfo.setTextureCoordinateParams(n4, 4);
                for (n2 = 0; n2 < n4; ++n2) {
                    int n14;
                    int n15;
                    TexCoord4f[] texCoord4fArray = null;
                    if (bl2) {
                        n15 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialTexCoordIndex(n2) : 0;
                        if (bl) {
                            object2 = geometryArray.getTexCoordRefBuffer(n2);
                            if (BufferWrapper.getBufferType((J3DBuffer)object2) == 3) {
                                object = new FloatBufferWrapper((J3DBuffer)object2);
                                objectArray = new float[n3 * 4];
                                ((BufferWrapper)object).position(n15 * 4);
                                ((FloatBufferWrapper)object).get((float[])objectArray, 0, n3 * 4);
                                texCoord4fArray = new TexCoord4f[n3];
                                for (n14 = 0; n14 < n3; ++n14) {
                                    texCoord4fArray[n14] = new TexCoord4f(objectArray[n14 * 4 + 0], objectArray[n14 * 4 + 1], objectArray[n14 * 4 + 2], objectArray[n14 * 4 + 3]);
                                }
                            }
                        } else {
                            object2 = geometryArray.getTexCoordRefFloat(n2);
                            texCoord4fArray = new TexCoord4f[n3];
                            for (n14 = 0; n14 < n3; ++n14) {
                                texCoord4fArray[n14] = new TexCoord4f((float)object2[(n14 + n15) * 4], (float)object2[(n14 + n15) * 4 + 1], (float)object2[(n14 + n15) * 4 + 2], (float)object2[(n14 + n15) * 4 + 3]);
                            }
                        }
                    } else {
                        n15 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                        texCoord4fArray = new TexCoord4f[n3];
                        for (n14 = 0; n14 < n3; ++n14) {
                            texCoord4fArray[n14] = new TexCoord4f();
                        }
                        geometryArray.getTextureCoordinates(n2, n15, texCoord4fArray);
                    }
                    geometryInfo.setTextureCoordinates(n2, texCoord4fArray);
                }
                int[] nArray = new int[geometryArray.getTexCoordSetMapLength()];
                geometryArray.getTexCoordSetMap(nArray);
                geometryInfo.setTexCoordSetMap(nArray);
            } else if ((n5 & 0x40) != 0) {
                geometryInfo.setTextureCoordinateParams(n4, 3);
                for (n2 = 0; n2 < n4; ++n2) {
                    int n16;
                    int n17;
                    TexCoord3f[] texCoord3fArray = null;
                    if (bl2) {
                        n17 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialTexCoordIndex(n2) : 0;
                        if (bl) {
                            object2 = geometryArray.getTexCoordRefBuffer(n2);
                            if (BufferWrapper.getBufferType((J3DBuffer)object2) == 3) {
                                object = new FloatBufferWrapper((J3DBuffer)object2);
                                objectArray = new float[n3 * 3];
                                ((BufferWrapper)object).position(n17 * 3);
                                ((FloatBufferWrapper)object).get((float[])objectArray, 0, n3 * 3);
                                texCoord3fArray = new TexCoord3f[n3];
                                for (n16 = 0; n16 < n3; ++n16) {
                                    texCoord3fArray[n16] = new TexCoord3f(objectArray[n16 * 3 + 0], objectArray[n16 * 3 + 1], objectArray[n16 * 3 + 2]);
                                }
                            }
                        } else if (geometryArray.getTexCoordRef3f(n2) != null) {
                            if (n17 != 0) {
                                object2 = geometryArray.getTexCoordRef3f(n2);
                                texCoord3fArray = new TexCoord3f[n3];
                                for (n16 = 0; n16 < n3; ++n16) {
                                    texCoord3fArray[n16] = new TexCoord3f((TexCoord3f)((Object)object2[n16 + n17]));
                                }
                            } else {
                                texCoord3fArray = geometryArray.getTexCoordRef3f(n2);
                            }
                        } else if (geometryArray.getTexCoordRefFloat(n2) != null) {
                            object2 = geometryArray.getTexCoordRefFloat(n2);
                            texCoord3fArray = new TexCoord3f[n3];
                            for (n16 = 0; n16 < n3; ++n16) {
                                texCoord3fArray[n16] = new TexCoord3f((float)object2[(n16 + n17) * 3], (float)object2[(n16 + n17) * 3 + 1], (float)object2[(n16 + n17) * 3 + 2]);
                            }
                        }
                    } else {
                        n17 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                        texCoord3fArray = new TexCoord3f[n3];
                        for (n16 = 0; n16 < n3; ++n16) {
                            texCoord3fArray[n16] = new TexCoord3f();
                        }
                        geometryArray.getTextureCoordinates(n2, n17, texCoord3fArray);
                    }
                    geometryInfo.setTextureCoordinates(n2, texCoord3fArray);
                }
                int[] nArray = new int[geometryArray.getTexCoordSetMapLength()];
                geometryArray.getTexCoordSetMap(nArray);
                geometryInfo.setTexCoordSetMap(nArray);
            } else if ((n5 & 0x20) != 0) {
                geometryInfo.setTextureCoordinateParams(n4, 2);
                for (n2 = 0; n2 < n4; ++n2) {
                    int n18;
                    int n19;
                    TexCoord2f[] texCoord2fArray = null;
                    if (bl2) {
                        n19 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialTexCoordIndex(n2) : 0;
                        if (bl) {
                            object2 = geometryArray.getTexCoordRefBuffer(n2);
                            if (BufferWrapper.getBufferType((J3DBuffer)object2) == 3) {
                                object = new FloatBufferWrapper((J3DBuffer)object2);
                                objectArray = new float[n3 * 2];
                                ((BufferWrapper)object).position(n19 * 2);
                                ((FloatBufferWrapper)object).get((float[])objectArray, 0, n3 * 2);
                                texCoord2fArray = new TexCoord2f[n3];
                                for (n18 = 0; n18 < n3; ++n18) {
                                    texCoord2fArray[n18] = new TexCoord2f(objectArray[n18 * 2 + 0], objectArray[n18 * 2 + 1]);
                                }
                            }
                        } else if (geometryArray.getTexCoordRefFloat(n2) != null) {
                            object2 = geometryArray.getTexCoordRefFloat(n2);
                            texCoord2fArray = new TexCoord2f[n3];
                            for (n18 = 0; n18 < n3; ++n18) {
                                texCoord2fArray[n18] = new TexCoord2f((float)object2[(n18 + n19) * 2 + 0], (float)object2[(n18 + n19) * 2 + 1]);
                            }
                        } else if (geometryArray.getTexCoordRef2f(n2) != null) {
                            if (n19 != 0) {
                                object2 = geometryArray.getTexCoordRef2f(n2);
                                texCoord2fArray = new TexCoord2f[n3];
                                for (n18 = 0; n18 < n3; ++n18) {
                                    texCoord2fArray[n18] = new TexCoord2f((TexCoord2f)((Object)object2[n18 + n19]));
                                }
                            } else {
                                texCoord2fArray = geometryArray.getTexCoordRef2f(n2);
                            }
                        }
                    } else {
                        n19 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                        texCoord2fArray = new TexCoord2f[n3];
                        for (n18 = 0; n18 < n3; ++n18) {
                            texCoord2fArray[n18] = new TexCoord2f();
                        }
                        geometryArray.getTextureCoordinates(n2, n19, texCoord2fArray);
                    }
                    geometryInfo.setTextureCoordinates(n2, texCoord2fArray);
                }
                int[] nArray = new int[geometryArray.getTexCoordSetMapLength()];
                geometryArray.getTexCoordSetMap(nArray);
                geometryInfo.setTexCoordSetMap(nArray);
            }
        }
    }

    private static void processIndexedArray(GeometryInfo geometryInfo, IndexedGeometryArray indexedGeometryArray) {
        block11: {
            int n2;
            int[] nArray;
            int n3;
            int n4;
            int n5;
            block10: {
                Object object;
                n5 = indexedGeometryArray.getInitialIndexIndex();
                n4 = indexedGeometryArray.getVertexFormat();
                n3 = indexedGeometryArray.getTexCoordSetCount();
                if (indexedGeometryArray instanceof IndexedGeometryStripArray) {
                    object = (IndexedGeometryStripArray)indexedGeometryArray;
                    nArray = new int[((IndexedGeometryStripArray)object).getNumStrips()];
                    ((IndexedGeometryStripArray)object).getStripIndexCounts(nArray);
                    n2 = 0;
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        n2 += nArray[i2];
                    }
                } else {
                    n2 = indexedGeometryArray.getValidIndexCount();
                }
                object = new int[n2];
                indexedGeometryArray.getCoordinateIndices(n5, (int[])object);
                geometryInfo.setCoordinateIndices((int[])object);
                if ((n4 & 0x200) == 0) break block10;
                if ((n4 & 2) != 0) {
                    geometryInfo.setNormalIndices((int[])object);
                }
                if ((n4 & 4) != 0 || (n4 & 0xC) != 0) {
                    geometryInfo.setColorIndices((int[])object);
                }
                if ((n4 & 0x20) == 0 && (n4 & 0x40) == 0 && (n4 & 0x400) == 0) break block11;
                for (int i3 = 0; i3 < n3; ++i3) {
                    geometryInfo.setTextureCoordinateIndices(i3, (int[])object);
                }
                break block11;
            }
            if ((n4 & 2) != 0) {
                nArray = new int[n2];
                indexedGeometryArray.getNormalIndices(n5, nArray);
                geometryInfo.setNormalIndices(nArray);
            }
            if ((n4 & 4) != 0 || (n4 & 0xC) != 0) {
                nArray = new int[n2];
                indexedGeometryArray.getColorIndices(n5, nArray);
                geometryInfo.setColorIndices(nArray);
            }
            if ((n4 & 0x20) != 0 || (n4 & 0x40) != 0 || (n4 & 0x400) != 0) {
                for (int i4 = 0; i4 < n3; ++i4) {
                    int[] nArray2 = new int[n2];
                    indexedGeometryArray.getTextureCoordinateIndices(i4, n5, nArray2);
                    geometryInfo.setTextureCoordinateIndices(i4, nArray2);
                }
            }
        }
    }

    private static void processStripArray(GeometryInfo geometryInfo, GeometryStripArray geometryStripArray) {
        int[] nArray = new int[geometryStripArray.getNumStrips()];
        geometryStripArray.getStripVertexCounts(nArray);
        geometryInfo.setStripCounts(nArray);
    }

    private static void processIndexStripArray(GeometryInfo geometryInfo, IndexedGeometryStripArray indexedGeometryStripArray) {
        int[] nArray = new int[indexedGeometryStripArray.getNumStrips()];
        indexedGeometryStripArray.getStripIndexCounts(nArray);
        geometryInfo.setStripCounts(nArray);
    }
}

