/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.HeapNode;
import com.sun.j3d.utils.geometry.Triangulator;

class Heap {
    Heap() {
    }

    static void printHeapData(Triangulator triangulator) {
        System.out.println("\nHeap Data : numZero " + triangulator.numZero + " numHeap " + triangulator.numHeap);
        for (int i2 = 0; i2 < triangulator.numHeap; ++i2) {
            System.out.println(i2 + " ratio " + triangulator.heap[i2].ratio + ", index " + triangulator.heap[i2].index + ", prev " + triangulator.heap[i2].prev + ", next " + triangulator.heap[i2].next);
        }
        System.out.println(" ");
    }

    static void initHeap(Triangulator triangulator) {
        triangulator.maxNumHeap = triangulator.numPoints;
        triangulator.heap = new HeapNode[triangulator.maxNumHeap];
        triangulator.numHeap = 0;
        triangulator.numZero = 0;
    }

    static void storeHeapData(Triangulator triangulator, int n2, double d2, int n3, int n4, int n5) {
        triangulator.heap[n2] = new HeapNode();
        triangulator.heap[n2].ratio = d2;
        triangulator.heap[n2].index = n3;
        triangulator.heap[n2].prev = n4;
        triangulator.heap[n2].next = n5;
    }

    static void dumpOnHeap(Triangulator triangulator, double d2, int n2, int n3, int n4) {
        int n5;
        if (triangulator.numHeap >= triangulator.maxNumHeap) {
            HeapNode[] heapNodeArray = triangulator.heap;
            triangulator.maxNumHeap += triangulator.numPoints;
            triangulator.heap = new HeapNode[triangulator.maxNumHeap];
            System.arraycopy(heapNodeArray, 0, triangulator.heap, 0, heapNodeArray.length);
        }
        if (d2 == 0.0) {
            if (triangulator.numZero < triangulator.numHeap) {
                if (triangulator.heap[triangulator.numHeap] == null) {
                    Heap.storeHeapData(triangulator, triangulator.numHeap, triangulator.heap[triangulator.numZero].ratio, triangulator.heap[triangulator.numZero].index, triangulator.heap[triangulator.numZero].prev, triangulator.heap[triangulator.numZero].next);
                } else {
                    triangulator.heap[triangulator.numHeap].copy(triangulator.heap[triangulator.numZero]);
                }
            }
            n5 = triangulator.numZero++;
        } else {
            n5 = triangulator.numHeap;
        }
        Heap.storeHeapData(triangulator, n5, d2, n2, n3, n4);
        ++triangulator.numHeap;
    }

    static void insertIntoHeap(Triangulator triangulator, double d2, int n2, int n3, int n4) {
        Heap.dumpOnHeap(triangulator, d2, n2, n3, n4);
    }

    static boolean deleteFromHeap(Triangulator triangulator, int[] nArray, int[] nArray2, int[] nArray3) {
        if (triangulator.numZero > 0) {
            --triangulator.numZero;
            --triangulator.numHeap;
            nArray[0] = triangulator.heap[triangulator.numZero].index;
            nArray2[0] = triangulator.heap[triangulator.numZero].prev;
            nArray3[0] = triangulator.heap[triangulator.numZero].next;
            if (triangulator.numZero < triangulator.numHeap) {
                triangulator.heap[triangulator.numZero].copy(triangulator.heap[triangulator.numHeap]);
            }
            return true;
        }
        if (triangulator.earsRandom) {
            if (triangulator.numHeap <= 0) {
                triangulator.numHeap = 0;
                return false;
            }
            double d2 = triangulator.randomGen.nextDouble();
            int n2 = (int)(d2 * (double)triangulator.numHeap);
            --triangulator.numHeap;
            if (n2 > triangulator.numHeap) {
                n2 = triangulator.numHeap;
            }
            nArray[0] = triangulator.heap[n2].index;
            nArray2[0] = triangulator.heap[n2].prev;
            nArray3[0] = triangulator.heap[n2].next;
            if (n2 < triangulator.numHeap) {
                triangulator.heap[n2].copy(triangulator.heap[triangulator.numHeap]);
            }
            return true;
        }
        if (triangulator.numHeap <= 0) {
            triangulator.numHeap = 0;
            return false;
        }
        --triangulator.numHeap;
        nArray[0] = triangulator.heap[triangulator.numHeap].index;
        nArray2[0] = triangulator.heap[triangulator.numHeap].prev;
        nArray3[0] = triangulator.heap[triangulator.numHeap].next;
        return true;
    }
}

