/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Edge;
import com.sun.j3d.utils.geometry.EdgeTable;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.Triangulator;
import java.util.ArrayList;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class NormalGenerator {
    private double creaseAngle;
    private Vector3f[] facetNorms;
    private ArrayList tally;
    private GeometryInfo gi;
    private int[] coordInds;
    private int[] normalInds;
    private int[] colorInds;
    private int[][] texInds;
    private int[] stripCounts;
    private static long t1 = 0L;
    private static long t2 = 0L;
    private static long t3 = 0L;
    private static long t4 = 0L;
    private static long t5 = 0L;
    private static long t6 = 0L;
    private Triangulator tr = null;
    private int numTexSets;
    private static final int DEBUG = 0;

    private void calculatefacetNorms() {
        Point3f[] point3fArray = this.gi.getCoordinates();
        this.facetNorms = new Vector3f[this.coordInds.length / 3];
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        if (this.gi.getOldPrim() != 2) {
            for (int i2 = 0; i2 < this.coordInds.length; i2 += 3) {
                vector3f.sub(point3fArray[this.coordInds[i2 + 2]], point3fArray[this.coordInds[i2 + 1]]);
                vector3f2.sub(point3fArray[this.coordInds[i2 + 0]], point3fArray[this.coordInds[i2 + 1]]);
                this.facetNorms[i2 / 3] = new Vector3f();
                this.facetNorms[i2 / 3].cross(vector3f, vector3f2);
                this.facetNorms[i2 / 3].normalize();
                if (!Float.isNaN(this.facetNorms[i2 / 3].x)) continue;
                this.facetNorms[i2 / 3].x = 1.0f;
                this.facetNorms[i2 / 3].z = 0.0f;
                this.facetNorms[i2 / 3].y = 0.0f;
            }
        } else {
            for (int i3 = 0; i3 < this.coordInds.length; i3 += 6) {
                vector3f.sub(point3fArray[this.coordInds[i3 + 2]], point3fArray[this.coordInds[i3 + 0]]);
                vector3f2.sub(point3fArray[this.coordInds[i3 + 5]], point3fArray[this.coordInds[i3 + 1]]);
                this.facetNorms[i3 / 3] = new Vector3f();
                this.facetNorms[i3 / 3].cross(vector3f, vector3f2);
                this.facetNorms[i3 / 3].normalize();
                if (Float.isNaN(this.facetNorms[i3 / 3].x)) {
                    this.facetNorms[i3 / 3].x = 1.0f;
                    this.facetNorms[i3 / 3].z = 0.0f;
                    this.facetNorms[i3 / 3].y = 0.0f;
                }
                this.facetNorms[i3 / 3 + 1] = new Vector3f(this.facetNorms[i3 / 3]);
            }
        }
    }

    private int createHardEdges() {
        int n2;
        EdgeTable edgeTable = new EdgeTable(this.coordInds);
        this.tally = new ArrayList();
        int[] nArray = new int[this.coordInds.length];
        int n3 = 1;
        float f2 = (float)Math.cos(this.creaseAngle);
        for (n2 = 0; n2 < this.coordInds.length; ++n2) {
            nArray[n2] = Integer.MAX_VALUE;
        }
        for (n2 = 0; n2 < this.coordInds.length; ++n2) {
            boolean bl;
            if (nArray[n2] != Integer.MAX_VALUE) continue;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            this.tally.add(arrayList);
            arrayList.add(new Integer(n2));
            nArray[n2] = this.tally.size() - 1;
            boolean bl2 = true;
            Edge edge = new Edge(this.coordInds[n2], this.coordInds[(n2 + 1) % 3 == 0 ? n2 - 2 : n2 + 1]);
            int n4 = this.coordInds[n2 % 3 == 0 ? n2 + 2 : n2 - 1];
            int n5 = n2;
            do {
                Integer n6;
                if ((n6 = edgeTable.get(edge.v2, edge.v1)) == null) {
                    bl = false;
                } else {
                    int n7 = n6;
                    float f3 = this.facetNorms[n5 / 3].dot(this.facetNorms[n7 / 3]);
                    boolean bl3 = bl = f3 > f2;
                    if (bl) {
                        int n8;
                        int n9 = n8 = (n7 + 1) % 3 == 0 ? n7 - 2 : n7 + 1;
                        if (this.coordInds[n2] != this.coordInds[n8]) {
                            int n10 = n8 = n7 % 3 == 0 ? n7 + 2 : n7 - 1;
                        }
                        if (nArray[n8] != Integer.MAX_VALUE) {
                            bl = false;
                        } else {
                            nArray[n8] = this.tally.size() - 1;
                            arrayList.add(new Integer(n8));
                            if (arrayList.size() > n3) {
                                n3 = arrayList.size();
                            }
                            n5 = n7;
                            if (bl2) {
                                edge.v2 = this.coordInds[n5];
                            } else {
                                edge.v1 = this.coordInds[n5];
                            }
                        }
                    }
                }
                if (bl || !bl2) continue;
                bl2 = false;
                bl = true;
                n5 = n2;
                edge = new Edge(this.coordInds[n2 % 3 == 0 ? n2 + 2 : n2 - 1], this.coordInds[n2]);
            } while (bl && (bl2 && edge.v2 != n4 || !bl2));
        }
        return n3;
    }

    private void calculateVertexNormals(int n2) {
        Vector3f[] vector3fArray;
        if (this.creaseAngle != 0.0) {
            Vector3f[] vector3fArray2 = new Vector3f[n2];
            vector3fArray = new Vector3f[this.tally.size()];
            this.normalInds = new int[this.coordInds.length];
            for (int i2 = 0; i2 < this.tally.size(); ++i2) {
                ArrayList arrayList = (ArrayList)this.tally.get(i2);
                int n3 = 0;
                vector3fArray[i2] = new Vector3f();
                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                    int n4;
                    int n5 = (Integer)arrayList.get(i3);
                    if (n5 == -1) continue;
                    int n6 = n5 / 3;
                    if (Float.isNaN(this.facetNorms[n6].x)) continue;
                    for (n4 = 0; n4 < n3 && !vector3fArray2[n4].equals(this.facetNorms[n6]); ++n4) {
                    }
                    this.normalInds[n5] = i2;
                    if (n4 != n3) continue;
                    vector3fArray[i2].add(this.facetNorms[n6]);
                    vector3fArray2[n3++] = this.facetNorms[n6];
                }
                vector3fArray[i2].normalize();
                if (!Float.isNaN(vector3fArray[i2].x)) continue;
                vector3fArray[i2].x = 1.0f;
                vector3fArray[i2].z = 0.0f;
                vector3fArray[i2].y = 0.0f;
            }
        } else {
            vector3fArray = this.facetNorms;
            this.normalInds = new int[this.facetNorms.length * 3];
            for (int i4 = 0; i4 < this.facetNorms.length; ++i4) {
                this.normalInds[i4 * 3 + 0] = i4;
                this.normalInds[i4 * 3 + 1] = i4;
                this.normalInds[i4 * 3 + 2] = i4;
            }
        }
        this.gi.setNormals(vector3fArray);
    }

    private int[] triToQuadIndices(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length / 6 * 4];
        for (int i2 = 0; i2 < nArray.length / 6; ++i2) {
            nArray2[i2 * 4 + 0] = nArray[i2 * 6 + 0];
            nArray2[i2 * 4 + 1] = nArray[i2 * 6 + 1];
            nArray2[i2 * 4 + 2] = nArray[i2 * 6 + 2];
            nArray2[i2 * 4 + 3] = nArray[i2 * 6 + 5];
        }
        return nArray2;
    }

    private void convertTriToQuad(GeometryInfo geometryInfo) {
        geometryInfo.setCoordinateIndices(this.triToQuadIndices(geometryInfo.getCoordinateIndices()));
        geometryInfo.setColorIndices(this.triToQuadIndices(geometryInfo.getColorIndices()));
        geometryInfo.setNormalIndices(this.triToQuadIndices(geometryInfo.getNormalIndices()));
        int n2 = geometryInfo.getTexCoordSetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            geometryInfo.setTextureCoordinateIndices(i2, this.triToQuadIndices(geometryInfo.getTextureCoordinateIndices(i2)));
        }
        geometryInfo.setPrimitive(2);
    }

    private int[] triToFanIndices(int[] nArray, int[] nArray2, int n2) {
        if (nArray2 == null) {
            return null;
        }
        int[] nArray3 = new int[n2];
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray3[n4++] = nArray2[n3++];
            nArray3[n4++] = nArray2[n3++];
            nArray3[n4++] = nArray2[n3++];
            for (int i3 = 3; i3 < nArray[i2]; ++i3) {
                nArray3[n4++] = nArray2[n3 + 2];
                n3 += 3;
            }
        }
        return nArray3;
    }

    private void convertTriToFan(GeometryInfo geometryInfo, int[] nArray) {
        int n2;
        int n3;
        int[] nArray2 = geometryInfo.getNormalIndices();
        int n4 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length + 100);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n3 = 3;
            for (n2 = 0; n2 < nArray[i2] - 3; ++n2) {
                if (nArray2[n4 * 3] == nArray2[(n4 + 1) * 3] && nArray2[n4 * 3 + 2] == nArray2[(n4 + 1) * 3 + 1]) {
                    ++n3;
                } else {
                    arrayList.add(new Integer(n3));
                    n3 = 3;
                }
                ++n4;
            }
            ++n4;
            arrayList.add(new Integer(n3));
        }
        int[] nArray3 = new int[arrayList.size()];
        for (n3 = 0; n3 < nArray3.length; ++n3) {
            nArray3[n3] = (Integer)arrayList.get(n3);
        }
        arrayList = null;
        n3 = 0;
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            n3 += nArray3[n2];
        }
        geometryInfo.setCoordinateIndices(this.triToFanIndices(nArray3, geometryInfo.getCoordinateIndices(), n3));
        geometryInfo.setColorIndices(this.triToFanIndices(nArray3, geometryInfo.getColorIndices(), n3));
        geometryInfo.setNormalIndices(this.triToFanIndices(nArray3, geometryInfo.getNormalIndices(), n3));
        n2 = geometryInfo.getTexCoordSetCount();
        for (int i3 = 0; i3 < n2; ++i3) {
            geometryInfo.setTextureCoordinateIndices(i3, this.triToFanIndices(nArray3, geometryInfo.getTextureCoordinateIndices(i3), n3));
        }
        geometryInfo.setStripCounts(nArray3);
        geometryInfo.setPrimitive(3);
    }

    private int[] triToStripIndices(int[] nArray, int[] nArray2, int n2) {
        if (nArray2 == null) {
            return null;
        }
        int[] nArray3 = new int[n2];
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray3[n4++] = nArray2[n3++];
            nArray3[n4++] = nArray2[n3++];
            nArray3[n4++] = nArray2[n3++];
            for (int i3 = 3; i3 < nArray[i2]; ++i3) {
                nArray3[n4++] = nArray2[n3 + 2 - i3 % 2];
                n3 += 3;
            }
        }
        return nArray3;
    }

    private void convertTriToStrip(GeometryInfo geometryInfo, int[] nArray) {
        int n2;
        int n3;
        int[] nArray2 = geometryInfo.getNormalIndices();
        int n4 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length + 100);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n3 = 3;
            for (n2 = 0; n2 < nArray[i2] - 3; ++n2) {
                if (n2 % 2 == 0) {
                    if (nArray2[n4 * 3 + 1] == nArray2[(n4 + 1) * 3] && nArray2[n4 * 3 + 2] == nArray2[(n4 + 1) * 3 + 2]) {
                        ++n3;
                    } else {
                        arrayList.add(new Integer(n3));
                        n3 = 3;
                        if (n2 < nArray[i2] - 4) {
                            arrayList.add(new Integer(3));
                            ++n2;
                        }
                    }
                } else if (nArray2[n4 * 3 + 1] == nArray2[(n4 + 1) * 3 + 1] && nArray2[n4 * 3 + 2] == nArray2[(n4 + 1) * 3]) {
                    ++n3;
                } else {
                    arrayList.add(new Integer(n3));
                    n3 = 3;
                }
                ++n4;
            }
            ++n4;
            arrayList.add(new Integer(n3));
        }
        int[] nArray3 = new int[arrayList.size()];
        for (n3 = 0; n3 < nArray3.length; ++n3) {
            nArray3[n3] = (Integer)arrayList.get(n3);
        }
        arrayList = null;
        n3 = 0;
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            n3 += nArray3[n2];
        }
        geometryInfo.setCoordinateIndices(this.triToStripIndices(nArray3, geometryInfo.getCoordinateIndices(), n3));
        geometryInfo.setColorIndices(this.triToStripIndices(nArray3, geometryInfo.getColorIndices(), n3));
        geometryInfo.setNormalIndices(this.triToStripIndices(nArray3, geometryInfo.getNormalIndices(), n3));
        n2 = geometryInfo.getTexCoordSetCount();
        for (int i3 = 0; i3 < n2; ++i3) {
            geometryInfo.setTextureCoordinateIndices(i3, this.triToStripIndices(nArray3, geometryInfo.getTextureCoordinateIndices(i3), n3));
        }
        geometryInfo.setStripCounts(nArray3);
        geometryInfo.setPrimitive(4);
    }

    void convertBackToOldPrim(GeometryInfo geometryInfo, int n2, int[] nArray) {
        if (n2 == 1) {
            return;
        }
        switch (n2) {
            case 2: {
                this.convertTriToQuad(geometryInfo);
                break;
            }
            case 3: {
                this.convertTriToFan(geometryInfo, nArray);
                break;
            }
            case 4: {
                this.convertTriToStrip(geometryInfo, nArray);
            }
        }
    }

    public void generateNormals(GeometryInfo geometryInfo) {
        int n2;
        this.gi = geometryInfo;
        this.gi.setNormals((Vector3f[])null);
        this.gi.setNormalIndices(null);
        long l2 = 0L;
        if (this.gi.getPrimitive() == 5) {
            if (this.tr == null) {
                this.tr = new Triangulator();
            }
            this.tr.triangulate(this.gi);
        } else {
            this.gi.rememberOldPrim();
            this.gi.convertToIndexedTriangles();
        }
        this.coordInds = this.gi.getCoordinateIndices();
        this.colorInds = this.gi.getColorIndices();
        this.normalInds = this.gi.getNormalIndices();
        this.numTexSets = this.gi.getTexCoordSetCount();
        this.texInds = new int[this.numTexSets][];
        for (n2 = 0; n2 < this.numTexSets; ++n2) {
            this.texInds[n2] = this.gi.getTextureCoordinateIndices(n2);
        }
        this.stripCounts = this.gi.getStripCounts();
        this.calculatefacetNorms();
        n2 = this.createHardEdges();
        this.calculateVertexNormals(n2);
        this.gi.setCoordinateIndices(this.coordInds);
        this.gi.setColorIndices(this.colorInds);
        this.gi.setNormalIndices(this.normalInds);
        for (int i2 = 0; i2 < this.numTexSets; ++i2) {
            this.gi.setTextureCoordinateIndices(i2, this.texInds[i2]);
        }
        this.gi.setStripCounts(this.stripCounts);
    }

    public void setCreaseAngle(double d2) {
        if (d2 > Math.PI) {
            d2 = Math.PI;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        this.creaseAngle = d2;
    }

    public double getCreaseAngle() {
        return this.creaseAngle;
    }

    public NormalGenerator(double d2) {
        this.creaseAngle = d2;
    }

    public NormalGenerator() {
        this(0.767944870877505);
    }
}

