/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Basic;
import com.sun.j3d.utils.geometry.Triangulator;
import javax.vecmath.Point2f;
import javax.vecmath.Tuple2f;

class Numerics {
    Numerics() {
    }

    static double max3(double d2, double d3, double d4) {
        return d2 > d3 ? (d2 > d4 ? d2 : d4) : (d3 > d4 ? d3 : d4);
    }

    static double min3(double d2, double d3, double d4) {
        return d2 < d3 ? (d2 < d4 ? d2 : d4) : (d3 < d4 ? d3 : d4);
    }

    static boolean lt(double d2, double d3) {
        return d2 < -d3;
    }

    static boolean le(double d2, double d3) {
        return d2 <= d3;
    }

    static boolean ge(double d2, double d3) {
        return !(d2 <= -d3);
    }

    static boolean eq(double d2, double d3) {
        return d2 <= d3 && !(d2 < -d3);
    }

    static boolean gt(double d2, double d3) {
        return !(d2 <= d3);
    }

    static double baseLength(Tuple2f tuple2f, Tuple2f tuple2f2) {
        double d2 = tuple2f2.x - tuple2f.x;
        double d3 = tuple2f2.y - tuple2f.y;
        return Math.abs(d2) + Math.abs(d3);
    }

    static double sideLength(Tuple2f tuple2f, Tuple2f tuple2f2) {
        double d2 = tuple2f2.x - tuple2f.x;
        double d3 = tuple2f2.y - tuple2f.y;
        return d2 * d2 + d3 * d3;
    }

    static boolean inBetween(int n2, int n3, int n4) {
        return n2 <= n4 && n4 <= n3;
    }

    static boolean strictlyInBetween(int n2, int n3, int n4) {
        return n2 < n4 && n4 < n3;
    }

    static double stableDet2D(Triangulator triangulator, int n2, int n3, int n4) {
        double d2;
        if (n2 == n3 || n2 == n4 || n3 == n4) {
            d2 = 0.0;
        } else {
            Point2f point2f = triangulator.points[n2];
            Point2f point2f2 = triangulator.points[n3];
            Point2f point2f3 = triangulator.points[n4];
            d2 = n2 < n3 ? (n3 < n4 ? Basic.det2D(point2f, point2f2, point2f3) : (n2 < n4 ? -Basic.det2D(point2f, point2f3, point2f2) : Basic.det2D(point2f3, point2f, point2f2))) : (n2 < n4 ? -Basic.det2D(point2f2, point2f, point2f3) : (n3 < n4 ? Basic.det2D(point2f2, point2f3, point2f) : -Basic.det2D(point2f3, point2f2, point2f)));
        }
        return d2;
    }

    static int orientation(Triangulator triangulator, int n2, int n3, int n4) {
        double d2 = Numerics.stableDet2D(triangulator, n2, n3, n4);
        int n5 = Numerics.lt(d2, triangulator.epsilon) ? -1 : (Numerics.gt(d2, triangulator.epsilon) ? 1 : 0);
        return n5;
    }

    static boolean isInCone(Triangulator triangulator, int n2, int n3, int n4, int n5, boolean bl) {
        boolean bl2 = true;
        if (bl) {
            if (n2 != n3) {
                int n6 = Numerics.orientation(triangulator, n2, n3, n5);
                if (n6 < 0) {
                    bl2 = false;
                } else if (n6 == 0) {
                    if (n2 < n3) {
                        if (!Numerics.inBetween(n2, n3, n5)) {
                            bl2 = false;
                        }
                    } else if (!Numerics.inBetween(n3, n2, n5)) {
                        bl2 = false;
                    }
                }
            }
            if (n3 != n4 && bl2) {
                int n7 = Numerics.orientation(triangulator, n3, n4, n5);
                if (n7 < 0) {
                    bl2 = false;
                } else if (n7 == 0) {
                    if (n3 < n4) {
                        if (!Numerics.inBetween(n3, n4, n5)) {
                            bl2 = false;
                        }
                    } else if (!Numerics.inBetween(n4, n3, n5)) {
                        bl2 = false;
                    }
                }
            }
        } else {
            int n8;
            int n9 = Numerics.orientation(triangulator, n2, n3, n5);
            if (n9 <= 0 && (n8 = Numerics.orientation(triangulator, n3, n4, n5)) < 0) {
                bl2 = false;
            }
        }
        return bl2;
    }

    static int isConvexAngle(Triangulator triangulator, int n2, int n3, int n4, int n5) {
        int n6;
        if (n2 == n3) {
            if (n3 == n4) {
                return 1;
            }
            return 1;
        }
        if (n3 == n4) {
            return -1;
        }
        int n7 = Numerics.orientation(triangulator, n2, n3, n4);
        if (n7 > 0) {
            n6 = 1;
        } else if (n7 < 0) {
            n6 = -1;
        } else {
            Point2f point2f = new Point2f();
            Point2f point2f2 = new Point2f();
            Basic.vectorSub2D(triangulator.points[n2], triangulator.points[n3], point2f);
            Basic.vectorSub2D(triangulator.points[n4], triangulator.points[n3], point2f2);
            double d2 = Basic.dotProduct2D(point2f, point2f2);
            n6 = d2 < 0.0 ? 0 : Numerics.spikeAngle(triangulator, n2, n3, n4, n5);
        }
        return n6;
    }

    static boolean pntInTriangle(Triangulator triangulator, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        int n6 = Numerics.orientation(triangulator, n3, n4, n5);
        if (n6 >= 0 && (n6 = Numerics.orientation(triangulator, n2, n3, n5)) >= 0 && (n6 = Numerics.orientation(triangulator, n4, n2, n5)) >= 0) {
            bl = true;
        }
        return bl;
    }

    static boolean vtxInTriangle(Triangulator triangulator, int n2, int n3, int n4, int n5, int[] nArray) {
        boolean bl = false;
        int n6 = Numerics.orientation(triangulator, n3, n4, n5);
        if (n6 >= 0) {
            n6 = Numerics.orientation(triangulator, n2, n3, n5);
            if (n6 > 0) {
                n6 = Numerics.orientation(triangulator, n4, n2, n5);
                if (n6 > 0) {
                    bl = true;
                    nArray[0] = 0;
                } else if (n6 == 0) {
                    bl = true;
                    nArray[0] = 1;
                }
            } else if (n6 == 0) {
                n6 = Numerics.orientation(triangulator, n4, n2, n5);
                if (n6 > 0) {
                    bl = true;
                    nArray[0] = 2;
                } else if (n6 == 0) {
                    bl = true;
                    nArray[0] = 3;
                }
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean segIntersect(Triangulator triangulator, int n2, int n3, int n4, int n5, int n6) {
        if (n2 == n3 || n4 == n5) {
            return false;
        }
        if (n2 == n4 && n3 == n5) {
            return true;
        }
        if (n4 == n6 || n5 == n6) {
            ++triangulator.identCntr;
        }
        int n7 = Numerics.orientation(triangulator, n2, n3, n4);
        int n8 = Numerics.orientation(triangulator, n2, n3, n5);
        if (n7 == 1 && n8 == 1 || n7 == -1 && n8 == -1) {
            return false;
        }
        if (n7 == 0) {
            if (Numerics.strictlyInBetween(n2, n3, n4)) {
                return true;
            }
            if (n8 != 0) return false;
            if (Numerics.strictlyInBetween(n2, n3, n5)) {
                return true;
            }
        } else if (n8 == 0) {
            return Numerics.strictlyInBetween(n2, n3, n5);
        }
        int n9 = Numerics.orientation(triangulator, n4, n5, n2);
        int n10 = Numerics.orientation(triangulator, n4, n5, n3);
        return (n9 > 0 || n10 > 0) && (n9 < 0 || n10 < 0);
    }

    static double getRatio(Triangulator triangulator, int n2, int n3, int n4) {
        Point2f point2f = triangulator.points[n2];
        Point2f point2f2 = triangulator.points[n3];
        Point2f point2f3 = triangulator.points[n4];
        double d2 = Numerics.baseLength(point2f, point2f2);
        double d3 = Numerics.baseLength(point2f, point2f3);
        double d4 = Numerics.baseLength(point2f3, point2f2);
        double d5 = Numerics.max3(d2, d3, d4);
        if (10.0 * d2 < Math.min(d3, d4)) {
            return 0.1;
        }
        double d6 = Numerics.stableDet2D(triangulator, n2, n3, n4);
        if (Numerics.lt(d6, triangulator.epsilon)) {
            d6 = -d6;
        } else if (!Numerics.gt(d6, triangulator.epsilon)) {
            if (d5 > d2) {
                return 0.1;
            }
            return Double.MAX_VALUE;
        }
        double d7 = d5 * d5 / d6;
        if (d7 < 10.0) {
            return d7;
        }
        if (d2 < d5) {
            return 0.1;
        }
        return d7;
    }

    static int spikeAngle(Triangulator triangulator, int n2, int n3, int n4, int n5) {
        int n6 = n5;
        int n7 = triangulator.fetchData(n6);
        int n8 = triangulator.fetchPrevData(n6);
        int n9 = triangulator.fetchData(n8);
        int n10 = triangulator.fetchNextData(n6);
        int n11 = triangulator.fetchData(n10);
        return Numerics.recSpikeAngle(triangulator, n2, n3, n4, n8, n10);
    }

    static int recSpikeAngle(Triangulator triangulator, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == n6) {
            return -2;
        }
        if (n2 != n4) {
            int n7;
            int n8;
            if (n2 < n3) {
                n8 = n2;
                n7 = n3;
            } else {
                n8 = n3;
                n7 = n2;
            }
            if (Numerics.inBetween(n8, n7, n4)) {
                n3 = n4;
                n6 = triangulator.fetchNextData(n6);
                n4 = triangulator.fetchData(n6);
                if (n5 == n6) {
                    return 2;
                }
                int n9 = Numerics.orientation(triangulator, n2, n3, n4);
                if (n9 > 0) {
                    return 2;
                }
                if (n9 < 0) {
                    return -2;
                }
                return Numerics.recSpikeAngle(triangulator, n2, n3, n4, n5, n6);
            }
            n3 = n2;
            n5 = triangulator.fetchPrevData(n5);
            n2 = triangulator.fetchData(n5);
            if (n5 == n6) {
                return 2;
            }
            int n10 = Numerics.orientation(triangulator, n2, n3, n4);
            if (n10 > 0) {
                return 2;
            }
            if (n10 < 0) {
                return -2;
            }
            return Numerics.recSpikeAngle(triangulator, n2, n3, n4, n5, n6);
        }
        int n11 = n3;
        n3 = n2;
        n5 = triangulator.fetchPrevData(n5);
        n2 = triangulator.fetchData(n5);
        if (n5 == n6) {
            return 2;
        }
        n6 = triangulator.fetchNextData(n6);
        n4 = triangulator.fetchData(n6);
        if (n5 == n6) {
            return 2;
        }
        int n12 = Numerics.orientation(triangulator, n2, n3, n4);
        if (n12 > 0) {
            int n13;
            int n14 = Numerics.orientation(triangulator, n2, n3, n11);
            if (n14 > 0 && (n13 = Numerics.orientation(triangulator, n3, n4, n11)) > 0) {
                return -2;
            }
            return 2;
        }
        if (n12 < 0) {
            int n15;
            int n16 = Numerics.orientation(triangulator, n3, n2, n11);
            if (n16 > 0 && (n15 = Numerics.orientation(triangulator, n4, n3, n11)) > 0) {
                return 2;
            }
            return -2;
        }
        Point2f point2f = new Point2f();
        Basic.vectorSub2D(triangulator.points[n2], triangulator.points[n3], point2f);
        Point2f point2f2 = new Point2f();
        Basic.vectorSub2D(triangulator.points[n4], triangulator.points[n3], point2f2);
        double d2 = Basic.dotProduct2D(point2f, point2f2);
        if (d2 < 0.0) {
            n12 = Numerics.orientation(triangulator, n3, n2, n11);
            if (n12 > 0) {
                return 2;
            }
            return -2;
        }
        return Numerics.recSpikeAngle(triangulator, n2, n3, n4, n5, n6);
    }

    static double angle(Triangulator triangulator, Point2f point2f, Point2f point2f2, Point2f point2f3) {
        double d2;
        int n2 = Basic.signEps(Basic.det2D(point2f3, point2f, point2f2), triangulator.epsilon);
        if (n2 == 0) {
            return 0.0;
        }
        Point2f point2f4 = new Point2f();
        Point2f point2f5 = new Point2f();
        Basic.vectorSub2D(point2f2, point2f, point2f4);
        Basic.vectorSub2D(point2f3, point2f, point2f5);
        double d3 = Math.atan2(point2f4.y, point2f4.x);
        double d4 = Math.atan2(point2f5.y, point2f5.x);
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        if (d4 < 0.0) {
            d4 += Math.PI * 2;
        }
        if ((d2 = d3 - d4) > Math.PI) {
            d2 = Math.PI * 2 - d2;
        } else if (d2 < -Math.PI) {
            d2 = Math.PI * 2 + d2;
        }
        if (n2 == 1) {
            if (d2 < 0.0) {
                return -d2;
            }
            return d2;
        }
        if (d2 > 0.0) {
            return -d2;
        }
        return d2;
    }
}

