/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Numerics;
import com.sun.j3d.utils.geometry.Triangulator;

class Orientation {
    Orientation() {
    }

    static void adjustOrientation(Triangulator triangulator, int n2, int n3) {
        int n4;
        int n5;
        if (n2 >= n3) {
            System.out.println("Orientation:adjustOrientation Problem i1>=i2 !!!");
        }
        if (triangulator.numLoops >= triangulator.maxNumPolyArea) {
            triangulator.maxNumPolyArea = triangulator.numLoops;
            double[] dArray = triangulator.polyArea;
            triangulator.polyArea = new double[triangulator.maxNumPolyArea];
            if (dArray != null) {
                System.arraycopy(dArray, 0, triangulator.polyArea, 0, dArray.length);
            }
        }
        for (n5 = n2; n5 < n3; ++n5) {
            n4 = triangulator.loops[n5];
            triangulator.polyArea[n5] = Orientation.polygonArea(triangulator, n4);
        }
        double d2 = Math.abs(triangulator.polyArea[n2]);
        int n6 = n2;
        for (n5 = n2 + 1; n5 < n3; ++n5) {
            if (!(d2 < Math.abs(triangulator.polyArea[n5]))) continue;
            d2 = Math.abs(triangulator.polyArea[n5]);
            n6 = n5;
        }
        if (n6 != n2) {
            n4 = triangulator.loops[n2];
            triangulator.loops[n2] = triangulator.loops[n6];
            triangulator.loops[n6] = n4;
            d2 = triangulator.polyArea[n2];
            triangulator.polyArea[n2] = triangulator.polyArea[n6];
            triangulator.polyArea[n6] = d2;
        }
        if (triangulator.polyArea[n2] < 0.0) {
            triangulator.swapLinks(triangulator.loops[n2]);
        }
        for (n5 = n2 + 1; n5 < n3; ++n5) {
            if (!(triangulator.polyArea[n5] > 0.0)) continue;
            triangulator.swapLinks(triangulator.loops[n5]);
        }
    }

    static double polygonArea(Triangulator triangulator, int n2) {
        int n3 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = n2;
        int n5 = triangulator.fetchData(n4);
        int n6 = triangulator.fetchNextData(n4);
        int n7 = triangulator.fetchData(n6);
        d2 = Numerics.stableDet2D(triangulator, n3, n5, n7);
        n4 = n6;
        n5 = n7;
        while (n4 != n2) {
            n6 = triangulator.fetchNextData(n4);
            n7 = triangulator.fetchData(n6);
            d3 = Numerics.stableDet2D(triangulator, n3, n5, n7);
            d2 += d3;
            n4 = n6;
            n5 = n7;
        }
        return d2;
    }

    static void determineOrientation(Triangulator triangulator, int n2) {
        double d2 = Orientation.polygonArea(triangulator, n2);
        if (d2 < 0.0) {
            triangulator.swapLinks(n2);
            triangulator.ccwLoop = false;
        }
    }
}

