/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.StripifierStats;
import java.awt.Color;
import java.util.ArrayList;
import javax.vecmath.Color3b;

public class Stripifier {
    final boolean DEBUG = false;
    final boolean CHECK_ORIENT = false;
    static final int EMPTY = -1;
    boolean hasNormals = false;
    boolean hasTextures = false;
    int texSetCount = 0;
    boolean hasColors = false;
    boolean colorStrips = false;
    StripifierStats stats;
    int[] numNhbrs;
    public static final int COLLECT_STATS = 1;

    public Stripifier() {
    }

    public Stripifier(int n2) {
        if ((n2 & 1) != 0) {
            this.stats = new StripifierStats();
        }
    }

    public void stripify(GeometryInfo geometryInfo) {
        long l2 = System.currentTimeMillis();
        geometryInfo.convertToIndexedTriangles();
        geometryInfo.forgetOldPrim();
        Face[] faceArray = this.createFaceArray(geometryInfo);
        Edge[] edgeArray = this.createEdgeArray(faceArray);
        this.buildAdjacencies(edgeArray, faceArray);
        Node[] nodeArray = new Node[faceArray.length];
        Node[] nodeArray2 = this.dfSearch(faceArray, nodeArray);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ArrayList arrayList = this.hamilton(nodeArray2, nArray, nArray2);
        int n2 = nArray[0];
        int n3 = nArray2[0];
        ArrayList arrayList2 = this.stripe(arrayList);
        this.concatenate(arrayList2, faceArray);
        this.putBackData(geometryInfo, arrayList2);
        if (this.stats != null) {
            this.stats.updateInfo(System.currentTimeMillis() - l2, arrayList2, faceArray.length);
        }
    }

    public StripifierStats getStripifierStats() {
        if (this.stats == null) {
            throw new IllegalStateException(J3dUtilsI18N.getString("Stripifier0"));
        }
        return this.stats;
    }

    Face[] createFaceArray(GeometryInfo geometryInfo) {
        int[] nArray = geometryInfo.getCoordinateIndices();
        int[] nArray2 = geometryInfo.getNormalIndices();
        Object object = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        int[] nArray5 = null;
        this.texSetCount = geometryInfo.getTexCoordSetCount();
        if (this.texSetCount > 0) {
            this.hasTextures = true;
            object = new int[this.texSetCount][];
            for (int i2 = 0; i2 < this.texSetCount; ++i2) {
                object[i2] = geometryInfo.getTextureCoordinateIndices(i2);
            }
            nArray3 = new int[this.texSetCount];
            nArray4 = new int[this.texSetCount];
            nArray5 = new int[this.texSetCount];
        } else {
            this.hasTextures = false;
        }
        int[] nArray6 = geometryInfo.getColorIndices();
        Face[] faceArray = new Face[nArray.length / 3];
        int n2 = 0;
        for (int i3 = 0; i3 < nArray.length; i3 += 3) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            if (nArray2 != null) {
                this.hasNormals = true;
                n8 = nArray2[i3];
                n7 = nArray2[i3 + 1];
                n6 = nArray2[i3 + 2];
            } else {
                this.hasNormals = false;
                n8 = -1;
                n7 = -1;
                n6 = -1;
            }
            if (this.hasTextures) {
                for (int i4 = 0; i4 < this.texSetCount; ++i4) {
                    nArray3[i4] = object[i4][i3];
                    nArray4[i4] = object[i4][i3 + 1];
                    nArray5[i4] = object[i4][i3 + 2];
                }
            }
            if (nArray6 != null) {
                this.hasColors = true;
                n5 = nArray6[i3];
                n4 = nArray6[i3 + 1];
                n3 = nArray6[i3 + 2];
            } else {
                this.hasColors = false;
                n5 = -1;
                n4 = -1;
                n3 = -1;
            }
            Vertex vertex = new Vertex(nArray[i3], n8, this.texSetCount, nArray3, n5);
            Vertex vertex2 = new Vertex(nArray[i3 + 1], n7, this.texSetCount, nArray4, n4);
            Vertex vertex3 = new Vertex(nArray[i3 + 2], n6, this.texSetCount, nArray5, n3);
            if (vertex.equals(vertex2) || vertex2.equals(vertex3) || vertex3.equals(vertex)) continue;
            faceArray[n2] = new Face(n2, vertex, vertex2, vertex3);
            ++n2;
        }
        if (faceArray.length > n2) {
            Face[] faceArray2 = faceArray;
            faceArray = new Face[n2];
            System.arraycopy(faceArray2, 0, faceArray, 0, n2);
        }
        return faceArray;
    }

    Edge[] createEdgeArray(Face[] faceArray) {
        Edge[] edgeArray = new Edge[faceArray.length * 3];
        for (int i2 = 0; i2 < faceArray.length; ++i2) {
            Face face = faceArray[i2];
            edgeArray[i2 * 3] = new Edge(face.verts[0], face.verts[1], face.key);
            edgeArray[i2 * 3 + 1] = new Edge(face.verts[1], face.verts[2], face.key);
            edgeArray[i2 * 3 + 2] = new Edge(face.verts[2], face.verts[0], face.key);
        }
        return edgeArray;
    }

    void buildAdjacencies(Edge[] edgeArray, Face[] faceArray) {
        int n2;
        int n3;
        boolean bl;
        Face face;
        Edge edge;
        int n4;
        this.quickSortEdges(edgeArray, 0, edgeArray.length - 1);
        for (n4 = 0; n4 < edgeArray.length; ++n4) {
            edge = edgeArray[n4];
            face = faceArray[edge.face];
            Vertex[] vertexArray = face.verts;
            bl = true;
            if (!vertexArray[0].equals(edge.v1) && !vertexArray[0].equals(edge.v2)) {
                face.edges[0] = edge;
                --face.numNhbrs;
                bl = false;
            } else if (!vertexArray[1].equals(edge.v1) && !vertexArray[1].equals(edge.v2)) {
                face.edges[1] = edge;
                --face.numNhbrs;
                bl = false;
            } else if (!vertexArray[2].equals(edge.v1) && !vertexArray[2].equals(edge.v2)) {
                face.edges[2] = edge;
                --face.numNhbrs;
                bl = false;
            }
            if (!bl) continue;
            if (edge.v1.equals(edge.v2)) {
                face.edges[--face.numNhbrs] = edge;
                continue;
            }
            Vertex vertex = vertexArray[0].equals(vertexArray[1]) ? vertexArray[1] : vertexArray[2];
            if (vertexArray[0].equals(vertex) && face.edges[0] == null) {
                face.edges[0] = edge;
                --face.numNhbrs;
                continue;
            }
            if (vertexArray[1].equals(vertex) && face.edges[1] == null) {
                face.edges[1] = edge;
                --face.numNhbrs;
                continue;
            }
            face.edges[2] = edge;
            --face.numNhbrs;
        }
        n4 = 0;
        int n5 = 0;
        while (n4 < edgeArray.length - 1) {
            n5 = n4 + 1;
            if (edgeArray[n4].equals(edgeArray[n5])) {
                n3 = edgeArray[n4].face;
                n2 = edgeArray[n5].face;
                if (n3 != n2) {
                    face = faceArray[n3];
                    edge = edgeArray[n4];
                    int n6 = face.getEdgeIndex(edge);
                    bl = !edge.v1.equals(face.verts[(n6 + 1) % 3]) || !edge.v2.equals(face.verts[(n6 + 2) % 3]);
                    face = faceArray[n2];
                    edge = edgeArray[n5];
                    n6 = face.getEdgeIndex(edge);
                    if (!edge.v1.equals(face.verts[(n6 + 1) % 3]) || !edge.v2.equals(face.verts[(n6 + 2) % 3])) {
                        boolean bl2 = bl = !bl;
                    }
                    if (bl) {
                        edgeArray[n4].face = n2;
                        edgeArray[n5].face = n3;
                        ++faceArray[n3].numNhbrs;
                        ++faceArray[n2].numNhbrs;
                    } else {
                        edgeArray[n4].face = -1;
                    }
                } else {
                    edgeArray[n4].face = -1;
                }
            } else {
                edgeArray[n4].face = -1;
            }
            n4 = ++n5;
        }
        if (n4 <= edgeArray.length - 1) {
            edgeArray[n4].face = -1;
        }
        for (n4 = 0; n4 < faceArray.length; ++n4) {
            face = faceArray[n4];
            if (face.numNhbrs != 3) continue;
            n3 = face.edges[1].face;
            if (n3 == face.edges[0].face) {
                face.edges[1].face = -1;
                --face.numNhbrs;
                faceArray[n3].counterEdgeDel(face.edges[1]);
            }
            if ((n2 = face.edges[2].face) == face.edges[0].face) {
                face.edges[2].face = -1;
                --face.numNhbrs;
                faceArray[n2].counterEdgeDel(face.edges[2]);
            }
            if (face.edges[1].face == -1 || n3 != n2) continue;
            face.edges[2].face = -1;
            --face.numNhbrs;
            faceArray[n3].counterEdgeDel(face.edges[2]);
        }
    }

    void sortEdges(Edge[] edgeArray) {
        boolean bl = false;
        Edge edge = null;
        for (int i2 = edgeArray.length; i2 > 1 && !bl; --i2) {
            bl = true;
            for (int i3 = 1; i3 < i2; ++i3) {
                if (!edgeArray[i3].lessThan(edgeArray[i3 - 1])) continue;
                edge = edgeArray[i3 - 1];
                edgeArray[i3 - 1] = edgeArray[i3];
                edgeArray[i3] = edge;
                bl = false;
            }
        }
    }

    void quickSortEdges(Edge[] edgeArray, int n2, int n3) {
        if (edgeArray.length > 0) {
            int n4 = n2;
            int n5 = n3;
            Edge edge = edgeArray[(n2 + n3) / 2];
            while (true) {
                if (edgeArray[n4].lessThan(edge)) {
                    ++n4;
                    continue;
                }
                while (edge.lessThan(edgeArray[n5])) {
                    --n5;
                }
                if (n4 <= n5) {
                    Edge edge2 = edgeArray[n4];
                    edgeArray[n4] = edgeArray[n5];
                    edgeArray[n5] = edge2;
                    ++n4;
                    --n5;
                }
                if (n4 > n5) break;
            }
            if (n2 < n5) {
                this.quickSortEdges(edgeArray, n2, n5);
            }
            if (n2 < n3) {
                this.quickSortEdges(edgeArray, n4, n3);
            }
        }
    }

    Node[] hybridSearch(Face[] faceArray, Node[] nodeArray) {
        int n2 = faceArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray = new int[]{0, 0, 0, 0};
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        boolean bl = false;
        Node[] nodeArray2 = new Node[n2];
        int n7 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            int n8 = n4 = faceArray[n3].numNhbrs;
            nArray[n8] = nArray[n8] + 1;
            nodeArray[n3] = new Node(faceArray[n3]);
        }
        for (n3 = 1; n3 < 4; ++n3) {
            int n9 = n3;
            nArray[n9] = nArray[n9] + nArray[n3 - 1];
        }
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            int n10 = n4 = faceArray[n3].numNhbrs;
            nArray[n10] = nArray[n10] - 1;
            nArray2[nArray[n4]] = n3;
            nArray3[n3] = nArray[n4];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if (nArray2[n3] == -1) continue;
            SortedList sortedList = new SortedList();
            Node node = nodeArray[nArray2[n3]];
            node.setRoot();
            nodeArray2[n6] = node;
            ++n6;
            nArray2[n3] = -1;
            while (node != null) {
                Node node2 = null;
                Face face = node.face;
                for (n4 = 0; n4 < 3; ++n4) {
                    n5 = face.getNeighbor(n4);
                    if (n5 == -1 || !nodeArray[n5].notAccessed()) continue;
                    node2 = nodeArray[n5];
                    break;
                }
                if (node2 != null) {
                    node2.insert(node);
                    if (!bl) {
                        n7 = sortedList.sortedInsert(node, n7);
                    } else {
                        bl = false;
                    }
                    nodeArray2[n6] = node = node2;
                    ++n6;
                    nArray2[nArray3[n5]] = -1;
                    continue;
                }
                node.processed();
                node = sortedList.pop();
                bl = true;
                n7 = 0;
            }
        }
        return nodeArray2;
    }

    Node[] dfSearch(Face[] faceArray, Node[] nodeArray) {
        int n2 = faceArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray = new int[]{0, 0, 0, 0};
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        Node[] nodeArray2 = new Node[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            int n7 = n4 = faceArray[n3].numNhbrs;
            nArray[n7] = nArray[n7] + 1;
            nodeArray[n3] = new Node(faceArray[n3]);
        }
        for (n3 = 1; n3 < 4; ++n3) {
            int n8 = n3;
            nArray[n8] = nArray[n8] + nArray[n3 - 1];
        }
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            int n9 = n4 = faceArray[n3].numNhbrs;
            nArray[n9] = nArray[n9] - 1;
            nArray2[nArray[n4]] = n3;
            nArray3[n3] = nArray[n4];
        }
        this.setNumNhbrs(faceArray);
        for (n3 = 0; n3 < n2; ++n3) {
            if (nArray2[n3] == -1) continue;
            Node node = nodeArray[nArray2[n3]];
            node.setRoot();
            nodeArray2[n6] = node;
            ++n6;
            nArray2[n3] = -1;
            Node node2 = node;
            while (node2 != node || node2.right == null) {
                Node node3 = null;
                Face face = node2.face;
                n5 = this.findNext(node2, nodeArray, faceArray);
                if (n5 != -1) {
                    node3 = nodeArray[n5];
                }
                if (node3 != null) {
                    this.updateNumNhbrs(node3);
                }
                if (node3 != null) {
                    node3.insert(node2);
                    nodeArray2[n6] = node2 = node3;
                    ++n6;
                    nArray2[nArray3[n5]] = -1;
                } else {
                    node2.processed();
                    node2 = node2.parent;
                }
                if (node2 != node.parent) continue;
            }
        }
        this.freeNhbrTable();
        return nodeArray2;
    }

    int findNext(Node node, Node[] nodeArray, Face[] faceArray) {
        int n2;
        int n3;
        Face face = node.face;
        if (face.numNhbrs == 0) {
            return -1;
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[]{-1, -1, -1};
        int n4 = 0;
        for (n3 = 0; n3 < 3; ++n3) {
            n2 = face.getNeighbor(n3);
            if (n2 == -1 || !nodeArray[n2].notAccessed()) continue;
            nArray2[n4] = n2;
            nArray[n4] = this.numNhbrs[n2];
            ++n4;
        }
        if (n4 == 0) {
            return -1;
        }
        if (n4 == 1) {
            return nArray2[0];
        }
        if (n4 == 2) {
            if (nArray[0] == nArray[1] && nArray[0] != 0) {
                nArray[0] = this.resetNhbr(nArray2[0], faceArray, nodeArray);
                nArray[1] = this.resetNhbr(nArray2[1], faceArray, nodeArray);
            }
            if (nArray[0] < nArray[1]) {
                return nArray2[0];
            }
            if (nArray[1] < nArray[0]) {
                return nArray2[1];
            }
            Node node2 = node.parent;
            if (node2 != null) {
                Face face2 = node2.face;
                n3 = face2.findSharedEdge(face.key);
                Node node3 = node2.parent;
                if (node3 != null) {
                    Face face3 = node3.face;
                    n2 = face2.getNeighbor((n3 + 1) % 3) == face3.key ? face2.verts[(n3 + 2) % 3].index : face2.verts[(n3 + 1) % 3].index;
                } else {
                    n2 = face2.verts[(n3 + 1) % 3].index;
                }
                n3 = face.findSharedEdge(nArray2[0]);
                if (face.verts[n3].index == n2) {
                    return nArray2[0];
                }
                return nArray2[1];
            }
            return nArray2[0];
        }
        if (nArray[0] < nArray[1] && nArray[0] < nArray[2]) {
            return nArray2[0];
        }
        if (nArray[1] < nArray[0] && nArray[1] < nArray[2]) {
            return nArray2[1];
        }
        if (nArray[2] < nArray[0] && nArray[2] < nArray[1]) {
            return nArray2[2];
        }
        if (nArray[0] == nArray[1] && nArray[0] < nArray[2]) {
            if (nArray[0] != 0) {
                nArray[0] = this.resetNhbr(nArray2[0], faceArray, nodeArray);
                nArray[1] = this.resetNhbr(nArray2[1], faceArray, nodeArray);
            }
            if (nArray[0] <= nArray[1]) {
                return nArray2[0];
            }
            return nArray2[1];
        }
        if (nArray[1] == nArray[2] && nArray[1] < nArray[0]) {
            if (nArray[1] != 0) {
                nArray[1] = this.resetNhbr(nArray2[1], faceArray, nodeArray);
                nArray[2] = this.resetNhbr(nArray2[2], faceArray, nodeArray);
            }
            if (nArray[1] <= nArray[2]) {
                return nArray2[1];
            }
            return nArray2[2];
        }
        if (nArray[2] == nArray[0] && nArray[2] < nArray[1]) {
            if (nArray[0] != 0) {
                nArray[0] = this.resetNhbr(nArray2[0], faceArray, nodeArray);
                nArray[2] = this.resetNhbr(nArray2[2], faceArray, nodeArray);
            }
            if (nArray[0] <= nArray[2]) {
                return nArray2[0];
            }
            return nArray2[2];
        }
        if (nArray[0] != 0) {
            nArray[0] = this.resetNhbr(nArray2[0], faceArray, nodeArray);
            nArray[1] = this.resetNhbr(nArray2[1], faceArray, nodeArray);
            nArray[2] = this.resetNhbr(nArray2[2], faceArray, nodeArray);
        }
        if (nArray[0] <= nArray[1] && nArray[0] <= nArray[2]) {
            return nArray2[0];
        }
        if (nArray[1] <= nArray[2]) {
            return nArray2[1];
        }
        return nArray2[2];
    }

    void setNumNhbrs(Face[] faceArray) {
        int n2 = faceArray.length;
        this.numNhbrs = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.numNhbrs[i2] = faceArray[i2].numNhbrs;
        }
    }

    void freeNhbrTable() {
        this.numNhbrs = null;
    }

    void updateNumNhbrs(Node node) {
        Face face = node.face;
        int n2 = face.getNeighbor(0);
        if (n2 != -1) {
            int n3 = n2;
            this.numNhbrs[n3] = this.numNhbrs[n3] - 1;
        }
        if ((n2 = face.getNeighbor(1)) != -1) {
            int n4 = n2;
            this.numNhbrs[n4] = this.numNhbrs[n4] - 1;
        }
        if ((n2 = face.getNeighbor(2)) != -1) {
            int n5 = n2;
            this.numNhbrs[n5] = this.numNhbrs[n5] - 1;
        }
    }

    int resetNhbr(int n2, Face[] faceArray, Node[] nodeArray) {
        int n3 = -1;
        Face face = faceArray[n2];
        for (int i2 = 0; i2 < 3; ++i2) {
            int n4 = face.getNeighbor(i2);
            if (n4 == -1 || !nodeArray[n4].notAccessed() || n3 != -1 && n3 <= this.numNhbrs[n4]) continue;
            n3 = this.numNhbrs[n4];
        }
        return n3;
    }

    ArrayList hamilton(Node[] nodeArray, int[] nArray, int[] nArray2) {
        int n2 = nodeArray.length;
        int n3 = 0;
        int n4 = 0;
        ArrayList arrayList = new ArrayList();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            Node node;
            ArrayList<Face> arrayList2;
            Node node2 = nodeArray[i2];
            if (node2.isRoot()) {
                ++n4;
                arrayList2 = new ArrayList<Face>();
                arrayList2.add(0, node2.face);
                node = node2.left;
                while (node != null) {
                    arrayList2.add(0, node.face);
                    node = node.left;
                }
                node = node2.right;
                while (node != null) {
                    arrayList2.add(arrayList2.size(), node.face);
                    node = node.left;
                }
                ++n3;
                arrayList.add(arrayList2);
                continue;
            }
            if (node2.numChildren != 2) continue;
            Node node3 = node2.parent;
            if (node3.isRoot() && node3.numChildren == 1) {
                node3 = node2.right;
                node2 = node3.left != null ? node3 : node2.left;
            }
            node2.remove();
            arrayList2 = new ArrayList();
            arrayList2.add(0, node2.face);
            node = node2.left;
            while (node != null) {
                arrayList2.add(0, node.face);
                node = node.left;
            }
            node = node2.right;
            while (node != null) {
                arrayList2.add(arrayList2.size(), node.face);
                node = node.left;
            }
            ++n3;
            arrayList.add(arrayList2);
        }
        nArray[0] = n3;
        nArray2[0] = n4;
        return arrayList;
    }

    ArrayList stripe(ArrayList arrayList) {
        int n2 = arrayList.size();
        ArrayList<Istream> arrayList2 = new ArrayList<Istream>();
        boolean bl = true;
        Vertex[] vertexArray = new Vertex[4];
        for (int i2 = 0; i2 < n2; ++i2) {
            ArrayList arrayList3 = (ArrayList)arrayList.get(i2);
            int n3 = 0;
            boolean bl2 = false;
            Face face = this.getNextFace(arrayList3, n3++);
            while (!bl2) {
                Istream istream;
                boolean bl3 = true;
                if (this.stripDone(arrayList3, n3)) {
                    istream = new Istream(face.verts, 3, false);
                    istream.head = face.key;
                    bl2 = true;
                    istream.tail = face.key;
                } else {
                    Face face2 = face;
                    face = this.getNextFace(arrayList3, n3++);
                    int n4 = face2.findSharedEdge(face.key);
                    vertexArray[0] = face2.verts[n4];
                    vertexArray[1] = face2.verts[(n4 + 1) % 3];
                    vertexArray[2] = face2.verts[(n4 + 2) % 3];
                    n4 = face.findSharedEdge(face2.key);
                    vertexArray[3] = face.verts[n4];
                    istream = new Istream(vertexArray, 4, false);
                    istream.head = face2.key;
                    if (this.stripDone(arrayList3, n3)) {
                        bl2 = true;
                        istream.tail = face.key;
                    }
                    while (bl3 && !this.stripDone(arrayList3, n3)) {
                        face2 = face;
                        if (this.seq(istream, face = this.getNextFace(arrayList3, n3++), n4 = face.findSharedEdge(face2.key))) {
                            istream.append(face.verts[n4]);
                            if (!this.stripDone(arrayList3, n3)) continue;
                            bl2 = true;
                            istream.tail = face.key;
                            continue;
                        }
                        istream.swapEnd();
                        istream.append(face.verts[n4]);
                        if (!this.stripDone(arrayList3, n3)) continue;
                        bl2 = true;
                        istream.tail = face.key;
                    }
                }
                arrayList2.add(istream);
            }
        }
        return arrayList2;
    }

    boolean stripDone(ArrayList arrayList, int n2) {
        return n2 >= arrayList.size();
    }

    boolean seq(Istream istream, Face face, int n2) {
        int n3 = istream.length;
        Vertex vertex = face.edges[n2].v1;
        Vertex vertex2 = face.edges[n2].v2;
        Vertex vertex3 = istream.istream[n3 - 1];
        Vertex vertex4 = istream.istream[n3 - 2];
        return vertex.equals(vertex4) && vertex2.equals(vertex3) || vertex.equals(vertex3) && vertex2.equals(vertex4);
    }

    boolean orientSeq(boolean bl, Istream istream, Face face) {
        int n2 = istream.length;
        Vertex vertex = istream.istream[n2 - 1];
        Vertex vertex2 = istream.istream[n2 - 2];
        return bl && this.checkOrientCCWSeq(vertex, vertex2, face) || !bl && this.checkOrientCWSeq(vertex, vertex2, face);
    }

    boolean orientZAT(boolean bl, Istream istream, Face face) {
        int n2 = istream.length;
        Vertex vertex = istream.istream[n2 - 1];
        Vertex vertex2 = istream.istream[n2 - 3];
        return bl && this.checkOrientCWSeq(vertex, vertex2, face) || !bl && this.checkOrientCCWSeq(vertex, vertex2, face);
    }

    boolean checkOrientCWSeq(Vertex vertex, Vertex vertex2, Face face) {
        System.out.println("checkOrientCWSeq");
        System.out.println("last = " + vertex.index);
        System.out.println("prev = " + vertex2.index);
        System.out.print("face = ");
        face.printVertices();
        return !(vertex.equals(face.verts[0]) ? !vertex2.equals(face.verts[1]) : (vertex.equals(face.verts[1]) ? !vertex2.equals(face.verts[2]) : vertex.equals(face.verts[2]) && !vertex2.equals(face.verts[0])));
    }

    boolean checkOrientCCWSeq(Vertex vertex, Vertex vertex2, Face face) {
        System.out.println("checkOrientCCWSeq");
        System.out.println("last = " + vertex.index);
        System.out.println("prev = " + vertex2.index);
        System.out.print("face = ");
        face.printVertices();
        if (vertex2.equals(face.verts[0])) {
            if (!vertex.equals(face.verts[1])) {
                System.out.println("ORIENTATION PROBLEM!");
                return false;
            }
        } else if (vertex2.equals(face.verts[1])) {
            if (!vertex.equals(face.verts[2])) {
                System.out.println("ORIENTATION PROBLEM!");
                return false;
            }
        } else if (vertex2.equals(face.verts[2]) && !vertex.equals(face.verts[0])) {
            System.out.println("ORIENTATION PROBLEM!");
            return false;
        }
        return true;
    }

    Face getNextFace(ArrayList arrayList, int n2) {
        if (arrayList.size() > n2) {
            return (Face)arrayList.get(n2);
        }
        return null;
    }

    void concatenate(ArrayList arrayList, Face[] faceArray) {
        int n2;
        int n3 = faceArray.length;
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = -1;
        }
        n2 = 0;
        while (n2 < arrayList.size()) {
            Istream istream = (Istream)arrayList.get(n2);
            nArray[istream.head] = n2;
            nArray[istream.tail] = n2++;
        }
        this.reduceCostByTwo(arrayList, faceArray, nArray);
        this.reduceCostByOne(arrayList, faceArray, nArray);
        this.reduceCostByZero(arrayList, faceArray, nArray);
    }

    void reduceCostByTwo(ArrayList arrayList, Face[] faceArray, int[] nArray) {
        int n2 = faceArray.length;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            Vertex vertex;
            Vertex[] vertexArray;
            int n3;
            Istream istream;
            int n4;
            int n5;
            int n6;
            int n7 = nArray[i2];
            if (n7 == -1) continue;
            boolean bl = false;
            boolean bl2 = false;
            Istream istream2 = (Istream)arrayList.get(n7);
            int n8 = istream2.length;
            Vertex[] vertexArray2 = istream2.istream;
            Face face = faceArray[i2];
            Vertex[] vertexArray3 = face.verts;
            if (istream2.fan) continue;
            if (n8 == 3) {
                for (n6 = 0; n6 < 3; ++n6) {
                    n5 = face.getNeighbor(n6);
                    if (n5 == -1 || (n4 = nArray[n5]) == -1 || n4 == n7) continue;
                    vertexArray2[0] = vertexArray3[n6];
                    vertexArray2[1] = vertexArray3[(n6 + 1) % 3];
                    vertexArray2[2] = vertexArray3[(n6 + 2) % 3];
                    istream = (Istream)arrayList.get(n4);
                    n3 = istream.length;
                    if (n5 != istream.head) {
                        istream.invert();
                        if (n3 % 2 != 0) {
                            bl2 = true;
                        }
                    }
                    vertexArray = istream.istream;
                    if (n3 == 3) {
                        int n9 = faceArray[n5].findSharedEdge(i2);
                        istream2.append(faceArray[n5].verts[n9]);
                        istream.length = 0;
                        istream.istream = null;
                        istream2.tail = n5;
                        nArray[n5] = n7;
                        --i2;
                        continue block0;
                    }
                    if (n3 == 4 && vertexArray2[1].index == vertexArray[0].index && vertexArray2[2].index == vertexArray[2].index) {
                        vertex = vertexArray[1];
                        vertexArray[1] = vertexArray[2];
                        vertexArray[2] = vertex;
                    }
                    if (vertexArray2[1].index == vertexArray[0].index && vertexArray2[2].index == vertexArray[1].index) {
                        istream2.addStream(istream);
                        nArray[n5] = -1;
                        nArray[istream2.tail] = n7;
                        --i2;
                        continue block0;
                    }
                    if (!bl2) continue;
                    istream.invert();
                    bl2 = false;
                }
                continue;
            }
            if (i2 != istream2.tail && n8 % 2 != 0) continue;
            if (i2 != istream2.tail) {
                istream2.invert();
                vertexArray2 = istream2.istream;
            }
            vertex = vertexArray2[n8 - 3];
            n6 = -1;
            if (vertexArray3[0].index == vertex.index) {
                n6 = 0;
            } else if (vertexArray3[1].index == vertex.index) {
                n6 = 1;
            } else if (vertexArray3[2].index == vertex.index) {
                n6 = 2;
            }
            if (n6 == -1) {
                // empty if block
            }
            if ((n4 = (n5 = face.getNeighbor(n6)) == -1 ? n5 : nArray[n5]) != -1 && ((Istream)arrayList.get((int)n4)).fan != istream2.fan) {
                n4 = -1;
            }
            if (n4 == -1 || n4 == n7) continue;
            istream = (Istream)arrayList.get(n4);
            n3 = istream.length;
            if (n5 != istream.head) {
                istream.invert();
                if (n3 % 2 != 0) {
                    bl2 = true;
                }
            }
            vertexArray = istream.istream;
            if (n3 == 3) {
                n6 = faceArray[n5].findSharedEdge(i2);
                istream2.append(faceArray[n5].verts[n6]);
                istream.length = 0;
                istream.istream = null;
                istream2.tail = n5;
                nArray[i2] = -1;
                nArray[n5] = n7;
                continue;
            }
            if (n3 == 4 && vertexArray2[n8 - 2].index == vertexArray[0].index && vertexArray2[n8 - 1].index == vertexArray[2].index) {
                vertex = vertexArray[1];
                vertexArray[1] = vertexArray[2];
                vertexArray[2] = vertex;
            }
            if (vertexArray2[n8 - 2].index == vertexArray[0].index && vertexArray2[n8 - 1].index == vertexArray[1].index) {
                istream2.addStream(istream);
                nArray[i2] = -1;
                nArray[istream2.tail] = n7;
                nArray[n5] = -1;
                continue;
            }
            if (!bl2) continue;
            istream.invert();
        }
    }

    void reduceCostByOne(ArrayList arrayList, Face[] faceArray, int[] nArray) {
        int n2 = faceArray.length;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4;
            Vertex vertex;
            Vertex[] vertexArray;
            int n5;
            Istream istream;
            int n6;
            int n7;
            int n8;
            int n9 = nArray[i2];
            if (n9 == -1 || ((Istream)arrayList.get((int)n9)).fan) continue;
            boolean bl = false;
            Istream istream2 = (Istream)arrayList.get(n9);
            Vertex[] vertexArray2 = istream2.istream;
            Face face = faceArray[i2];
            Vertex[] vertexArray3 = face.verts;
            int n10 = istream2.length;
            if (n10 == 3) {
                for (n8 = 0; n8 < 3; ++n8) {
                    n7 = face.getNeighbor(n8);
                    if (n7 == -1 || (n6 = nArray[n7]) == -1 || n6 == n9 || ((Istream)arrayList.get((int)n6)).fan) continue;
                    vertexArray2[0] = vertexArray3[n8];
                    vertexArray2[1] = vertexArray3[(n8 + 1) % 3];
                    vertexArray2[2] = vertexArray3[(n8 + 2) % 3];
                    istream = (Istream)arrayList.get(n6);
                    n5 = istream.length;
                    if (n7 != istream.head) {
                        istream.invert();
                        if (n5 % 2 != 0) {
                            bl = true;
                        }
                    }
                    vertexArray = istream.istream;
                    if (n5 == 4 && (vertexArray2[1].index == vertexArray[2].index && vertexArray2[2].index == vertexArray[0].index || vertexArray2[1].index == vertexArray[0].index && vertexArray2[2].index == vertexArray[2].index)) {
                        vertex = vertexArray[1];
                        vertexArray[1] = vertexArray[2];
                        vertexArray[2] = vertex;
                    }
                    if (vertexArray2[1].index == vertexArray[0].index && vertexArray2[2].index == vertexArray[1].index) {
                        istream2.addStream(istream);
                        nArray[n7] = -1;
                        nArray[istream2.tail] = n9;
                        --i2;
                        continue block0;
                    }
                    if (vertexArray2[1].index == vertexArray[1].index && vertexArray2[2].index == vertexArray[0].index) {
                        istream2.append(vertexArray[1]);
                        istream2.addStream(istream);
                        nArray[n7] = -1;
                        nArray[istream2.tail] = n9;
                        --i2;
                        continue block0;
                    }
                    if (vertexArray2[1].index == vertexArray[0].index && vertexArray2[2].index == vertexArray[2].index) {
                        vertexArray[0] = vertexArray[2];
                        istream2.append(vertexArray[1]);
                        istream2.addStream(istream);
                        nArray[n7] = -1;
                        nArray[istream2.tail] = n9;
                        --i2;
                        continue block0;
                    }
                    if (!bl) continue;
                    istream.invert();
                    bl = false;
                }
                continue;
            }
            if (i2 != istream2.tail && n10 % 2 != 0) continue;
            if (i2 != istream2.tail) {
                istream2.invert();
                vertexArray2 = istream2.istream;
            }
            vertex = vertexArray2[n10 - 3];
            n8 = -1;
            if (vertexArray3[0].index == vertex.index) {
                n8 = 0;
            } else if (vertexArray3[1].index == vertex.index) {
                n8 = 1;
            } else if (vertexArray3[2].index == vertex.index) {
                n8 = 2;
            }
            if (n8 == -1) {
                // empty if block
            }
            if ((n6 = (n7 = face.getNeighbor(n8)) == -1 ? n7 : nArray[n7]) != -1 && ((Istream)arrayList.get((int)n6)).fan != istream2.fan) {
                n6 = -1;
            }
            vertex = vertexArray2[n10 - 2];
            n8 = -1;
            if (vertexArray3[0].index == vertex.index) {
                n8 = 0;
            } else if (vertexArray3[1].index == vertex.index) {
                n8 = 1;
            } else if (vertexArray3[2].index == vertex.index) {
                n8 = 2;
            }
            if (n8 == -1) {
                // empty if block
            }
            if ((n4 = (n3 = face.getNeighbor(n8)) == -1 ? n3 : nArray[n3]) != -1 && ((Istream)arrayList.get((int)n4)).fan != istream2.fan) {
                n4 = -1;
            }
            boolean bl2 = false;
            if (n6 != -1 && n6 != n9) {
                istream = (Istream)arrayList.get(n6);
                n5 = istream.length;
                if (n7 != istream.head) {
                    istream.invert();
                    if (n5 % 2 != 0) {
                        bl = true;
                    }
                }
                vertexArray = istream.istream;
                if (n5 == 4 && (vertexArray2[n10 - 2].index == vertexArray[2].index && vertexArray2[n10 - 1].index == vertexArray[0].index || vertexArray2[n10 - 2].index == vertexArray[0].index && vertexArray2[n10 - 1].index == vertexArray[2].index)) {
                    vertex = vertexArray[1];
                    vertexArray[1] = vertexArray[2];
                    vertexArray[2] = vertex;
                }
                if (vertexArray2[n10 - 2].index == vertexArray[0].index && vertexArray2[n10 - 1].index == vertexArray[1].index) {
                    istream2.addStream(istream);
                    nArray[i2] = -1;
                    nArray[istream2.tail] = n9;
                    nArray[n7] = -1;
                    bl2 = true;
                } else if (vertexArray2[n10 - 2].index == vertexArray[1].index && vertexArray2[n10 - 1].index == vertexArray[0].index) {
                    istream2.append(vertexArray[1]);
                    istream2.addStream(istream);
                    nArray[i2] = -1;
                    nArray[istream2.tail] = n9;
                    nArray[n7] = -1;
                    bl2 = true;
                } else if (vertexArray2[n10 - 2].index == vertexArray[0].index && vertexArray2[n10 - 1].index == vertexArray[2].index) {
                    vertexArray[0] = vertexArray[2];
                    istream2.append(vertexArray[1]);
                    istream2.addStream(istream);
                    nArray[i2] = -1;
                    nArray[istream2.tail] = n9;
                    nArray[n7] = -1;
                    bl2 = true;
                } else if (bl) {
                    istream.invert();
                    bl = false;
                }
            }
            if (bl2 || n4 == -1 || n4 == n9) continue;
            istream = (Istream)arrayList.get(n4);
            n5 = istream.length;
            if (n3 != istream.head) {
                istream.invert();
                if (n5 % 2 != 0) {
                    bl = true;
                }
            }
            vertexArray = istream.istream;
            if (n5 == 4 && vertexArray2[n10 - 3].index == vertexArray[0].index && vertexArray2[n10 - 1].index == vertexArray[2].index) {
                vertex = vertexArray[1];
                vertexArray[1] = vertexArray[2];
                vertexArray[2] = vertex;
            }
            if (vertexArray2[n10 - 3].index == vertexArray[0].index && vertexArray2[n10 - 1].index == vertexArray[1].index) {
                istream2.swapEnd();
                istream2.addStream(istream);
                nArray[i2] = -1;
                nArray[istream2.tail] = n9;
                nArray[n3] = -1;
                bl2 = true;
            }
            if (bl2 || !bl) continue;
            istream.invert();
        }
    }

    void reduceCostByZero(ArrayList arrayList, Face[] faceArray, int[] nArray) {
        int n2 = faceArray.length;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4;
            Vertex[] vertexArray;
            int n5;
            Istream istream;
            int n6;
            int n7;
            int n8;
            int n9 = nArray[i2];
            if (n9 == -1 || ((Istream)arrayList.get((int)n9)).fan) continue;
            boolean bl = false;
            Istream istream2 = (Istream)arrayList.get(n9);
            Vertex[] vertexArray2 = istream2.istream;
            int n10 = istream2.length;
            Face face = faceArray[i2];
            Vertex[] vertexArray3 = face.verts;
            if (n10 == 3) {
                for (n8 = 0; n8 < 3; ++n8) {
                    n7 = face.getNeighbor(n8);
                    if (n7 == -1 || (n6 = nArray[n7]) == -1 || n6 == n9 || ((Istream)arrayList.get((int)n6)).fan) continue;
                    vertexArray2[0] = vertexArray3[n8];
                    vertexArray2[1] = vertexArray3[(n8 + 1) % 3];
                    vertexArray2[2] = vertexArray3[(n8 + 2) % 3];
                    istream = (Istream)arrayList.get(n6);
                    n5 = istream.length;
                    if (n7 != istream.head) {
                        istream.invert();
                        if (n5 % 2 != 0) {
                            bl = true;
                        }
                    }
                    vertexArray = istream.istream;
                    if (vertexArray2[1].index == vertexArray[2].index && vertexArray2[2].index == vertexArray[0].index) {
                        vertexArray[0] = vertexArray[2];
                        istream2.append(vertexArray[0]);
                        istream2.append(vertexArray[1]);
                        istream2.addStream(istream);
                        nArray[n7] = -1;
                        nArray[istream2.tail] = n9;
                        --i2;
                        continue block0;
                    }
                    if (!bl) continue;
                    istream.invert();
                    bl = false;
                }
                continue;
            }
            if (i2 != istream2.tail && n10 % 2 != 0) continue;
            if (i2 != istream2.tail) {
                istream2.invert();
                vertexArray2 = istream2.istream;
            }
            Vertex vertex = vertexArray2[n10 - 3];
            n8 = -1;
            if (vertexArray3[0].index == vertex.index) {
                n8 = 0;
            } else if (vertexArray3[1].index == vertex.index) {
                n8 = 1;
            } else if (vertexArray3[2].index == vertex.index) {
                n8 = 2;
            }
            if (n8 == -1) {
                // empty if block
            }
            if ((n6 = (n7 = face.getNeighbor(n8)) == -1 ? n7 : nArray[n7]) != -1 && ((Istream)arrayList.get((int)n6)).fan != istream2.fan) {
                n6 = -1;
            }
            vertex = vertexArray2[n10 - 2];
            n8 = -1;
            if (vertexArray3[0].index == vertex.index) {
                n8 = 0;
            } else if (vertexArray3[1].index == vertex.index) {
                n8 = 1;
            } else if (vertexArray3[2].index == vertex.index) {
                n8 = 2;
            }
            if (n8 == -1) {
                // empty if block
            }
            if ((n4 = (n3 = face.getNeighbor(n8)) == -1 ? n3 : nArray[n3]) != -1 && ((Istream)arrayList.get((int)n4)).fan != istream2.fan) {
                n4 = -1;
            }
            boolean bl2 = false;
            if (n6 != -1 && n6 != n9) {
                istream = (Istream)arrayList.get(n6);
                n5 = istream.length;
                if (n7 != istream.head) {
                    istream.invert();
                    if (n5 % 2 != 0) {
                        bl = true;
                    }
                }
                vertexArray = istream.istream;
                if (vertexArray2[n10 - 2].index == vertexArray[2].index && vertexArray2[n10 - 1].index == vertexArray[0].index) {
                    vertexArray[0] = vertexArray[2];
                    istream2.append(vertexArray[0]);
                    istream2.append(vertexArray[1]);
                    istream2.addStream(istream);
                    nArray[i2] = -1;
                    nArray[istream2.tail] = n9;
                    nArray[n7] = -1;
                    bl2 = true;
                } else if (bl) {
                    istream.invert();
                    bl = false;
                }
            }
            if (bl2 || n4 == -1 || n4 == n9) continue;
            istream = (Istream)arrayList.get(n4);
            n5 = istream.length;
            if (n3 != istream.head) {
                istream.invert();
                if (n5 % 2 != 0) {
                    bl = true;
                }
            }
            vertexArray = istream.istream;
            if (n5 == 4 && (vertexArray2[n10 - 3].index == vertexArray[2].index && vertexArray2[n10 - 1].index == vertexArray[0].index || vertexArray2[n10 - 3].index == vertexArray[0].index && vertexArray2[n10 - 1].index == vertexArray[2].index)) {
                vertex = vertexArray[1];
                vertexArray[1] = vertexArray[2];
                vertexArray[2] = vertex;
            }
            if (vertexArray2[n10 - 3].index == vertexArray[1].index && vertexArray2[n10 - 1].index == vertexArray[0].index) {
                istream2.swapEnd();
                istream2.append(vertexArray[1]);
                istream2.addStream(istream);
                nArray[i2] = -1;
                nArray[istream2.tail] = n9;
                nArray[n3] = -1;
                continue;
            }
            if (vertexArray2[n10 - 3].index == vertexArray[0].index && vertexArray2[n10 - 1].index == vertexArray[2].index) {
                vertexArray[0] = vertexArray[2];
                istream2.swapEnd();
                istream2.append(vertexArray[1]);
                istream2.addStream(istream);
                nArray[i2] = -1;
                nArray[istream2.tail] = n9;
                nArray[n3] = -1;
                continue;
            }
            if (vertexArray2[n10 - 3].index == vertexArray[0].index && vertexArray2[n10 - 1].index == vertexArray[1].index) {
                istream2.swapEnd();
                istream2.addStream(istream);
                nArray[i2] = -1;
                nArray[istream2.tail] = n9;
                nArray[n3] = -1;
                continue;
            }
            if (!bl) continue;
            istream.invert();
        }
    }

    void putBackData(GeometryInfo geometryInfo, ArrayList arrayList) {
        int[] nArray = new int[arrayList.size()];
        int n2 = 0;
        int n3 = 0;
        while (n3 < arrayList.size()) {
            int n4 = ((Istream)arrayList.get((int)n3)).length;
            if (n4 != 0) {
                nArray[n3] = n4;
                n2 += n4;
                ++n3;
                continue;
            }
            arrayList.remove(n3);
        }
        if (n2 > 3) {
            int n5;
            geometryInfo.setPrimitive(4);
            int[] nArray2 = new int[arrayList.size()];
            System.arraycopy(nArray, 0, nArray2, 0, arrayList.size());
            geometryInfo.setStripCounts(nArray2);
            int[] nArray3 = new int[n2];
            int[] nArray4 = null;
            int[][] nArray5 = null;
            int[] nArray6 = null;
            Object[] objectArray = null;
            if (this.hasNormals) {
                nArray4 = new int[n2];
            }
            if (this.hasTextures) {
                nArray5 = new int[this.texSetCount][n2];
            }
            if (this.hasColors) {
                nArray6 = new int[n2];
            }
            if (this.colorStrips) {
                objectArray = new Color3b[n2];
                nArray6 = new int[n2];
            }
            int n6 = 0;
            for (n5 = 0; n5 < arrayList.size(); ++n5) {
                int n7;
                int n8;
                Istream istream = (Istream)arrayList.get(n5);
                if (istream.length < 3) {
                    throw new RuntimeException("currStrip.length = " + istream.length);
                }
                Color color = null;
                if (this.colorStrips) {
                    n8 = (int)(Math.random() * 1000.0) % 255;
                    n7 = (int)(Math.random() * 1000.0) % 255;
                    int n9 = (int)(Math.random() * 1000.0) % 255;
                    color = new Color(n8, n7, n9);
                }
                for (n8 = 0; n8 < istream.length; ++n8) {
                    nArray3[n6] = istream.istream[n8].index;
                    if (this.hasNormals) {
                        nArray4[n6] = istream.istream[n8].normal;
                    }
                    if (this.hasTextures) {
                        for (n7 = 0; n7 < this.texSetCount; ++n7) {
                            nArray5[n7][n6] = istream.istream[n8].texture[n7];
                        }
                    }
                    if (this.hasColors) {
                        nArray6[n6] = istream.istream[n8].color;
                    }
                    if (this.colorStrips) {
                        objectArray[n6] = new Color3b(color);
                    }
                    ++n6;
                }
            }
            geometryInfo.setCoordinateIndices(nArray3);
            if (this.hasNormals) {
                geometryInfo.setNormalIndices(nArray4);
            }
            if (this.hasTextures) {
                for (n5 = 0; n5 < this.texSetCount; ++n5) {
                    geometryInfo.setTextureCoordinateIndices(n5, nArray5[n5]);
                }
            }
            if (this.hasColors) {
                geometryInfo.setColorIndices(nArray6);
            }
            if (this.colorStrips) {
                geometryInfo.setColors((Color3b[])objectArray);
                nArray6 = geometryInfo.getListIndices(objectArray);
                geometryInfo.setColorIndices(nArray6);
            }
        }
    }

    class Edge {
        Vertex v1;
        Vertex v2;
        int face;

        Edge(Vertex vertex, Vertex vertex2, int n2) {
            this.face = n2;
            if (vertex.lessThan(vertex2)) {
                this.v1 = vertex;
                this.v2 = vertex2;
            } else {
                this.v1 = vertex2;
                this.v2 = vertex;
            }
        }

        boolean equals(Edge edge) {
            return this.v1.equals(edge.v1) && this.v2.equals(edge.v2);
        }

        boolean lessThan(Edge edge) {
            if (this.v1.lessThan(edge.v1)) {
                return true;
            }
            if (this.v1.equals(edge.v1)) {
                return this.v2.lessThan(edge.v2);
            }
            return false;
        }
    }

    class Face {
        int key;
        int numNhbrs = 0;
        Vertex[] verts = null;
        Edge[] edges = null;

        Face(int n2, Vertex vertex, Vertex vertex2, Vertex vertex3) {
            this.key = n2;
            this.verts = new Vertex[3];
            this.verts[0] = vertex;
            this.verts[1] = vertex2;
            this.verts[2] = vertex3;
            this.edges = new Edge[3];
            this.edges[0] = null;
            this.edges[1] = null;
            this.edges[2] = null;
            this.numNhbrs = 3;
        }

        int getNeighbor(int n2) {
            return this.edges[n2].face;
        }

        int findSharedEdge(int n2) {
            if (this.edges[0].face == n2) {
                return 0;
            }
            if (this.edges[1].face == n2) {
                return 1;
            }
            if (this.edges[2].face == n2) {
                return 2;
            }
            return -1;
        }

        int getEdgeIndex(Edge edge) {
            if (this.edges[0].equals(edge)) {
                return 0;
            }
            if (this.edges[1].equals(edge)) {
                return 1;
            }
            return 2;
        }

        void counterEdgeDel(Edge edge) {
            if (this.edges[0].equals(edge)) {
                this.edges[0].face = -1;
                --this.numNhbrs;
            } else if (this.edges[1].equals(edge)) {
                this.edges[1].face = -1;
                --this.numNhbrs;
            } else if (this.edges[2].equals(edge)) {
                this.edges[2].face = -1;
                --this.numNhbrs;
            }
        }

        void printAdjacency() {
            System.out.println("Face " + this.key + ": ");
            System.out.println("\t numNhbrs = " + this.numNhbrs);
            System.out.println("\t edge 0: Face " + this.edges[0].face);
            System.out.println("\t edge 1: Face " + this.edges[1].face);
            System.out.println("\t edge 2: Face " + this.edges[2].face);
        }

        void printVertices() {
            System.out.println("Face " + this.key + ": (" + this.verts[0].index + ", " + this.verts[1].index + ", " + this.verts[2].index + ")");
        }
    }

    class Istream {
        boolean fan = false;
        int length = 0;
        Vertex[] istream;
        int head;
        int tail;

        Istream(Vertex[] vertexArray, int n2, boolean bl) {
            if (n2 == 0) {
                throw new RuntimeException("size is 0");
            }
            this.fan = bl;
            this.length = n2;
            this.istream = new Vertex[this.length];
            System.arraycopy(vertexArray, 0, this.istream, 0, this.length);
        }

        void append(Vertex vertex) {
            this.growArray();
            this.istream[this.length] = vertex;
            ++this.length;
        }

        void swapEnd() {
            this.growArray();
            this.istream[this.length] = this.istream[this.length - 1];
            this.istream[this.length - 1] = this.istream[this.length - 3];
            ++this.length;
        }

        void growArray() {
            if (this.length >= this.istream.length) {
                Vertex[] vertexArray = this.istream;
                this.istream = new Vertex[this.length + 3];
                System.arraycopy(vertexArray, 0, this.istream, 0, this.length);
            }
        }

        void invert() {
            int n2;
            Vertex[] vertexArray = new Vertex[this.istream.length];
            for (n2 = 0; n2 < this.length; ++n2) {
                vertexArray[n2] = this.istream[this.length - n2 - 1];
            }
            System.arraycopy(vertexArray, 0, this.istream, 0, this.istream.length);
            vertexArray = null;
            n2 = this.head;
            this.head = this.tail;
            this.tail = n2;
        }

        void addStream(Istream istream) {
            int n2 = istream.length;
            int n3 = n2 + this.length - 2;
            if (n3 >= this.istream.length) {
                Vertex[] vertexArray = this.istream;
                this.istream = new Vertex[n3];
                System.arraycopy(vertexArray, 0, this.istream, 0, this.length);
            }
            System.arraycopy(istream.istream, 2, this.istream, this.length, n2 - 2);
            this.tail = istream.tail;
            this.length = n3;
            istream.length = 0;
            istream.istream = null;
        }
    }

    class Node {
        Face face;
        Node parent;
        Node left;
        Node right;
        int depth;
        int numChildren;
        int attrib;
        static final int WHITE = 0;
        static final int GREY = 1;
        static final int BLACK = 2;

        Node(Face face) {
            this.face = face;
        }

        void insert(Node node) {
            this.parent = node;
            this.depth = node.depth + 1;
            this.attrib = 1;
            if (this.parent.left == null) {
                this.parent.left = this;
            } else {
                this.parent.right = this;
            }
            ++this.parent.numChildren;
        }

        void remove() {
            if (this.parent != null) {
                if (this.parent.left == this) {
                    this.parent.left = this.parent.right;
                    this.parent.right = null;
                } else {
                    this.parent.right = null;
                }
                --this.parent.numChildren;
            }
        }

        void setRoot() {
            this.depth = 0;
            this.attrib = 1;
        }

        boolean notAccessed() {
            return this.attrib == 0;
        }

        void processed() {
            this.attrib = 2;
        }

        boolean isRoot() {
            return this.parent == null;
        }

        void print() {
            System.out.println(this);
            System.out.println("Node depth: " + this.depth);
            this.face.printVertices();
            System.out.print("parent: ");
            if (this.parent != null) {
                this.parent.face.printVertices();
            } else {
                System.out.println("null");
            }
            System.out.print("left: ");
            if (this.left != null) {
                this.left.face.printVertices();
            } else {
                System.out.println("null");
            }
            System.out.print("right: ");
            if (this.right != null) {
                this.right.face.printVertices();
            } else {
                System.out.println("null");
            }
            System.out.println("attrib: " + this.attrib);
            System.out.println("");
        }
    }

    class SortedList {
        ArrayList list = new ArrayList();

        SortedList() {
        }

        int sortedInsert(Node node, int n2) {
            while (n2 < this.list.size() && ((Node)this.list.get((int)n2)).depth <= node.depth) {
                ++n2;
            }
            this.list.add(n2, node);
            return n2 + 1;
        }

        Node pop() {
            if (!this.list.isEmpty()) {
                return (Node)this.list.remove(0);
            }
            return null;
        }
    }

    class Vertex {
        int index;
        int normal = -1;
        int numTexSets = 0;
        int[] texture = null;
        int color = -1;

        Vertex(int n2) {
            this(n2, -1, 0, null, -1);
        }

        Vertex(int n2, int n3, int n4, int[] nArray, int n5) {
            this.index = n2;
            this.normal = n3;
            this.numTexSets = n4;
            if (this.numTexSets > 0) {
                this.texture = new int[this.numTexSets];
                System.arraycopy(nArray, 0, this.texture, 0, this.numTexSets);
            }
            this.color = n5;
        }

        boolean equals(Vertex vertex) {
            for (int i2 = 0; i2 < this.numTexSets; ++i2) {
                if (this.texture[i2] == vertex.texture[i2]) continue;
                return false;
            }
            return vertex.index == this.index && vertex.normal == this.normal && vertex.color == this.color;
        }

        boolean lessThan(Vertex vertex) {
            if (this.index < vertex.index) {
                return true;
            }
            if (this.index > vertex.index) {
                return false;
            }
            if (this.normal < vertex.normal) {
                return true;
            }
            if (this.normal > vertex.normal) {
                return false;
            }
            for (int i2 = 0; i2 < this.numTexSets; ++i2) {
                if (this.texture[i2] < vertex.texture[i2]) {
                    return true;
                }
                if (this.texture[i2] <= vertex.texture[i2]) continue;
                return false;
            }
            if (this.color < vertex.color) {
                return true;
            }
            if (this.color > vertex.color) {
                return false;
            }
            return false;
        }
    }
}

