/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry.compression;

import com.sun.j3d.utils.geometry.compression.CompressionStreamVertex;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

class MeshBuffer {
    static final int NOT_FOUND = -1;
    private static final int SIZE = 16;
    private static final int NAN_HASH = new Point3f(Float.NaN, Float.NaN, Float.NaN).hashCode();
    private int topIndex = 15;
    private int[] positionIndices = new int[16];
    private int[] normalIndices = new int[16];
    private int[] colorIndices = new int[16];
    private int topPosition = 15;
    private int[] positionHashCodes = new int[16];
    private Point3f[] positions = new Point3f[16];
    private Vector3f[] normals = new Vector3f[16];
    private Color3f[] colors3 = new Color3f[16];
    private Color4f[] colors4 = new Color4f[16];
    private int topVertex = 15;
    private CompressionStreamVertex[] vertices = new CompressionStreamVertex[16];

    MeshBuffer() {
        for (int i2 = 0; i2 < 16; ++i2) {
            this.positionHashCodes[i2] = NAN_HASH;
            this.positionIndices[i2] = -1;
            this.normalIndices[i2] = -1;
            this.colorIndices[i2] = -1;
        }
    }

    private static int nextTop(int n2) {
        return (n2 + 1) % 16;
    }

    private static int flipOffset(int n2, int n3) {
        if (n3 > n2) {
            n3 -= 16;
        }
        return n2 - n3;
    }

    void push(CompressionStreamVertex compressionStreamVertex) {
        this.topVertex = MeshBuffer.nextTop(this.topVertex);
        this.vertices[this.topVertex] = compressionStreamVertex;
    }

    CompressionStreamVertex getVertex(int n2) {
        return this.vertices[MeshBuffer.flipOffset(this.topVertex, n2)];
    }

    void push(int n2, int n3) {
        this.topIndex = MeshBuffer.nextTop(this.topIndex);
        this.positionIndices[this.topIndex] = n2;
        this.normalIndices[this.topIndex] = n3;
    }

    void push(int n2, int n3, int n4) {
        this.push(n2, n4);
        this.colorIndices[this.topIndex] = n3;
    }

    int getMeshReference(int n2) {
        int n3;
        for (n3 = 0; n3 < 16 && this.positionIndices[n3] != n2; ++n3) {
        }
        if (n3 == 16) {
            return -1;
        }
        return MeshBuffer.flipOffset(this.topIndex, n3);
    }

    int getPositionIndex(int n2) {
        return this.positionIndices[MeshBuffer.flipOffset(this.topIndex, n2)];
    }

    int getColorIndex(int n2) {
        return this.colorIndices[MeshBuffer.flipOffset(this.topIndex, n2)];
    }

    int getNormalIndex(int n2) {
        return this.normalIndices[MeshBuffer.flipOffset(this.topIndex, n2)];
    }

    void push(Point3f point3f, Vector3f vector3f) {
        this.topPosition = MeshBuffer.nextTop(this.topPosition);
        this.positionHashCodes[this.topPosition] = point3f.hashCode();
        this.positions[this.topPosition] = point3f;
        this.normals[this.topPosition] = vector3f;
    }

    void push(Point3f point3f, Color3f color3f, Vector3f vector3f) {
        this.push(point3f, vector3f);
        this.colors3[this.topPosition] = color3f;
    }

    void push(Point3f point3f, Color4f color4f, Vector3f vector3f) {
        this.push(point3f, vector3f);
        this.colors4[this.topPosition] = color4f;
    }

    void push(Point3f point3f, Object object, Vector3f vector3f) {
        this.push(point3f, vector3f);
        if (object instanceof Color3f) {
            this.colors3[this.topPosition] = (Color3f)object;
        } else {
            this.colors4[this.topPosition] = (Color4f)object;
        }
    }

    int getMeshReference(Point3f point3f) {
        int n2;
        int n3 = point3f.hashCode();
        for (n2 = 0; !(n2 >= 16 || this.positionHashCodes[n2] == n3 && this.positions[n2].equals(point3f)); ++n2) {
        }
        if (n2 == 16) {
            return -1;
        }
        return MeshBuffer.flipOffset(this.topPosition, n2);
    }

    Point3f getPosition(int n2) {
        return this.positions[MeshBuffer.flipOffset(this.topPosition, n2)];
    }

    Color3f getColor3(int n2) {
        return this.colors3[MeshBuffer.flipOffset(this.topPosition, n2)];
    }

    Color4f getColor4(int n2) {
        return this.colors4[MeshBuffer.flipOffset(this.topPosition, n2)];
    }

    Vector3f getNormal(int n2) {
        return this.normals[MeshBuffer.flipOffset(this.topPosition, n2)];
    }
}

