/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.picking;

import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CompressedGeometry;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.Locale;
import javax.media.j3d.Morph;
import javax.media.j3d.Node;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickConeRay;
import javax.media.j3d.PickConeSegment;
import javax.media.j3d.PickCylinderRay;
import javax.media.j3d.PickCylinderSegment;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class PickTool {
    private final boolean debug = true;
    protected boolean userDefineShape = false;
    PickShape pickShape;
    BranchGroup pickRootBG = null;
    Locale pickRootL = null;
    Point3d start = null;
    int mode = 512;
    public static final int BOUNDS = 512;
    public static final int GEOMETRY = 256;
    public static final int GEOMETRY_INTERSECT_INFO = 1024;
    public static final int INTERSECT_TEST = 4097;
    public static final int INTERSECT_COORD = 4098;
    public static final int INTERSECT_FULL = 4100;

    public PickTool(BranchGroup branchGroup) {
        this.pickRootBG = branchGroup;
    }

    public BranchGroup getBranchGroup() {
        return this.pickRootBG;
    }

    public PickTool(Locale locale) {
        this.pickRootL = locale;
    }

    public Locale getLocale() {
        return this.pickRootL;
    }

    public Locale setBranchGroup(Locale locale) {
        return locale;
    }

    public static void setCapabilities(Node node, int n2) {
        if (node instanceof Morph) {
            Morph morph = (Morph)node;
            switch (n2) {
                case 4098: 
                case 4100: {
                    morph.setCapability(12);
                }
                case 4097: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Improper level");
                }
            }
            double[] dArray = morph.getWeights();
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                GeometryArray geometryArray = morph.getGeometryArray(i2);
                PickTool.setCapabilities(geometryArray, n2);
            }
        } else if (node instanceof Shape3D) {
            Shape3D shape3D = (Shape3D)node;
            switch (n2) {
                case 4098: 
                case 4100: {
                    shape3D.setCapability(12);
                }
                case 4097: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Improper level");
                }
            }
            for (int i3 = 0; i3 < shape3D.numGeometries(); ++i3) {
                Geometry geometry = shape3D.getGeometry(i3);
                if (geometry instanceof GeometryArray) {
                    PickTool.setCapabilities((GeometryArray)geometry, n2);
                    continue;
                }
                if (!(geometry instanceof CompressedGeometry)) continue;
                PickTool.setCapabilities((CompressedGeometry)geometry, n2);
            }
        } else {
            throw new IllegalArgumentException("Improper node type");
        }
    }

    private static void setCapabilities(GeometryArray geometryArray, int n2) {
        switch (n2) {
            case 4100: {
                geometryArray.setCapability(2);
                geometryArray.setCapability(4);
                geometryArray.setCapability(6);
            }
            case 4098: {
                geometryArray.setCapability(8);
                geometryArray.setCapability(17);
                geometryArray.setCapability(0);
            }
            case 4097: {
                geometryArray.setCapability(18);
            }
        }
        if (geometryArray instanceof IndexedGeometryArray) {
            PickTool.setCapabilities((IndexedGeometryArray)geometryArray, n2);
        }
    }

    private static void setCapabilities(IndexedGeometryArray indexedGeometryArray, int n2) {
        switch (n2) {
            case 4100: {
                indexedGeometryArray.setCapability(11);
                indexedGeometryArray.setCapability(13);
                indexedGeometryArray.setCapability(15);
            }
            case 4098: {
                indexedGeometryArray.setCapability(9);
            }
        }
    }

    private static void setCapabilities(CompressedGeometry compressedGeometry, int n2) {
        switch (n2) {
            case 4098: 
            case 4100: {
                compressedGeometry.setCapability(2);
            }
            case 4097: {
                compressedGeometry.setCapability(18);
            }
        }
    }

    public void setShape(PickShape pickShape, Point3d point3d) {
        this.pickShape = pickShape;
        this.start = point3d;
        this.userDefineShape = pickShape != null;
    }

    public void setShapeBounds(Bounds bounds, Point3d point3d) {
        this.pickShape = new PickBounds(bounds);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setMode(int n2) {
        if (n2 != 512 && n2 != 256 && n2 != 1024) {
            throw new IllegalArgumentException();
        }
        this.mode = n2;
    }

    public int getMode() {
        return this.mode;
    }

    public void setShapeRay(Point3d point3d, Vector3d vector3d) {
        this.pickShape = new PickRay(point3d, vector3d);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeSegment(Point3d point3d, Point3d point3d2) {
        this.pickShape = new PickSegment(point3d, point3d2);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeCylinderSegment(Point3d point3d, Point3d point3d2, double d2) {
        this.pickShape = new PickCylinderSegment(point3d, point3d2, d2);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeCylinderRay(Point3d point3d, Vector3d vector3d, double d2) {
        this.pickShape = new PickCylinderRay(point3d, vector3d, d2);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeConeSegment(Point3d point3d, Point3d point3d2, double d2) {
        this.pickShape = new PickConeSegment(point3d, point3d2, d2);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeConeRay(Point3d point3d, Vector3d vector3d, double d2) {
        this.pickShape = new PickConeRay(point3d, vector3d, d2);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public PickShape getPickShape() {
        return this.pickShape;
    }

    public Point3d getStartPosition() {
        return this.start;
    }

    public PickResult[] pickAll() {
        PickResult[] pickResultArray = null;
        switch (this.mode) {
            case 512: {
                pickResultArray = this.pickAll(this.pickShape);
                break;
            }
            case 256: {
                pickResultArray = this.pickGeomAll(this.pickShape);
                break;
            }
            case 1024: {
                pickResultArray = this.pickGeomAllIntersect(this.pickShape);
                break;
            }
            default: {
                throw new RuntimeException("Invalid pick mode");
            }
        }
        return pickResultArray;
    }

    public PickResult pickAny() {
        PickResult pickResult = null;
        switch (this.mode) {
            case 512: {
                pickResult = this.pickAny(this.pickShape);
                break;
            }
            case 256: {
                pickResult = this.pickGeomAny(this.pickShape);
                break;
            }
            case 1024: {
                pickResult = this.pickGeomAnyIntersect(this.pickShape);
                break;
            }
            default: {
                throw new RuntimeException("Invalid pick mode");
            }
        }
        return pickResult;
    }

    public PickResult[] pickAllSorted() {
        PickResult[] pickResultArray = null;
        switch (this.mode) {
            case 512: {
                pickResultArray = this.pickAllSorted(this.pickShape);
                break;
            }
            case 256: {
                pickResultArray = this.pickGeomAllSorted(this.pickShape);
                break;
            }
            case 1024: {
                pickResultArray = this.pickGeomAllSortedIntersect(this.pickShape);
                break;
            }
            default: {
                throw new RuntimeException("Invalid pick mode");
            }
        }
        return pickResultArray;
    }

    public PickResult pickClosest() {
        PickResult pickResult = null;
        switch (this.mode) {
            case 512: {
                pickResult = this.pickClosest(this.pickShape);
                break;
            }
            case 256: {
                pickResult = this.pickGeomClosest(this.pickShape);
                break;
            }
            case 1024: {
                pickResult = this.pickGeomClosestIntersect(this.pickShape);
                break;
            }
            default: {
                throw new RuntimeException("Invalid pick mode");
            }
        }
        return pickResult;
    }

    private PickResult[] pickAll(PickShape pickShape) {
        PickResult[] pickResultArray = null;
        SceneGraphPath[] sceneGraphPathArray = null;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        pickResultArray = new PickResult[sceneGraphPathArray.length];
        for (int i2 = 0; i2 < sceneGraphPathArray.length; ++i2) {
            pickResultArray[i2] = new PickResult(sceneGraphPathArray[i2], pickShape);
        }
        return pickResultArray;
    }

    private PickResult[] pickAllSorted(PickShape pickShape) {
        PickResult[] pickResultArray = null;
        SceneGraphPath[] sceneGraphPathArray = null;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAllSorted(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAllSorted(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        pickResultArray = new PickResult[sceneGraphPathArray.length];
        for (int i2 = 0; i2 < sceneGraphPathArray.length; ++i2) {
            pickResultArray[i2] = new PickResult(sceneGraphPathArray[i2], pickShape);
        }
        return pickResultArray;
    }

    private PickResult pickAny(PickShape pickShape) {
        PickResult pickResult = null;
        SceneGraphPath sceneGraphPath = null;
        if (this.pickRootBG != null) {
            sceneGraphPath = this.pickRootBG.pickAny(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPath = this.pickRootL.pickAny(pickShape);
        }
        if (sceneGraphPath == null) {
            return null;
        }
        pickResult = new PickResult(sceneGraphPath, pickShape);
        return pickResult;
    }

    private PickResult pickClosest(PickShape pickShape) {
        PickResult pickResult = null;
        SceneGraphPath sceneGraphPath = null;
        if (this.pickRootBG != null) {
            sceneGraphPath = this.pickRootBG.pickClosest(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPath = this.pickRootL.pickClosest(pickShape);
        }
        if (sceneGraphPath == null) {
            return null;
        }
        pickResult = new PickResult(sceneGraphPath, pickShape);
        return pickResult;
    }

    private PickResult[] pickGeomAll(PickShape pickShape) {
        int n2;
        SceneGraphPath[] sceneGraphPathArray = null;
        Node[] nodeArray = null;
        int n3 = 0;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[sceneGraphPathArray.length];
        nodeArray = new Node[sceneGraphPathArray.length];
        PickResult[] pickResultArray = new PickResult[sceneGraphPathArray.length];
        for (n2 = 0; n2 < sceneGraphPathArray.length; ++n2) {
            nodeArray[n2] = sceneGraphPathArray[n2].getObject();
            pickResultArray[n2] = new PickResult(sceneGraphPathArray[n2], pickShape);
            if (nodeArray[n2] instanceof Shape3D) {
                blArray[n2] = ((Shape3D)nodeArray[n2]).intersect(sceneGraphPathArray[n2], pickShape);
            } else if (nodeArray[n2] instanceof Morph) {
                blArray[n2] = ((Morph)nodeArray[n2]).intersect(sceneGraphPathArray[n2], pickShape);
            }
            if (!blArray[n2]) continue;
            ++n3;
        }
        if (n3 == 0) {
            return null;
        }
        PickResult[] pickResultArray2 = new PickResult[n3];
        n3 = 0;
        for (n2 = 0; n2 < sceneGraphPathArray.length; ++n2) {
            if (!blArray[n2]) continue;
            pickResultArray[n3++] = pickResultArray[n2];
        }
        return pickResultArray;
    }

    private PickResult[] pickGeomAllSorted(PickShape pickShape) {
        int n2;
        SceneGraphPath[] sceneGraphPathArray = null;
        Node[] nodeArray = null;
        int n3 = 0;
        double[] dArray = new double[1];
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[sceneGraphPathArray.length];
        double[] dArray2 = new double[sceneGraphPathArray.length];
        nodeArray = new Node[sceneGraphPathArray.length];
        PickResult[] pickResultArray = new PickResult[sceneGraphPathArray.length];
        for (n2 = 0; n2 < sceneGraphPathArray.length; ++n2) {
            nodeArray[n2] = sceneGraphPathArray[n2].getObject();
            pickResultArray[n2] = new PickResult(sceneGraphPathArray[n2], pickShape);
            if (nodeArray[n2] instanceof Shape3D) {
                blArray[n2] = ((Shape3D)nodeArray[n2]).intersect(sceneGraphPathArray[n2], pickShape, dArray);
                dArray2[n2] = dArray[0];
            } else if (nodeArray[n2] instanceof Morph) {
                blArray[n2] = ((Morph)nodeArray[n2]).intersect(sceneGraphPathArray[n2], pickShape, dArray);
                dArray2[n2] = dArray[0];
            }
            if (!blArray[n2]) continue;
            ++n3;
        }
        if (n3 == 0) {
            return null;
        }
        PickResult[] pickResultArray2 = new PickResult[n3];
        double[] dArray3 = new double[n3];
        n3 = 0;
        for (n2 = 0; n2 < sceneGraphPathArray.length; ++n2) {
            if (!blArray[n2]) continue;
            dArray3[n3] = dArray2[n2];
            pickResultArray2[n3++] = pickResultArray[n2];
        }
        if (n3 > 1) {
            return this.sortPickResults(pickResultArray2, dArray3);
        }
        return pickResultArray2;
    }

    private PickResult pickGeomAny(PickShape pickShape) {
        Node node = null;
        SceneGraphPath[] sceneGraphPathArray = null;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < sceneGraphPathArray.length; ++i2) {
            node = sceneGraphPathArray[i2].getObject();
            PickResult pickResult = new PickResult(sceneGraphPathArray[i2], pickShape);
            if (!(node instanceof Shape3D ? ((Shape3D)node).intersect(sceneGraphPathArray[i2], pickShape) : node instanceof Morph && ((Morph)node).intersect(sceneGraphPathArray[i2], pickShape))) continue;
            return pickResult;
        }
        return null;
    }

    private PickResult pickGeomClosest(PickShape pickShape) {
        PickResult[] pickResultArray = this.pickGeomAllSorted(pickShape);
        if (pickResultArray == null) {
            return null;
        }
        return pickResultArray[0];
    }

    private PickResult[] pickGeomAllIntersect(PickShape pickShape) {
        int n2;
        SceneGraphPath[] sceneGraphPathArray = null;
        Object var3_3 = null;
        int n3 = 0;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[sceneGraphPathArray.length];
        PickResult[] pickResultArray = new PickResult[sceneGraphPathArray.length];
        for (n2 = 0; n2 < sceneGraphPathArray.length; ++n2) {
            pickResultArray[n2] = new PickResult(sceneGraphPathArray[n2], pickShape);
            if (pickResultArray[n2].numIntersections() <= 0) continue;
            blArray[n2] = true;
            ++n3;
        }
        if (n3 == 0) {
            return null;
        }
        PickResult[] pickResultArray2 = new PickResult[n3];
        n3 = 0;
        for (n2 = 0; n2 < sceneGraphPathArray.length; ++n2) {
            if (!blArray[n2]) continue;
            pickResultArray[n3++] = pickResultArray[n2];
        }
        return pickResultArray;
    }

    private PickResult[] pickGeomAllSortedIntersect(PickShape pickShape) {
        int n2;
        SceneGraphPath[] sceneGraphPathArray = null;
        Object var3_3 = null;
        int n3 = 0;
        double[] dArray = new double[1];
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[sceneGraphPathArray.length];
        double[] dArray2 = new double[sceneGraphPathArray.length];
        PickResult[] pickResultArray = new PickResult[sceneGraphPathArray.length];
        for (n2 = 0; n2 < sceneGraphPathArray.length; ++n2) {
            pickResultArray[n2] = new PickResult(sceneGraphPathArray[n2], pickShape);
            int n4 = pickResultArray[n2].numIntersections();
            if (n4 <= 0) continue;
            blArray[n2] = true;
            boolean bl = false;
            double d2 = pickResultArray[n2].getIntersection(0).getDistance();
            int n5 = 0;
            for (int i2 = 1; i2 < n4; ++i2) {
                double d3 = pickResultArray[n2].getIntersection(i2).getDistance();
                if (!(d2 > d3)) continue;
                d2 = d3;
                n5 = i2;
                bl = true;
            }
            if (bl) {
                PickIntersection pickIntersection = pickResultArray[n2].getIntersection(0);
                PickIntersection pickIntersection2 = pickResultArray[n2].getIntersection(n5);
                pickResultArray[n2].intersections.set(0, pickIntersection2);
                pickResultArray[n2].intersections.set(n5, pickIntersection);
            }
            dArray2[n2] = pickResultArray[n2].getIntersection(0).getDistance();
            ++n3;
        }
        if (n3 == 0) {
            return null;
        }
        PickResult[] pickResultArray2 = new PickResult[n3];
        double[] dArray3 = new double[n3];
        n3 = 0;
        for (n2 = 0; n2 < sceneGraphPathArray.length; ++n2) {
            if (!blArray[n2]) continue;
            dArray3[n3] = dArray2[n2];
            pickResultArray2[n3++] = pickResultArray[n2];
        }
        if (n3 > 1) {
            return this.sortPickResults(pickResultArray2, dArray3);
        }
        return pickResultArray2;
    }

    private PickResult pickGeomClosestIntersect(PickShape pickShape) {
        PickResult[] pickResultArray = this.pickGeomAllSortedIntersect(pickShape);
        if (pickResultArray == null) {
            return null;
        }
        return pickResultArray[0];
    }

    private PickResult pickGeomAnyIntersect(PickShape pickShape) {
        Object var2_2 = null;
        SceneGraphPath[] sceneGraphPathArray = null;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < sceneGraphPathArray.length; ++i2) {
            PickResult pickResult = new PickResult(sceneGraphPathArray[i2], pickShape);
            pickResult.setFirstIntersectOnly(true);
            if (pickResult.numIntersections() <= 0) continue;
            return pickResult;
        }
        return null;
    }

    private PickResult[] sortPickResults(PickResult[] pickResultArray, double[] dArray) {
        int n2;
        int[] nArray = new int[pickResultArray.length];
        PickResult[] pickResultArray2 = new PickResult[pickResultArray.length];
        for (n2 = 0; n2 < pickResultArray.length; ++n2) {
            nArray[n2] = n2;
        }
        this.quicksort(0, dArray.length - 1, dArray, nArray);
        for (n2 = 0; n2 < pickResultArray.length; ++n2) {
            pickResultArray2[n2] = pickResultArray[nArray[n2]];
        }
        return pickResultArray2;
    }

    private final void quicksort(int n2, int n3, double[] dArray, int[] nArray) {
        int n4 = n2;
        int n5 = n3;
        double d2 = dArray[(n2 + n3) / 2];
        while (true) {
            if (dArray[n4] < d2) {
                ++n4;
                continue;
            }
            while (d2 < dArray[n5]) {
                --n5;
            }
            if (n4 <= n5) {
                double d3 = dArray[n4];
                dArray[n4] = dArray[n5];
                dArray[n5] = d3;
                int n6 = nArray[n4];
                nArray[n4] = nArray[n5];
                nArray[n5] = n6;
                ++n4;
                --n5;
            }
            if (n4 > n5) break;
        }
        if (n2 < n5) {
            this.quicksort(n2, n5, dArray, nArray);
        }
        if (n2 < n3) {
            this.quicksort(n4, n3, dArray, nArray);
        }
    }
}

