/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.Collection;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;

class ConfigCommand {
    static final int CREATE = 0;
    static final int ATTRIBUTE = 1;
    static final int PROPERTY = 2;
    static final int ALIAS = 3;
    static final int BUILTIN = 4;
    static final int INCLUDE = 5;
    static final int IGNORE = 6;
    int type = -1;
    int argc = 0;
    Object[] argv = null;
    String commandName = null;
    String baseName = null;
    String instanceName = null;
    String fileName = null;
    int lineNumber = 0;

    ConfigCommand(Collection collection, String string, int n2) {
        this.fileName = string;
        this.lineNumber = n2;
        this.argc = collection.size();
        this.argv = collection.toArray(new Object[0]);
        if (this.argc <= 0 || !(this.argv[0] instanceof String)) {
            throw new IllegalArgumentException("malformed command");
        }
        this.commandName = (String)this.argv[0];
        if (this.commandName.startsWith("New")) {
            this.type = 0;
            this.baseName = this.commandName.substring(3);
            this.instanceName = this.checkName(this.argv[1]);
        } else if (this.commandName.endsWith("Property")) {
            this.baseName = this.commandName.substring(0, this.commandName.length() - 8);
            if (this.baseName.equals("Java")) {
                this.type = 6;
                ConfigCommand.processJavaProperty(this.argc, this.argv);
            } else {
                this.type = 2;
                this.instanceName = this.checkName(this.argv[1]);
            }
        } else if (this.commandName.endsWith("Attribute")) {
            this.type = 2;
            this.baseName = this.commandName.substring(0, this.commandName.length() - 9);
            this.instanceName = this.checkName(this.argv[1]);
        } else if (this.commandName.endsWith("Alias")) {
            this.type = 3;
            this.baseName = this.commandName.substring(0, this.commandName.length() - 5);
            this.instanceName = this.checkName(this.argv[1]);
        } else {
            this.type = this.commandName.equals("Include") ? 5 : 4;
        }
        if (this.baseName != null && this.baseName.equals("Window")) {
            this.baseName = "Screen";
        }
    }

    private static void processJavaProperty(int n2, Object[] objectArray) {
        for (int i2 = 1; i2 < n2; ++i2) {
            if (objectArray[i2] instanceof Boolean) {
                objectArray[i2] = ((Boolean)objectArray[i2]).toString();
                continue;
            }
            if (objectArray[i2] instanceof String) continue;
            throw new IllegalArgumentException("JavaProperty arguments must be Strings or Booleans");
        }
        if (n2 == 3) {
            ConfigCommand.setJavaProperty((String)objectArray[1], (String)objectArray[2]);
        } else {
            if (n2 != 4) {
                throw new IllegalArgumentException("JavaProperty must have either 2 or 3 arguments");
            }
            if (!((String)objectArray[2]).equals("Default")) {
                throw new IllegalArgumentException("JavaProperty 2nd argument must be \"Default\"");
            }
            if (ConfigCommand.evaluateJavaProperty((String)objectArray[1]) == null) {
                ConfigCommand.setJavaProperty((String)objectArray[1], (String)objectArray[3]);
            }
        }
    }

    static String setJavaProperty(final String string, final String string2) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.setProperty(string, string2);
            }
        });
    }

    static String evaluateJavaProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    private final String checkName(Object object) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("second argument to \"" + this.commandName + "\" must be a name");
        }
        return (String)object;
    }

    static String[] formatMatrixRows(Matrix3d matrix3d) {
        double[] dArray = new double[]{matrix3d.m00, matrix3d.m01, matrix3d.m02, matrix3d.m10, matrix3d.m11, matrix3d.m12, matrix3d.m20, matrix3d.m21, matrix3d.m22};
        return ConfigCommand.formatMatrixRows(3, 3, dArray);
    }

    static String[] formatMatrixRows(Matrix4d matrix4d) {
        double[] dArray = new double[]{matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m03, matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m13, matrix4d.m20, matrix4d.m21, matrix4d.m22, matrix4d.m23, matrix4d.m30, matrix4d.m31, matrix4d.m32, matrix4d.m33};
        return ConfigCommand.formatMatrixRows(4, 4, dArray);
    }

    static String[] formatMatrixRows(int n2, int n3, double[] dArray) {
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        FieldPosition fieldPosition = new FieldPosition(0);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.setLength(0);
            for (int i3 = 0; i3 < n3; ++i3) {
                stringBuffer2.setLength(0);
                decimalFormat.format(dArray[i2 * n3 + i3], stringBuffer2, fieldPosition);
                int n4 = 8 - fieldPosition.getEndIndex();
                for (int i4 = 0; i4 < n4; ++i4) {
                    stringBuffer2.insert(0, " ");
                }
                stringBuffer.append(stringBuffer2);
            }
            stringArray[i2] = stringBuffer.toString();
        }
        return stringArray;
    }

    public String toString() {
        String[] stringArray = null;
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i2 = 0; i2 < this.argc; ++i2) {
            if (this.argv[i2] instanceof Matrix3d) {
                stringArray = ConfigCommand.formatMatrixRows((Matrix3d)this.argv[i2]);
                stringBuffer.append("\n ((" + stringArray[0] + ")\n");
                stringBuffer.append("  (" + stringArray[1] + ")\n");
                stringBuffer.append("  (" + stringArray[2] + "))");
                if (i2 == this.argc - 1) continue;
                stringBuffer.append("\n");
                continue;
            }
            if (this.argv[i2] instanceof Matrix4d) {
                stringArray = ConfigCommand.formatMatrixRows((Matrix4d)this.argv[i2]);
                stringBuffer.append("\n ((" + stringArray[0] + ")\n");
                stringBuffer.append("  (" + stringArray[1] + ")\n");
                stringBuffer.append("  (" + stringArray[2] + ")\n");
                stringBuffer.append("  (" + stringArray[3] + "))");
                if (i2 == this.argc - 1) continue;
                stringBuffer.append("\n");
                continue;
            }
            if (i2 > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.argv[i2].toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

