/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.utils.universe.ConfigCommand;
import com.sun.j3d.utils.universe.ConfigDevice;
import com.sun.j3d.utils.universe.ConfigObject;
import javax.media.j3d.Sensor;
import javax.vecmath.Point3d;

class ConfigSensor
extends ConfigObject {
    private int sensorIndex;
    private ConfigDevice configDevice;
    private Point3d hotspot = null;
    private int predictor = -1;
    private int predictionPolicy = -1;
    private int sensorReadCount = -1;
    Sensor j3dSensor;

    ConfigSensor() {
    }

    protected void initialize(ConfigCommand configCommand) {
        int n2 = configCommand.argc;
        Object[] objectArray = configCommand.argv;
        if (n2 != 4) {
            this.syntaxError("Incorrect number of arguments to " + configCommand.commandName);
        }
        if (!this.isName(objectArray[2])) {
            this.syntaxError("The second argument to " + configCommand.commandName + " must be the device name");
        }
        if (!(objectArray[3] instanceof Double)) {
            this.syntaxError("The third argument to " + configCommand.commandName + " must be a sensor index");
        }
        this.sensorIndex = ((Double)objectArray[3]).intValue();
        this.configDevice = (ConfigDevice)this.configContainer.findConfigObject("Device", (String)objectArray[2]);
    }

    protected void setProperty(ConfigCommand configCommand) {
        String string;
        int n2 = configCommand.argc;
        Object[] objectArray = configCommand.argv;
        if (n2 != 4) {
            this.syntaxError("Incorrect number of arguments to " + configCommand.commandName);
        }
        if (!this.isName(objectArray[1])) {
            this.syntaxError("The first argument to " + configCommand.commandName + " must be the instance name");
        }
        if (!this.isName(objectArray[2])) {
            this.syntaxError("The second argument to " + configCommand.commandName + " must be a property name");
        }
        if ((string = (String)objectArray[2]).equals("Hotspot")) {
            if (!(objectArray[3] instanceof Point3d)) {
                this.syntaxError("Hotspot must be a 3D point");
            }
            this.hotspot = (Point3d)objectArray[3];
        } else {
            this.syntaxError("Unknown " + configCommand.commandName + " \"" + string + "\"");
        }
    }

    void configureSensor() {
        this.j3dSensor = this.configDevice.j3dInputDevice.getSensor(this.sensorIndex);
        if (this.hotspot != null) {
            this.j3dSensor.setHotspot(this.hotspot);
        }
        if (this.predictor != -1) {
            this.j3dSensor.setPredictor(this.predictor);
        }
        if (this.predictionPolicy != -1) {
            this.j3dSensor.setPredictionPolicy(this.predictionPolicy);
        }
        if (this.sensorReadCount != -1) {
            this.j3dSensor.setSensorReadCount(this.sensorReadCount);
        }
    }
}

