/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.ConfigCommand;
import com.sun.j3d.utils.universe.ConfigObject;
import javax.media.j3d.Bounds;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix4d;

class ConfigViewPlatformBehavior
extends ConfigObject {
    private Transform3D homeTransform = null;
    private Bounds schedulingBounds = null;
    private int schedulingInterval = -1;
    ViewPlatformBehavior viewPlatformBehavior;

    ConfigViewPlatformBehavior() {
    }

    protected void setProperty(ConfigCommand configCommand) {
        String string;
        int n2 = configCommand.argc;
        Object[] objectArray = configCommand.argv;
        if (n2 < 4) {
            this.syntaxError("Wrong number of arguments to " + configCommand.commandName);
        }
        if (!this.isName(objectArray[2])) {
            this.syntaxError("The second argument to " + configCommand.commandName + " must be a property name");
        }
        if ((string = (String)objectArray[2]).equals("HomeTransform")) {
            if (!(objectArray[3] instanceof Matrix4d)) {
                this.syntaxError("HomeTransform must be a Matrix4d");
            }
            this.homeTransform = new Transform3D((Matrix4d)objectArray[3]);
        } else if (string.equals("SchedulingBounds")) {
            if (!(objectArray[3] instanceof Bounds)) {
                this.syntaxError("SchedulingBounds must be an instance of Bounds");
            }
            this.schedulingBounds = (Bounds)objectArray[3];
        } else if (string.equals("SchedulingInterval")) {
            if (!(objectArray[3] instanceof Double)) {
                this.syntaxError("SchedulingInterval must be a priority (number)");
            }
            this.schedulingInterval = ((Double)objectArray[3]).intValue();
        } else {
            this.properties.add(configCommand);
        }
    }

    ViewPlatformBehavior createViewPlatformBehavior() {
        this.viewPlatformBehavior = (ViewPlatformBehavior)this.createTargetObject();
        if (this.homeTransform != null) {
            this.viewPlatformBehavior.setHomeTransform(this.homeTransform);
        }
        if (this.schedulingBounds != null) {
            this.viewPlatformBehavior.setSchedulingBounds(this.schedulingBounds);
        }
        if (this.schedulingInterval != -1) {
            this.viewPlatformBehavior.setSchedulingInterval(this.schedulingInterval);
        }
        return this.viewPlatformBehavior;
    }
}

