/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.MultiTransformGroup;
import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewerAvatar;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.vecmath.Vector3d;

public class ViewingPlatform
extends BranchGroup {
    protected ViewPlatform viewPlatform;
    protected MultiTransformGroup mtg;
    protected BranchGroup platformGeometryRoot;
    protected BranchGroup avatarRoot;
    protected PlatformGeometry platformGeometry = null;
    protected Hashtable viewerList = new Hashtable();
    protected BranchGroup behaviors;
    protected SimpleUniverse universe;

    public ViewingPlatform() {
        this(1);
    }

    public ViewingPlatform(int n2) {
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(17);
        if (n2 < 1) {
            n2 = 1;
        }
        this.mtg = new MultiTransformGroup(n2);
        TransformGroup transformGroup = this.mtg.getTransformGroup(0);
        this.addChild(transformGroup);
        transformGroup = this.mtg.getTransformGroup(n2 - 1);
        this.viewPlatform = new ViewPlatform();
        this.viewPlatform.setCapability(12);
        this.viewPlatform.setCapability(13);
        transformGroup.addChild(this.viewPlatform);
        transformGroup.setCapability(17);
        transformGroup.setCapability(18);
        this.avatarRoot = new BranchGroup();
        this.avatarRoot.setCapability(12);
        this.avatarRoot.setCapability(13);
        this.avatarRoot.setCapability(14);
        transformGroup.addChild(this.avatarRoot);
        this.platformGeometryRoot = new BranchGroup();
        this.platformGeometryRoot.setCapability(12);
        this.platformGeometryRoot.setCapability(13);
        this.platformGeometryRoot.setCapability(14);
        transformGroup.addChild(this.platformGeometryRoot);
    }

    public void setViewPlatform(ViewPlatform viewPlatform) {
        TransformGroup transformGroup = this.getViewPlatformTransform();
        transformGroup.removeChild(this.viewPlatform);
        transformGroup.addChild(viewPlatform);
        this.viewPlatform = viewPlatform;
        Enumeration enumeration = this.viewerList.keys();
        while (enumeration.hasMoreElements()) {
            ((Viewer)enumeration.nextElement()).setViewingPlatform(this);
        }
    }

    public ViewPlatform getViewPlatform() {
        return this.viewPlatform;
    }

    public void setPlatformGeometry(PlatformGeometry platformGeometry) {
        if (this.platformGeometry == platformGeometry) {
            return;
        }
        if (platformGeometry == null) {
            if (this.platformGeometryRoot.numChildren() != 0) {
                this.platformGeometryRoot.removeChild(0);
            }
        } else if (this.platformGeometryRoot.numChildren() != 0) {
            this.platformGeometryRoot.setChild(platformGeometry, 0);
        } else {
            this.platformGeometryRoot.addChild(platformGeometry);
        }
        this.platformGeometry = platformGeometry;
    }

    public PlatformGeometry getPlatformGeometry() {
        return this.platformGeometry;
    }

    public MultiTransformGroup getMultiTransformGroup() {
        return this.mtg;
    }

    public TransformGroup getViewPlatformTransform() {
        return this.mtg.getTransformGroup(this.mtg.getNumTransforms() - 1);
    }

    public void setNominalViewingTransform() {
        if (this.viewPlatform.getViewAttachPolicy() == 0) {
            Object object;
            double d2;
            if (this.viewerList.size() == 0) {
                d2 = 0.7853981633974483;
            } else {
                if (this.viewerList.size() > 1) {
                    throw new RuntimeException(J3dUtilsI18N.getString("ViewingPlatform0"));
                }
                object = (Viewer)this.viewerList.keys().nextElement();
                View view = ((Viewer)object).getView();
                d2 = view.getFieldOfView();
            }
            object = new Transform3D();
            double d3 = 1.0 / Math.tan(d2 / 2.0);
            ((Transform3D)object).set(new Vector3d(0.0, 0.0, d3));
            this.getViewPlatformTransform().setTransform((Transform3D)object);
        }
    }

    private int findAvatarChild(ViewerAvatar viewerAvatar) {
        for (int i2 = 0; i2 < this.avatarRoot.numChildren(); ++i2) {
            if ((ViewerAvatar)this.avatarRoot.getChild(i2) != viewerAvatar) continue;
            return i2;
        }
        System.err.println("ViewingPlatform.findAvatarChild:Child not found.");
        return -1;
    }

    void setAvatar(Viewer viewer, ViewerAvatar viewerAvatar) {
        Object v = this.viewerList.get(viewer);
        int n2 = -1;
        if (v != this.avatarRoot) {
            n2 = this.findAvatarChild((ViewerAvatar)v);
        }
        if (viewerAvatar == null) {
            if (n2 != -1) {
                this.avatarRoot.removeChild(n2);
                this.viewerList.put(viewer, this.avatarRoot);
            }
        } else {
            if (n2 != -1) {
                this.avatarRoot.setChild(viewerAvatar, n2);
            } else {
                this.avatarRoot.addChild(viewerAvatar);
            }
            this.viewerList.put(viewer, viewerAvatar);
        }
    }

    void addViewer(Viewer viewer) {
        this.viewerList.put(viewer, this.avatarRoot);
    }

    void removeViewer(Viewer viewer) {
        this.viewerList.remove(viewer);
    }

    void addViewPlatformBehavior(ViewPlatformBehavior viewPlatformBehavior) {
        viewPlatformBehavior.setViewingPlatform(this);
        if (this.behaviors == null) {
            this.behaviors = new BranchGroup();
            this.behaviors.setCapability(17);
            this.behaviors.setCapability(12);
        } else {
            this.behaviors.detach();
        }
        this.behaviors.addChild(viewPlatformBehavior);
        this.addChild(this.behaviors);
    }

    public void setViewPlatformBehavior(ViewPlatformBehavior viewPlatformBehavior) {
        if (this.behaviors != null) {
            this.removeViewPlatformBehavior((ViewPlatformBehavior)this.behaviors.getChild(0));
        }
        if (viewPlatformBehavior != null) {
            this.addViewPlatformBehavior(viewPlatformBehavior);
        }
    }

    void removeViewPlatformBehavior(ViewPlatformBehavior viewPlatformBehavior) {
        if (this.behaviors != null) {
            this.behaviors.detach();
            for (int i2 = 0; i2 < this.behaviors.numChildren(); ++i2) {
                if (this.behaviors.getChild(i2) != viewPlatformBehavior) continue;
                viewPlatformBehavior.setViewingPlatform(null);
                this.behaviors.removeChild(i2);
                break;
            }
            if (this.behaviors.numChildren() == 0) {
                this.behaviors = null;
            } else {
                this.addChild(this.behaviors);
            }
        }
    }

    int getViewPlatformBehaviorCount() {
        return this.behaviors.numChildren();
    }

    ViewPlatformBehavior getViewPlatformBehavior(int n2) {
        return (ViewPlatformBehavior)this.behaviors.getChild(n2);
    }

    public ViewPlatformBehavior getViewPlatformBehavior() {
        if (this.behaviors == null) {
            return null;
        }
        return this.getViewPlatformBehavior(0);
    }

    public Viewer[] getViewers() {
        if (this.viewerList.size() == 0) {
            return null;
        }
        return this.viewerList.keySet().toArray(new Viewer[0]);
    }

    public SimpleUniverse getUniverse() {
        return this.universe;
    }

    public void setUniverse(SimpleUniverse simpleUniverse) {
        this.universe = simpleUniverse;
    }
}

