/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.font.CharToGlyphMapper;
import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.webkit.prism.TextUtilities;
import com.sun.javafx.webkit.prism.WCTextRunImpl;
import com.sun.prism.GraphicsPipeline;
import com.sun.webkit.graphics.WCFont;
import com.sun.webkit.graphics.WCTextRun;
import java.util.Arrays;
import java.util.HashMap;

final class WCFontImpl
extends WCFont {
    private static final PlatformLogger log = PlatformLogger.getLogger((String)WCFontImpl.class.getName());
    private static final HashMap<String, String> FONT_MAP = new HashMap();
    private final PGFont font;
    private FontStrike strike;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WCFont getFont(String string, boolean bl, boolean bl2, float f2) {
        FontFactory fontFactory = GraphicsPipeline.getPipeline().getFontFactory();
        Object object = FONT_MAP;
        synchronized (object) {
            if (FONT_MAP.isEmpty()) {
                FONT_MAP.put("serif", "Serif");
                FONT_MAP.put("dialog", "SansSerif");
                FONT_MAP.put("helvetica", "SansSerif");
                FONT_MAP.put("sansserif", "SansSerif");
                FONT_MAP.put("sans-serif", "SansSerif");
                FONT_MAP.put("monospace", "Monospaced");
                FONT_MAP.put("monospaced", "Monospaced");
                FONT_MAP.put("times", "Times New Roman");
                FONT_MAP.put("courier", "Courier New");
                for (String string2 : fontFactory.getFontFamilyNames()) {
                    FONT_MAP.put(string2.toLowerCase(), string2);
                }
            }
        }
        object = FONT_MAP.get(string.toLowerCase());
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            String[] stringArray = new StringBuilder("WCFontImpl.get(");
            stringArray.append(string).append(", ").append(f2);
            if (bl) {
                stringArray.append(", bold");
            }
            if (bl2) {
                stringArray.append(", italic");
            }
            log.fine(stringArray.append(") = ").append((String)object).toString());
        }
        return object != null ? new WCFontImpl(fontFactory.createFont((String)object, bl, bl2, f2)) : null;
    }

    WCFontImpl(PGFont pGFont) {
        this.font = pGFont;
    }

    @Override
    public WCFont deriveFont(float f2) {
        FontFactory fontFactory = GraphicsPipeline.getPipeline().getFontFactory();
        return new WCFontImpl(fontFactory.deriveFont(this.font, this.font.getFontResource().isBold(), this.font.getFontResource().isItalic(), f2));
    }

    private FontStrike getFontStrike() {
        if (this.strike == null) {
            this.strike = this.font.getStrike(BaseTransform.IDENTITY_TRANSFORM, 1);
        }
        return this.strike;
    }

    @Override
    public double getGlyphWidth(int n2) {
        return this.getFontStrike().getFontResource().getAdvance(n2, this.font.getSize());
    }

    @Override
    public float[] getGlyphBoundingBox(int n2) {
        float[] fArray = new float[4];
        fArray = this.getFontStrike().getFontResource().getGlyphBoundingBox(n2, this.font.getSize(), fArray);
        return new float[]{fArray[0], -fArray[3], fArray[2], fArray[3] - fArray[1]};
    }

    @Override
    public float getXHeight() {
        return this.getFontStrike().getMetrics().getXHeight();
    }

    private static boolean needsTextLayout(int[] nArray) {
        for (int n2 : nArray) {
            if (n2 != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[] getGlyphCodes(char[] cArray) {
        int[] nArray = new int[cArray.length];
        CharToGlyphMapper charToGlyphMapper = this.getFontStrike().getFontResource().getGlyphMapper();
        charToGlyphMapper.charsToGlyphs(cArray.length, cArray, nArray);
        if (WCFontImpl.needsTextLayout(nArray)) {
            TextUtilities.createLayout(new String(cArray), this.getPlatformFont()).getRuns();
            charToGlyphMapper.charsToGlyphs(cArray.length, cArray, nArray);
        }
        return nArray;
    }

    @Override
    public float getAscent() {
        float f2 = -this.getFontStrike().getMetrics().getAscent();
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("getAscent({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), Float.valueOf(f2)});
        }
        return f2;
    }

    @Override
    public float getDescent() {
        float f2 = this.getFontStrike().getMetrics().getDescent();
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("getDescent({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), Float.valueOf(f2)});
        }
        return f2;
    }

    @Override
    public float getLineSpacing() {
        float f2 = this.getFontStrike().getMetrics().getLineHeight();
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("getLineSpacing({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), Float.valueOf(f2)});
        }
        return f2;
    }

    @Override
    public float getLineGap() {
        float f2 = this.getFontStrike().getMetrics().getLineGap();
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("getLineGap({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), Float.valueOf(f2)});
        }
        return f2;
    }

    @Override
    public boolean hasUniformLineMetrics() {
        return false;
    }

    @Override
    public Object getPlatformFont() {
        return this.font;
    }

    @Override
    public float getCapHeight() {
        return this.getFontStrike().getMetrics().getCapHeight();
    }

    @Override
    public WCTextRun[] getTextRuns(String string) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("str='%s' length=%d", string, string.length()));
        }
        TextLayout textLayout = TextUtilities.createLayout(string, this.getPlatformFont());
        return (WCTextRun[])Arrays.stream(textLayout.getRuns()).map(WCTextRunImpl::new).toArray(WCTextRunImpl[]::new);
    }
}

