/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.classy;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;

public class GraphicsUtils
extends de.javasoft.plaf.synthetica.GraphicsUtils {
    private boolean textShadowEnabled = SyntheticaLookAndFeel.getBoolean("SyntheticaClassy.textShadowEnabled", null, true);
    private boolean useSimpleTextShadow = SyntheticaLookAndFeel.getBoolean("SyntheticaClassy.useSimpleTextShadow", null, true);
    private Color optionalForeground = new Color(12629172);
    private Color optionalForeground_hover = new Color(0xEFEFEF);
    private Color optionalForeground_disabled = new Color(5984589);

    public void paintText(SynthContext sc, Graphics g2, String text, int x, int y, int mnemonicIndex) {
        JComponent c2 = sc.getComponent();
        String name = c2.getName();
        Region region = sc.getRegion();
        boolean selected = (sc.getComponentState() & 0x200) > 0;
        boolean disabled = (sc.getComponentState() & 8) > 0;
        boolean hover = (sc.getComponentState() & 2) > 0;
        boolean pressed = (sc.getComponentState() & 4) > 0;
        Container cParent = c2.getParent();
        Container grandParent = cParent == null ? null : cParent.getParent();
        JComponent parent = cParent instanceof JComponent ? (JComponent)cParent : null;
        JToolBar opaqueToolBar = null;
        boolean isMenuBarChild = parent instanceof JMenuBar;
        boolean isToolBarChild = parent instanceof JToolBar;
        boolean isStatusBarChild = parent != null && (parent.getUIClassID().equals("StatusBarUI") || "StatusBar".equals(parent.getName()));
        Color paintColor = g2.getColor();
        if ((isMenuBarChild || isToolBarChild || isStatusBarChild) && paintColor instanceof UIResource && parent.isOpaque()) {
            g2.setColor(this.optionalForeground);
        } else if (isMenuBarChild && !(c2 instanceof JMenuItem) && paintColor instanceof UIResource) {
            g2.setColor(this.optionalForeground);
        } else if (isToolBarChild && (opaqueToolBar = SyntheticaLookAndFeel.findOpaqueParentOfClass(JToolBar.class, c2, false)) != null && paintColor instanceof UIResource) {
            g2.setColor(this.optionalForeground);
        }
        if (region == Region.PROGRESS_BAR) {
            this.paintTextShadow(c2, g2, x, y, text, false, 5, -5, 1.0f, Color.BLACK, -2, -2, false, mnemonicIndex);
        } else if (region == Region.BUTTON || region == Region.TOGGLE_BUTTON) {
            if (pressed && !selected) {
                ++y;
            }
            if ((opaqueToolBar = SyntheticaLookAndFeel.findOpaqueParentOfClass(JToolBar.class, c2, false)) != null && paintColor instanceof UIResource) {
                Color foreground = hover ? this.optionalForeground_hover : (disabled ? this.optionalForeground_disabled : this.optionalForeground);
                g2.setColor(foreground);
            }
        }
        if (this.textShadowEnabled) {
            if (region == Region.MENU && ((JMenu)c2).isTopLevelMenu()) {
                Window w = SwingUtilities.getWindowAncestor(c2);
                if (w != null && w.isActive()) {
                    this.paintDarkShadow(c2, g2, x, y, text, mnemonicIndex);
                }
            } else if (region == Region.MENU && selected) {
                this.paintBrightShadow(c2, g2, x, y, text, mnemonicIndex);
            } else if (c2 instanceof JMenuItem && hover) {
                this.paintBrightShadow(c2, g2, x, y, text, mnemonicIndex);
            } else if (region == Region.LABEL && "TableHeader.renderer".equals(name)) {
                this.paintBrightShadow(c2, g2, x, y, text, mnemonicIndex);
            } else if (region == Region.LABEL && -13421773 == c2.getForeground().getRGB() && ("List.cellRenderer".equals(name) || "ComboBox.listRenderer".equals(name) || "Table.cellRenderer".equals(name) || "Tree.cellRenderer".equals(name))) {
                JTable table;
                boolean focused;
                boolean respectFocus = SyntheticaLookAndFeel.getBoolean("Synthetica.cellRenderer.respectFocus", c2, false);
                boolean bl = respectFocus ? (grandParent != null ? grandParent.hasFocus() : false) : (focused = false);
                if ("Table.cellRenderer".equals(name) && respectFocus && grandParent instanceof JTable && (table = (JTable)grandParent).getCellEditor() != null) {
                    focused = true;
                }
                if (focused || "ComboBox.listRenderer".equals(name)) {
                    this.paintBrightShadow(c2, g2, x, y, text, mnemonicIndex);
                }
            } else if ((region == Region.BUTTON || region == Region.TOGGLE_BUTTON) && opaqueToolBar == null) {
                this.paintBrightShadow2(c2, g2, x, y, text, mnemonicIndex);
            } else if (region == Region.TABBED_PANE_TAB) {
                this.paintBrightShadow2(c2, g2, x, y, text, mnemonicIndex);
            }
        }
        super.paintText(sc, g2, text, x, y, mnemonicIndex);
    }

    private void paintBrightShadow(JComponent c2, Graphics g2, int x, int y, String text, int mnemonicIndex) {
        this.paintShadow(c2, g2, x, y, text, false, 1, -2, 0.75f, Color.WHITE, 0, 1, mnemonicIndex);
    }

    private void paintBrightShadow2(JComponent c2, Graphics g2, int x, int y, String text, int mnemonicIndex) {
        this.paintShadow(c2, g2, x, y, text, false, 1, -2, 0.5f, Color.WHITE, 0, 1, mnemonicIndex);
    }

    private void paintDarkShadow(JComponent c2, Graphics g2, int x, int y, String text, int mnemonicIndex) {
        this.paintShadow(c2, g2, x, y, text, false, 1, -2, 1.0f, Color.BLACK, 0, 1, mnemonicIndex);
    }

    private void paintShadow(JComponent c2, Graphics g2, int x, int y, String text, boolean highQuality, int size, int distance, float opacity, Color color, int xOffset, int yOffset, int mnemonicIndex) {
        if (this.useSimpleTextShadow) {
            FontMetrics fm = g2.getFontMetrics(c2.getFont());
            Color col = g2.getColor();
            g2.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * opacity / 1.25f)));
            g2.drawString(text, x + xOffset, y + yOffset + fm.getAscent());
            g2.setColor(col);
        } else {
            this.paintTextShadow(c2, g2, x, y, text, highQuality, size, distance, opacity, color, xOffset, yOffset, false, mnemonicIndex);
        }
    }
}

