/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Image;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class SyntheticaSoftCache {
    private final int maxCacheSize;
    private final int maxImageSize;
    private final LinkedHashMap<Integer, ImageReference> cache = new LinkedHashMap();
    private ReferenceQueue<Image> referenceQueue = new ReferenceQueue();
    private int pixelCount = 0;
    private static final SyntheticaSoftCache instance = new SyntheticaSoftCache();

    private SyntheticaSoftCache() {
        int n2 = SyntheticaLookAndFeel.getInt("Synthetica.cache.maxSize", null, 4);
        this.maxCacheSize = n2 * 1024 * 1024;
        this.maxImageSize = SyntheticaLookAndFeel.getInt("Synthetica.cache.maxImageSize", null, 200000);
    }

    static SyntheticaSoftCache getInstance() {
        return instance;
    }

    public boolean isCacheable(int n2, int n3) {
        return n2 * n3 < this.maxImageSize && n2 > 0 && n3 > 0;
    }

    public Image getImage(int n2) {
        ImageReference imageReference = this.cache.get(n2);
        if (imageReference != null) {
            return (Image)imageReference.get();
        }
        return null;
    }

    public boolean setImage(Image image, int n2) {
        ImageReference imageReference = this.cache.get(n2);
        if (imageReference != null && imageReference.get() != null) {
            return true;
        }
        int n3 = image.getWidth(null) * image.getHeight(null);
        this.pixelCount += n3;
        while ((imageReference = (ImageReference)this.referenceQueue.poll()) != null) {
            this.cache.remove(imageReference.cacheHash);
            this.pixelCount -= imageReference.pixelCount;
        }
        if (this.pixelCount > this.maxCacheSize) {
            Iterator<Map.Entry<Integer, ImageReference>> iterator = this.cache.entrySet().iterator();
            while (this.pixelCount > this.maxCacheSize / 2 && iterator.hasNext()) {
                Map.Entry<Integer, ImageReference> entry = iterator.next();
                ImageReference imageReference2 = entry.getValue();
                Image image2 = (Image)imageReference2.get();
                if (image2 != null) {
                    image2.flush();
                }
                iterator.remove();
                this.pixelCount -= imageReference2.pixelCount;
            }
        }
        this.cache.put(n2, new ImageReference(image, n2, this.referenceQueue));
        return true;
    }

    public void clear() {
        this.pixelCount = 0;
        this.cache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImageReference
    extends SoftReference<Image> {
        private int cacheHash;
        private int pixelCount;

        public ImageReference(Image image, int n2, ReferenceQueue<Image> referenceQueue) {
            super(image, referenceQueue);
            this.cacheHash = n2;
            this.pixelCount = image.getWidth(null) * image.getHeight(null);
        }
    }
}

