/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.util;

import java.text.NumberFormat;
import java.text.ParseException;

public class JavaVersion {
    public static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");
    public static final boolean JAVA6 = System.getProperty("java.version").startsWith("1.6.");
    public static final boolean JAVA6U10_OR_ABOVE = JavaVersion.isJava6uNOrAbove(10);
    public static final boolean JAVA7 = System.getProperty("java.version").startsWith("1.7.");
    public static final boolean JAVA7_OR_ABOVE = !JAVA5 && !JAVA6;
    public static final boolean JAVA7U8_OR_ABOVE = JavaVersion.isJava7uNOrAbove(8);
    public static final boolean JAVA8 = System.getProperty("java.version").startsWith("1.8.");

    public static boolean isJava6uNOrAbove(int n2) {
        String string = System.getProperty("java.version");
        if (JAVA5) {
            return false;
        }
        if (string.equals("1.6.0")) {
            return false;
        }
        if (string.startsWith("1.6.0_")) {
            try {
                int n3 = ((Long)NumberFormat.getIntegerInstance().parse(string.substring(6))).intValue();
                return n3 >= n2;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }

    public static boolean isJava7uNOrAbove(int n2) {
        String string = System.getProperty("java.version");
        if (JAVA5 || JAVA6) {
            return false;
        }
        if (string.equals("1.7.0")) {
            return false;
        }
        if (string.startsWith("1.7.0_")) {
            try {
                int n3 = ((Long)NumberFormat.getIntegerInstance().parse(string.substring(6))).intValue();
                return n3 >= n2;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }
}

