/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Bounds;
import javax.media.j3d.NodeComponentRetained;
import javax.vecmath.Point2f;

class AuralAttributesRetained
extends NodeComponentRetained {
    float attributeGain = 1.0f;
    float rolloff = 1.0f;
    static final float SPEED_OF_SOUND = 0.344f;
    float reflectionCoefficient = 0.0f;
    float reverbCoefficient = 1.0f;
    float reflectionDelay = 20.0f;
    float reverbDelay = 40.0f;
    Bounds reverbBounds = null;
    float decayTime = 1000.0f;
    float decayFilter = 5000.0f;
    float diffusion = 1.0f;
    float density = 1.0f;
    int reverbOrder = 0;
    static final int NO_FILTERING = -1;
    static final int LOW_PASS = 1;
    int filterType = -1;
    float[] distance = null;
    float[] frequencyCutoff = null;
    float frequencyScaleFactor = 1.0f;
    float velocityScaleFactor = 0.0f;
    boolean aaDirty = true;
    AuralAttributesRetained mirrorAa = null;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    AuralAttributesRetained() {
    }

    void debugPrint(String string) {
    }

    void setAttributeGain(float f2) {
        this.attributeGain = f2;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getAttributeGain() {
        return this.attributeGain;
    }

    void setRolloff(float f2) {
        this.rolloff = f2;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getRolloff() {
        return this.rolloff;
    }

    void setReflectionCoefficient(float f2) {
        this.reflectionCoefficient = f2;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getReflectionCoefficient() {
        return this.reflectionCoefficient;
    }

    void setReflectionDelay(float f2) {
        this.reflectionDelay = f2;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getReflectionDelay() {
        return this.reflectionDelay;
    }

    void setReverbCoefficient(float f2) {
        this.reverbCoefficient = f2;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getReverbCoefficient() {
        return this.reverbCoefficient;
    }

    void setReverbDelay(float f2) {
        this.reverbDelay = f2;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getReverbDelay() {
        return this.reverbDelay;
    }

    void setDecayTime(float f2) {
        this.decayTime = f2;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getDecayTime() {
        return this.decayTime;
    }

    void setDecayFilter(float f2) {
        this.decayFilter = f2;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getDecayFilter() {
        return this.decayFilter;
    }

    void setDiffusion(float f2) {
        this.diffusion = f2;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getDiffusion() {
        return this.diffusion;
    }

    void setDensity(float f2) {
        this.density = f2;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getDensity() {
        return this.density;
    }

    synchronized void setReverbBounds(Bounds bounds) {
        this.reverbBounds = bounds;
        this.aaDirty = true;
        this.notifyUsers();
    }

    Bounds getReverbBounds() {
        return this.reverbBounds;
    }

    void setReverbOrder(int n2) {
        this.reverbOrder = n2;
        this.aaDirty = true;
        this.notifyUsers();
    }

    int getReverbOrder() {
        return this.reverbOrder;
    }

    synchronized void setDistanceFilter(Point2f[] point2fArray) {
        if (point2fArray == null) {
            this.filterType = -1;
            return;
        }
        int n2 = point2fArray.length;
        if (n2 == 0) {
            this.filterType = -1;
            return;
        }
        this.filterType = 1;
        if (this.distance == null || this.distance != null && this.distance.length != n2) {
            this.distance = new float[n2];
            this.frequencyCutoff = new float[n2];
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.distance[i2] = point2fArray[i2].x;
            this.frequencyCutoff[i2] = point2fArray[i2].y;
        }
        this.aaDirty = true;
        this.notifyUsers();
    }

    synchronized void setDistanceFilter(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            this.filterType = -1;
            return;
        }
        int n2 = fArray.length;
        int n3 = fArray2.length;
        if (n2 == 0 || n3 == 0) {
            this.filterType = -1;
            return;
        }
        if (this.distance == null || this.distance != null && this.distance.length != n3) {
            this.distance = new float[n2];
            this.frequencyCutoff = new float[n2];
        }
        this.filterType = 1;
        System.arraycopy(fArray, 0, this.distance, 0, n2);
        if (n2 <= n3) {
            System.arraycopy(fArray2, 0, this.frequencyCutoff, 0, n2);
        } else {
            System.arraycopy(fArray2, 0, this.frequencyCutoff, 0, n3);
            for (int i2 = n3; i2 < n2; ++i2) {
                this.frequencyCutoff[i2] = fArray2[n3 - 1];
            }
        }
        this.aaDirty = true;
        this.notifyUsers();
    }

    int getDistanceFilterLength() {
        if (this.distance == null) {
            return 0;
        }
        return this.distance.length;
    }

    void getDistanceFilter(Point2f[] point2fArray) {
        if (point2fArray == null) {
            return;
        }
        if (this.distance == null || this.frequencyCutoff == null) {
            return;
        }
        int n2 = this.distance.length;
        if (n2 > point2fArray.length) {
            n2 = point2fArray.length;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            point2fArray[i2].x = this.distance[i2];
            if (this.filterType == -1) {
                point2fArray[i2].y = -1.0f;
                continue;
            }
            if (this.filterType != 1) continue;
            point2fArray[i2].y = this.frequencyCutoff[i2];
        }
    }

    void getDistanceFilter(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            return;
        }
        if (this.distance == null || this.frequencyCutoff == null) {
            return;
        }
        int n2 = this.distance.length;
        if (fArray.length < n2) {
            n2 = fArray.length;
        }
        System.arraycopy(this.distance, 0, fArray, 0, n2);
        int n3 = this.frequencyCutoff.length;
        if (fArray2.length < n3) {
            n3 = fArray2.length;
        }
        if (this.filterType == -1) {
            for (int i2 = 0; i2 < n3; ++i2) {
                fArray2[i2] = -1.0f;
            }
        }
        if (this.filterType == 1) {
            System.arraycopy(this.frequencyCutoff, 0, fArray2, 0, n3);
        }
    }

    void setFrequencyScaleFactor(float f2) {
        this.frequencyScaleFactor = f2;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getFrequencyScaleFactor() {
        return this.frequencyScaleFactor;
    }

    void setVelocityScaleFactor(float f2) {
        this.velocityScaleFactor = f2;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getVelocityScaleFactor() {
        return this.velocityScaleFactor;
    }

    synchronized void reset(AuralAttributesRetained auralAttributesRetained) {
        this.attributeGain = auralAttributesRetained.attributeGain;
        this.rolloff = auralAttributesRetained.rolloff;
        this.reflectionCoefficient = auralAttributesRetained.reflectionCoefficient;
        this.reverbCoefficient = auralAttributesRetained.reverbCoefficient;
        this.reflectionDelay = auralAttributesRetained.reflectionDelay;
        this.reverbDelay = auralAttributesRetained.reverbDelay;
        this.reverbBounds = auralAttributesRetained.reverbBounds;
        this.reverbOrder = auralAttributesRetained.reverbOrder;
        this.decayTime = auralAttributesRetained.decayTime;
        this.decayFilter = auralAttributesRetained.decayFilter;
        this.diffusion = auralAttributesRetained.diffusion;
        this.density = auralAttributesRetained.density;
        this.frequencyScaleFactor = auralAttributesRetained.frequencyScaleFactor;
        this.velocityScaleFactor = auralAttributesRetained.velocityScaleFactor;
        if (auralAttributesRetained.distance != null) {
            this.distance = new float[auralAttributesRetained.distance.length];
            System.arraycopy(auralAttributesRetained.distance, 0, this.distance, 0, this.distance.length);
        }
        if (auralAttributesRetained.frequencyCutoff != null) {
            this.frequencyCutoff = new float[auralAttributesRetained.frequencyCutoff.length];
            System.arraycopy(auralAttributesRetained.frequencyCutoff, 0, this.frequencyCutoff, 0, this.frequencyCutoff.length);
        }
        this.aaDirty = false;
        auralAttributesRetained.aaDirty = false;
    }

    void update(AuralAttributesRetained auralAttributesRetained) {
        this.reset(auralAttributesRetained);
    }
}

