/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Random;
import javax.media.j3d.BHInternalNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BHTree;

class BHInsertStructure {
    static boolean debug = false;
    static boolean debug2 = false;
    Random randomNumber = new Random(0L);
    ArrayList[] bhListArr = null;
    ArrayList[] oldBhListArr = null;
    BHNode[] bhListArrRef = null;
    BHNode[] oldBhListArrRef = null;
    int bhListArrCnt = 0;
    int bhListArrMaxCnt = 0;
    int blockSize = 0;

    BHInsertStructure(int n2) {
        if (n2 > 50) {
            n2 = 50;
        }
        this.blockSize = 50;
        this.bhListArr = new ArrayList[n2];
        this.bhListArrRef = new BHNode[n2];
        this.bhListArrCnt = 0;
        this.bhListArrMaxCnt = n2;
    }

    void clear() {
        for (int i2 = 0; i2 < this.bhListArrCnt; ++i2) {
            this.bhListArr[i2].clear();
            this.bhListArrRef[i2] = null;
        }
        this.bhListArrCnt = 0;
    }

    void lookupAndInsert(BHNode bHNode, BHNode bHNode2) {
        boolean bl = false;
        for (int i2 = 0; i2 < this.bhListArrCnt; ++i2) {
            if (this.bhListArrRef[i2] != bHNode) continue;
            this.bhListArr[i2].add(bHNode2);
            bl = true;
            break;
        }
        if (!bl) {
            if (this.bhListArrCnt >= this.bhListArrMaxCnt) {
                if (debug) {
                    System.err.println("(1) Expanding bhListArr array ...");
                }
                this.bhListArrMaxCnt += this.blockSize;
                this.oldBhListArr = this.bhListArr;
                this.oldBhListArrRef = this.bhListArrRef;
                this.bhListArr = new ArrayList[this.bhListArrMaxCnt];
                this.bhListArrRef = new BHNode[this.bhListArrMaxCnt];
                System.arraycopy(this.oldBhListArr, 0, this.bhListArr, 0, this.oldBhListArr.length);
                System.arraycopy(this.oldBhListArrRef, 0, this.bhListArrRef, 0, this.oldBhListArrRef.length);
            }
            this.bhListArrRef[this.bhListArrCnt] = bHNode;
            this.bhListArr[this.bhListArrCnt] = new ArrayList();
            this.bhListArr[this.bhListArrCnt].add(bHNode2);
            ++this.bhListArrCnt;
        }
    }

    void updateBoundingTree(BHTree bHTree) {
        for (int i2 = 0; i2 < this.bhListArrCnt; ++i2) {
            int n2 = 0;
            BHNode bHNode = ((BHInternalNode)this.bhListArrRef[i2]).getLeftChild();
            BHNode bHNode2 = ((BHInternalNode)this.bhListArrRef[i2]).getRightChild();
            if (bHNode != null) {
                ++n2;
            }
            if (bHNode2 != null) {
                ++n2;
            }
            int n3 = this.bhListArr[i2].size();
            BHNode[] bHNodeArray = new BHNode[n2 + n3];
            this.bhListArr[i2].toArray(bHNodeArray);
            n2 = 0;
            if (bHNode != null) {
                bHNodeArray[n3] = bHNode;
                bHNodeArray[n3 + ++n2] = bHNode2;
            }
            if (debug2 && (bHNode == null || bHNode2 == null)) {
                System.err.println("child1 or child2 is null ...");
                System.err.println("This is bad, it shouldn't happen");
            }
            ((BHInternalNode)this.bhListArrRef[i2]).setRightChild(null);
            ((BHInternalNode)this.bhListArrRef[i2]).setLeftChild(null);
            bHTree.cluster((BHInternalNode)this.bhListArrRef[i2], bHNodeArray);
        }
    }
}

