/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BHInternalNode;
import javax.media.j3d.BoundingBox;

abstract class BHNode {
    static final byte BH_TYPE_INTERNAL = 1;
    static final byte BH_TYPE_LEAF = 2;
    static final int NUMBER_OF_PLANES = 6;
    static final boolean debug = false;
    static final boolean debug2 = false;
    BHNode parent;
    byte nodeType;
    BoundingBox bHull = null;
    boolean mark;

    BHNode() {
        this.parent = null;
        this.mark = false;
    }

    BHNode(BHNode bHNode) {
        this.parent = bHNode;
        this.mark = false;
    }

    BHNode(BHNode bHNode, BoundingBox boundingBox) {
        this.parent = bHNode;
        this.mark = false;
        this.bHull = boundingBox;
    }

    BHNode getParent() {
        return this.parent;
    }

    abstract void computeBoundingHull();

    abstract void updateMarkedBoundingHull();

    abstract void destroyTree(BHNode[] var1, int[] var2);

    void setParent(BHNode bHNode) {
        this.parent = bHNode;
    }

    BoundingBox getBoundingHull() {
        return this.bHull;
    }

    void setBoundingHull(BoundingBox boundingBox) {
        this.bHull = boundingBox;
    }

    void combineBHull(BHNode bHNode, BHNode bHNode2) {
        BoundingBox boundingBox = null;
        BoundingBox boundingBox2 = null;
        boundingBox = bHNode.getBoundingHull();
        boundingBox2 = bHNode2.getBoundingHull();
        if (this.bHull == null) {
            this.bHull = new BoundingBox(boundingBox);
        } else {
            this.bHull.set(boundingBox);
        }
        this.bHull.combine(boundingBox2);
    }

    boolean isInside(BoundingBox boundingBox) {
        if (boundingBox == null) {
            return false;
        }
        if (this.bHull.isEmpty() || boundingBox.isEmpty()) {
            return false;
        }
        return !(this.bHull.upper.x < boundingBox.upper.x || this.bHull.upper.y < boundingBox.upper.y || this.bHull.upper.z < boundingBox.upper.z || this.bHull.lower.x > boundingBox.lower.x || this.bHull.lower.y > boundingBox.lower.y) && !(this.bHull.lower.z > boundingBox.lower.z);
    }

    BHNode findNode(BHNode bHNode) {
        BHNode bHNode2 = null;
        if (this.nodeType == 2) {
            if (this == bHNode) {
                return this;
            }
        } else {
            if (((BHInternalNode)this).rChild.isInside(bHNode.bHull) && (bHNode2 = ((BHInternalNode)this).rChild.findNode(bHNode)) != null) {
                return bHNode2;
            }
            if (((BHInternalNode)this).lChild.isInside(bHNode.bHull)) {
                return ((BHInternalNode)this).lChild.findNode(bHNode);
            }
        }
        return null;
    }

    void deleteFromParent() {
        BHInternalNode bHInternalNode = (BHInternalNode)this.parent;
        if (bHInternalNode != null) {
            if (bHInternalNode.rChild == this) {
                bHInternalNode.rChild = null;
            } else if (bHInternalNode.lChild == this) {
                bHInternalNode.lChild = null;
            }
        }
    }

    BHNode deleteAndUpdateMarkedNodes() {
        if (this.mark) {
            if (this.nodeType == 2) {
                this.deleteFromParent();
                return null;
            }
            if (((BHInternalNode)this).rChild != null) {
                ((BHInternalNode)this).rChild = ((BHInternalNode)this).rChild.deleteAndUpdateMarkedNodes();
            }
            if (((BHInternalNode)this).lChild != null) {
                ((BHInternalNode)this).lChild = ((BHInternalNode)this).lChild.deleteAndUpdateMarkedNodes();
            }
            if (((BHInternalNode)this).rChild == null && ((BHInternalNode)this).lChild == null) {
                this.deleteFromParent();
                return null;
            }
            if (((BHInternalNode)this).rChild == null) {
                BHNode bHNode = ((BHInternalNode)this).lChild;
                bHNode.parent = this.parent;
                this.deleteFromParent();
                return bHNode;
            }
            if (((BHInternalNode)this).lChild == null) {
                BHNode bHNode = ((BHInternalNode)this).rChild;
                bHNode.parent = this.parent;
                this.deleteFromParent();
                return bHNode;
            }
            this.combineBHull(((BHInternalNode)this).rChild, ((BHInternalNode)this).lChild);
            ((BHInternalNode)this).rChild.parent = this;
            ((BHInternalNode)this).lChild.parent = this;
            this.mark = false;
            return this;
        }
        return this;
    }

    int countNumberOfInternals() {
        if (this.nodeType == 2) {
            return 0;
        }
        return ((BHInternalNode)this).rChild.countNumberOfInternals() + ((BHInternalNode)this).lChild.countNumberOfInternals() + 1;
    }

    int countNumberOfLeaves() {
        if (this.nodeType == 2) {
            return 1;
        }
        return ((BHInternalNode)this).rChild.countNumberOfLeaves() + ((BHInternalNode)this).lChild.countNumberOfLeaves();
    }

    int computeMaxDepth(int n2) {
        int n3;
        if (this.nodeType == 2) {
            return n2;
        }
        int n4 = ((BHInternalNode)this).rChild.computeMaxDepth(n2 + 1);
        if (n4 > (n3 = ((BHInternalNode)this).lChild.computeMaxDepth(n2 + 1))) {
            return n4;
        }
        return n3;
    }

    float computeAverageLeafDepth(int n2, int n3) {
        int n4 = this.computeSumOfDepths(0);
        return (float)n4 / (float)n2;
    }

    int computeSumOfDepths(int n2) {
        if (this.nodeType == 2) {
            return n2;
        }
        return ((BHInternalNode)this).rChild.computeSumOfDepths(n2 + 1) + ((BHInternalNode)this).lChild.computeSumOfDepths(n2 + 1);
    }
}

