/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Color3f;

public class Background
extends Leaf {
    public static final int ALLOW_APPLICATION_BOUNDS_READ = 12;
    public static final int ALLOW_APPLICATION_BOUNDS_WRITE = 13;
    public static final int ALLOW_IMAGE_READ = 14;
    public static final int ALLOW_IMAGE_WRITE = 15;
    public static final int ALLOW_COLOR_READ = 16;
    public static final int ALLOW_COLOR_WRITE = 17;
    public static final int ALLOW_GEOMETRY_READ = 18;
    public static final int ALLOW_GEOMETRY_WRITE = 19;
    public static final int ALLOW_IMAGE_SCALE_MODE_READ = 20;
    public static final int ALLOW_IMAGE_SCALE_MODE_WRITE = 21;
    public static final int SCALE_NONE = 0;
    public static final int SCALE_FIT_MIN = 1;
    public static final int SCALE_FIT_MAX = 2;
    public static final int SCALE_FIT_ALL = 3;
    public static final int SCALE_REPEAT = 4;
    public static final int SCALE_NONE_CENTER = 5;
    private static final int[] readCapabilities = new int[]{12, 16, 18, 14, 20};

    public Background() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Background(Color3f color3f) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((BackgroundRetained)this.retained).setColor(color3f);
    }

    public Background(float f2, float f3, float f4) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((BackgroundRetained)this.retained).setColor(f2, f3, f4);
    }

    public Background(ImageComponent2D imageComponent2D) {
        this.setDefaultReadCapabilities(readCapabilities);
        if (imageComponent2D != null && imageComponent2D.getImageClass() == ImageComponent.ImageClass.NIO_IMAGE_BUFFER) {
            throw new IllegalArgumentException(J3dI18N.getString("Background14"));
        }
        ((BackgroundRetained)this.retained).setImage(imageComponent2D);
    }

    public Background(BranchGroup branchGroup) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((BackgroundRetained)this.retained).setGeometry(branchGroup);
    }

    public void setColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background0"));
        }
        if (this.isLive()) {
            ((BackgroundRetained)this.retained).setColor(color3f);
        } else {
            ((BackgroundRetained)this.retained).initColor(color3f);
        }
    }

    public void setColor(float f2, float f3, float f4) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background0"));
        }
        if (this.isLive()) {
            ((BackgroundRetained)this.retained).setColor(f2, f3, f4);
        } else {
            ((BackgroundRetained)this.retained).initColor(f2, f3, f4);
        }
    }

    public void getColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background2"));
        }
        ((BackgroundRetained)this.retained).getColor(color3f);
    }

    public void setImage(ImageComponent2D imageComponent2D) {
        ImageComponent2DRetained imageComponent2DRetained;
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background3"));
        }
        BackgroundRetained backgroundRetained = (BackgroundRetained)this.retained;
        if (imageComponent2D != null && imageComponent2D.getImageClass() == ImageComponent.ImageClass.NIO_IMAGE_BUFFER) {
            throw new IllegalArgumentException(J3dI18N.getString("Background14"));
        }
        if (imageComponent2D != null && (imageComponent2DRetained = (ImageComponent2DRetained)imageComponent2D.retained).getUsedByOffScreen()) {
            if (this.isLive()) {
                throw new IllegalSharingException(J3dI18N.getString("Background12"));
            }
            if (backgroundRetained.getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("Background13"));
            }
        }
        if (this.isLive()) {
            backgroundRetained.setImage(imageComponent2D);
        } else {
            backgroundRetained.initImage(imageComponent2D);
        }
    }

    public ImageComponent2D getImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background4"));
        }
        return ((BackgroundRetained)this.retained).getImage();
    }

    public void setImageScaleMode(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background9"));
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("Background11"));
            }
        }
        if (this.isLive()) {
            ((BackgroundRetained)this.retained).setImageScaleMode(n2);
        } else {
            ((BackgroundRetained)this.retained).initImageScaleMode(n2);
        }
    }

    public int getImageScaleMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background10"));
        }
        return ((BackgroundRetained)this.retained).getImageScaleMode();
    }

    public void setGeometry(BranchGroup branchGroup) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background5"));
        }
        if (this.isLive()) {
            ((BackgroundRetained)this.retained).setGeometry(branchGroup);
        } else {
            ((BackgroundRetained)this.retained).initGeometry(branchGroup);
        }
    }

    public BranchGroup getGeometry() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background6"));
        }
        return ((BackgroundRetained)this.retained).getGeometry();
    }

    public void setApplicationBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background7"));
        }
        if (this.isLive()) {
            ((BackgroundRetained)this.retained).setApplicationBounds(bounds);
        } else {
            ((BackgroundRetained)this.retained).initApplicationBounds(bounds);
        }
    }

    public Bounds getApplicationBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background8"));
        }
        return ((BackgroundRetained)this.retained).getApplicationBounds();
    }

    public void setApplicationBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background7"));
        }
        if (this.isLive()) {
            ((BackgroundRetained)this.retained).setApplicationBoundingLeaf(boundingLeaf);
        } else {
            ((BackgroundRetained)this.retained).initApplicationBoundingLeaf(boundingLeaf);
        }
    }

    public BoundingLeaf getApplicationBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background8"));
        }
        return ((BackgroundRetained)this.retained).getApplicationBoundingLeaf();
    }

    void createRetained() {
        this.retained = new BackgroundRetained();
        this.retained.setSource(this);
    }

    public Node cloneNode(boolean bl) {
        Background background = new Background();
        background.duplicateNode(this, bl);
        return background;
    }

    public void duplicateNode(Node node, boolean bl) {
        this.checkDuplicateNode(node, bl);
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        BackgroundRetained backgroundRetained = (BackgroundRetained)node.retained;
        BackgroundRetained backgroundRetained2 = (BackgroundRetained)this.retained;
        Color3f color3f = new Color3f();
        backgroundRetained.getColor(color3f);
        backgroundRetained2.initColor(color3f);
        backgroundRetained2.initApplicationBounds(backgroundRetained.getApplicationBounds());
        backgroundRetained2.initGeometry(backgroundRetained.getGeometry());
        backgroundRetained2.initImage((ImageComponent2D)this.getNodeComponent(backgroundRetained.getImage(), bl, node.nodeHashtable));
        backgroundRetained2.initApplicationBoundingLeaf(backgroundRetained.getApplicationBoundingLeaf());
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        BackgroundRetained backgroundRetained = (BackgroundRetained)this.retained;
        BoundingLeaf boundingLeaf = backgroundRetained.getApplicationBoundingLeaf();
        if (boundingLeaf != null) {
            SceneGraphObject sceneGraphObject = nodeReferenceTable.getNewObjectReference(boundingLeaf);
            backgroundRetained.initApplicationBoundingLeaf((BoundingLeaf)sceneGraphObject);
        }
    }
}

