/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.media.j3d.Behavior;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.IndexedUnorderSet;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupIndexedList;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnActivation;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnDeactivation;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.media.j3d.WakeupOnSensorEntry;
import javax.media.j3d.WakeupOnSensorExit;
import javax.media.j3d.WakeupOnViewPlatformEntry;
import javax.media.j3d.WakeupOnViewPlatformExit;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class BehaviorStructure
extends J3dStructure {
    IndexedUnorderSet behaviors;
    IndexedUnorderSet viewPlatforms;
    IndexedUnorderSet scheduleList;
    UnorderList[] processList = new UnorderList[10];
    Point3d vpCenter = new Point3d();
    Point3d vpTransCenter = new Point3d();
    WakeupIndexedList boundsEntryList;
    WakeupIndexedList boundsExitList;
    WakeupIndexedList currentSensorEntryList;
    WakeupIndexedList currentSensorExitList;
    WakeupIndexedList wakeupOnAWTEvent;
    WakeupIndexedList wakeupOnActivation;
    WakeupIndexedList wakeupOnDeactivation;
    WakeupIndexedList wakeupOnBehaviorPost;
    WakeupIndexedList wakeupOnElapsedFrames;
    WakeupIndexedList wakeupOnViewPlatformEntry;
    WakeupIndexedList wakeupOnViewPlatformExit;
    WakeupIndexedList wakeupOnSensorEntry;
    WakeupIndexedList wakeupOnSensorExit;
    UnorderList transformViewPlatformList = new UnorderList(ViewPlatformRetained.class);
    int activeWakeupOnFrameCount = 0;
    int activeWakeupOnSensorCount = 0;
    UnorderList awtEventsBuffer = new UnorderList(AWTEvent.class);
    int[] postIDBuffer = new int[10];
    int[] clonePostIDBuffer = new int[this.postIDBuffer.length];
    UnorderList behaviorPostBuffer = new UnorderList(Behavior.class);
    Transform3D sensorTransform = new Transform3D();
    Vector3d sensorLoc = new Vector3d();
    Point3d ptSensorLoc = new Point3d();
    UnorderList physicalEnvironments = new UnorderList(1, PhysicalEnvironment.class);
    UnorderList pendingBehaviors = new UnorderList(BehaviorRetained.class);
    boolean branchDetach = false;
    long awtEventTimestamp = 1L;
    boolean transformMsg = false;
    UpdateTargets targets = null;

    BehaviorStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 256);
        for (int i2 = 9; i2 >= 0; --i2) {
            this.processList[i2] = new UnorderList(BehaviorRetained.class);
        }
        this.behaviors = new IndexedUnorderSet(BehaviorRetained.class, 0, virtualUniverse);
        this.viewPlatforms = new IndexedUnorderSet(ViewPlatformRetained.class, 0, virtualUniverse);
        this.scheduleList = new IndexedUnorderSet(BehaviorRetained.class, 1, virtualUniverse);
        this.boundsEntryList = new WakeupIndexedList(WakeupOnViewPlatformEntry.class, 1, virtualUniverse);
        this.boundsExitList = new WakeupIndexedList(WakeupOnViewPlatformExit.class, 1, virtualUniverse);
        this.currentSensorEntryList = new WakeupIndexedList(WakeupOnSensorEntry.class, 1, virtualUniverse);
        this.currentSensorExitList = new WakeupIndexedList(WakeupOnSensorExit.class, 1, virtualUniverse);
        this.wakeupOnAWTEvent = new WakeupIndexedList(WakeupOnAWTEvent.class, 0, virtualUniverse);
        this.wakeupOnActivation = new WakeupIndexedList(WakeupOnActivation.class, 0, virtualUniverse);
        this.wakeupOnDeactivation = new WakeupIndexedList(WakeupOnDeactivation.class, 0, virtualUniverse);
        this.wakeupOnBehaviorPost = new WakeupIndexedList(WakeupOnBehaviorPost.class, 0, virtualUniverse);
        this.wakeupOnElapsedFrames = new WakeupIndexedList(WakeupOnElapsedFrames.class, 0, virtualUniverse);
        this.wakeupOnViewPlatformEntry = new WakeupIndexedList(WakeupOnViewPlatformEntry.class, 0, virtualUniverse);
        this.wakeupOnViewPlatformExit = new WakeupIndexedList(WakeupOnViewPlatformExit.class, 0, virtualUniverse);
        this.wakeupOnSensorEntry = new WakeupIndexedList(WakeupOnSensorEntry.class, 0, virtualUniverse);
        this.wakeupOnSensorExit = new WakeupIndexedList(WakeupOnSensorExit.class, 0, virtualUniverse);
    }

    void processMessages(long l2) {
        Object[] objectArray = this.getMessages(l2);
        int n2 = this.getNumMessage();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                J3dMessage j3dMessage = objectArray[i2];
                switch (j3dMessage.type) {
                    case 3: {
                        this.transformMsg = true;
                        break;
                    }
                    case 28: {
                        this.processConditionMet((BehaviorRetained)j3dMessage.args[0], (Boolean)j3dMessage.args[1]);
                        break;
                    }
                    case 0: {
                        this.insertNodes((Object[])j3dMessage.args[0]);
                        break;
                    }
                    case 1: {
                        this.removeNodes(j3dMessage);
                        break;
                    }
                    case 49: {
                        this.activateBehaviors();
                        break;
                    }
                    case 29: {
                        this.addToScheduleList((BehaviorRetained)j3dMessage.args[1]);
                        this.reEvaluateWakeupCount();
                        break;
                    }
                    case 30: {
                        this.removeFromScheduleList((BehaviorRetained)j3dMessage.args[1]);
                        this.reEvaluateWakeupCount();
                        break;
                    }
                    case 55: {
                        ((BehaviorRetained)j3dMessage.args[1]).schedulingInterval = (Integer)j3dMessage.args[2];
                        break;
                    }
                    case 27: {
                        this.processSwitchChanged(j3dMessage);
                        if (!this.universe.transformStructure.getLazyUpdate()) break;
                        this.transformMsg = true;
                        break;
                    }
                    case 23: {
                        this.processBoundingLeafChanged((Object[])j3dMessage.args[3], (Bounds)j3dMessage.args[2]);
                        break;
                    }
                    case 4: {
                        this.reEvaluatePhysicalEnvironments();
                        ViewPlatform viewPlatform = ((View)j3dMessage.args[0]).getViewPlatform();
                        if (viewPlatform == null) break;
                        this.processViewPlatformTransform((ViewPlatformRetained)viewPlatform.retained);
                        break;
                    }
                    case 48: {
                        ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)j3dMessage.args[0];
                        viewPlatformRetained.updateActivationRadius(((Float)j3dMessage.args[1]).floatValue());
                        this.processViewPlatformTransform(viewPlatformRetained);
                        break;
                    }
                    case 35: {
                        BehaviorRetained behaviorRetained = (BehaviorRetained)j3dMessage.args[1];
                        behaviorRetained.updateTransformRegion();
                        this.processBehaviorTransform(behaviorRetained);
                        break;
                    }
                    case 60: {
                        BehaviorRetained behaviorRetained = (BehaviorRetained)j3dMessage.args[0];
                        behaviorRetained.active = false;
                        this.addToScheduleList(behaviorRetained);
                    }
                }
                j3dMessage.decRefcount();
            }
            if (this.transformMsg) {
                this.targets = this.universe.transformStructure.getTargetList();
                UnorderList unorderList = this.targets.targetList[2];
                if (unorderList != null) {
                    this.processBehXformChanged(unorderList);
                }
                if ((unorderList = this.targets.targetList[4]) != null) {
                    this.processVpfXformChanged(unorderList);
                }
                this.transformMsg = false;
                this.targets = null;
            }
            Arrays.fill(objectArray, 0, n2, null);
        }
        if (this.activeWakeupOnSensorCount <= 0) {
            if (this.activeWakeupOnFrameCount > 0) {
                VirtualUniverse.mc.sendRunMessage(this.universe, 17);
            } else {
                VirtualUniverse.mc.sendRunMessage(this.universe, 1);
            }
        } else {
            this.checkSensorEntryExit();
            if (this.activeWakeupOnFrameCount > 0) {
                VirtualUniverse.mc.sendRunMessage(this.universe, 273);
            } else {
                VirtualUniverse.mc.sendRunMessage(this.universe, 257);
            }
        }
    }

    void insertNodes(Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            if (object instanceof BehaviorRetained) {
                this.pendingBehaviors.add(object);
                continue;
            }
            if (!(object instanceof ViewPlatformRetained)) continue;
            this.addViewPlatform((ViewPlatformRetained)object);
        }
    }

    void activateBehaviors() {
        BehaviorRetained[] behaviorRetainedArray = (BehaviorRetained[])this.pendingBehaviors.toArray(false);
        for (int i2 = this.pendingBehaviors.arraySize() - 1; i2 >= 0; --i2) {
            BehaviorRetained behaviorRetained = behaviorRetainedArray[i2];
            behaviorRetained.wakeupCondition = behaviorRetained.newWakeupCondition;
            if (behaviorRetained.wakeupCondition == null) continue;
            behaviorRetained.wakeupCondition.buildTree(null, 0, behaviorRetained);
            behaviorRetained.conditionSet = true;
            this.behaviors.add(behaviorRetained);
            behaviorRetained.updateTransformRegion();
            this.addToScheduleList(behaviorRetained);
        }
        this.pendingBehaviors.clear();
    }

    void addViewPlatform(ViewPlatformRetained viewPlatformRetained) {
        int n2;
        BehaviorRetained[] behaviorRetainedArray = (BehaviorRetained[])this.behaviors.toArray(false);
        this.viewPlatforms.add(viewPlatformRetained);
        viewPlatformRetained.updateTransformRegion();
        if (!viewPlatformRetained.isActiveViewPlatform()) {
            return;
        }
        for (n2 = this.behaviors.arraySize() - 1; n2 >= 0; --n2) {
            this.addToScheduleList(behaviorRetainedArray[n2]);
        }
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArray = (WakeupOnViewPlatformEntry[])this.wakeupOnViewPlatformEntry.toArray(false);
        for (n2 = this.wakeupOnViewPlatformEntry.arraySize() - 1; n2 >= 0; --n2) {
            WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry = wakeupOnViewPlatformEntryArray[n2];
            if (this.boundsEntryList.contains(wakeupOnViewPlatformEntry) || !wakeupOnViewPlatformEntry.transformedRegion.intersect(viewPlatformRetained.center)) continue;
            this.boundsEntryList.add(wakeupOnViewPlatformEntry);
            wakeupOnViewPlatformEntry.triggeredVP = viewPlatformRetained;
            wakeupOnViewPlatformEntry.setTriggered();
        }
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArray = (WakeupOnViewPlatformExit[])this.wakeupOnViewPlatformExit.toArray(false);
        for (n2 = this.wakeupOnViewPlatformExit.arraySize() - 1; n2 >= 0; --n2) {
            WakeupOnViewPlatformExit wakeupOnViewPlatformExit = wakeupOnViewPlatformExitArray[n2];
            if (this.boundsExitList.contains(wakeupOnViewPlatformExit) || !wakeupOnViewPlatformExit.transformedRegion.intersect(viewPlatformRetained.center)) continue;
            wakeupOnViewPlatformExit.triggeredVP = viewPlatformRetained;
            this.boundsExitList.add(wakeupOnViewPlatformExit);
        }
    }

    void removeNodes(J3dMessage j3dMessage) {
        Object[] objectArray = (Object[])j3dMessage.args[0];
        boolean bl = false;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            if (object instanceof BehaviorRetained) {
                bl = true;
                this.removeBehavior((BehaviorRetained)object);
                continue;
            }
            if (!(object instanceof ViewPlatformRetained)) continue;
            this.removeViewPlatform((ViewPlatformRetained)object);
        }
        this.wakeupOnAWTEvent.clearMirror();
        this.awtEventsBuffer.clearMirror();
        this.wakeupOnBehaviorPost.clearMirror();
        this.behaviorPostBuffer.clearMirror();
        this.wakeupOnSensorEntry.clearMirror();
        this.wakeupOnSensorExit.clearMirror();
        this.branchDetach = true;
        if (bl) {
            WakeupOnAWTEvent[] wakeupOnAWTEventArray = (WakeupOnAWTEvent[])this.wakeupOnAWTEvent.toArray();
            int n2 = this.wakeupOnAWTEvent.arraySize();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            for (int i3 = 0; i3 < n2; ++i3) {
                WakeupOnAWTEvent wakeupOnAWTEvent = wakeupOnAWTEventArray[i3];
                int n3 = wakeupOnAWTEvent.AwtId;
                long l2 = wakeupOnAWTEvent.EventMask;
                if (n3 >= 1004 && n3 <= 1005 || (l2 & 4L) != 0L) {
                    bl2 = true;
                }
                if (n3 >= 400 && n3 <= 402 || (l2 & 8L) != 0L) {
                    bl3 = true;
                }
                if (n3 >= 500 && n3 <= 507) {
                    if (n3 == 506 || n3 == 503) {
                        bl4 = true;
                        continue;
                    }
                    if (n3 == 504 || n3 == 505 || n3 == 500 || n3 == 501 || n3 == 502) {
                        bl5 = true;
                        continue;
                    }
                    if (n3 != 507) continue;
                    bl6 = true;
                    continue;
                }
                if ((l2 & 0x10L) != 0L) {
                    bl5 = true;
                }
                if ((l2 & 0x20L) != 0L) {
                    bl4 = true;
                }
                if ((l2 & 0x20000L) == 0L) continue;
                bl6 = true;
            }
            if (!bl2 && this.universe.enableFocus) {
                bl7 = true;
                this.universe.disableFocusEvents();
            }
            if (!VirtualUniverse.mc.isD3D() && !bl3 && this.universe.enableKey) {
                bl7 = true;
                this.universe.disableKeyEvents();
            }
            if (!bl6 && this.universe.enableMouseWheel) {
                bl7 = true;
                this.universe.disableMouseWheelEvents();
            }
            if (!bl4 && this.universe.enableMouseMotion) {
                bl7 = true;
                this.universe.disableMouseMotionEvents();
            }
            if (!bl5 && this.universe.enableMouse) {
                bl7 = true;
                this.universe.disableMouseEvents();
            }
            if (bl7) {
                ++this.awtEventTimestamp;
            }
        }
    }

    void removeViewPlatform(ViewPlatformRetained viewPlatformRetained) {
        ViewPlatformRetained viewPlatformRetained2;
        int n2;
        this.viewPlatforms.remove(viewPlatformRetained);
        BehaviorRetained[] behaviorRetainedArray = (BehaviorRetained[])this.scheduleList.toArray(false);
        for (n2 = this.scheduleList.arraySize() - 1; n2 >= 0; --n2) {
            BehaviorRetained behaviorRetained = behaviorRetainedArray[n2];
            if (this.intersectVPRegion(behaviorRetained.transformedRegion)) continue;
            this.removeFromScheduleList(behaviorRetained);
        }
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArray = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        for (n2 = this.boundsEntryList.arraySize() - 1; n2 >= 0; --n2) {
            WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry = wakeupOnViewPlatformEntryArray[n2];
            viewPlatformRetained2 = this.intersectVPCenter(wakeupOnViewPlatformEntry.transformedRegion);
            if (viewPlatformRetained2 != null) continue;
            this.boundsEntryList.remove(wakeupOnViewPlatformEntry);
        }
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArray = (WakeupOnViewPlatformExit[])this.boundsExitList.toArray(false);
        for (n2 = this.boundsExitList.arraySize() - 1; n2 >= 0; --n2) {
            WakeupOnViewPlatformExit wakeupOnViewPlatformExit = wakeupOnViewPlatformExitArray[n2];
            viewPlatformRetained2 = this.intersectVPCenter(wakeupOnViewPlatformExit.transformedRegion);
            if (viewPlatformRetained2 != null) continue;
            this.boundsExitList.remove(wakeupOnViewPlatformExit);
            wakeupOnViewPlatformExit.setTriggered();
        }
    }

    void removeBehavior(BehaviorRetained behaviorRetained) {
        this.behaviors.remove(behaviorRetained);
        if (behaviorRetained.wakeupCondition != null && behaviorRetained.wakeupCondition.behav != null) {
            behaviorRetained.wakeupCondition.cleanTree(this);
            if (behaviorRetained.universe == this.universe) {
                behaviorRetained.conditionSet = false;
            }
        }
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArray = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        for (int i2 = this.boundsEntryList.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry = wakeupOnViewPlatformEntryArray[i2];
            if (wakeupOnViewPlatformEntry.behav != behaviorRetained) continue;
            this.boundsEntryList.remove(wakeupOnViewPlatformEntry);
        }
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArray = (WakeupOnViewPlatformExit[])this.boundsExitList.toArray(false);
        for (int i3 = this.boundsExitList.arraySize() - 1; i3 >= 0; --i3) {
            WakeupOnViewPlatformExit wakeupOnViewPlatformExit = wakeupOnViewPlatformExitArray[i3];
            if (wakeupOnViewPlatformExit.behav != behaviorRetained) continue;
            this.boundsExitList.remove(wakeupOnViewPlatformExit);
        }
        WakeupOnSensorEntry[] wakeupOnSensorEntryArray = (WakeupOnSensorEntry[])this.currentSensorEntryList.toArray(false);
        for (int i4 = this.currentSensorEntryList.arraySize() - 1; i4 >= 0; --i4) {
            WakeupOnSensorEntry wakeupOnSensorEntry = wakeupOnSensorEntryArray[i4];
            if (wakeupOnSensorEntry.behav != behaviorRetained) continue;
            this.currentSensorEntryList.remove(wakeupOnSensorEntry);
        }
        WakeupOnSensorExit[] wakeupOnSensorExitArray = (WakeupOnSensorExit[])this.currentSensorExitList.toArray(false);
        for (int i5 = this.currentSensorExitList.arraySize() - 1; i5 >= 0; --i5) {
            WakeupOnSensorExit wakeupOnSensorExit = wakeupOnSensorExitArray[i5];
            if (wakeupOnSensorExit.behav != behaviorRetained) continue;
            this.currentSensorExitList.remove(wakeupOnSensorExit);
        }
        this.removeFromScheduleList(behaviorRetained);
    }

    void handleAWTEvent(AWTEvent aWTEvent) {
        this.awtEventsBuffer.add(aWTEvent);
        VirtualUniverse.mc.sendRunMessage(this.universe, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAWTEvent() {
        int n2;
        AWTEvent[] aWTEventArray;
        WakeupOnAWTEvent[] wakeupOnAWTEventArray = (WakeupOnAWTEvent[])this.wakeupOnAWTEvent.toArray();
        int n3 = this.wakeupOnAWTEvent.arraySize();
        Object object = this.awtEventsBuffer;
        synchronized (object) {
            aWTEventArray = (AWTEvent[])this.awtEventsBuffer.toArray();
            n2 = this.awtEventsBuffer.size();
            this.awtEventsBuffer.clear();
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            object = wakeupOnAWTEventArray[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                AWTEvent aWTEvent = aWTEventArray[i3];
                int n4 = aWTEvent.getID();
                if (((WakeupOnAWTEvent)object).AwtId != 0) {
                    if (((WakeupOnAWTEvent)object).AwtId != n4) continue;
                    ((WakeupOnAWTEvent)object).addAWTEvent(aWTEvent);
                    continue;
                }
                if (n4 >= 100 && n4 <= 103 && (((WakeupOnAWTEvent)object).EventMask & 1L) != 0L) {
                    ((WakeupOnAWTEvent)object).addAWTEvent(aWTEvent);
                    continue;
                }
                if (n4 >= 1004 && n4 <= 1005 && (((WakeupOnAWTEvent)object).EventMask & 4L) != 0L) {
                    ((WakeupOnAWTEvent)object).addAWTEvent(aWTEvent);
                    continue;
                }
                if (n4 >= 400 && n4 <= 402 && (((WakeupOnAWTEvent)object).EventMask & 8L) != 0L) {
                    ((WakeupOnAWTEvent)object).addAWTEvent(aWTEvent);
                    continue;
                }
                if ((n4 == 500 || n4 == 504 || n4 == 505 || n4 == 501 || n4 == 502) && (((WakeupOnAWTEvent)object).EventMask & 0x10L) != 0L) {
                    ((WakeupOnAWTEvent)object).addAWTEvent(aWTEvent);
                    continue;
                }
                if ((n4 == 506 || n4 == 503) && (((WakeupOnAWTEvent)object).EventMask & 0x20L) != 0L) {
                    ((WakeupOnAWTEvent)object).addAWTEvent(aWTEvent);
                    continue;
                }
                if (n4 != 507 || (((WakeupOnAWTEvent)object).EventMask & 0x20000L) == 0L) continue;
                ((WakeupOnAWTEvent)object).addAWTEvent(aWTEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBehaviorPost(Behavior behavior, int n2) {
        UnorderList unorderList = this.behaviorPostBuffer;
        synchronized (unorderList) {
            int n3 = this.behaviorPostBuffer.size();
            if (this.postIDBuffer.length == n3) {
                int[] nArray = this.postIDBuffer;
                this.postIDBuffer = new int[n3 << 1];
                System.arraycopy(nArray, 0, this.postIDBuffer, 0, n3);
            }
            this.postIDBuffer[n3] = n2;
            this.behaviorPostBuffer.add(behavior);
        }
        VirtualUniverse.mc.sendRunMessage(this.universe, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBehaviorPost() {
        int n2;
        Behavior[] behaviorArray;
        WakeupOnBehaviorPost[] wakeupOnBehaviorPostArray = (WakeupOnBehaviorPost[])this.wakeupOnBehaviorPost.toArray();
        UnorderList unorderList = this.behaviorPostBuffer;
        synchronized (unorderList) {
            behaviorArray = (Behavior[])this.behaviorPostBuffer.toArray();
            n2 = this.behaviorPostBuffer.size();
            if (this.clonePostIDBuffer.length < n2) {
                this.clonePostIDBuffer = new int[n2];
            }
            System.arraycopy(this.postIDBuffer, 0, this.clonePostIDBuffer, 0, n2);
            this.behaviorPostBuffer.clear();
        }
        int n3 = this.wakeupOnBehaviorPost.arraySize();
        for (int i2 = 0; i2 < n3; ++i2) {
            WakeupOnBehaviorPost wakeupOnBehaviorPost = wakeupOnBehaviorPostArray[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                Behavior behavior = behaviorArray[i3];
                int n4 = this.clonePostIDBuffer[i3];
                if (wakeupOnBehaviorPost.post != n4 && wakeupOnBehaviorPost.post != 0 || behavior != wakeupOnBehaviorPost.armingBehavior && wakeupOnBehaviorPost.armingBehavior != null) continue;
                wakeupOnBehaviorPost.triggeringBehavior = behavior;
                wakeupOnBehaviorPost.triggeringPost = n4;
                wakeupOnBehaviorPost.setTriggered();
            }
        }
    }

    void incElapsedFrames() {
        WakeupOnElapsedFrames[] wakeupOnElapsedFramesArray = (WakeupOnElapsedFrames[])this.wakeupOnElapsedFrames.toArray(true);
        int n2 = this.wakeupOnElapsedFrames.arraySize();
        int n3 = 0;
        while (n3 < n2) {
            wakeupOnElapsedFramesArray[n3++].newFrame();
        }
        if (n2 > 0) {
            VirtualUniverse.mc.sendRunMessage(this.universe, 257);
        }
        if (this.branchDetach) {
            this.wakeupOnElapsedFrames.clearMirror();
            this.branchDetach = false;
        }
    }

    void removeVPEntryCondition(WakeupCondition wakeupCondition) {
        this.wakeupOnViewPlatformEntry.remove(wakeupCondition);
    }

    void addVPEntryCondition(WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry) {
        boolean bl = true;
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArray = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        for (int i2 = this.boundsEntryList.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry2 = wakeupOnViewPlatformEntryArray[i2];
            if (wakeupOnViewPlatformEntry2.behav != wakeupOnViewPlatformEntry.behav || !wakeupOnViewPlatformEntry2.region.equals(wakeupOnViewPlatformEntry.region)) continue;
            this.boundsEntryList.remove(i2);
            bl = false;
            break;
        }
        this.wakeupOnViewPlatformEntry.add(wakeupOnViewPlatformEntry);
        ViewPlatformRetained viewPlatformRetained = this.intersectVPCenter(wakeupOnViewPlatformEntry.transformedRegion);
        if (viewPlatformRetained != null) {
            this.boundsEntryList.add(wakeupOnViewPlatformEntry);
        }
        if (bl && viewPlatformRetained != null) {
            wakeupOnViewPlatformEntry.triggeredVP = viewPlatformRetained;
            wakeupOnViewPlatformEntry.setTriggered();
        }
    }

    void removeVPExitCondition(WakeupOnViewPlatformExit wakeupOnViewPlatformExit) {
        this.wakeupOnViewPlatformExit.remove(wakeupOnViewPlatformExit);
    }

    void addVPExitCondition(WakeupOnViewPlatformExit wakeupOnViewPlatformExit) {
        boolean bl = true;
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArray = (WakeupOnViewPlatformExit[])this.boundsExitList.toArray(false);
        for (int i2 = this.boundsExitList.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformExit wakeupOnViewPlatformExit2 = wakeupOnViewPlatformExitArray[i2];
            if (wakeupOnViewPlatformExit2.behav != wakeupOnViewPlatformExit.behav || !wakeupOnViewPlatformExit2.region.equals(wakeupOnViewPlatformExit.region)) continue;
            this.boundsExitList.remove(i2);
            bl = false;
            break;
        }
        ViewPlatformRetained viewPlatformRetained = this.intersectVPCenter(wakeupOnViewPlatformExit.transformedRegion);
        this.wakeupOnViewPlatformExit.add(wakeupOnViewPlatformExit);
        if (viewPlatformRetained != null) {
            wakeupOnViewPlatformExit.triggeredVP = viewPlatformRetained;
            this.boundsExitList.add(wakeupOnViewPlatformExit);
        }
        if (!bl) {
            return;
        }
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArray = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        for (int i3 = this.boundsEntryList.arraySize() - 1; i3 >= 0; --i3) {
            WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry = wakeupOnViewPlatformEntryArray[i3];
            if (wakeupOnViewPlatformEntry.behav != wakeupOnViewPlatformExit.behav || !wakeupOnViewPlatformEntry.region.equals(wakeupOnViewPlatformExit.region)) continue;
            if (viewPlatformRetained != null) break;
            wakeupOnViewPlatformExit.setTriggered();
            break;
        }
    }

    void removeSensorEntryCondition(WakeupOnSensorEntry wakeupOnSensorEntry) {
        this.wakeupOnSensorEntry.remove(wakeupOnSensorEntry);
    }

    void addSensorEntryCondition(WakeupOnSensorEntry wakeupOnSensorEntry) {
        boolean bl = true;
        WakeupOnSensorEntry[] wakeupOnSensorEntryArray = (WakeupOnSensorEntry[])this.currentSensorEntryList.toArray(false);
        for (int i2 = this.currentSensorEntryList.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnSensorEntry wakeupOnSensorEntry2 = wakeupOnSensorEntryArray[i2];
            if (wakeupOnSensorEntry2.behav != wakeupOnSensorEntry.behav || !wakeupOnSensorEntry2.region.equals(wakeupOnSensorEntry.region)) continue;
            this.currentSensorEntryList.remove(i2);
            bl = false;
            break;
        }
        this.wakeupOnSensorEntry.add(wakeupOnSensorEntry);
        wakeupOnSensorEntry.updateTransformRegion();
        Sensor sensor = this.sensorIntersect(wakeupOnSensorEntry.transformedRegion);
        if (sensor != null) {
            wakeupOnSensorEntry.setTarget(sensor);
            this.currentSensorEntryList.add(wakeupOnSensorEntry);
        }
        if (bl && sensor != null) {
            wakeupOnSensorEntry.setTriggered();
        }
        VirtualUniverse.mc.sendRunMessage(this.universe, 256);
    }

    void removeSensorExitCondition(WakeupOnSensorExit wakeupOnSensorExit) {
        this.wakeupOnSensorExit.remove(wakeupOnSensorExit);
    }

    void addSensorExitCondition(WakeupOnSensorExit wakeupOnSensorExit) {
        boolean bl = true;
        WakeupOnSensorExit[] wakeupOnSensorExitArray = (WakeupOnSensorExit[])this.currentSensorExitList.toArray(false);
        for (int i2 = this.currentSensorExitList.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnSensorExit wakeupOnSensorExit2 = wakeupOnSensorExitArray[i2];
            if (wakeupOnSensorExit2.behav != wakeupOnSensorExit.behav || !wakeupOnSensorExit2.region.equals(wakeupOnSensorExit.region)) continue;
            this.currentSensorExitList.remove(i2);
            bl = false;
            break;
        }
        wakeupOnSensorExit.updateTransformRegion();
        Sensor sensor = this.sensorIntersect(wakeupOnSensorExit.transformedRegion);
        this.wakeupOnSensorExit.add(wakeupOnSensorExit);
        if (sensor != null) {
            wakeupOnSensorExit.setTarget(sensor);
            this.currentSensorExitList.add(wakeupOnSensorExit);
        }
        if (!bl) {
            return;
        }
        WakeupOnSensorEntry[] wakeupOnSensorEntryArray = (WakeupOnSensorEntry[])this.currentSensorEntryList.toArray(false);
        for (int i3 = this.currentSensorEntryList.arraySize() - 1; i3 >= 0; --i3) {
            WakeupOnSensorEntry wakeupOnSensorEntry = wakeupOnSensorEntryArray[i3];
            if (wakeupOnSensorEntry.behav != wakeupOnSensorExit.behav || !wakeupOnSensorEntry.region.equals(wakeupOnSensorExit.region)) continue;
            if (sensor != null) break;
            wakeupOnSensorExit.setTriggered();
            break;
        }
        VirtualUniverse.mc.sendRunMessage(this.universe, 256);
    }

    void processConditionMet(BehaviorRetained behaviorRetained, Boolean bl) {
        if (!behaviorRetained.inCallback && (bl == Boolean.FALSE || behaviorRetained.active)) {
            this.processList[behaviorRetained.schedulingInterval].add(behaviorRetained);
        } else if ((behaviorRetained.wakeupMask & 0x10) != 0 && behaviorRetained.source != null && behaviorRetained.source.isLive() && behaviorRetained.wakeupCondition != null) {
            behaviorRetained.wakeupCondition.reInsertElapseTimeCond();
        }
    }

    final void processBehXformChanged(UnorderList unorderList) {
        int n2 = unorderList.size();
        Object[] objectArray = unorderList.toArray(false);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object[] objectArray2 = (Object[])objectArray[i2];
            for (int i3 = 0; i3 < objectArray2.length; ++i3) {
                BehaviorRetained behaviorRetained = (BehaviorRetained)objectArray2[i3];
                behaviorRetained.updateTransformRegion();
                this.processBehaviorTransform(behaviorRetained);
            }
        }
    }

    final void processVpfXformChanged(UnorderList unorderList) {
        int n2 = unorderList.size();
        Object[] objectArray = unorderList.toArray(false);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object[] objectArray2 = (Object[])objectArray[i2];
            for (int i3 = 0; i3 < objectArray2.length; ++i3) {
                this.processViewPlatformTransform((ViewPlatformRetained)objectArray2[i3]);
            }
        }
    }

    final void processTransformChanged(Object[] objectArray) {
        int n2;
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            Object object = objectArray[n2];
            if (object instanceof BehaviorRetained) {
                ((BehaviorRetained)object).updateTransformRegion();
                this.processBehaviorTransform((BehaviorRetained)object);
                continue;
            }
            if (!(object instanceof ViewPlatformRetained)) continue;
            ((ViewPlatformRetained)object).updateTransformRegion();
            this.transformViewPlatformList.add(object);
        }
        if (this.transformViewPlatformList.size() > 0) {
            ViewPlatformRetained[] viewPlatformRetainedArray = (ViewPlatformRetained[])this.transformViewPlatformList.toArray(false);
            int n3 = this.transformViewPlatformList.arraySize();
            for (n2 = 0; n2 < n3; ++n2) {
                this.processViewPlatformTransform(viewPlatformRetainedArray[n2]);
            }
            this.transformViewPlatformList.clear();
        }
    }

    final void processBehaviorTransform(BehaviorRetained behaviorRetained) {
        if ((behaviorRetained.wakeupMask & 4) != 0) {
            this.updateVPEntryTransformRegion(behaviorRetained);
        }
        if ((behaviorRetained.wakeupMask & 8) != 0) {
            this.updateVPExitTransformRegion(behaviorRetained);
        }
        if (behaviorRetained.active) {
            if (!this.intersectVPRegion(behaviorRetained.transformedRegion)) {
                this.removeFromScheduleList(behaviorRetained);
            }
        } else {
            this.addToScheduleList(behaviorRetained);
        }
    }

    void processViewPlatformTransform(ViewPlatformRetained viewPlatformRetained) {
        ViewPlatformRetained viewPlatformRetained2;
        int n2;
        int n3;
        viewPlatformRetained.updateTransformRegion();
        if (!viewPlatformRetained.isActiveViewPlatform()) {
            return;
        }
        BehaviorRetained[] behaviorRetainedArray = (BehaviorRetained[])this.behaviors.toArray(false);
        for (n3 = this.behaviors.arraySize() - 1; n3 >= 0; --n3) {
            BehaviorRetained behaviorRetained = behaviorRetainedArray[n3];
            if (behaviorRetained.active) {
                if (this.intersectVPRegion(behaviorRetained.transformedRegion)) continue;
                this.removeFromScheduleList(behaviorRetained);
                continue;
            }
            this.addToScheduleList(behaviorRetained);
        }
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArray = (WakeupOnViewPlatformEntry[])this.wakeupOnViewPlatformEntry.toArray(false);
        for (n3 = this.wakeupOnViewPlatformEntry.arraySize() - 1; n3 >= 0; --n3) {
            WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry = wakeupOnViewPlatformEntryArray[n3];
            n2 = this.boundsEntryList.indexOf(wakeupOnViewPlatformEntry);
            if (n2 < 0) {
                if (!wakeupOnViewPlatformEntry.transformedRegion.intersect(viewPlatformRetained.center)) continue;
                this.boundsEntryList.add(wakeupOnViewPlatformEntry);
                wakeupOnViewPlatformEntry.triggeredVP = viewPlatformRetained;
                wakeupOnViewPlatformEntry.setTriggered();
                continue;
            }
            viewPlatformRetained2 = this.intersectVPCenter(wakeupOnViewPlatformEntry.transformedRegion);
            if (viewPlatformRetained2 != null) continue;
            this.boundsEntryList.remove(n2);
        }
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArray = (WakeupOnViewPlatformExit[])this.wakeupOnViewPlatformExit.toArray(false);
        for (n3 = this.wakeupOnViewPlatformExit.arraySize() - 1; n3 >= 0; --n3) {
            WakeupOnViewPlatformExit wakeupOnViewPlatformExit = wakeupOnViewPlatformExitArray[n3];
            n2 = this.boundsExitList.indexOf(wakeupOnViewPlatformExit);
            if (n2 < 0) {
                if (!wakeupOnViewPlatformExit.transformedRegion.intersect(viewPlatformRetained.center)) continue;
                wakeupOnViewPlatformExit.triggeredVP = viewPlatformRetained;
                this.boundsExitList.add(wakeupOnViewPlatformExit);
                continue;
            }
            viewPlatformRetained2 = this.intersectVPCenter(wakeupOnViewPlatformExit.transformedRegion);
            if (viewPlatformRetained2 != null) continue;
            this.boundsExitList.remove(n2);
            wakeupOnViewPlatformExit.setTriggered();
        }
    }

    void updateVPEntryTransformRegion(BehaviorRetained behaviorRetained) {
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArray = (WakeupOnViewPlatformEntry[])this.wakeupOnViewPlatformEntry.toArray(false);
        for (int i2 = this.wakeupOnViewPlatformEntry.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry = wakeupOnViewPlatformEntryArray[i2];
            if (wakeupOnViewPlatformEntry.behav != behaviorRetained) continue;
            wakeupOnViewPlatformEntry.updateTransformRegion(behaviorRetained);
            int n2 = this.boundsEntryList.indexOf(wakeupOnViewPlatformEntry);
            ViewPlatformRetained viewPlatformRetained = this.intersectVPCenter(wakeupOnViewPlatformEntry.transformedRegion);
            if (viewPlatformRetained != null) {
                if (n2 >= 0) continue;
                this.boundsEntryList.add(wakeupOnViewPlatformEntry);
                wakeupOnViewPlatformEntry.triggeredVP = viewPlatformRetained;
                wakeupOnViewPlatformEntry.setTriggered();
                continue;
            }
            if (n2 < 0) continue;
            this.boundsEntryList.remove(n2);
        }
    }

    void updateVPExitTransformRegion(BehaviorRetained behaviorRetained) {
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArray = (WakeupOnViewPlatformExit[])this.wakeupOnViewPlatformExit.toArray(false);
        for (int i2 = this.wakeupOnViewPlatformExit.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformExit wakeupOnViewPlatformExit = wakeupOnViewPlatformExitArray[i2];
            if (wakeupOnViewPlatformExit.behav != behaviorRetained) continue;
            wakeupOnViewPlatformExit.updateTransformRegion(behaviorRetained);
            wakeupOnViewPlatformExit = wakeupOnViewPlatformExitArray[i2];
            int n2 = this.boundsExitList.indexOf(wakeupOnViewPlatformExit);
            ViewPlatformRetained viewPlatformRetained = this.intersectVPCenter(wakeupOnViewPlatformExit.transformedRegion);
            if (viewPlatformRetained != null) {
                if (n2 >= 0) continue;
                wakeupOnViewPlatformExit.triggeredVP = viewPlatformRetained;
                this.boundsExitList.add(wakeupOnViewPlatformExit);
                continue;
            }
            if (n2 < 0) continue;
            this.boundsExitList.remove(n2);
            wakeupOnViewPlatformExit.setTriggered();
        }
    }

    void reEvaluatePhysicalEnvironments() {
        ArrayList arrayList = this.universe.viewPlatforms;
        this.physicalEnvironments.clear();
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            View[] viewArray = ((ViewPlatformRetained)arrayList.get(i2)).getViewList();
            for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                View view = viewArray[i3];
                if (!view.active || this.physicalEnvironments.contains(view.physicalEnvironment)) continue;
                this.physicalEnvironments.add(view.physicalEnvironment);
            }
        }
    }

    void checkSensorEntryExit() {
        Sensor sensor;
        int n2;
        int n3;
        WakeupOnSensorEntry[] wakeupOnSensorEntryArray = (WakeupOnSensorEntry[])this.wakeupOnSensorEntry.toArray();
        for (n3 = this.wakeupOnSensorEntry.arraySize() - 1; n3 >= 0; --n3) {
            WakeupOnSensorEntry wakeupOnSensorEntry = wakeupOnSensorEntryArray[n3];
            n2 = this.currentSensorEntryList.indexOf(wakeupOnSensorEntry);
            wakeupOnSensorEntry.updateTransformRegion();
            sensor = this.sensorIntersect(wakeupOnSensorEntry.transformedRegion);
            if (sensor != null) {
                if (n2 >= 0) continue;
                this.currentSensorEntryList.add(wakeupOnSensorEntry);
                wakeupOnSensorEntry.setTarget(sensor);
                wakeupOnSensorEntry.setTriggered();
                continue;
            }
            if (n2 < 0) continue;
            this.currentSensorEntryList.remove(n2);
        }
        WakeupOnSensorExit[] wakeupOnSensorExitArray = (WakeupOnSensorExit[])this.wakeupOnSensorExit.toArray();
        for (n3 = this.wakeupOnSensorExit.arraySize() - 1; n3 >= 0; --n3) {
            WakeupOnSensorExit wakeupOnSensorExit = wakeupOnSensorExitArray[n3];
            n2 = this.currentSensorExitList.indexOf(wakeupOnSensorExit);
            wakeupOnSensorExit.updateTransformRegion();
            sensor = this.sensorIntersect(wakeupOnSensorExit.transformedRegion);
            if (sensor != null) {
                if (n2 >= 0) continue;
                this.currentSensorExitList.add(wakeupOnSensorExit);
                wakeupOnSensorExit.setTarget(sensor);
                continue;
            }
            if (n2 < 0) continue;
            this.currentSensorExitList.remove(n2);
            wakeupOnSensorExit.setTriggered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Sensor sensorIntersect(Bounds bounds) {
        if (bounds == null) {
            return null;
        }
        PhysicalEnvironment[] physicalEnvironmentArray = (PhysicalEnvironment[])this.physicalEnvironments.toArray(false);
        int n2 = this.physicalEnvironments.arraySize() - 1;
        while (n2 >= 0) {
            Sensor[] sensorArray;
            if (physicalEnvironmentArray[n2].activeViewRef > 0 && (sensorArray = physicalEnvironmentArray[n2].getSensorList()) != null) {
                for (int i2 = physicalEnvironmentArray[n2].users.size() - 1; i2 >= 0; --i2) {
                    View view = (View)physicalEnvironmentArray[n2].users.get(i2);
                    Sensor[] sensorArray2 = sensorArray;
                    // MONITORENTER : sensorArray
                    for (int i3 = sensorArray.length - 1; i3 >= 0; --i3) {
                        Sensor sensor = sensorArray[i3];
                        if (sensor == null) continue;
                        view.getSensorToVworld(sensor, this.sensorTransform);
                        this.sensorTransform.get(this.sensorLoc);
                        this.ptSensorLoc.set(this.sensorLoc);
                        if (!bounds.intersect(this.ptSensorLoc)) continue;
                        // MONITOREXIT : sensorArray2
                        return sensor;
                    }
                    // MONITOREXIT : sensorArray2
                }
            }
            --n2;
        }
        return null;
    }

    final boolean intersectVPRegion(Bounds bounds) {
        if (bounds == null) {
            return false;
        }
        ViewPlatformRetained[] viewPlatformRetainedArray = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i2 = this.viewPlatforms.arraySize() - 1; i2 >= 0; --i2) {
            ViewPlatformRetained viewPlatformRetained = viewPlatformRetainedArray[i2];
            if (!viewPlatformRetained.isActiveViewPlatform() || !viewPlatformRetained.schedSphere.intersect(bounds)) continue;
            return true;
        }
        return false;
    }

    final ViewPlatformRetained intersectVPCenter(Bounds bounds) {
        if (bounds == null) {
            return null;
        }
        ViewPlatformRetained[] viewPlatformRetainedArray = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i2 = this.viewPlatforms.arraySize() - 1; i2 >= 0; --i2) {
            ViewPlatformRetained viewPlatformRetained = viewPlatformRetainedArray[i2];
            if (!viewPlatformRetained.isActiveViewPlatform() || !bounds.intersect(viewPlatformRetained.center)) continue;
            return viewPlatformRetained;
        }
        return null;
    }

    void notifyDeactivationCondition(BehaviorRetained behaviorRetained) {
        WakeupOnDeactivation[] wakeupOnDeactivationArray = (WakeupOnDeactivation[])this.wakeupOnDeactivation.toArray(false);
        for (int i2 = this.wakeupOnDeactivation.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnDeactivation wakeupOnDeactivation = wakeupOnDeactivationArray[i2];
            if (wakeupOnDeactivation.behav != behaviorRetained) continue;
            wakeupOnDeactivation.setTriggered();
        }
    }

    void notifyActivationCondition(BehaviorRetained behaviorRetained) {
        WakeupOnActivation[] wakeupOnActivationArray = (WakeupOnActivation[])this.wakeupOnActivation.toArray(false);
        for (int i2 = this.wakeupOnActivation.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnActivation wakeupOnActivation = wakeupOnActivationArray[i2];
            if (wakeupOnActivation.behav != behaviorRetained) continue;
            wakeupOnActivation.setTriggered();
        }
    }

    void processSwitchChanged(J3dMessage j3dMessage) {
        Object object;
        int n2;
        Object[] objectArray;
        int n3;
        Object[] objectArray2;
        int n4;
        UpdateTargets updateTargets = (UpdateTargets)j3dMessage.args[0];
        UnorderList unorderList = updateTargets.targetList[4];
        if (unorderList != null) {
            n4 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            for (n3 = 0; n3 < n4; ++n3) {
                objectArray = (Object[])objectArray2[n3];
                for (n2 = objectArray.length - 1; n2 >= 0; --n2) {
                    object = (ViewPlatformRetained)objectArray[n2];
                    ((ViewPlatformRetained)object).processSwitchChanged();
                }
            }
        }
        if ((unorderList = updateTargets.targetList[2]) != null) {
            n4 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            for (n3 = 0; n3 < n4; ++n3) {
                objectArray = (Object[])objectArray2[n3];
                for (n2 = objectArray.length - 1; n2 >= 0; --n2) {
                    object = (BehaviorRetained)objectArray[n2];
                    if (((BehaviorRetained)object).switchState.currentSwitchOn) {
                        this.addToScheduleList((BehaviorRetained)object);
                        continue;
                    }
                    this.removeFromScheduleList((BehaviorRetained)object);
                }
            }
        }
        if ((unorderList = updateTargets.targetList[5]) != null) {
            n4 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            object = (Object[])j3dMessage.args[1];
            for (int i2 = 0; i2 < n4; ++i2) {
                objectArray = (Object[])objectArray2[i2];
                Object[] objectArray3 = (Object[])object[i2];
                for (n2 = objectArray.length - 1; n2 >= 0; --n2) {
                    Object[] objectArray4 = (Object[])objectArray3[n2];
                    Object[] objectArray5 = new Object[1];
                    BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray[n2];
                    for (n3 = 0; n3 < objectArray4.length; ++n3) {
                        if (!(objectArray4[n3] instanceof BehaviorRetained)) continue;
                        objectArray5[0] = objectArray4[n3];
                        this.processTransformChanged(objectArray5);
                    }
                }
            }
        }
    }

    void processBoundingLeafChanged(Object[] objectArray, Bounds bounds) {
        for (int i2 = objectArray.length - 1; i2 >= 0; --i2) {
            Object object = objectArray[i2];
            if (!(object instanceof BehaviorRetained)) continue;
            BehaviorRetained behaviorRetained = (BehaviorRetained)object;
            behaviorRetained.updateTransformRegion(bounds);
            this.processBehaviorTransform(behaviorRetained);
        }
    }

    final void removeFromScheduleList(BehaviorRetained behaviorRetained) {
        if (behaviorRetained.active) {
            if ((behaviorRetained.wakeupMask & 2) != 0) {
                this.notifyDeactivationCondition(behaviorRetained);
            }
            this.scheduleList.remove(behaviorRetained);
            behaviorRetained.active = false;
            if (behaviorRetained.universe != this.universe) {
                J3dMessage j3dMessage = new J3dMessage();
                j3dMessage.threads = 256;
                j3dMessage.type = 60;
                j3dMessage.universe = behaviorRetained.universe;
                j3dMessage.args[0] = behaviorRetained;
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
    }

    final void addToScheduleList(BehaviorRetained behaviorRetained) {
        if (!behaviorRetained.inCallback && !behaviorRetained.active && behaviorRetained.enable && behaviorRetained.switchState.currentSwitchOn && behaviorRetained.wakeupCondition != null && ((Behavior)behaviorRetained.source).isLive() && this.intersectVPRegion(behaviorRetained.transformedRegion)) {
            this.scheduleList.add(behaviorRetained);
            behaviorRetained.active = true;
            if ((behaviorRetained.wakeupMask & 1) != 0) {
                this.notifyActivationCondition(behaviorRetained);
            }
            if (behaviorRetained.wakeupCondition != null) {
                behaviorRetained.wakeupCondition.conditionMet = false;
            }
        }
    }

    void resetConditionMet() {
        BehaviorStructure.resetConditionMet(this.wakeupOnAWTEvent);
        BehaviorStructure.resetConditionMet(this.wakeupOnActivation);
        BehaviorStructure.resetConditionMet(this.wakeupOnDeactivation);
        BehaviorStructure.resetConditionMet(this.wakeupOnBehaviorPost);
        BehaviorStructure.resetConditionMet(this.wakeupOnElapsedFrames);
        BehaviorStructure.resetConditionMet(this.wakeupOnViewPlatformEntry);
        BehaviorStructure.resetConditionMet(this.wakeupOnViewPlatformExit);
        BehaviorStructure.resetConditionMet(this.wakeupOnSensorEntry);
        BehaviorStructure.resetConditionMet(this.wakeupOnSensorExit);
    }

    static void resetConditionMet(WakeupIndexedList wakeupIndexedList) {
        WakeupCondition[] wakeupConditionArray = (WakeupCondition[])wakeupIndexedList.toArray(false);
        for (int i2 = wakeupIndexedList.size() - 1; i2 >= 0; --i2) {
            wakeupConditionArray[v0].conditionMet = false;
        }
    }

    void reEvaluateWakeupCount() {
        WakeupOnElapsedFrames[] wakeupOnElapsedFramesArray = (WakeupOnElapsedFrames[])this.wakeupOnElapsedFrames.toArray(true);
        int n2 = this.wakeupOnElapsedFrames.arraySize();
        int n3 = 0;
        this.activeWakeupOnFrameCount = 0;
        while (n3 < n2) {
            WakeupOnElapsedFrames wakeupOnElapsedFrames = wakeupOnElapsedFramesArray[n3++];
            if (wakeupOnElapsedFrames.passive || wakeupOnElapsedFrames.behav == null || !wakeupOnElapsedFrames.behav.enable) continue;
            ++this.activeWakeupOnFrameCount;
        }
        this.activeWakeupOnSensorCount = 0;
        WakeupOnSensorEntry[] wakeupOnSensorEntryArray = (WakeupOnSensorEntry[])this.wakeupOnSensorEntry.toArray();
        for (n3 = this.wakeupOnSensorEntry.arraySize() - 1; n3 >= 0; --n3) {
            WakeupOnSensorEntry wakeupOnSensorEntry = wakeupOnSensorEntryArray[n3];
            if (wakeupOnSensorEntry.behav == null || !wakeupOnSensorEntry.behav.enable) continue;
            ++this.activeWakeupOnSensorCount;
        }
        WakeupOnSensorExit[] wakeupOnSensorExitArray = (WakeupOnSensorExit[])this.wakeupOnSensorExit.toArray();
        for (n3 = this.wakeupOnSensorExit.arraySize() - 1; n3 >= 0; --n3) {
            WakeupOnSensorExit wakeupOnSensorExit = wakeupOnSensorExitArray[n3];
            if (wakeupOnSensorExit.behav == null || !wakeupOnSensorExit.behav.enable) continue;
            ++this.activeWakeupOnSensorCount;
        }
    }

    void cleanup() {
        this.behaviors.clear();
        this.viewPlatforms.clear();
        this.scheduleList.clear();
        this.boundsEntryList.clear();
        this.boundsExitList.clear();
        this.currentSensorEntryList.clear();
        this.currentSensorExitList.clear();
        this.wakeupOnAWTEvent.clear();
        this.wakeupOnActivation.clear();
        this.wakeupOnDeactivation.clear();
        this.wakeupOnBehaviorPost.clear();
        this.wakeupOnElapsedFrames.clear();
        this.wakeupOnViewPlatformEntry.clear();
        this.wakeupOnViewPlatformExit.clear();
        this.wakeupOnSensorEntry.clear();
        this.wakeupOnSensorExit.clear();
    }
}

