/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.NnuId;
import javax.media.j3d.NnuIdManager;

class CachedTargets {
    static String[] typeString = new String[]{"GEO_TARGETS", "ENV_TARGETS", "BEH_TARGETS", "SND_TARGETS", "VPF_TARGETS", "BLN_TARGETS", "GRP_TARGETS"};
    static int[] updateTargetThreads = new int[]{8384, 4224, 256, 514, 898, 4992, 8256};
    NnuId[][] targetArr = new NnuId[7][];

    CachedTargets() {
    }

    int computeTargetThreads() {
        int n2 = 0;
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.targetArr[i2] == null) continue;
            n2 |= updateTargetThreads[i2];
        }
        return n2;
    }

    void copy(CachedTargets cachedTargets) {
        for (int i2 = 0; i2 < 7; ++i2) {
            this.targetArr[i2] = cachedTargets.targetArr[i2];
        }
    }

    void replace(NnuId nnuId, NnuId nnuId2, int n2) {
        NnuId[] nnuIdArray = new NnuId[this.targetArr[n2].length];
        System.arraycopy(this.targetArr[n2], 0, nnuIdArray, 0, this.targetArr[n2].length);
        this.targetArr[n2] = nnuIdArray;
        NnuIdManager.replace(nnuId, nnuId2, this.targetArr[n2]);
    }

    void dump() {
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.targetArr[i2] == null) continue;
            System.err.println("  " + typeString[i2]);
            for (int i3 = 0; i3 < this.targetArr[i2].length; ++i3) {
                System.err.println("  " + this.targetArr[i2][i3]);
            }
        }
    }
}

