/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ClipRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;

public class Clip
extends Leaf {
    public static final int ALLOW_APPLICATION_BOUNDS_READ = 12;
    public static final int ALLOW_APPLICATION_BOUNDS_WRITE = 13;
    public static final int ALLOW_BACK_DISTANCE_READ = 14;
    public static final int ALLOW_BACK_DISTANCE_WRITE = 15;
    private static final int[] readCapabilities = new int[]{12, 14};

    public Clip() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Clip(double d2) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((ClipRetained)this.retained).initBackDistance(d2);
    }

    public void setBackDistance(double d2) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Clip0"));
        }
        if (this.isLive()) {
            ((ClipRetained)this.retained).setBackDistance(d2);
        } else {
            ((ClipRetained)this.retained).initBackDistance(d2);
        }
    }

    public double getBackDistance() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Clip1"));
        }
        return ((ClipRetained)this.retained).getBackDistance();
    }

    public void setApplicationBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Clip2"));
        }
        if (this.isLive()) {
            ((ClipRetained)this.retained).setApplicationBounds(bounds);
        } else {
            ((ClipRetained)this.retained).initApplicationBounds(bounds);
        }
    }

    public Bounds getApplicationBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Clip3"));
        }
        return ((ClipRetained)this.retained).getApplicationBounds();
    }

    public void setApplicationBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Clip2"));
        }
        if (this.isLive()) {
            ((ClipRetained)this.retained).setApplicationBoundingLeaf(boundingLeaf);
        } else {
            ((ClipRetained)this.retained).initApplicationBoundingLeaf(boundingLeaf);
        }
    }

    public BoundingLeaf getApplicationBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Clip3"));
        }
        return ((ClipRetained)this.retained).getApplicationBoundingLeaf();
    }

    void createRetained() {
        this.retained = new ClipRetained();
        this.retained.setSource(this);
    }

    public Node cloneNode(boolean bl) {
        Clip clip = new Clip();
        clip.duplicateNode(this, bl);
        return clip;
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        ClipRetained clipRetained = (ClipRetained)this.retained;
        BoundingLeaf boundingLeaf = clipRetained.getApplicationBoundingLeaf();
        if (boundingLeaf != null) {
            SceneGraphObject sceneGraphObject = nodeReferenceTable.getNewObjectReference(boundingLeaf);
            clipRetained.initApplicationBoundingLeaf((BoundingLeaf)sceneGraphObject);
        }
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        ClipRetained clipRetained = (ClipRetained)node.retained;
        ClipRetained clipRetained2 = (ClipRetained)this.retained;
        clipRetained2.initBackDistance(clipRetained.getBackDistance());
        clipRetained2.initApplicationBounds(clipRetained.getApplicationBounds());
        clipRetained2.initApplicationBoundingLeaf(clipRetained.getApplicationBoundingLeaf());
    }
}

