/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Context;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.Pipeline;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;

class ExponentialFogRetained
extends FogRetained {
    private float density = 1.0f;
    private float densityInEc;
    static final int DENSITY_CHANGED = 64;

    ExponentialFogRetained() {
        this.nodeType = 4;
    }

    void initDensity(float f2) {
        this.density = f2;
    }

    void setDensity(float f2) {
        this.density = f2;
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 22;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(64);
        j3dMessage.args[2] = new Float(f2);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    float getDensity() {
        return this.density;
    }

    void setLive(SetLiveState setLiveState) {
        super.setLive(setLiveState);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 4096;
        j3dMessage.universe = this.universe;
        j3dMessage.type = 22;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(16);
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < this.scopes.size(); ++i2) {
            GroupRetained groupRetained = (GroupRetained)this.scopes.get(i2);
            this.tempKey.reset();
            groupRetained.addAllNodesForScopedFog(this.mirrorFog, arrayList, this.tempKey);
        }
        Object[] objectArray = new Object[]{this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE, arrayList};
        j3dMessage.args[2] = objectArray;
        Color3f color3f = new Color3f(this.color);
        j3dMessage.args[3] = color3f;
        Object[] objectArray2 = new Object[]{this.boundingLeaf, this.regionOfInfluence != null ? this.regionOfInfluence.clone() : null, this.inBackgroundGroup ? Boolean.TRUE : Boolean.FALSE, this.geometryBackground, new Float(this.density)};
        j3dMessage.args[4] = objectArray2;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void update(Context context, double d2) {
        this.validateDistancesInEc(d2);
        Pipeline.getPipeline().updateExponentialFog(context, this.color.x, this.color.y, this.color.z, this.densityInEc);
    }

    void updateMirrorObject(Object[] objectArray) {
        int n2 = (Integer)objectArray[1];
        if ((n2 & 0x40) != 0) {
            ((ExponentialFogRetained)this.mirrorFog).density = ((Float)objectArray[2]).floatValue();
        }
        if ((n2 & 0x10) != 0) {
            ((ExponentialFogRetained)this.mirrorFog).density = ((Float)((Object[])objectArray[4])[4]).floatValue();
        }
        ((ExponentialFogRetained)this.mirrorFog).setLocalToVworldScale(this.getLastLocalToVworld().getDistanceScale());
        super.updateMirrorObject(objectArray);
    }

    protected Object clone() {
        ExponentialFogRetained exponentialFogRetained = (ExponentialFogRetained)super.clone();
        exponentialFogRetained.initDensity(this.getDensity());
        return exponentialFogRetained;
    }

    protected void validateDistancesInEc(double d2) {
        double d3 = this.getLocalToVworldScale() * d2;
        this.densityInEc = (float)((double)this.density / d3);
    }
}

