/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.FastVector;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleArrayRetained;
import javax.media.j3d.UnorderList;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class Font3D
extends NodeComponent {
    Font font;
    double tessellationTolerance;
    FontExtrusion fontExtrusion;
    FontRenderContext frc;
    static final float EPS = 1.0E-6f;
    Hashtable geomHash = new Hashtable(20);

    public Font3D(Font font, FontExtrusion fontExtrusion) {
        this(font, 0.01, fontExtrusion);
    }

    public Font3D(Font font, double d2, FontExtrusion fontExtrusion) {
        this.font = font;
        this.tessellationTolerance = d2;
        this.fontExtrusion = fontExtrusion;
        this.frc = new FontRenderContext(new AffineTransform(), true, true);
    }

    public Font getFont() {
        return this.font;
    }

    public double getTessellationTolerance() {
        return this.tessellationTolerance;
    }

    public void getFontExtrusion(FontExtrusion fontExtrusion) {
        fontExtrusion = this.fontExtrusion;
    }

    public void getBoundingBox(int n2, BoundingBox boundingBox) {
        int[] nArray = new int[]{n2};
        GlyphVector glyphVector = this.font.createGlyphVector(this.frc, nArray);
        Rectangle2D.Float float_ = (Rectangle2D.Float)glyphVector.getGlyphMetrics(0).getBounds2D();
        Point3d point3d = new Point3d(float_.x, float_.y, 0.0);
        Point3d point3d2 = this.fontExtrusion != null ? new Point3d(float_.x + float_.width, float_.y + float_.height, this.fontExtrusion.length) : new Point3d(float_.x + float_.width, float_.y + float_.height, 0.0);
        boundingBox.setLower(point3d);
        boundingBox.setUpper(point3d2);
    }

    public GeometryArray getGlyphGeometry(char c2) {
        char[] cArray = new char[]{c2};
        GlyphVector glyphVector = this.font.createGlyphVector(this.frc, cArray);
        GeometryArrayRetained geometryArrayRetained = this.triangulateGlyphs(glyphVector, cArray[0]);
        assert (geometryArrayRetained instanceof TriangleArrayRetained) : "Font3D: GeometryArray is not an instance of TrangleArray";
        assert (geometryArrayRetained.getVertexFormat() == 3) : "Font3D: Illegal GeometryArray format -- only coordinates and normals expected";
        TriangleArray triangleArray = new TriangleArray(geometryArrayRetained.getVertexCount(), geometryArrayRetained.getVertexFormat());
        float[] fArray = new float[3];
        int n2 = triangleArray.getVertexCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            geometryArrayRetained.getCoordinate(i2, fArray);
            triangleArray.setCoordinate(i2, fArray);
            geometryArrayRetained.getNormal(i2, fArray);
            triangleArray.setNormal(i2, fArray);
        }
        return triangleArray;
    }

    GeometryArrayRetained triangulateGlyphs(GlyphVector glyphVector, char c2) {
        GeometryArrayRetained geometryArrayRetained;
        block84: {
            GeometryArray geometryArray;
            int n2;
            int n3;
            int n4;
            Point3f point3f;
            Character c3 = new Character(c2);
            geometryArrayRetained = (GeometryArrayRetained)this.geomHash.get(c3);
            if (geometryArrayRetained != null) break block84;
            Rectangle2D rectangle2D = glyphVector.getVisualBounds();
            AffineTransform affineTransform = new AffineTransform();
            double d2 = rectangle2D.getX() + 0.5 * rectangle2D.getWidth();
            double d3 = rectangle2D.getY() + 0.5 * rectangle2D.getHeight();
            affineTransform.setToTranslation(-d2, -d3);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(d2, -d3);
            Shape shape = glyphVector.getOutline();
            PathIterator pathIterator = shape.getPathIterator(affineTransform, this.tessellationTolerance);
            int n5 = -1;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            UnorderList unorderList = new UnorderList(100, Point3f.class);
            float[] fArray = new float[6];
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = Float.MAX_VALUE;
            float f5 = Float.MAX_VALUE;
            GeometryInfo geometryInfo = null;
            NormalGenerator normalGenerator = new NormalGenerator();
            FastVector fastVector = new FastVector(10);
            float f6 = -3.4028235E38f;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            boolean bl = false;
            while (!pathIterator.isDone()) {
                point3f = new Point3f();
                n5 = pathIterator.currentSegment(fArray);
                if (n5 == 4) {
                    if (n8 > 0) {
                        if (bl) {
                            n10 = n12;
                            n11 = n7 - 1;
                        }
                        fastVector.addElement(n8);
                        n8 = 0;
                        ++n6;
                    }
                } else if (n5 == 0) {
                    point3f.x = fArray[0];
                    point3f.y = fArray[1];
                    f2 = point3f.x;
                    f3 = point3f.y;
                    if (f2 == f4 && f3 == f5) {
                        pathIterator.next();
                        continue;
                    }
                    bl = false;
                    unorderList.add(point3f);
                    f4 = f2;
                    f5 = f3;
                    if (n8 > 0) {
                        fastVector.addElement(n8);
                        n8 = 0;
                        ++n6;
                    }
                    ++n8;
                    n12 = ++n7;
                } else if (n5 == 1) {
                    point3f.x = fArray[0];
                    point3f.y = fArray[1];
                    if (point3f.x == f2 && point3f.y == f3) {
                        pathIterator.next();
                        continue;
                    }
                    if (point3f.y > f6) {
                        f6 = point3f.y;
                        n9 = n7;
                        bl = true;
                    }
                    f2 = point3f.x;
                    f3 = point3f.y;
                    unorderList.add(point3f);
                    ++n8;
                    ++n7;
                }
                pathIterator.next();
            }
            if (n7 == 0) {
                return null;
            }
            point3f = new Point3f();
            Point3f point3f2 = new Point3f();
            Point3f point3f3 = new Point3f();
            boolean bl2 = true;
            Point3f[] point3fArray = (Point3f[])unorderList.toArray(false);
            if (n11 - n10 > 0) {
                if (n9 == n10) {
                    point3f.set(point3fArray[n11]);
                } else {
                    point3f.set(point3fArray[n9 - 1]);
                }
                point3f2.set(point3fArray[n9]);
                if (n9 == n11) {
                    point3f3.set(point3fArray[n10]);
                } else {
                    point3f3.set(point3fArray[n9 + 1]);
                }
                bl2 = point3f3.x != point3f2.x ? (point3f.x != point3f2.x ? (Math.abs((point3f2.y - point3f.y) / (point3f2.x - point3f.x)) > Math.abs((point3f3.y - point3f2.y) / (point3f3.x - point3f2.x)) ? point3f3.x > point3f2.x : point3f2.x > point3f.x) : point3f3.x > point3f2.x) : point3f2.x > point3f.x;
            }
            int n13 = 0;
            IslandsNode islandsNode = new IslandsNode(-1, -1);
            int[] nArray = fastVector.getData();
            for (n4 = 0; n4 < fastVector.getSize(); ++n4) {
                n11 = n13 + nArray[n4];
                islandsNode.insert(new IslandsNode(n13, n11), point3fArray);
                n13 = n11;
            }
            unorderList = null;
            fastVector = null;
            nArray = null;
            UnorderList unorderList2 = new UnorderList(10, IslandsNode.class);
            islandsNode.collectOddLevelNode(unorderList2, 0);
            IslandsNode[] islandsNodeArray = (IslandsNode[])unorderList2.toArray(false);
            int[][] nArrayArray = new int[unorderList2.arraySize()][];
            Point3f[][] point3fArrayArray = new Point3f[nArrayArray.length][];
            for (n4 = 0; n4 < nArrayArray.length; ++n4) {
                IslandsNode islandsNode2 = islandsNodeArray[n4];
                int n14 = islandsNode2.numChild();
                nArrayArray[n4] = new int[n14 + 1];
                nArrayArray[n4][0] = islandsNode2.numVertices();
                int n15 = 0;
                n15 += nArrayArray[n4][0];
                for (n3 = 0; n3 < n14; ++n3) {
                    nArrayArray[n4][n3 + 1] = islandsNode2.getChild(n3).numVertices();
                    n15 += nArrayArray[n4][n3 + 1];
                }
                point3fArrayArray[n4] = new Point3f[n15];
                n13 = 0;
                for (n2 = islandsNode2.startIdx; n2 < islandsNode2.endIdx; ++n2) {
                    point3fArrayArray[n4][n13++] = point3fArray[n2];
                }
                for (n3 = 0; n3 < n14; ++n3) {
                    n11 = islandsNode2.getChild((int)n3).endIdx;
                    for (n2 = islandsNode2.getChild((int)n3).startIdx; n2 < n11; ++n2) {
                        point3fArrayArray[n4][n13++] = point3fArray[n2];
                    }
                }
            }
            islandsNode = null;
            unorderList2 = null;
            point3fArray = null;
            nArray = new int[1];
            int n16 = 0;
            int n17 = 0;
            ArrayList<GeometryArray> arrayList = new ArrayList<GeometryArray>();
            Point3f point3f4 = new Point3f();
            Point3f point3f5 = new Point3f();
            Point3f point3f6 = new Point3f();
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            n7 = 0;
            for (n4 = 0; n4 < nArrayArray.length; ++n4) {
                nArray[0] = nArrayArray[n4].length;
                n7 += point3fArrayArray[n4].length;
                geometryInfo = new GeometryInfo(5);
                geometryInfo.setCoordinates(point3fArrayArray[n4]);
                geometryInfo.setStripCounts(nArrayArray[n4]);
                geometryInfo.setContourCounts(nArray);
                normalGenerator.generateNormals(geometryInfo);
                geometryArray = geometryInfo.getGeometryArray(false, false, false);
                n17 += geometryArray.getVertexCount();
                arrayList.add(geometryArray);
            }
            int n18 = this.fontExtrusion == null ? n17 : (this.fontExtrusion.shape == null ? n17 * 2 + n7 * 6 : n17 * 2 + n7 * 6 * (this.fontExtrusion.pnts.length - 1));
            geometryArray = new TriangleArray(n18, 3);
            boolean[] blArray = new boolean[nArrayArray.length];
            Vector3f vector3f3 = new Vector3f();
            for (n3 = 0; n3 < nArrayArray.length; ++n3) {
                GeometryArray geometryArray2 = (GeometryArray)arrayList.get(n3);
                n17 = geometryArray2.getVertexCount();
                boolean bl3 = false;
                n4 = 0;
                while (n4 < n17) {
                    block86: {
                        block85: {
                            block88: {
                                block87: {
                                    geometryArray2.getCoordinate(n4, point3f);
                                    geometryArray2.getNormal(n4, vector3f);
                                    geometryArray2.getCoordinate(n4 + 1, point3f2);
                                    geometryArray2.getCoordinate(n4 + 2, point3f3);
                                    if (bl3) break block85;
                                    if (!Font3D.getNormal(point3f, point3f2, point3f3, vector3f2)) break block86;
                                    if (!(vector3f2.z >= 1.0E-6f)) break block87;
                                    blArray[n3] = false;
                                    break block88;
                                }
                                if (!(vector3f2.z <= -1.0E-6f)) break block86;
                                blArray[n3] = true;
                            }
                            bl3 = true;
                        }
                        if (blArray[n3]) {
                            point3f4.x = point3f2.x;
                            point3f4.y = point3f2.y;
                            point3f4.z = point3f2.z;
                            point3f2.x = point3f3.x;
                            point3f2.y = point3f3.y;
                            point3f2.z = point3f3.z;
                            point3f3.x = point3f4.x;
                            point3f3.y = point3f4.y;
                            point3f3.z = point3f4.z;
                            vector3f.x = -vector3f.x;
                            vector3f.y = -vector3f.y;
                            vector3f.z = -vector3f.z;
                        }
                        if (this.fontExtrusion != null) {
                            vector3f2.x = -vector3f.x;
                            vector3f2.y = -vector3f.y;
                            vector3f2.z = -vector3f.z;
                            geometryArray.setCoordinate(n16, point3f);
                            geometryArray.setNormal(n16, vector3f2);
                            geometryArray.setCoordinate(n16 + 1, point3f3);
                            geometryArray.setNormal(n16 + 1, vector3f2);
                            geometryArray.setCoordinate(n16 + 2, point3f2);
                            geometryArray.setNormal(n16 + 2, vector3f2);
                            point3f4.x = point3f.x;
                            point3f4.y = point3f.y;
                            point3f4.z = point3f.z + this.fontExtrusion.length;
                            point3f5.x = point3f2.x;
                            point3f5.y = point3f2.y;
                            point3f5.z = point3f2.z + this.fontExtrusion.length;
                            point3f6.x = point3f3.x;
                            point3f6.y = point3f3.y;
                            point3f6.z = point3f3.z + this.fontExtrusion.length;
                            geometryArray.setCoordinate(n16 + n17, point3f4);
                            geometryArray.setNormal(n16 + n17, vector3f);
                            geometryArray.setCoordinate(n16 + 1 + n17, point3f5);
                            geometryArray.setNormal(n16 + 1 + n17, vector3f);
                            geometryArray.setCoordinate(n16 + 2 + n17, point3f6);
                            geometryArray.setNormal(n16 + 2 + n17, vector3f);
                        } else {
                            geometryArray.setCoordinate(n16, point3f);
                            geometryArray.setNormal(n16, vector3f);
                            geometryArray.setCoordinate(n16 + 1, point3f2);
                            geometryArray.setNormal(n16 + 1, vector3f);
                            geometryArray.setCoordinate(n16 + 2, point3f3);
                            geometryArray.setNormal(n16 + 2, vector3f);
                        }
                    }
                    n4 += 3;
                    n16 += 3;
                }
                if (this.fontExtrusion == null) continue;
                n16 += n17;
            }
            if (this.fontExtrusion != null) {
                if (this.fontExtrusion.shape == null) {
                    float f7 = (float)Math.cos(0.767944870877505);
                    Vector3f vector3f4 = null;
                    Vector3f vector3f5 = null;
                    Vector3f vector3f6 = new Vector3f();
                    Vector3f vector3f7 = new Vector3f();
                    Vector3f vector3f8 = new Vector3f();
                    Vector3f vector3f9 = new Vector3f();
                    Vector3f vector3f10 = new Vector3f();
                    Vector3f vector3f11 = new Vector3f();
                    Vector3f vector3f12 = new Vector3f();
                    Vector3f vector3f13 = new Vector3f();
                    for (n4 = 0; n4 < nArrayArray.length; ++n4) {
                        n2 = 0;
                        n8 = 0;
                        for (n3 = 0; n3 < nArrayArray[n4].length; ++n3) {
                            point3f.x = point3fArrayArray[n4][(n8 += nArrayArray[n4][n3]) - 1].x;
                            point3f.y = point3fArrayArray[n4][n8 - 1].y;
                            point3f.z = 0.0f;
                            point3f4.x = point3f.x;
                            point3f4.y = point3f.y;
                            point3f4.z = point3f.z + this.fontExtrusion.length;
                            point3f2.z = 0.0f;
                            point3f5.z = point3f2.z + this.fontExtrusion.length;
                            for (int i2 = 0; i2 < n8; ++i2) {
                                point3f2.x = point3fArrayArray[n4][i2].x;
                                point3f2.y = point3fArrayArray[n4][i2].y;
                                point3f5.x = point3f2.x;
                                point3f5.y = point3f2.y;
                                if (!Font3D.getNormal(point3f, point3f4, point3f2, vector3f)) continue;
                                if (!bl2) {
                                    vector3f.negate();
                                }
                                vector3f3.set(vector3f);
                                break;
                            }
                            while (n2 < n8) {
                                boolean bl4;
                                float f8;
                                point3f2.x = point3fArrayArray[n4][n2].x;
                                point3f2.y = point3fArrayArray[n4][n2].y;
                                point3f2.z = 0.0f;
                                point3f5.x = point3f2.x;
                                point3f5.y = point3f2.y;
                                point3f5.z = point3f2.z + this.fontExtrusion.length;
                                if (!Font3D.getNormal(point3f, point3f4, point3f2, vector3f)) {
                                    vector3f.set(vector3f3);
                                } else {
                                    if (!bl2) {
                                        vector3f.negate();
                                    }
                                    vector3f3.set(vector3f);
                                }
                                if (!Font3D.getNormal(point3f2, point3f4, point3f5, vector3f2)) {
                                    vector3f2.set(vector3f3);
                                } else {
                                    if (!bl2) {
                                        vector3f2.negate();
                                    }
                                    vector3f3.set(vector3f2);
                                }
                                if (vector3f4 != null) {
                                    f8 = vector3f.dot(vector3f5);
                                    boolean bl5 = bl4 = f8 > f7;
                                    if (bl4) {
                                        vector3f8.x = vector3f4.x + vector3f5.x + vector3f.x;
                                        vector3f8.y = vector3f4.y + vector3f5.y + vector3f.y;
                                        vector3f8.z = vector3f4.z + vector3f5.z + vector3f.z;
                                        Font3D.normalize(vector3f8);
                                        vector3f11.x = vector3f5.x + vector3f.x + vector3f2.x;
                                        vector3f11.y = vector3f5.y + vector3f.y + vector3f2.y;
                                        vector3f11.z = vector3f5.z + vector3f.z + vector3f2.z;
                                        Font3D.normalize(vector3f11);
                                    } else {
                                        vector3f8.x = vector3f.x;
                                        vector3f8.y = vector3f.y;
                                        vector3f8.z = vector3f.z;
                                        vector3f11.x = vector3f.x + vector3f2.x;
                                        vector3f11.y = vector3f.y + vector3f2.y;
                                        vector3f11.z = vector3f.z + vector3f2.z;
                                        Font3D.normalize(vector3f11);
                                    }
                                } else {
                                    vector3f4 = new Vector3f();
                                    vector3f5 = new Vector3f();
                                    vector3f8.x = vector3f.x;
                                    vector3f8.y = vector3f.y;
                                    vector3f8.z = vector3f.z;
                                    vector3f11.x = vector3f.x + vector3f2.x;
                                    vector3f11.y = vector3f.y + vector3f2.y;
                                    vector3f11.z = vector3f.z + vector3f2.z;
                                    Font3D.normalize(vector3f11);
                                }
                                if (n2 + 1 < n8) {
                                    point3f3.x = point3fArrayArray[n4][n2 + 1].x;
                                    point3f3.y = point3fArrayArray[n4][n2 + 1].y;
                                    point3f3.z = 0.0f;
                                    point3f6.x = point3f3.x;
                                    point3f6.y = point3f3.y;
                                    point3f6.z = point3f3.z + this.fontExtrusion.length;
                                    if (!Font3D.getNormal(point3f2, point3f5, point3f3, vector3f6)) {
                                        vector3f6.set(vector3f3);
                                    } else {
                                        if (!bl2) {
                                            vector3f6.negate();
                                        }
                                        vector3f3.set(vector3f6);
                                    }
                                    if (!Font3D.getNormal(point3f3, point3f5, point3f6, vector3f7)) {
                                        vector3f7.set(vector3f3);
                                    } else {
                                        if (!bl2) {
                                            vector3f7.negate();
                                        }
                                        vector3f3.set(vector3f7);
                                    }
                                    f8 = vector3f2.dot(vector3f6);
                                    boolean bl6 = bl4 = f8 > f7;
                                    if (bl4) {
                                        vector3f9.x = vector3f.x + vector3f2.x + vector3f6.x;
                                        vector3f9.y = vector3f.y + vector3f2.y + vector3f6.y;
                                        vector3f9.z = vector3f.z + vector3f2.z + vector3f6.z;
                                        Font3D.normalize(vector3f9);
                                        vector3f12.x = vector3f2.x + vector3f6.x + vector3f7.x;
                                        vector3f12.y = vector3f2.y + vector3f6.y + vector3f7.y;
                                        vector3f12.z = vector3f2.z + vector3f6.z + vector3f7.z;
                                        Font3D.normalize(vector3f12);
                                    } else {
                                        vector3f9.x = vector3f.x + vector3f2.x;
                                        vector3f9.y = vector3f.y + vector3f2.y;
                                        vector3f9.z = vector3f.z + vector3f2.z;
                                        Font3D.normalize(vector3f9);
                                        vector3f12.x = vector3f2.x;
                                        vector3f12.y = vector3f2.y;
                                        vector3f12.z = vector3f2.z;
                                    }
                                } else {
                                    vector3f9.x = vector3f.x + vector3f2.x;
                                    vector3f9.y = vector3f.y + vector3f2.y;
                                    vector3f9.z = vector3f.z + vector3f2.z;
                                    Font3D.normalize(vector3f9);
                                    vector3f12.x = vector3f2.x;
                                    vector3f12.y = vector3f2.y;
                                    vector3f12.z = vector3f2.z;
                                }
                                if (bl2) {
                                    geometryArray.setCoordinate(n16, point3f);
                                    geometryArray.setNormal(n16, vector3f8);
                                    geometryArray.setCoordinate(++n16, point3f4);
                                    geometryArray.setNormal(n16, vector3f11);
                                    geometryArray.setCoordinate(++n16, point3f2);
                                    geometryArray.setNormal(n16, vector3f9);
                                    geometryArray.setCoordinate(++n16, point3f2);
                                    geometryArray.setNormal(n16, vector3f9);
                                    geometryArray.setCoordinate(++n16, point3f4);
                                    geometryArray.setNormal(n16, vector3f11);
                                    ++n16;
                                } else {
                                    geometryArray.setCoordinate(n16, point3f4);
                                    geometryArray.setNormal(n16, vector3f11);
                                    geometryArray.setCoordinate(++n16, point3f);
                                    geometryArray.setNormal(n16, vector3f8);
                                    geometryArray.setCoordinate(++n16, point3f2);
                                    geometryArray.setNormal(n16, vector3f9);
                                    geometryArray.setCoordinate(++n16, point3f4);
                                    geometryArray.setNormal(n16, vector3f11);
                                    geometryArray.setCoordinate(++n16, point3f2);
                                    geometryArray.setNormal(n16, vector3f9);
                                    ++n16;
                                }
                                geometryArray.setCoordinate(n16, point3f5);
                                geometryArray.setNormal(n16, vector3f12);
                                ++n16;
                                vector3f4.x = vector3f.x;
                                vector3f4.y = vector3f.y;
                                vector3f4.z = vector3f.z;
                                vector3f5.x = vector3f2.x;
                                vector3f5.y = vector3f2.y;
                                vector3f5.z = vector3f2.z;
                                point3f.x = point3f2.x;
                                point3f.y = point3f2.y;
                                point3f.z = point3f2.z;
                                point3f4.x = point3f5.x;
                                point3f4.y = point3f5.y;
                                point3f4.z = point3f5.z;
                                ++n2;
                            }
                            vector3f4 = null;
                            vector3f5 = null;
                        }
                    }
                } else {
                    int n19 = 0;
                    Point3f point3f7 = new Point3f();
                    Point3f point3f8 = new Point3f();
                    Point3f point3f9 = new Point3f();
                    Vector3f vector3f14 = new Vector3f();
                    Vector3f vector3f15 = new Vector3f();
                    Vector3f vector3f16 = new Vector3f();
                    Vector3f vector3f17 = new Vector3f();
                    Vector3f vector3f18 = new Vector3f();
                    Vector3f vector3f19 = new Vector3f();
                    boolean bl7 = false;
                    for (n4 = 0; n4 < nArrayArray.length; ++n4) {
                        n2 = 0;
                        n8 = 0;
                        n19 = 0;
                        for (n3 = 0; n3 < nArrayArray[n4].length; ++n3) {
                            int n20;
                            point3f.x = point3fArrayArray[n4][(n8 += nArrayArray[n4][n3]) - 1].x;
                            point3f.y = point3fArrayArray[n4][n8 - 1].y;
                            point3f.z = 0.0f;
                            point3f4.x = point3f.x;
                            point3f4.y = point3f.y;
                            point3f4.z = point3f.z + this.fontExtrusion.length;
                            point3f3.z = 0.0f;
                            for (n20 = n8 - 2; n20 >= 0; --n20) {
                                point3f3.x = point3fArrayArray[n4][n20].x;
                                point3f3.y = point3fArrayArray[n4][n20].y;
                                if (!Font3D.getNormal(point3f3, point3f4, point3f, vector3f15)) continue;
                                if (!bl2) {
                                    vector3f15.negate();
                                }
                                vector3f3.set(vector3f15);
                                break;
                            }
                            while (n2 < n8) {
                                point3f2.x = point3fArrayArray[n4][n2].x;
                                point3f2.y = point3fArrayArray[n4][n2].y;
                                point3f2.z = 0.0f;
                                point3f5.x = point3f2.x;
                                point3f5.y = point3f2.y;
                                point3f5.z = point3f2.z + this.fontExtrusion.length;
                                Font3D.getNormal(point3f, point3f4, point3f2, vector3f16);
                                point3f3.x = point3fArrayArray[n4][n2 + 1 == n8 ? n19 : n2 + 1].x;
                                point3f3.y = point3fArrayArray[n4][n2 + 1 == n8 ? n19 : n2 + 1].y;
                                point3f3.z = 0.0f;
                                if (!Font3D.getNormal(point3f3, point3f2, point3f5, vector3f17)) {
                                    vector3f17.set(vector3f3);
                                } else {
                                    if (!bl2) {
                                        vector3f17.negate();
                                    }
                                    vector3f3.set(vector3f17);
                                }
                                vector3f18.x = vector3f15.x + vector3f16.x;
                                vector3f18.y = vector3f15.y + vector3f16.y;
                                vector3f18.z = vector3f15.z + vector3f16.z;
                                Font3D.normalize(vector3f18);
                                vector3f19.x = vector3f17.x + vector3f16.x;
                                vector3f19.y = vector3f17.y + vector3f16.y;
                                vector3f19.z = vector3f17.z + vector3f16.z;
                                Font3D.normalize(vector3f19);
                                point3f9.x = point3f.x;
                                point3f9.y = point3f.y;
                                point3f9.z = point3f.z;
                                point3f7.x = point3f2.x;
                                point3f7.y = point3f2.y;
                                point3f7.z = point3f2.z;
                                point3f8.x = point3f5.x;
                                point3f8.y = point3f5.y;
                                point3f8.z = point3f5.z;
                                for (n20 = 1; n20 < this.fontExtrusion.pnts.length; ++n20) {
                                    point3f4.z = point3f5.z = this.fontExtrusion.pnts[n20].x;
                                    point3f4.x = point3f9.x + vector3f18.x * this.fontExtrusion.pnts[n20].y;
                                    point3f4.y = point3f9.y + vector3f18.y * this.fontExtrusion.pnts[n20].y;
                                    point3f5.x = point3f7.x + vector3f19.x * this.fontExtrusion.pnts[n20].y;
                                    point3f5.y = point3f7.y + vector3f19.y * this.fontExtrusion.pnts[n20].y;
                                    if (!Font3D.getNormal(point3f, point3f4, point3f2, vector3f)) {
                                        vector3f.set(vector3f3);
                                    } else {
                                        if (!bl2) {
                                            vector3f.negate();
                                        }
                                        vector3f3.set(vector3f);
                                    }
                                    if (bl2) {
                                        geometryArray.setCoordinate(n16, point3f);
                                        geometryArray.setNormal(n16, vector3f);
                                        geometryArray.setCoordinate(++n16, point3f4);
                                        geometryArray.setNormal(n16, vector3f);
                                        ++n16;
                                    } else {
                                        geometryArray.setCoordinate(n16, point3f4);
                                        geometryArray.setNormal(n16, vector3f);
                                        geometryArray.setCoordinate(++n16, point3f);
                                        geometryArray.setNormal(n16, vector3f);
                                        ++n16;
                                    }
                                    geometryArray.setCoordinate(n16, point3f2);
                                    geometryArray.setNormal(n16, vector3f);
                                    ++n16;
                                    if (!Font3D.getNormal(point3f2, point3f4, point3f5, vector3f)) {
                                        vector3f.set(vector3f3);
                                    } else {
                                        if (!bl2) {
                                            vector3f.negate();
                                        }
                                        vector3f3.set(vector3f);
                                    }
                                    if (bl2) {
                                        geometryArray.setCoordinate(n16, point3f2);
                                        geometryArray.setNormal(n16, vector3f);
                                        geometryArray.setCoordinate(++n16, point3f4);
                                        geometryArray.setNormal(n16, vector3f);
                                        ++n16;
                                    } else {
                                        geometryArray.setCoordinate(n16, point3f4);
                                        geometryArray.setNormal(n16, vector3f);
                                        geometryArray.setCoordinate(++n16, point3f2);
                                        geometryArray.setNormal(n16, vector3f);
                                        ++n16;
                                    }
                                    geometryArray.setCoordinate(n16, point3f5);
                                    geometryArray.setNormal(n16, vector3f);
                                    ++n16;
                                    point3f.x = point3f4.x;
                                    point3f.y = point3f4.y;
                                    point3f.z = point3f4.z;
                                    point3f2.x = point3f5.x;
                                    point3f2.y = point3f5.y;
                                    point3f2.z = point3f5.z;
                                }
                                point3f.x = point3f7.x;
                                point3f.y = point3f7.y;
                                point3f.z = point3f7.z;
                                point3f4.x = point3f8.x;
                                point3f4.y = point3f8.y;
                                point3f4.z = point3f8.z;
                                vector3f15.x = vector3f16.x;
                                vector3f15.y = vector3f16.y;
                                vector3f15.z = vector3f16.z;
                                ++n2;
                            }
                            n19 = n8;
                        }
                    }
                }
            }
            geometryArrayRetained = (GeometryArrayRetained)((TriangleArray)geometryArray).retained;
            this.geomHash.put(c3, geometryArrayRetained);
        }
        return geometryArrayRetained;
    }

    static boolean getNormal(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3f vector3f) {
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        vector3f2.sub(point3f2, point3f);
        vector3f3.sub(point3f2, point3f3);
        vector3f.cross(vector3f2, vector3f3);
        vector3f.negate();
        float f2 = vector3f.length();
        if (f2 > 0.0f) {
            f2 = 1.0f / f2;
            vector3f.x *= f2;
            vector3f.y *= f2;
            vector3f.z *= f2;
            return true;
        }
        return false;
    }

    static int check2Contours(int n2, int n3, int n4, int n5, Point3f[] point3fArray) {
        int n6;
        boolean bl = Font3D.pointInPolygon2D(point3fArray[n2].x, point3fArray[n2].y, n4, n5, point3fArray);
        for (n6 = n2 + 1; n6 < n3; ++n6) {
            if (Font3D.pointInPolygon2D(point3fArray[n6].x, point3fArray[n6].y, n4, n5, point3fArray) == bl) continue;
            return 1;
        }
        boolean bl2 = Font3D.pointInPolygon2D(point3fArray[n4].x, point3fArray[n4].y, n2, n3, point3fArray);
        for (n6 = n4 + 1; n6 < n5; ++n6) {
            if (Font3D.pointInPolygon2D(point3fArray[n6].x, point3fArray[n6].y, n2, n3, point3fArray) == bl2) continue;
            return 1;
        }
        if (!bl) {
            if (!bl2) {
                return 0;
            }
            return 3;
        }
        return 2;
    }

    static boolean pointInPolygon2D(float f2, float f3, int n2, int n3, Point3f[] point3fArray) {
        float f4;
        int n4;
        int n5 = 0;
        for (n4 = n2; n4 < n3 - 1; ++n4) {
            if (point3fArray[n4].y >= f3 && point3fArray[n4 + 1].y >= f3 || point3fArray[n4].y < f3 && point3fArray[n4 + 1].y < f3 || !(f2 < (f4 = point3fArray[n4].x + (point3fArray[n4].x - point3fArray[n4 + 1].x) * (f3 - point3fArray[n4].y) / (point3fArray[n4].y - point3fArray[n4 + 1].y)))) continue;
            ++n5;
        }
        if (!(point3fArray[n4].y >= f3 && point3fArray[n2].y >= f3 || point3fArray[n4].y < f3 && point3fArray[n2].y < f3 || !(f2 < (f4 = point3fArray[n4].x + (point3fArray[n4].x - point3fArray[n2].x) * (f3 - point3fArray[n4].y) / (point3fArray[n4].y - point3fArray[n2].y))))) {
            ++n5;
        }
        return n5 % 2 != 0;
    }

    static final boolean normalize(Vector3f vector3f) {
        float f2 = vector3f.length();
        if (f2 > 0.0f) {
            f2 = 1.0f / f2;
            vector3f.x *= f2;
            vector3f.y *= f2;
            vector3f.z *= f2;
            return true;
        }
        return false;
    }

    private static class IslandsNode {
        private ArrayList islandsList = null;
        int startIdx;
        int endIdx;

        IslandsNode(int n2, int n3) {
            this.startIdx = n2;
            this.endIdx = n3;
            this.islandsList = null;
        }

        void addChild(IslandsNode islandsNode) {
            if (this.islandsList == null) {
                this.islandsList = new ArrayList(5);
            }
            this.islandsList.add(islandsNode);
        }

        void removeChild(IslandsNode islandsNode) {
            this.islandsList.remove(this.islandsList.indexOf(islandsNode));
        }

        IslandsNode getChild(int n2) {
            return (IslandsNode)this.islandsList.get(n2);
        }

        int numChild() {
            return this.islandsList == null ? 0 : this.islandsList.size();
        }

        int numVertices() {
            return this.endIdx - this.startIdx;
        }

        void insert(IslandsNode islandsNode, Point3f[] point3fArray) {
            boolean bl = false;
            if (this.islandsList != null) {
                block4: for (int i2 = this.numChild() - 1; i2 >= 0; --i2) {
                    IslandsNode islandsNode2 = this.getChild(i2);
                    int n2 = Font3D.check2Contours(islandsNode.startIdx, islandsNode.endIdx, islandsNode2.startIdx, islandsNode2.endIdx, point3fArray);
                    switch (n2) {
                        case 2: {
                            islandsNode2.insert(islandsNode, point3fArray);
                            return;
                        }
                        case 3: {
                            islandsNode.addChild(islandsNode2);
                            bl = true;
                            continue block4;
                        }
                    }
                }
            }
            if (bl) {
                for (int i3 = islandsNode.numChild() - 1; i3 >= 0; --i3) {
                    this.removeChild(islandsNode.getChild(i3));
                }
            }
            this.addChild(islandsNode);
        }

        void collectOddLevelNode(UnorderList unorderList, int n2) {
            if (n2 % 2 == 1) {
                unorderList.add(this);
            }
            if (this.islandsList != null) {
                ++n2;
                for (int i2 = this.numChild() - 1; i2 >= 0; --i2) {
                    this.getChild(i2).collectOddLevelNode(unorderList, n2);
                }
            }
        }
    }
}

