/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.TexCoord4f;
import javax.vecmath.Vector3f;

public abstract class GeometryArray
extends Geometry {
    public static final int ALLOW_COORDINATE_READ = 0;
    public static final int ALLOW_COORDINATE_WRITE = 1;
    public static final int ALLOW_COLOR_READ = 2;
    public static final int ALLOW_COLOR_WRITE = 3;
    public static final int ALLOW_NORMAL_READ = 4;
    public static final int ALLOW_NORMAL_WRITE = 5;
    public static final int ALLOW_TEXCOORD_READ = 6;
    public static final int ALLOW_TEXCOORD_WRITE = 7;
    public static final int ALLOW_VERTEX_ATTR_READ = 22;
    public static final int ALLOW_VERTEX_ATTR_WRITE = 23;
    public static final int ALLOW_COUNT_READ = 8;
    public static final int ALLOW_COUNT_WRITE = 20;
    public static final int ALLOW_FORMAT_READ = 17;
    public static final int ALLOW_REF_DATA_READ = 21;
    private static final int J3D_1_2_ALLOW_REF_DATA_READ = 18;
    public static final int ALLOW_REF_DATA_WRITE = 19;
    public static final int COORDINATES = 1;
    public static final int NORMALS = 2;
    static final int COLOR = 4;
    static final int WITH_ALPHA = 8;
    public static final int COLOR_3 = 4;
    public static final int COLOR_4 = 12;
    public static final int TEXTURE_COORDINATE_2 = 32;
    public static final int TEXTURE_COORDINATE_3 = 64;
    public static final int TEXTURE_COORDINATE_4 = 1024;
    static final int TEXTURE_COORDINATE = 1120;
    public static final int BY_REFERENCE = 128;
    public static final int INTERLEAVED = 256;
    public static final int USE_NIO_BUFFER = 2048;
    public static final int USE_COORD_INDEX_ONLY = 512;
    public static final int VERTEX_ATTRIBUTES = 4096;
    public static final int BY_REFERENCE_INDICES = 8192;
    private static final int LAST_FORMAT_BIT = 8192;
    private TexCoord2f[] texCoord2fArray = null;
    private TexCoord3f[] texCoord3fArray = null;
    private TexCoord4f[] texCoord4fArray = null;
    private TexCoord2f texCoord2fScratch = null;
    private TexCoord3f texCoord3fScratch = null;
    private static final int[] defTexCoordMap = new int[]{0};
    private static final int[] readCapabilities = new int[]{2, 0, 8, 17, 4, 21, 6, 22};

    GeometryArray() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public GeometryArray(int n2, int n3) {
        this(n2, n3, (n3 & 0x460) != 0 ? 1 : 0, (int[])((n3 & 0x460) != 0 ? defTexCoordMap : null));
    }

    public GeometryArray(int n2, int n3, int n4, int[] nArray) {
        this(n2, n3, n4, nArray, 0, null);
    }

    public GeometryArray(int n2, int n3, int n4, int[] nArray, int n5, int[] nArray2) {
        int n6;
        if (n2 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray96"));
        }
        if (n4 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray124"));
        }
        if (n5 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray125"));
        }
        if ((n3 & 1) == 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray0"));
        }
        if ((n3 & 0x100) != 0 && (n3 & 0x80) == 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray80"));
        }
        if ((n3 & 0x100) != 0 && (n3 & 0x1000) != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray128"));
        }
        if ((n3 & 0x200) != 0 && !(this instanceof IndexedGeometryArray)) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray135"));
        }
        if ((n3 & 0x2000) != 0) {
            if (!(this instanceof IndexedGeometryArray)) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray136"));
            }
            if ((n3 & 0x80) == 0) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray137"));
            }
            if ((n3 & 0x200) == 0) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray138"));
            }
        }
        if ((n3 & 0x800) != 0 && (n3 & 0x80) == 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray117"));
        }
        if ((n3 & 0x460) != 0) {
            if (nArray == null) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray106"));
            }
            if (n4 == 0) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray107"));
            }
            for (n6 = 0; n6 < nArray.length; ++n6) {
                if (nArray[n6] < n4) continue;
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray108"));
            }
            if ((n3 & 0x20) != 0) {
                this.texCoord2fArray = new TexCoord2f[1];
                this.texCoord2fScratch = new TexCoord2f();
            } else if ((n3 & 0x40) != 0) {
                this.texCoord3fArray = new TexCoord3f[1];
                this.texCoord3fScratch = new TexCoord3f();
            } else if ((n3 & 0x400) != 0) {
                this.texCoord4fArray = new TexCoord4f[1];
            }
        }
        if ((n3 & 0x1000) != 0) {
            if (n5 > 0) {
                if (n5 != nArray2.length) {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray132"));
                }
                for (n6 = 0; n6 < nArray2.length; ++n6) {
                    if (nArray2[n6] >= 1 && nArray2[n6] <= 4) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray133"));
                }
            } else if (nArray2 != null && nArray2.length != 0) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray132"));
            }
        } else if (n5 > 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray131"));
        }
        this.setDefaultReadCapabilities(readCapabilities);
        ((GeometryArrayRetained)this.retained).createGeometryArrayData(n2, n3, n4, nArray, n5, nArray2);
    }

    public int getVertexCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray1"));
        }
        return ((GeometryArrayRetained)this.retained).getVertexCount();
    }

    public int getVertexFormat() {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray2"));
        }
        return ((GeometryArrayRetained)this.retained).getVertexFormat();
    }

    public int getTexCoordSetCount() {
        return ((GeometryArrayRetained)this.retained).getTexCoordSetCount();
    }

    public int getTexCoordSetMapLength() {
        return ((GeometryArrayRetained)this.retained).getTexCoordSetMapLength();
    }

    public void getTexCoordSetMap(int[] nArray) {
        ((GeometryArrayRetained)this.retained).getTexCoordSetMap(nArray);
    }

    public int getVertexAttrCount() {
        return ((GeometryArrayRetained)this.retained).getVertexAttrCount();
    }

    public void getVertexAttrSizes(int[] nArray) {
        ((GeometryArrayRetained)this.retained).getVertexAttrSizes(nArray);
    }

    public void updateData(GeometryUpdater geometryUpdater) {
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0 && this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray81"));
        }
        ((GeometryArrayRetained)this.retained).updateData(geometryUpdater);
    }

    public void setValidVertexCount(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray88"));
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray96"));
        }
        ((GeometryArrayRetained)this.retained).setValidVertexCount(n2);
    }

    public int getValidVertexCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray89"));
        }
        return ((GeometryArrayRetained)this.retained).getValidVertexCount();
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        block24: {
            GeometryArrayRetained geometryArrayRetained;
            GeometryArrayRetained geometryArrayRetained2;
            block25: {
                int n2;
                int n3;
                int n4;
                block26: {
                    int n5;
                    block23: {
                        super.duplicateAttributes(nodeComponent, bl);
                        geometryArrayRetained2 = (GeometryArrayRetained)nodeComponent.retained;
                        geometryArrayRetained = (GeometryArrayRetained)this.retained;
                        n5 = geometryArrayRetained2.getVertexFormat();
                        if ((n5 & 0x80) != 0) break block23;
                        System.arraycopy(geometryArrayRetained2.vertexData, 0, geometryArrayRetained.vertexData, 0, geometryArrayRetained2.vertexData.length);
                        geometryArrayRetained.setInitialVertexIndex(geometryArrayRetained2.getInitialVertexIndex());
                        break block24;
                    }
                    geometryArrayRetained.setInitialCoordIndex(geometryArrayRetained2.getInitialCoordIndex());
                    geometryArrayRetained.setInitialColorIndex(geometryArrayRetained2.getInitialColorIndex());
                    geometryArrayRetained.setInitialNormalIndex(geometryArrayRetained2.getInitialNormalIndex());
                    n4 = geometryArrayRetained2.getTexCoordSetCount();
                    n3 = geometryArrayRetained2.getVertexAttrCount();
                    for (n2 = 0; n2 < n4; ++n2) {
                        geometryArrayRetained.setInitialTexCoordIndex(n2, geometryArrayRetained2.getInitialTexCoordIndex(n2));
                    }
                    if ((n5 & 0x100) != 0) break block25;
                    if ((n5 & 0x800) != 0) break block26;
                    geometryArrayRetained.setCoordRefFloat(geometryArrayRetained2.getCoordRefFloat());
                    geometryArrayRetained.setCoordRefDouble(geometryArrayRetained2.getCoordRefDouble());
                    geometryArrayRetained.setCoordRef3f(geometryArrayRetained2.getCoordRef3f());
                    geometryArrayRetained.setCoordRef3d(geometryArrayRetained2.getCoordRef3d());
                    geometryArrayRetained.setColorRefFloat(geometryArrayRetained2.getColorRefFloat());
                    geometryArrayRetained.setColorRefByte(geometryArrayRetained2.getColorRefByte());
                    if ((n5 & 8) == 0) {
                        geometryArrayRetained.setColorRef3f(geometryArrayRetained2.getColorRef3f());
                        geometryArrayRetained.setColorRef3b(geometryArrayRetained2.getColorRef3b());
                    } else {
                        geometryArrayRetained.setColorRef4f(geometryArrayRetained2.getColorRef4f());
                        geometryArrayRetained.setColorRef4b(geometryArrayRetained2.getColorRef4b());
                    }
                    geometryArrayRetained.setNormalRefFloat(geometryArrayRetained2.getNormalRefFloat());
                    geometryArrayRetained.setNormalRef3f(geometryArrayRetained2.getNormalRef3f());
                    switch (geometryArrayRetained2.getVertexAttrType()) {
                        case 32768: {
                            for (n2 = 0; n2 < n3; ++n2) {
                                geometryArrayRetained.setVertexAttrRefFloat(n2, geometryArrayRetained2.getVertexAttrRefFloat(n2));
                            }
                            break;
                        }
                    }
                    switch (geometryArrayRetained2.getTexCoordType()) {
                        case 4096: {
                            for (n2 = 0; n2 < n4; ++n2) {
                                geometryArrayRetained.setTexCoordRefFloat(n2, geometryArrayRetained2.getTexCoordRefFloat(n2));
                            }
                            break block24;
                        }
                        case 8192: {
                            for (n2 = 0; n2 < n4; ++n2) {
                                geometryArrayRetained.setTexCoordRef2f(n2, geometryArrayRetained2.getTexCoordRef2f(n2));
                            }
                            break block24;
                        }
                        case 16384: {
                            for (n2 = 0; n2 < n4; ++n2) {
                                geometryArrayRetained.setTexCoordRef3f(n2, geometryArrayRetained2.getTexCoordRef3f(n2));
                            }
                            break;
                        }
                    }
                    break block24;
                }
                geometryArrayRetained.setCoordRefBuffer(geometryArrayRetained2.getCoordRefBuffer());
                geometryArrayRetained.setColorRefBuffer(geometryArrayRetained2.getColorRefBuffer());
                geometryArrayRetained.setNormalRefBuffer(geometryArrayRetained2.getNormalRefBuffer());
                switch (geometryArrayRetained2.getVertexAttrType()) {
                    case 32768: {
                        for (n2 = 0; n2 < n3; ++n2) {
                            geometryArrayRetained.setVertexAttrRefBuffer(n2, geometryArrayRetained2.getVertexAttrRefBuffer(n2));
                        }
                        break;
                    }
                }
                switch (geometryArrayRetained2.getTexCoordType()) {
                    case 4096: {
                        for (n2 = 0; n2 < n4; ++n2) {
                            geometryArrayRetained.setTexCoordRefBuffer(n2, geometryArrayRetained2.getTexCoordRefBuffer(n2));
                        }
                        break;
                    }
                }
                break block24;
            }
            geometryArrayRetained.setInterleavedVertices(geometryArrayRetained2.getInterleavedVertices());
        }
    }

    public void setInitialVertexIndex(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0 && (n3 & 0x100) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray105"));
        }
        ((GeometryArrayRetained)this.retained).setInitialVertexIndex(n2);
    }

    public int getInitialVertexIndex() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialVertexIndex();
    }

    public void setCoordinate(int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray3"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinate(n2, fArray);
    }

    public void setCoordinate(int n2, double[] dArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray3"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinate(n2, dArray);
    }

    public void setCoordinate(int n2, Point3f point3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray3"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinate(n2, point3f);
    }

    public void setCoordinate(int n2, Point3d point3d) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray3"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinate(n2, point3d);
    }

    public void setCoordinates(int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n2, fArray);
    }

    public void setCoordinates(int n2, double[] dArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n2, dArray);
    }

    public void setCoordinates(int n2, Point3f[] point3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n2, point3fArray);
    }

    public void setCoordinates(int n2, Point3d[] point3dArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n2, point3dArray);
    }

    public void setCoordinates(int n2, float[] fArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n5 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n2, fArray, n3, n4);
    }

    public void setCoordinates(int n2, double[] dArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n5 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n2, dArray, n3, n4);
    }

    public void setCoordinates(int n2, Point3f[] point3fArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n5 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n2, point3fArray, n3, n4);
    }

    public void setCoordinates(int n2, Point3d[] point3dArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n5 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n2, point3dArray, n3, n4);
    }

    public void setColor(int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColor(n2, fArray);
    }

    public void setColor(int n2, byte[] byArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColor(n2, byArray);
    }

    public void setColor(int n2, Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColor(n2, color3f);
    }

    public void setColor(int n2, Color4f color4f) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColor(n2, color4f);
    }

    public void setColor(int n2, Color3b color3b) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColor(n2, color3b);
    }

    public void setColor(int n2, Color4b color4b) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColor(n2, color4b);
    }

    public void setColors(int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n2, fArray);
    }

    public void setColors(int n2, byte[] byArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n2, byArray);
    }

    public void setColors(int n2, Color3f[] color3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n2, color3fArray);
    }

    public void setColors(int n2, Color4f[] color4fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n2, color4fArray);
    }

    public void setColors(int n2, Color3b[] color3bArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n2, color3bArray);
    }

    public void setColors(int n2, Color4b[] color4bArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n2, color4bArray);
    }

    public void setColors(int n2, float[] fArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n5 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n5 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n2, fArray, n3, n4);
    }

    public void setColors(int n2, byte[] byArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n5 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n5 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n2, byArray, n3, n4);
    }

    public void setColors(int n2, Color3f[] color3fArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n5 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n5 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n5 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n2, color3fArray, n3, n4);
    }

    public void setColors(int n2, Color4f[] color4fArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n5 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n5 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n5 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n2, color4fArray, n3, n4);
    }

    public void setColors(int n2, Color3b[] color3bArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n5 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n5 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n5 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n2, color3bArray, n3, n4);
    }

    public void setColors(int n2, Color4b[] color4bArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n5 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n5 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n5 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n2, color4bArray, n3, n4);
    }

    public void setNormal(int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray33"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormal(n2, fArray);
    }

    public void setNormal(int n2, Vector3f vector3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray33"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormal(n2, vector3f);
    }

    public void setNormals(int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray35"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormals(n2, fArray);
    }

    public void setNormals(int n2, Vector3f[] vector3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray35"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormals(n2, vector3fArray);
    }

    public void setNormals(int n2, float[] fArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray35"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n5 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n5 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormals(n2, fArray, n3, n4);
    }

    public void setNormals(int n2, Vector3f[] vector3fArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray35"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n5 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n5 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormals(n2, vector3fArray, n3, n4);
    }

    public void setTextureCoordinate(int n2, float[] fArray) {
        this.setTextureCoordinate(0, n2, fArray);
    }

    public void setTextureCoordinate(int n2, int n3, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray39"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n2, n3, fArray, 0, 1);
    }

    public void setTextureCoordinate(int n2, Point2f point2f) {
        this.texCoord2fScratch.set(point2f);
        this.setTextureCoordinate(0, n2, this.texCoord2fScratch);
    }

    public void setTextureCoordinate(int n2, int n3, TexCoord2f texCoord2f) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray39"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x440) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        this.texCoord2fArray[0] = texCoord2f;
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n2, n3, this.texCoord2fArray, 0, 1);
    }

    public void setTextureCoordinate(int n2, Point3f point3f) {
        this.texCoord3fScratch.set(point3f);
        this.setTextureCoordinate(0, n2, this.texCoord3fScratch);
    }

    public void setTextureCoordinate(int n2, int n3, TexCoord3f texCoord3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray39"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x420) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        this.texCoord3fArray[0] = texCoord3f;
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n2, n3, this.texCoord3fArray, 0, 1);
    }

    public void setTextureCoordinate(int n2, int n3, TexCoord4f texCoord4f) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray39"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x60) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray109"));
        }
        this.texCoord4fArray[0] = texCoord4f;
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n2, n3, this.texCoord4fArray, 0, 1);
    }

    public void setTextureCoordinates(int n2, float[] fArray) {
        this.setTextureCoordinates(0, n2, fArray);
    }

    public void setTextureCoordinates(int n2, int n3, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x20) != 0) {
            ((GeometryArrayRetained)this.retained).setTextureCoordinates(n2, n3, fArray, 0, fArray.length / 2);
        } else if ((n4 & 0x40) != 0) {
            ((GeometryArrayRetained)this.retained).setTextureCoordinates(n2, n3, fArray, 0, fArray.length / 3);
        } else {
            ((GeometryArrayRetained)this.retained).setTextureCoordinates(n2, n3, fArray, 0, fArray.length / 4);
        }
    }

    public void setTextureCoordinates(int n2, Point2f[] point2fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(0, n2, point2fArray, 0, point2fArray.length);
    }

    public void setTextureCoordinates(int n2, int n3, TexCoord2f[] texCoord2fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x440) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n2, n3, texCoord2fArray, 0, texCoord2fArray.length);
    }

    public void setTextureCoordinates(int n2, Point3f[] point3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(0, n2, point3fArray, 0, point3fArray.length);
    }

    public void setTextureCoordinates(int n2, int n3, TexCoord3f[] texCoord3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x420) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n2, n3, texCoord3fArray, 0, texCoord3fArray.length);
    }

    public void setTextureCoordinates(int n2, int n3, TexCoord4f[] texCoord4fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x60) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray109"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n2, n3, texCoord4fArray, 0, texCoord4fArray.length);
    }

    public void setTextureCoordinates(int n2, float[] fArray, int n3, int n4) {
        this.setTextureCoordinates(0, n2, fArray, n3, n4);
    }

    public void setTextureCoordinates(int n2, int n3, float[] fArray, int n4, int n5) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n2, n3, fArray, n4, n5);
    }

    public void setTextureCoordinates(int n2, Point2f[] point2fArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(0, n2, point2fArray, n3, n4);
    }

    public void setTextureCoordinates(int n2, int n3, TexCoord2f[] texCoord2fArray, int n4, int n5) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x440) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n2, n3, texCoord2fArray, n4, n5);
    }

    public void setTextureCoordinates(int n2, Point3f[] point3fArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(0, n2, point3fArray, n3, n4);
    }

    public void setTextureCoordinates(int n2, int n3, TexCoord3f[] texCoord3fArray, int n4, int n5) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x420) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n2, n3, texCoord3fArray, n4, n5);
    }

    public void setTextureCoordinates(int n2, int n3, TexCoord4f[] texCoord4fArray, int n4, int n5) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x60) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray109"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n2, n3, texCoord4fArray, n4, n5);
    }

    public void setVertexAttr(int n2, int n3, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(n2, n3, fArray, 0, 1);
    }

    public void setVertexAttr(int n2, int n3, Point2f point2f) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n5 != 2) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttr(n2, n3, point2f);
    }

    public void setVertexAttr(int n2, int n3, Point3f point3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n5 != 3) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttr(n2, n3, point3f);
    }

    public void setVertexAttr(int n2, int n3, Point4f point4f) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n5 != 4) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttr(n2, n3, point4f);
    }

    public void setVertexAttrs(int n2, int n3, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        ((GeometryArrayRetained)this.retained).setVertexAttrs(n2, n3, fArray, 0, fArray.length / n5);
    }

    public void setVertexAttrs(int n2, int n3, Point2f[] point2fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n5 != 2) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(n2, n3, point2fArray, 0, point2fArray.length);
    }

    public void setVertexAttrs(int n2, int n3, Point3f[] point3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n5 != 3) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(n2, n3, point3fArray, 0, point3fArray.length);
    }

    public void setVertexAttrs(int n2, int n3, Point4f[] point4fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n5 != 4) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(n2, n3, point4fArray, 0, point4fArray.length);
    }

    public void setVertexAttrs(int n2, int n3, float[] fArray, int n4, int n5) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int n6 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n6 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(n2, n3, fArray, n4, n5);
    }

    public void setVertexAttrs(int n2, int n3, Point2f[] point2fArray, int n4, int n5) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int n6 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n6 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n7 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n7 != 2) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(n2, n3, point2fArray, n4, n5);
    }

    public void setVertexAttrs(int n2, int n3, Point3f[] point3fArray, int n4, int n5) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int n6 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n6 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n7 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n7 != 3) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(n2, n3, point3fArray, n4, n5);
    }

    public void setVertexAttrs(int n2, int n3, Point4f[] point4fArray, int n4, int n5) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int n6 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n6 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n7 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n7 != 4) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(n2, n3, point4fArray, n4, n5);
    }

    public void getCoordinate(int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray48"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinate(n2, fArray);
    }

    public void getCoordinate(int n2, double[] dArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray48"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinate(n2, dArray);
    }

    public void getCoordinate(int n2, Point3f point3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray48"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinate(n2, point3f);
    }

    public void getCoordinate(int n2, Point3d point3d) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray48"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinate(n2, point3d);
    }

    public void getCoordinates(int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray52"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinates(n2, fArray);
    }

    public void getCoordinates(int n2, double[] dArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray52"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinates(n2, dArray);
    }

    public void getCoordinates(int n2, Point3f[] point3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray52"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinates(n2, point3fArray);
    }

    public void getCoordinates(int n2, Point3d[] point3dArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray52"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinates(n2, point3dArray);
    }

    public void getColor(int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).getColor(n2, fArray);
    }

    public void getColor(int n2, byte[] byArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).getColor(n2, byArray);
    }

    public void getColor(int n2, Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).getColor(n2, color3f);
    }

    public void getColor(int n2, Color4f color4f) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).getColor(n2, color4f);
    }

    public void getColor(int n2, Color3b color3b) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).getColor(n2, color3b);
    }

    public void getColor(int n2, Color4b color4b) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).getColor(n2, color4b);
    }

    public void getColors(int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).getColors(n2, fArray);
    }

    public void getColors(int n2, byte[] byArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).getColors(n2, byArray);
    }

    public void getColors(int n2, Color3f[] color3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).getColors(n2, color3fArray);
    }

    public void getColors(int n2, Color4f[] color4fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).getColors(n2, color4fArray);
    }

    public void getColors(int n2, Color3b[] color3bArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).getColors(n2, color3bArray);
    }

    public void getColors(int n2, Color4b[] color4bArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n3 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).getColors(n2, color4bArray);
    }

    public void getNormal(int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray68"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).getNormal(n2, fArray);
    }

    public void getNormal(int n2, Vector3f vector3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray68"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).getNormal(n2, vector3f);
    }

    public void getNormals(int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray70"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).getNormals(n2, fArray);
    }

    public void getNormals(int n2, Vector3f[] vector3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray70"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).getNormals(n2, vector3fArray);
    }

    public void getTextureCoordinate(int n2, float[] fArray) {
        this.getTextureCoordinate(0, n2, fArray);
    }

    public void getTextureCoordinate(int n2, int n3, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray72"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinate(n2, n3, fArray);
    }

    public void getTextureCoordinate(int n2, Point2f point2f) {
        this.getTextureCoordinate(0, n2, this.texCoord2fArray[0]);
        point2f.set(this.texCoord2fArray[0]);
    }

    public void getTextureCoordinate(int n2, int n3, TexCoord2f texCoord2f) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray72"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x440) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinate(n2, n3, texCoord2f);
    }

    public void getTextureCoordinate(int n2, Point3f point3f) {
        this.getTextureCoordinate(0, n2, this.texCoord3fArray[0]);
        point3f.set(this.texCoord3fArray[0]);
    }

    public void getTextureCoordinate(int n2, int n3, TexCoord3f texCoord3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray72"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x420) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinate(n2, n3, texCoord3f);
    }

    public void getTextureCoordinate(int n2, int n3, TexCoord4f texCoord4f) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray72"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x60) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray109"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinate(n2, n3, texCoord4f);
    }

    public void getTextureCoordinates(int n2, float[] fArray) {
        this.getTextureCoordinates(0, n2, fArray);
    }

    public void getTextureCoordinates(int n2, int n3, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(n2, n3, fArray);
    }

    public void getTextureCoordinates(int n2, Point2f[] point2fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(0, n2, point2fArray);
    }

    public void getTextureCoordinates(int n2, int n3, TexCoord2f[] texCoord2fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x440) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(n2, n3, texCoord2fArray);
    }

    public void getTextureCoordinates(int n2, Point3f[] point3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(0, n2, point3fArray);
    }

    public void getTextureCoordinates(int n2, int n3, TexCoord3f[] texCoord3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x420) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(n2, n3, texCoord3fArray);
    }

    public void getTextureCoordinates(int n2, int n3, TexCoord4f[] texCoord4fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x60) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray109"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(n2, n3, texCoord4fArray);
    }

    public void getVertexAttr(int n2, int n3, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttr(n2, n3, fArray);
    }

    public void getVertexAttr(int n2, int n3, Point2f point2f) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n5 != 2) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttr(n2, n3, point2f);
    }

    public void getVertexAttr(int n2, int n3, Point3f point3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n5 != 3) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttr(n2, n3, point3f);
    }

    public void getVertexAttr(int n2, int n3, Point4f point4f) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n5 != 4) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttr(n2, n3, point4f);
    }

    public void getVertexAttrs(int n2, int n3, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttrs(n2, n3, fArray);
    }

    public void getVertexAttrs(int n2, int n3, Point2f[] point2fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n5 != 2) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttrs(n2, n3, point2fArray);
    }

    public void getVertexAttrs(int n2, int n3, Point3f[] point3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n5 != 3) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttrs(n2, n3, point3fArray);
    }

    public void getVertexAttrs(int n2, int n3, Point4f[] point4fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int n5 = ((GeometryArrayRetained)this.retained).vertexAttrSizes[n2];
        if (n5 != 4) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttrs(n2, n3, point4fArray);
    }

    public void setInitialCoordIndex(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if (n2 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        if ((n3 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setInitialCoordIndex(n2);
    }

    public int getInitialCoordIndex() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialCoordIndex();
    }

    public void setInitialColorIndex(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setInitialColorIndex(n2);
    }

    public int getInitialColorIndex() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialColorIndex();
    }

    public void setInitialNormalIndex(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setInitialNormalIndex(n2);
    }

    public int getInitialNormalIndex() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialNormalIndex();
    }

    public void setInitialTexCoordIndex(int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        if (n3 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n4 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setInitialTexCoordIndex(n2, n3);
    }

    public int getInitialTexCoordIndex(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialTexCoordIndex(n2);
    }

    public void setInitialVertexAttrIndex(int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        if (n3 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n4 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setInitialVertexAttrIndex(n2, n3);
    }

    public int getInitialVertexAttrIndex(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialVertexAttrIndex(n2);
    }

    public void setCoordRefBuffer(J3DBuffer j3DBuffer) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setCoordRefBuffer(j3DBuffer);
    }

    public J3DBuffer getCoordRefBuffer() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getCoordRefBuffer();
    }

    public void setCoordRefFloat(float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setCoordRefFloat(fArray);
    }

    public float[] getCoordRefFloat() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getCoordRefFloat();
    }

    public void setCoordRefDouble(double[] dArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setCoordRefDouble(dArray);
    }

    public double[] getCoordRefDouble() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getCoordRefDouble();
    }

    public void setCoordRef3f(Point3f[] point3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setCoordRef3f(point3fArray);
    }

    public Point3f[] getCoordRef3f() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getCoordRef3f();
    }

    public void setCoordRef3d(Point3d[] point3dArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setCoordRef3d(point3dArray);
    }

    public Point3d[] getCoordRef3d() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getCoordRef3d();
    }

    public void setColorRefBuffer(J3DBuffer j3DBuffer) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setColorRefBuffer(j3DBuffer);
    }

    public J3DBuffer getColorRefBuffer() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRefBuffer();
    }

    public void setColorRefFloat(float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setColorRefFloat(fArray);
    }

    public float[] getColorRefFloat() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRefFloat();
    }

    public void setColorRefByte(byte[] byArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setColorRefByte(byArray);
    }

    public byte[] getColorRefByte() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRefByte();
    }

    public void setColorRef3f(Color3f[] color3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((n2 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColorRef3f(color3fArray);
    }

    public Color3f[] getColorRef3f() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRef3f();
    }

    public void setColorRef4f(Color4f[] color4fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((n2 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColorRef4f(color4fArray);
    }

    public Color4f[] getColorRef4f() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRef4f();
    }

    public void setColorRef3b(Color3b[] color3bArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((n2 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColorRef3b(color3bArray);
    }

    public Color3b[] getColorRef3b() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRef3b();
    }

    public void setColorRef4b(Color4b[] color4bArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((n2 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColorRef4b(color4bArray);
    }

    public Color4b[] getColorRef4b() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRef4b();
    }

    public void setNormalRefBuffer(J3DBuffer j3DBuffer) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setNormalRefBuffer(j3DBuffer);
    }

    public J3DBuffer getNormalRefBuffer() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getNormalRefBuffer();
    }

    public void setNormalRefFloat(float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setNormalRefFloat(fArray);
    }

    public float[] getNormalRefFloat() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getNormalRefFloat();
    }

    public void setNormalRef3f(Vector3f[] vector3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setNormalRef3f(vector3fArray);
    }

    public Vector3f[] getNormalRef3f() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getNormalRef3f();
    }

    public void setTexCoordRefBuffer(int n2, J3DBuffer j3DBuffer) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setTexCoordRefBuffer(n2, j3DBuffer);
    }

    public J3DBuffer getTexCoordRefBuffer(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getTexCoordRefBuffer(n2);
    }

    public void setTexCoordRefFloat(int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n3 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setTexCoordRefFloat(n2, fArray);
    }

    public float[] getTexCoordRefFloat(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n3 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getTexCoordRefFloat(n2);
    }

    public void setTexCoordRef2f(int n2, TexCoord2f[] texCoord2fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n3 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((n3 & 0x440) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).setTexCoordRef2f(n2, texCoord2fArray);
    }

    public TexCoord2f[] getTexCoordRef2f(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n3 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getTexCoordRef2f(n2);
    }

    public void setTexCoordRef3f(int n2, TexCoord3f[] texCoord3fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n3 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((n3 & 0x420) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        ((GeometryArrayRetained)this.retained).setTexCoordRef3f(n2, texCoord3fArray);
    }

    public TexCoord3f[] getTexCoordRef3f(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n3 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getTexCoordRef3f(n2);
    }

    public void setVertexAttrRefBuffer(int n2, J3DBuffer j3DBuffer) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrRefBuffer(n2, j3DBuffer);
    }

    public J3DBuffer getVertexAttrRefBuffer(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getVertexAttrRefBuffer(n2);
    }

    public void setVertexAttrRefFloat(int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n3 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrRefFloat(n2, fArray);
    }

    public float[] getVertexAttrRefFloat(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n3 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((n3 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getVertexAttrRefFloat(n2);
    }

    public void setInterleavedVertices(float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x100) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray85"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        ((GeometryArrayRetained)this.retained).setInterleavedVertices(fArray);
    }

    public float[] getInterleavedVertices() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x100) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray85"));
        }
        if ((n2 & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        return ((GeometryArrayRetained)this.retained).getInterleavedVertices();
    }

    public void setInterleavedVertexBuffer(J3DBuffer j3DBuffer) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x100) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray85"));
        }
        if ((n2 & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        ((GeometryArrayRetained)this.retained).setInterleavedVertexBuffer(j3DBuffer);
    }

    public J3DBuffer getInterleavedVertexBuffer() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x100) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray85"));
        }
        if ((n2 & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        return ((GeometryArrayRetained)this.retained).getInterleavedVertexBuffer();
    }
}

