/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Arrays;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BHTree;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.Locale;
import javax.media.j3d.MRSWLock;
import javax.media.j3d.NnuId;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderBin;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupIndexedList;
import javax.media.j3d.WakeupOnCollisionEntry;
import javax.media.j3d.WakeupOnCollisionExit;
import javax.media.j3d.WakeupOnCollisionMovement;
import javax.vecmath.Vector3d;

class GeometryStructure
extends J3dStructure {
    UpdateTargets targets = null;
    private MRSWLock lock = null;
    private Object visLock = new Object();
    private Object collideListLock = new Object();
    private BHTree[] bhTreeArr = null;
    private int bhTreeCount = 0;
    private int bhTreeMax = 1;
    private int bhTreeBlockSize = 5;
    private BHNode[] bhNodeArr = null;
    private int bhNodeCount = 0;
    private int bhNodeMax;
    private int bhNodeBlockSize = 50;
    private Vector3d localeTrans = new Vector3d();
    WakeupIndexedList collideEntryList;
    WakeupIndexedList collideExitList;
    WakeupIndexedList collideMovementList;
    WakeupIndexedList wakeupOnCollisionEntry;
    WakeupIndexedList wakeupOnCollisionExit;
    WakeupIndexedList wakeupOnCollisionMovement;
    boolean reEvaluateWakeupCollisionGAs;
    private boolean transformMsg = false;

    GeometryStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 64);
        this.bhNodeMax = this.bhNodeBlockSize;
        this.bhNodeArr = new BHNode[this.bhNodeMax];
        this.bhTreeArr = new BHTree[this.bhTreeMax];
        this.lock = new MRSWLock();
        this.collideEntryList = new WakeupIndexedList(WakeupOnCollisionEntry.class, 1, virtualUniverse);
        this.collideExitList = new WakeupIndexedList(WakeupOnCollisionExit.class, 1, virtualUniverse);
        this.collideMovementList = new WakeupIndexedList(WakeupOnCollisionMovement.class, 1, virtualUniverse);
        this.wakeupOnCollisionEntry = new WakeupIndexedList(WakeupOnCollisionEntry.class, 0, virtualUniverse);
        this.wakeupOnCollisionExit = new WakeupIndexedList(WakeupOnCollisionExit.class, 0, virtualUniverse);
        this.wakeupOnCollisionMovement = new WakeupIndexedList(WakeupOnCollisionMovement.class, 0, virtualUniverse);
    }

    void processMessages(long l2) {
        Object[] objectArray = this.getMessages(l2);
        int n2 = this.getNumMessage();
        if (n2 > 0) {
            this.reEvaluateWakeupCollisionGAs = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.lock.writeLock();
                J3dMessage j3dMessage = objectArray[i2];
                switch (j3dMessage.type) {
                    case 3: {
                        this.transformMsg = true;
                        break;
                    }
                    case 27: {
                        this.processSwitchChanged(j3dMessage);
                        if (!this.universe.transformStructure.getLazyUpdate()) break;
                        this.transformMsg = true;
                        break;
                    }
                    case 0: {
                        this.insertNodes((Object[])j3dMessage.args[0]);
                        this.reEvaluateWakeupCollisionGAs = true;
                        break;
                    }
                    case 1: {
                        this.removeNodes(j3dMessage);
                        this.reEvaluateWakeupCollisionGAs = true;
                        break;
                    }
                    case 24: {
                        int n3 = (Integer)j3dMessage.args[1];
                        if (n3 == 1) {
                            j3dMessage.args[0] = j3dMessage.args[2];
                            this.removeNodes(j3dMessage);
                            this.insertNodes((Object[])j3dMessage.args[3]);
                            this.reEvaluateWakeupCollisionGAs = true;
                            break;
                        }
                        if (n3 != 2) break;
                        this.processVisibleChanged(j3dMessage.args[2], (GeometryAtom[])j3dMessage.args[3]);
                        break;
                    }
                    case 26: {
                        this.removeNodes(j3dMessage);
                        this.insertNodes((Object[])j3dMessage.args[1]);
                        break;
                    }
                    case 25: {
                        this.processBoundsChanged((Object[])j3dMessage.args[0], false);
                        break;
                    }
                    case 16: {
                        int n3 = (Integer)j3dMessage.args[1];
                        if (n3 == 1) {
                            this.processBoundsChanged((Object[])j3dMessage.args[3], false);
                            break;
                        }
                        if (n3 != 2) break;
                        this.processVisibleChanged(j3dMessage.args[2], (GeometryAtom[])j3dMessage.args[3]);
                        break;
                    }
                    case 35: 
                    case 37: {
                        this.processBoundsChanged((Object[])j3dMessage.args[0], false);
                        break;
                    }
                    case 17: {
                        this.processBoundsChanged((Object[])j3dMessage.args[0], false);
                        break;
                    }
                    case 10: {
                        this.processVisibleChanged(j3dMessage.args[2], (GeometryAtom[])j3dMessage.args[3]);
                    }
                }
                this.lock.writeUnlock();
                j3dMessage.decRefcount();
            }
            if (this.transformMsg) {
                this.targets = this.universe.transformStructure.getTargetList();
                this.lock.writeLock();
                this.processTransformChanged(this.targets);
                this.lock.writeUnlock();
                this.transformMsg = false;
                this.targets = null;
            }
            Arrays.fill(objectArray, 0, n2, null);
        }
        this.processCollisionDetection();
    }

    private int getBHTreeIndex(Locale locale) {
        for (int i2 = 0; i2 < this.bhTreeCount; ++i2) {
            if (this.bhTreeArr[i2].locale != locale) continue;
            return i2;
        }
        return -1;
    }

    private int getOrAddBHTreeIndex(Locale locale) {
        int n2;
        for (n2 = 0; n2 < this.bhTreeCount; ++n2) {
            if (this.bhTreeArr[n2].locale != locale) continue;
            return n2;
        }
        if (this.bhTreeCount >= this.bhTreeMax) {
            this.bhTreeMax += this.bhTreeBlockSize;
            BHTree[] bHTreeArray = this.bhTreeArr;
            this.bhTreeArr = new BHTree[this.bhTreeMax];
            System.arraycopy(bHTreeArray, 0, this.bhTreeArr, 0, bHTreeArray.length);
        }
        this.bhTreeArr[this.bhTreeCount] = new BHTree(locale);
        ++this.bhTreeCount;
        return n2;
    }

    private void clearBhNodeArr() {
        for (int i2 = 0; i2 < this.bhNodeCount; ++i2) {
            this.bhNodeArr[i2] = null;
        }
        this.bhNodeCount = 0;
    }

    private void addToBhNodeArr(BHNode bHNode) {
        if (this.bhNodeCount >= this.bhNodeMax) {
            this.bhNodeMax += this.bhNodeBlockSize;
            BHNode[] bHNodeArray = this.bhNodeArr;
            this.bhNodeArr = new BHNode[this.bhNodeMax];
            System.arraycopy(bHNodeArray, 0, this.bhNodeArr, 0, bHNodeArray.length);
        }
        this.bhNodeArr[this.bhNodeCount] = bHNode;
        ++this.bhNodeCount;
    }

    private void processVisibleChanged(Object object, GeometryAtom[] geometryAtomArray) {
        boolean bl = true;
        if (geometryAtomArray == null || geometryAtomArray.length < 1) {
            return;
        }
        int n2 = this.getBHTreeIndex(geometryAtomArray[0].locale);
        bl = (Boolean)object;
        for (int i2 = geometryAtomArray.length - 1; i2 >= 0; --i2) {
            geometryAtomArray[i2].visible = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNodes(Object[] objectArray) {
        int n2;
        BHTree bHTree = null;
        this.clearBhNodeArr();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            Object object;
            Object object2;
            Object object3 = objectArray[n2];
            if (object3 instanceof GeometryAtom) {
                object2 = object3;
                synchronized (object2) {
                    GeometryAtom geometryAtom = (GeometryAtom)object3;
                    if (geometryAtom.source.inBackgroundGroup) {
                        geometryAtom.source.geometryBackground.addBgGeometryAtomList(geometryAtom);
                        continue;
                    }
                    object = new BHLeafNode();
                    ((BHLeafNode)object).leafIF = geometryAtom;
                    geometryAtom.bhLeafNode = object;
                    ((BHLeafNode)object).computeBoundingHull();
                    this.addToBhNodeArr((BHNode)object);
                    continue;
                }
            }
            if (!(object3 instanceof GroupRetained)) continue;
            object2 = object3;
            synchronized (object2) {
                object = (GroupRetained)object3;
                BHLeafNode bHLeafNode = new BHLeafNode();
                bHLeafNode.leafIF = object;
                ((GroupRetained)object).bhLeafNode = bHLeafNode;
                bHLeafNode.computeBoundingHull();
                this.addToBhNodeArr(bHLeafNode);
                continue;
            }
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        if (bHTree == null) {
            n2 = this.getOrAddBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
            bHTree = this.bhTreeArr[n2];
        }
        bHTree.insert(this.bhNodeArr, this.bhNodeCount);
        this.clearBhNodeArr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNodes(J3dMessage j3dMessage) {
        Object[] objectArray = (Object[])j3dMessage.args[0];
        BHTree bHTree = null;
        this.clearBhNodeArr();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            NnuId nnuId;
            Object object;
            Object object2 = objectArray[i2];
            if (object2 instanceof GeometryAtom) {
                object = object2;
                synchronized (object) {
                    nnuId = (GeometryAtom)object2;
                    if (nnuId.source != null && nnuId.source.inBackgroundGroup) {
                        nnuId.source.geometryBackground.removeBgGeometryAtomList((GeometryAtom)nnuId);
                        continue;
                    }
                    if (nnuId.bhLeafNode != null) {
                        this.addToBhNodeArr(nnuId.bhLeafNode);
                        nnuId.bhLeafNode = null;
                    }
                    continue;
                }
            }
            if (object2 instanceof GroupRetained) {
                if (((NodeRetained)object2).nodeType == 20) continue;
                object = object2;
                synchronized (object) {
                    nnuId = (GroupRetained)object2;
                    if (((GroupRetained)nnuId).bhLeafNode != null) {
                        this.addToBhNodeArr(((GroupRetained)nnuId).bhLeafNode);
                        ((GroupRetained)nnuId).bhLeafNode = null;
                    }
                    continue;
                }
            }
            if (!(object2 instanceof BehaviorRetained)) continue;
            object = object2;
            synchronized (object) {
                nnuId = (BehaviorRetained)object2;
                WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
                for (int i3 = this.collideEntryList.arraySize() - 1; i3 >= 0; --i3) {
                    WakeupOnCollisionEntry wakeupOnCollisionEntry = wakeupOnCollisionEntryArray[i3];
                    if (wakeupOnCollisionEntry.behav != nnuId) continue;
                    this.collideEntryList.remove(wakeupOnCollisionEntry);
                }
                WakeupOnCollisionExit[] wakeupOnCollisionExitArray = (WakeupOnCollisionExit[])this.collideExitList.toArray();
                for (int i4 = this.collideExitList.arraySize() - 1; i4 >= 0; --i4) {
                    WakeupOnCollisionExit wakeupOnCollisionExit = wakeupOnCollisionExitArray[i4];
                    if (wakeupOnCollisionExit.behav != nnuId) continue;
                    this.collideExitList.remove(wakeupOnCollisionExit);
                }
                continue;
            }
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        if (bHTree == null) {
            int n2 = this.getBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
            if (n2 < 0) {
                this.clearBhNodeArr();
                return;
            }
            bHTree = this.bhTreeArr[n2];
        }
        bHTree.delete(this.bhNodeArr, this.bhNodeCount);
        this.clearBhNodeArr();
        this.wakeupOnCollisionEntry.clearMirror();
        this.wakeupOnCollisionMovement.clearMirror();
        this.wakeupOnCollisionExit.clearMirror();
        Object object = this.collideListLock;
        synchronized (object) {
            this.collideEntryList.clearMirror();
            this.collideExitList.clearMirror();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBoundsChanged(Object[] objectArray, boolean bl) {
        this.clearBhNodeArr();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object;
            Object object2;
            Object object3 = objectArray[i2];
            if (object3 instanceof GeometryAtom) {
                object2 = object3;
                synchronized (object2) {
                    object = (GeometryAtom)object3;
                    if (((GeometryAtom)object).bhLeafNode != null) {
                        this.addToBhNodeArr(((GeometryAtom)object).bhLeafNode);
                    }
                    continue;
                }
            }
            if (!(object3 instanceof GroupRetained)) continue;
            object2 = (GroupRetained)object3;
            if (((GroupRetained)object2).nodeType == 18) continue;
            object = object3;
            synchronized (object) {
                if (((GroupRetained)object2).bhLeafNode != null) {
                    this.addToBhNodeArr(((GroupRetained)object2).bhLeafNode);
                }
                continue;
            }
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        int n2 = this.getBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
        if (n2 >= 0) {
            this.bhTreeArr[n2].boundsChanged(this.bhNodeArr, this.bhNodeCount);
        }
        this.clearBhNodeArr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransformChanged(UpdateTargets updateTargets) {
        GeometryAtom geometryAtom;
        NnuId nnuId;
        int n2;
        Object[] objectArray;
        int n3;
        Object[] objectArray2;
        int n4;
        this.clearBhNodeArr();
        UnorderList unorderList = updateTargets.targetList[0];
        if (unorderList != null) {
            n4 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            for (n3 = 0; n3 < n4; ++n3) {
                objectArray = (Object[])objectArray2[n3];
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    geometryAtom = nnuId = (GeometryAtom)objectArray[n2];
                    synchronized (geometryAtom) {
                        if (nnuId.bhLeafNode != null) {
                            this.addToBhNodeArr(nnuId.bhLeafNode);
                        }
                        continue;
                    }
                }
            }
        }
        if ((unorderList = updateTargets.targetList[6]) != null) {
            n4 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            for (n3 = 0; n3 < n4; ++n3) {
                objectArray = (Object[])objectArray2[n3];
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    nnuId = (GroupRetained)objectArray[n2];
                    if (((GroupRetained)nnuId).nodeType == 18) continue;
                    geometryAtom = nnuId;
                    synchronized (geometryAtom) {
                        if (((GroupRetained)nnuId).bhLeafNode != null) {
                            this.addToBhNodeArr(((GroupRetained)nnuId).bhLeafNode);
                        }
                        continue;
                    }
                }
            }
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        int n5 = this.getBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
        if (n5 >= 0) {
            this.bhTreeArr[n5].boundsChanged(this.bhNodeArr, this.bhNodeCount);
        }
        this.clearBhNodeArr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getVisibleBHTrees(RenderBin renderBin, BoundingBox boundingBox, Locale locale, long l2, boolean bl, int n2) {
        boolean bl2 = true;
        this.lock.readLock();
        ArrayList arrayList = new ArrayList();
        if (this.bhTreeCount == 1) {
            Object object = this.visLock;
            synchronized (object) {
                bl2 = this.bhTreeArr[0].getVisibleBHTrees(renderBin, arrayList, boundingBox, l2, bl, n2, true);
            }
        }
        BoundingBox boundingBox2 = new BoundingBox();
        Object object = this.visLock;
        synchronized (object) {
            for (int i2 = 0; i2 < this.bhTreeCount; ++i2) {
                if (!locale.hiRes.equals(this.bhTreeArr[i2].locale.hiRes)) {
                    this.bhTreeArr[i2].locale.hiRes.difference(locale.hiRes, this.localeTrans);
                    boundingBox2.lower.x = boundingBox.lower.x + this.localeTrans.x;
                    boundingBox2.lower.y = boundingBox.lower.y + this.localeTrans.y;
                    boundingBox2.lower.z = boundingBox.lower.z + this.localeTrans.z;
                    boundingBox2.upper.x = boundingBox.upper.x + this.localeTrans.x;
                    boundingBox2.upper.y = boundingBox.upper.y + this.localeTrans.y;
                    boundingBox2.upper.z = boundingBox.upper.z + this.localeTrans.z;
                } else {
                    boundingBox.copy(boundingBox2);
                }
                if (this.bhTreeArr[i2].getVisibleBHTrees(renderBin, arrayList, boundingBox2, l2, bl, n2, false)) continue;
                bl2 = false;
            }
        }
        this.lock.readUnlock();
        return bl2;
    }

    GeometryAtom[] pickAll(Locale locale, PickShape pickShape) {
        UnorderList unorderList = new UnorderList(BHNode.class);
        unorderList.clear();
        this.lock.readLock();
        int n2 = this.getBHTreeIndex(locale);
        if (n2 < 0) {
            this.lock.readUnlock();
            return null;
        }
        this.bhTreeArr[n2].select(pickShape, unorderList);
        this.lock.readUnlock();
        int n3 = unorderList.size();
        if (n3 < 1) {
            return null;
        }
        BHNode[] bHNodeArray = (BHNode[])unorderList.toArray(false);
        GeometryAtom[] geometryAtomArray = new GeometryAtom[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            geometryAtomArray[n2] = (GeometryAtom)((BHLeafNode)bHNodeArray[n2]).leafIF;
        }
        return geometryAtomArray;
    }

    GeometryAtom pickAny(Locale locale, PickShape pickShape) {
        BHNode bHNode = null;
        this.lock.readLock();
        int n2 = this.getBHTreeIndex(locale);
        if (n2 < 0) {
            this.lock.readUnlock();
            return null;
        }
        bHNode = this.bhTreeArr[n2].selectAny(pickShape);
        this.lock.readUnlock();
        if (bHNode == null) {
            return null;
        }
        return (GeometryAtom)((BHLeafNode)bHNode).leafIF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWakeupOnCollision(WakeupOnCollisionEntry wakeupOnCollisionEntry) {
        boolean bl = true;
        Object object = this.collideListLock;
        synchronized (object) {
            WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
            for (int i2 = this.collideEntryList.arraySize() - 1; i2 >= 0; --i2) {
                WakeupOnCollisionEntry wakeupOnCollisionEntry2 = wakeupOnCollisionEntryArray[i2];
                if (wakeupOnCollisionEntry2.behav != wakeupOnCollisionEntry.behav || wakeupOnCollisionEntry2.geometryAtoms != wakeupOnCollisionEntry.geometryAtoms) continue;
                this.collideEntryList.remove(i2);
                bl = false;
                break;
            }
        }
        this.wakeupOnCollisionEntry.add(wakeupOnCollisionEntry);
        wakeupOnCollisionEntry.updateCollisionBounds(false);
        object = this.collide(wakeupOnCollisionEntry.behav.locale, wakeupOnCollisionEntry.accuracyMode, wakeupOnCollisionEntry.geometryAtoms, wakeupOnCollisionEntry.vwcBounds, wakeupOnCollisionEntry.boundingLeaf, wakeupOnCollisionEntry.armingNode, null);
        if (object != null) {
            this.collideEntryList.add(wakeupOnCollisionEntry);
            wakeupOnCollisionEntry.setTarget((BHLeafInterface)object);
        }
        if (object != null && bl) {
            wakeupOnCollisionEntry.setTriggered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWakeupOnCollision(WakeupOnCollisionExit wakeupOnCollisionExit) {
        WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray;
        Object object;
        boolean bl = true;
        Object object2 = this.collideListLock;
        synchronized (object2) {
            object = (WakeupOnCollisionExit[])this.collideExitList.toArray();
            for (int i2 = this.collideExitList.arraySize() - 1; i2 >= 0; --i2) {
                wakeupOnCollisionEntryArray = object[i2];
                if (wakeupOnCollisionEntryArray.behav != wakeupOnCollisionExit.behav || wakeupOnCollisionEntryArray.geometryAtoms != wakeupOnCollisionExit.geometryAtoms) continue;
                this.collideExitList.remove(i2);
                bl = false;
                break;
            }
        }
        this.wakeupOnCollisionExit.add(wakeupOnCollisionExit);
        wakeupOnCollisionExit.updateCollisionBounds(false);
        object2 = this.collide(wakeupOnCollisionExit.behav.locale, wakeupOnCollisionExit.accuracyMode, wakeupOnCollisionExit.geometryAtoms, wakeupOnCollisionExit.vwcBounds, wakeupOnCollisionExit.boundingLeaf, wakeupOnCollisionExit.armingNode, null);
        if (object2 != null) {
            wakeupOnCollisionExit.setTarget((BHLeafInterface)object2);
            this.collideExitList.add(wakeupOnCollisionExit);
        }
        if (!bl) {
            return;
        }
        object = this.collideListLock;
        synchronized (object) {
            wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
            for (int i3 = this.collideEntryList.arraySize() - 1; i3 >= 0; --i3) {
                WakeupOnCollisionEntry wakeupOnCollisionEntry = wakeupOnCollisionEntryArray[i3];
                if (wakeupOnCollisionEntry.behav != wakeupOnCollisionExit.behav || wakeupOnCollisionEntry.geometryAtoms != wakeupOnCollisionExit.geometryAtoms) continue;
                if (object2 != null) break;
                wakeupOnCollisionExit.setTriggered();
                break;
            }
        }
    }

    void addWakeupOnCollision(WakeupOnCollisionMovement wakeupOnCollisionMovement) {
        this.wakeupOnCollisionMovement.add(wakeupOnCollisionMovement);
        wakeupOnCollisionMovement.updateCollisionBounds(false);
        BHLeafInterface bHLeafInterface = this.collide(wakeupOnCollisionMovement.behav.locale, wakeupOnCollisionMovement.accuracyMode, wakeupOnCollisionMovement.geometryAtoms, wakeupOnCollisionMovement.vwcBounds, wakeupOnCollisionMovement.boundingLeaf, wakeupOnCollisionMovement.armingNode, wakeupOnCollisionMovement);
        if (bHLeafInterface != null) {
            wakeupOnCollisionMovement.setTarget(bHLeafInterface);
            this.collideMovementList.add(wakeupOnCollisionMovement);
        }
    }

    void removeWakeupOnCollision(WakeupOnCollisionEntry wakeupOnCollisionEntry) {
        this.wakeupOnCollisionEntry.remove(wakeupOnCollisionEntry);
    }

    void removeWakeupOnCollision(WakeupOnCollisionExit wakeupOnCollisionExit) {
        this.wakeupOnCollisionExit.remove(wakeupOnCollisionExit);
    }

    void removeWakeupOnCollision(WakeupOnCollisionMovement wakeupOnCollisionMovement) {
        this.wakeupOnCollisionMovement.remove(wakeupOnCollisionMovement);
        this.collideMovementList.remove(wakeupOnCollisionMovement);
    }

    void processCollisionDetection() {
        int n2;
        BHLeafInterface bHLeafInterface;
        int n3;
        WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.wakeupOnCollisionEntry.toArray();
        for (n3 = this.wakeupOnCollisionEntry.arraySize() - 1; n3 >= 0; --n3) {
            WakeupOnCollisionEntry wakeupOnCollisionEntry = wakeupOnCollisionEntryArray[n3];
            wakeupOnCollisionEntry.updateCollisionBounds(this.reEvaluateWakeupCollisionGAs);
            bHLeafInterface = this.collide(wakeupOnCollisionEntry.behav.locale, wakeupOnCollisionEntry.accuracyMode, wakeupOnCollisionEntry.geometryAtoms, wakeupOnCollisionEntry.vwcBounds, wakeupOnCollisionEntry.boundingLeaf, wakeupOnCollisionEntry.armingNode, null);
            n2 = this.collideEntryList.indexOf(wakeupOnCollisionEntry);
            if (bHLeafInterface != null) {
                if (n2 >= 0) continue;
                this.collideEntryList.add(wakeupOnCollisionEntry);
                wakeupOnCollisionEntry.setTarget(bHLeafInterface);
                wakeupOnCollisionEntry.setTriggered();
                continue;
            }
            if (n2 < 0) continue;
            this.collideEntryList.remove(n2);
        }
        WakeupOnCollisionMovement[] wakeupOnCollisionMovementArray = (WakeupOnCollisionMovement[])this.wakeupOnCollisionMovement.toArray();
        for (n3 = this.wakeupOnCollisionMovement.arraySize() - 1; n3 >= 0; --n3) {
            WakeupOnCollisionMovement wakeupOnCollisionMovement = wakeupOnCollisionMovementArray[n3];
            wakeupOnCollisionMovement.updateCollisionBounds(this.reEvaluateWakeupCollisionGAs);
            bHLeafInterface = this.collide(wakeupOnCollisionMovement.behav.locale, wakeupOnCollisionMovement.accuracyMode, wakeupOnCollisionMovement.geometryAtoms, wakeupOnCollisionMovement.vwcBounds, wakeupOnCollisionMovement.boundingLeaf, wakeupOnCollisionMovement.armingNode, wakeupOnCollisionMovement);
            n2 = this.collideMovementList.indexOf(wakeupOnCollisionMovement);
            if (bHLeafInterface != null) {
                if (n2 < 0) {
                    this.collideMovementList.add(wakeupOnCollisionMovement);
                    wakeupOnCollisionMovement.setTarget(bHLeafInterface);
                    continue;
                }
                if (wakeupOnCollisionMovement.duplicateEvent) continue;
                wakeupOnCollisionMovement.setTriggered();
                continue;
            }
            if (n2 < 0) continue;
            this.collideMovementList.remove(n2);
            wakeupOnCollisionMovement.lastSrcBounds = null;
            wakeupOnCollisionMovement.lastDstBounds = null;
        }
        WakeupOnCollisionExit[] wakeupOnCollisionExitArray = (WakeupOnCollisionExit[])this.wakeupOnCollisionExit.toArray();
        for (n3 = this.wakeupOnCollisionExit.arraySize() - 1; n3 >= 0; --n3) {
            WakeupOnCollisionExit wakeupOnCollisionExit = wakeupOnCollisionExitArray[n3];
            wakeupOnCollisionExit.updateCollisionBounds(this.reEvaluateWakeupCollisionGAs);
            bHLeafInterface = this.collide(wakeupOnCollisionExit.behav.locale, wakeupOnCollisionExit.accuracyMode, wakeupOnCollisionExit.geometryAtoms, wakeupOnCollisionExit.vwcBounds, wakeupOnCollisionExit.boundingLeaf, wakeupOnCollisionExit.armingNode, null);
            n2 = this.collideExitList.indexOf(wakeupOnCollisionExit);
            if (bHLeafInterface != null) {
                if (n2 >= 0) continue;
                this.collideExitList.add(wakeupOnCollisionExit);
                wakeupOnCollisionExit.setTarget(bHLeafInterface);
                continue;
            }
            if (n2 < 0) continue;
            this.collideExitList.remove(n2);
            wakeupOnCollisionExit.setTriggered();
        }
    }

    void checkDuplicateEvent(WakeupOnCollisionMovement wakeupOnCollisionMovement, Bounds bounds, BHLeafInterface bHLeafInterface) {
        if (wakeupOnCollisionMovement.lastSrcBounds != null && wakeupOnCollisionMovement.lastSrcBounds.equals(bounds)) {
            BoundingBox boundingBox = bHLeafInterface instanceof GeometryAtom ? ((GeometryAtom)bHLeafInterface).source.vwcBounds : ((GroupRetained)bHLeafInterface).collisionVwcBounds;
            if (wakeupOnCollisionMovement.lastDstBounds != null && wakeupOnCollisionMovement.lastDstBounds.equals(boundingBox)) {
                wakeupOnCollisionMovement.duplicateEvent = true;
            } else {
                wakeupOnCollisionMovement.duplicateEvent = false;
                wakeupOnCollisionMovement.lastDstBounds = (Bounds)((Bounds)boundingBox).clone();
            }
        } else {
            wakeupOnCollisionMovement.duplicateEvent = false;
            wakeupOnCollisionMovement.lastSrcBounds = (Bounds)bounds.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BHLeafInterface collide(Locale locale, int n2, UnorderList unorderList, Bounds bounds, BoundingLeafRetained boundingLeafRetained, NodeRetained nodeRetained, WakeupCriterion wakeupCriterion) {
        this.lock.readLock();
        int n3 = this.getBHTreeIndex(locale);
        if (n3 < 0) {
            this.lock.readUnlock();
            return null;
        }
        if (unorderList != null) {
            BHTree bHTree = this.bhTreeArr[n3];
            synchronized (bHTree) {
                if (bounds != null && nodeRetained instanceof GroupRetained) {
                    BHLeafInterface bHLeafInterface = this.bhTreeArr[n3].selectAny(bounds, n2, (GroupRetained)nodeRetained);
                    if (bHLeafInterface == null) {
                        this.lock.readUnlock();
                        return null;
                    }
                    GeometryAtom[] geometryAtomArray = (GeometryAtom[])unorderList.toArray(false);
                    bHLeafInterface = this.bhTreeArr[n3].selectAny(geometryAtomArray, unorderList.arraySize(), n2);
                    if (bHLeafInterface != null) {
                        this.lock.readUnlock();
                        if (wakeupCriterion != null) {
                            this.checkDuplicateEvent((WakeupOnCollisionMovement)wakeupCriterion, bounds, bHLeafInterface);
                        }
                        return bHLeafInterface;
                    }
                } else {
                    GeometryAtom geometryAtom = (GeometryAtom)unorderList.get(0);
                    BHLeafInterface bHLeafInterface = this.bhTreeArr[n3].selectAny(geometryAtom, n2);
                    if (bHLeafInterface != null) {
                        this.lock.readUnlock();
                        if (wakeupCriterion != null) {
                            this.checkDuplicateEvent((WakeupOnCollisionMovement)wakeupCriterion, geometryAtom.source.vwcBounds, bHLeafInterface);
                        }
                        return bHLeafInterface;
                    }
                }
            }
        } else {
            if (bounds == null) {
                if (boundingLeafRetained == null) {
                    this.lock.readUnlock();
                    return null;
                }
                bounds = boundingLeafRetained.transformedRegion;
            }
            if (bounds == null) {
                this.lock.readUnlock();
                return null;
            }
            if (nodeRetained instanceof GroupRetained) {
                BHTree bHTree = this.bhTreeArr[n3];
                synchronized (bHTree) {
                    BHLeafInterface bHLeafInterface = this.bhTreeArr[n3].selectAny(bounds, n2, (GroupRetained)nodeRetained);
                    this.lock.readUnlock();
                    if (bHLeafInterface != null && wakeupCriterion != null) {
                        this.checkDuplicateEvent((WakeupOnCollisionMovement)wakeupCriterion, bounds, bHLeafInterface);
                    }
                    return bHLeafInterface;
                }
            }
            BHTree bHTree = this.bhTreeArr[n3];
            synchronized (bHTree) {
                BHLeafInterface bHLeafInterface = this.bhTreeArr[n3].selectAny(bounds, n2, nodeRetained);
                this.lock.readUnlock();
                if (bHLeafInterface != null && wakeupCriterion != null) {
                    this.checkDuplicateEvent((WakeupOnCollisionMovement)wakeupCriterion, bounds, bHLeafInterface);
                }
                return bHLeafInterface;
            }
        }
        this.lock.readUnlock();
        return null;
    }

    void resetConditionMet() {
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionEntry);
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionExit);
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionMovement);
    }

    private void processSwitchChanged(J3dMessage j3dMessage) {
    }

    void cleanup() {
        this.collideEntryList.clear();
        this.collideExitList.clear();
        this.collideMovementList.clear();
        this.wakeupOnCollisionEntry.clear();
        this.wakeupOnCollisionExit.clear();
        this.wakeupOnCollisionMovement.clear();
    }
}

