/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.logging.Level;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.MasterControl;
import javax.media.j3d.NioImageBuffer;
import javax.media.j3d.NodeComponent;

public class ImageComponent2D
extends ImageComponent {
    ImageComponent2D() {
    }

    public ImageComponent2D(int n2, int n3, int n4) {
        if (MasterControl.isDevLoggable(Level.FINER)) {
            MasterControl.getDevLogger().finer("ImageComponent - using default of byCopy");
        }
        ((ImageComponent2DRetained)this.retained).processParams(n2, n3, n4, 1);
    }

    public ImageComponent2D(int n2, BufferedImage bufferedImage) {
        if (MasterControl.isDevLoggable(Level.FINER)) {
            MasterControl.getDevLogger().finer("ImageComponent - using default of byCopy");
        }
        ((ImageComponent2DRetained)this.retained).processParams(n2, bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        ((ImageComponent2DRetained)this.retained).set(bufferedImage);
    }

    public ImageComponent2D(int n2, RenderedImage renderedImage) {
        if (MasterControl.isDevLoggable(Level.FINER)) {
            MasterControl.getDevLogger().finer("ImageComponent - using default of byCopy");
        }
        ((ImageComponent2DRetained)this.retained).processParams(n2, renderedImage.getWidth(), renderedImage.getHeight(), 1);
        ((ImageComponent2DRetained)this.retained).set(renderedImage);
    }

    public ImageComponent2D(int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (MasterControl.isDevLoggable(Level.INFO) && bl && !bl2) {
            MasterControl.getDevLogger().info("ImageComponent - yUp should be set when using byReference, otherwise an extra copy of the image will be created");
        }
        ((ImageComponentRetained)this.retained).setByReference(bl);
        ((ImageComponentRetained)this.retained).setYUp(bl2);
        ((ImageComponent2DRetained)this.retained).processParams(n2, n3, n4, 1);
    }

    public ImageComponent2D(int n2, BufferedImage bufferedImage, boolean bl, boolean bl2) {
        if (MasterControl.isDevLoggable(Level.INFO) && bl && !bl2) {
            MasterControl.getDevLogger().info("ImageComponent - yUp should be set when using byReference, otherwise an extra copy of the image will be created");
        }
        ((ImageComponentRetained)this.retained).setByReference(bl);
        ((ImageComponentRetained)this.retained).setYUp(bl2);
        ((ImageComponent2DRetained)this.retained).processParams(n2, bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        ((ImageComponent2DRetained)this.retained).set(bufferedImage);
    }

    public ImageComponent2D(int n2, RenderedImage renderedImage, boolean bl, boolean bl2) {
        if (MasterControl.isDevLoggable(Level.INFO) && bl && !bl2) {
            MasterControl.getDevLogger().info("ImageComponent - yUp should be set when using byReference, otherwise an extra copy of the image will be created");
        }
        ((ImageComponentRetained)this.retained).setByReference(bl);
        ((ImageComponentRetained)this.retained).setYUp(bl2);
        ((ImageComponent2DRetained)this.retained).processParams(n2, renderedImage.getWidth(), renderedImage.getHeight(), 1);
        ((ImageComponent2DRetained)this.retained).set(renderedImage);
    }

    public ImageComponent2D(int n2, NioImageBuffer nioImageBuffer, boolean bl, boolean bl2) {
        ((ImageComponentRetained)this.retained).setByReference(bl);
        ((ImageComponentRetained)this.retained).setYUp(bl2);
        ((ImageComponent2DRetained)this.retained).processParams(n2, nioImageBuffer.getWidth(), nioImageBuffer.getHeight(), 1);
        ((ImageComponent2DRetained)this.retained).set(nioImageBuffer);
    }

    public void set(BufferedImage bufferedImage) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D1"));
        }
        ((ImageComponent2DRetained)this.retained).set(bufferedImage);
    }

    public void set(RenderedImage renderedImage) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D1"));
        }
        ((ImageComponent2DRetained)this.retained).set(renderedImage);
    }

    public void set(NioImageBuffer nioImageBuffer) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D1"));
        }
        ((ImageComponent2DRetained)this.retained).set(nioImageBuffer);
    }

    public BufferedImage getImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D0"));
        }
        RenderedImage renderedImage = ((ImageComponent2DRetained)this.retained).getImage();
        if (renderedImage != null && !(renderedImage instanceof BufferedImage)) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D5"));
        }
        return (BufferedImage)renderedImage;
    }

    public RenderedImage getRenderedImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D0"));
        }
        return ((ImageComponent2DRetained)this.retained).getImage();
    }

    public NioImageBuffer getNioImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D0"));
        }
        return ((ImageComponent2DRetained)this.retained).getNioImage();
    }

    public void setSubImage(RenderedImage renderedImage, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D1"));
        }
        if (((ImageComponent2DRetained)this.retained).isByReference()) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D4"));
        }
        int n8 = ((ImageComponent2DRetained)this.retained).getWidth();
        int n9 = ((ImageComponent2DRetained)this.retained).getHeight();
        if (n4 < 0 || n5 < 0 || n4 + n2 > renderedImage.getWidth() || n5 + n3 > renderedImage.getHeight() || n6 < 0 || n7 < 0 || n6 + n2 > n8 || n7 + n3 > n9) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2D3"));
        }
        ((ImageComponent2DRetained)this.retained).setSubImage(renderedImage, n2, n3, n4, n5, n6, n7);
    }

    public void updateData(Updater updater, int n2, int n3, int n4, int n5) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D1"));
        }
        if (!((ImageComponent2DRetained)this.retained).isByReference()) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D2"));
        }
        int n6 = ((ImageComponent2DRetained)this.retained).getWidth();
        int n7 = ((ImageComponent2DRetained)this.retained).getHeight();
        if (n2 < 0 || n3 < 0 || n2 + n4 > n6 || n3 + n5 > n7) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2D3"));
        }
        ((ImageComponent2DRetained)this.retained).updateData(updater, n2, n3, n4, n5);
    }

    void createRetained() {
        this.retained = new ImageComponent2DRetained();
        this.retained.setSource(this);
    }

    public NodeComponent cloneNodeComponent() {
        ImageComponent2DRetained imageComponent2DRetained = (ImageComponent2DRetained)this.retained;
        ImageComponent2D imageComponent2D = new ImageComponent2D(imageComponent2DRetained.getFormat(), imageComponent2DRetained.width, imageComponent2DRetained.height, imageComponent2DRetained.byReference, imageComponent2DRetained.yUp);
        imageComponent2D.duplicateNodeComponent(this);
        return imageComponent2D;
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        ImageComponent.ImageClass imageClass = ((ImageComponentRetained)nodeComponent.retained).getImageClass();
        if (imageClass == ImageComponent.ImageClass.NIO_IMAGE_BUFFER) {
            NioImageBuffer nioImageBuffer = ((ImageComponent2DRetained)nodeComponent.retained).getNioImage();
            if (nioImageBuffer != null) {
                ((ImageComponent2DRetained)this.retained).set(nioImageBuffer);
            }
        } else {
            RenderedImage renderedImage = ((ImageComponent2DRetained)nodeComponent.retained).getImage();
            if (renderedImage != null) {
                ((ImageComponent2DRetained)this.retained).set(renderedImage);
            }
        }
    }

    public static interface Updater {
        public void updateData(ImageComponent2D var1, int var2, int var3, int var4, int var5);
    }
}

