/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NioImageBuffer;

class ImageComponent2DRetained
extends ImageComponentRetained {
    ImageComponent2DRetained() {
    }

    void set(NioImageBuffer nioImageBuffer) {
        int n2 = nioImageBuffer.getWidth();
        int n3 = nioImageBuffer.getHeight();
        if (!this.byReference) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2D7"));
        }
        if (!this.yUp) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2D8"));
        }
        if (n2 != this.width) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained0"));
        }
        if (n3 != this.height) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained1"));
        }
        this.geomLock.getLock();
        this.setImageClass(nioImageBuffer);
        this.setRefImage(nioImageBuffer, 0);
        this.abgrSupported = true;
        this.imageTypeIsSupported = this.isImageTypeSupported(nioImageBuffer);
        if (this.imageTypeIsSupported) {
            this.imageData = this.createNioImageBufferDataObject(nioImageBuffer);
        } else {
            this.imageData = this.createNioImageBufferDataObject(null);
            this.copyUnsupportedNioImageToImageData(nioImageBuffer, 0, 0, 0, 0, n2, n3, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            this.sendMessage(1, null);
        }
    }

    void set(RenderedImage renderedImage) {
        int n2 = renderedImage.getWidth();
        int n3 = renderedImage.getHeight();
        if (n2 != this.width) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained0"));
        }
        if (n3 != this.height) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained1"));
        }
        this.setImageClass(renderedImage);
        this.geomLock.getLock();
        if (this.byReference) {
            this.setRefImage(renderedImage, 0);
        }
        this.abgrSupported = true;
        this.imageTypeIsSupported = this.isImageTypeSupported(renderedImage);
        if (this.imageTypeIsSupported) {
            if (this.byReference && this.yUp) {
                this.imageData = renderedImage instanceof BufferedImage ? this.createRenderedImageDataObject(renderedImage) : null;
            } else {
                this.imageData = this.createRenderedImageDataObject(null);
                this.copySupportedImageToImageData(renderedImage, 0, this.imageData);
            }
        } else {
            this.imageData = this.createRenderedImageDataObject(null);
            this.copyUnsupportedImageToImageData(renderedImage, 0, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            this.sendMessage(1, null);
        }
    }

    void setSubImage(RenderedImage renderedImage, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!this.isSubImageTypeEqual(renderedImage)) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D6"));
        }
        assert (!this.byReference);
        assert (this.imageData != null);
        this.geomLock.getLock();
        if (this.imageTypeIsSupported) {
            if (renderedImage instanceof BufferedImage) {
                this.copyImageLineByLine((BufferedImage)renderedImage, n4, n5, n6, n7, 0, n2, n3, this.imageData);
            } else {
                this.copySupportedImageToImageData(renderedImage, n4, n5, n6, n7, 0, n2, n3, this.imageData);
            }
        } else if (renderedImage instanceof BufferedImage) {
            this.copyUnsupportedImageToImageData((BufferedImage)renderedImage, n4, n5, n6, n7, 0, n2, n3, this.imageData);
        } else {
            this.copyUnsupportedImageToImageData(renderedImage, n4, n5, n6, n7, 0, n2, n3, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            ImageComponentUpdateInfo imageComponentUpdateInfo = new ImageComponentUpdateInfo();
            imageComponentUpdateInfo.x = n6;
            imageComponentUpdateInfo.y = n7;
            imageComponentUpdateInfo.z = 0;
            imageComponentUpdateInfo.width = n2;
            imageComponentUpdateInfo.height = n3;
            this.sendMessage(2, imageComponentUpdateInfo);
        }
    }

    RenderedImage getImage() {
        if (this.isByReference()) {
            return (RenderedImage)this.getRefImage(0);
        }
        if (this.imageData != null) {
            return this.imageData.createBufferedImage(0);
        }
        return null;
    }

    NioImageBuffer getNioImage() {
        if (this.getImageClass() != ImageComponent.ImageClass.NIO_IMAGE_BUFFER) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D9"));
        }
        assert (this.byReference);
        return (NioImageBuffer)this.getRefImage(0);
    }

    void updateData(ImageComponent2D.Updater updater, int n2, int n3, int n4, int n5) {
        Object object;
        this.geomLock.getLock();
        updater.updateData((ImageComponent2D)this.source, n2, n3, n4, n5);
        Object object2 = this.getRefImage(0);
        assert (object2 != null);
        assert (this.imageData != null);
        if (!this.imageData.isDataByRef()) {
            if (this.imageTypeIsSupported) {
                assert (!(object2 instanceof NioImageBuffer));
                if (object2 instanceof BufferedImage) {
                    this.copyImageLineByLine((BufferedImage)object2, n2, n3, n2, n3, 0, n4, n5, this.imageData);
                } else {
                    object = (RenderedImage)object2;
                    this.copySupportedImageToImageData((RenderedImage)object, n2 + object.getMinX(), n3 + object.getMinY(), n2, n3, 0, n4, n5, this.imageData);
                }
            } else if (object2 instanceof BufferedImage) {
                this.copyUnsupportedImageToImageData((BufferedImage)object2, n2, n3, n2, n3, 0, n4, n5, this.imageData);
            } else if (object2 instanceof RenderedImage) {
                object = (RenderedImage)object2;
                this.copyUnsupportedImageToImageData((RenderedImage)object, n2 + object.getMinX(), n3 + object.getMinY(), n2, n3, 0, n4, n5, this.imageData);
            } else if (object2 instanceof NioImageBuffer) {
                this.copyUnsupportedNioImageToImageData((NioImageBuffer)object2, n2, n3, n2, n3, n4, n5, this.imageData);
            } else assert (false);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            object = new ImageComponentUpdateInfo();
            ((ImageComponentUpdateInfo)object).x = n2;
            ((ImageComponentUpdateInfo)object).y = n3;
            ((ImageComponentUpdateInfo)object).z = 0;
            ((ImageComponentUpdateInfo)object).width = n4;
            ((ImageComponentUpdateInfo)object).height = n5;
            this.sendMessage(2, object);
        }
    }

    void clearLive(int n2) {
        super.clearLive(n2);
    }
}

