/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;

class ImageComponent3DRetained
extends ImageComponentRetained {
    ImageComponent3DRetained() {
    }

    void setDepth(int n2) {
        this.depth = n2;
    }

    int getDepth() {
        return this.depth;
    }

    void set(int n2, BufferedImage bufferedImage) {
        this.geomLock.getLock();
        if (this.byReference) {
            this.setRefImage(bufferedImage, n2);
        }
        if (this.imageData == null) {
            this.abgrSupported = true;
            this.imageTypeIsSupported = this.isImageTypeSupported(bufferedImage);
            this.imageData = this.createRenderedImageDataObject(null);
        } else if (this.getImageType() != this.evaluateImageType(bufferedImage)) {
            // empty if block
        }
        if (this.imageTypeIsSupported) {
            this.copySupportedImageToImageData(bufferedImage, n2, this.imageData);
        } else {
            this.copyUnsupportedImageToImageData(bufferedImage, n2, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            this.sendMessage(1, null);
        }
    }

    void set(int n2, RenderedImage renderedImage) {
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getHeight();
        if (n3 != this.width) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D2"));
        }
        if (n4 != this.height) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D4"));
        }
        if (renderedImage instanceof BufferedImage) {
            this.set(n2, (BufferedImage)renderedImage);
        } else {
            ColorModel colorModel = renderedImage.getColorModel();
            WritableRaster writableRaster = renderedImage.copyData(null);
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            this.set(n2, bufferedImage);
        }
    }

    RenderedImage[] getRenderedImage() {
        RenderedImage[] renderedImageArray = new RenderedImage[this.depth];
        if (!this.byReference) {
            for (int i2 = 0; i2 < this.depth; ++i2) {
                renderedImageArray[i2] = this.imageData.createBufferedImage(i2);
            }
        } else {
            for (int i3 = 0; i3 < this.depth; ++i3) {
                renderedImageArray[i3] = this.imageData.createBufferedImage(i3);
            }
        }
        return renderedImageArray;
    }

    BufferedImage[] getImage() {
        BufferedImage[] bufferedImageArray = new BufferedImage[this.depth];
        if (!this.byReference) {
            for (int i2 = 0; i2 < this.depth; ++i2) {
                bufferedImageArray[i2] = this.imageData.createBufferedImage(i2);
            }
        } else {
            for (int i3 = 0; i3 < this.depth; ++i3) {
                bufferedImageArray[i3] = this.imageData.createBufferedImage(i3);
                if (bufferedImageArray[i3] instanceof BufferedImage) continue;
                throw new IllegalStateException(J3dI18N.getString("ImageComponent3DRetained0"));
            }
        }
        return bufferedImageArray;
    }

    RenderedImage getImage(int n2) {
        if (!this.byReference) {
            return this.imageData.createBufferedImage(n2);
        }
        return (RenderedImage)this.getRefImage(n2);
    }

    void updateData(ImageComponent3D.Updater updater, int n2, int n3, int n4, int n5, int n6) {
        this.geomLock.getLock();
        updater.updateData((ImageComponent3D)this.source, n2, n3, n4, n5, n6);
        RenderedImage renderedImage = (RenderedImage)this.getRefImage(n2);
        assert (renderedImage != null);
        assert (this.imageData != null);
        int n7 = n3 + renderedImage.getMinX();
        int n8 = n4 + renderedImage.getMinY();
        if (this.imageTypeIsSupported) {
            if (renderedImage instanceof BufferedImage) {
                this.copyImageLineByLine((BufferedImage)renderedImage, n7, n8, n3, n4, n2, n5, n6, this.imageData);
            } else {
                this.copySupportedImageToImageData(renderedImage, n7, n8, n3, n4, n2, n5, n6, this.imageData);
            }
        } else if (renderedImage instanceof BufferedImage) {
            this.copyUnsupportedImageToImageData((BufferedImage)renderedImage, n7, n8, n3, n4, n2, n5, n6, this.imageData);
        } else {
            this.copyUnsupportedImageToImageData(renderedImage, n7, n8, n3, n4, n2, n5, n6, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            ImageComponentUpdateInfo imageComponentUpdateInfo = new ImageComponentUpdateInfo();
            imageComponentUpdateInfo.x = n3;
            imageComponentUpdateInfo.y = n4;
            imageComponentUpdateInfo.z = n2;
            imageComponentUpdateInfo.width = n5;
            imageComponentUpdateInfo.height = n6;
            this.sendMessage(2, imageComponentUpdateInfo);
        }
    }

    void setSubImage(int n2, RenderedImage renderedImage, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (!this.isSubImageTypeEqual(renderedImage)) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D6"));
        }
        assert (!this.byReference);
        assert (this.imageData != null);
        this.geomLock.getLock();
        if (this.imageTypeIsSupported) {
            if (renderedImage instanceof BufferedImage) {
                this.copyImageLineByLine((BufferedImage)renderedImage, n5, n6, n7, n8, n2, n3, n4, this.imageData);
            } else {
                this.copySupportedImageToImageData(renderedImage, n5, n6, n7, n8, n2, n3, n4, this.imageData);
            }
        } else if (renderedImage instanceof BufferedImage) {
            this.copyUnsupportedImageToImageData((BufferedImage)renderedImage, n5, n6, n7, n8, n2, n3, n4, this.imageData);
        } else {
            this.copyUnsupportedImageToImageData(renderedImage, n5, n6, n7, n8, n2, n3, n4, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            ImageComponentUpdateInfo imageComponentUpdateInfo = new ImageComponentUpdateInfo();
            imageComponentUpdateInfo.x = n7;
            imageComponentUpdateInfo.y = n8;
            imageComponentUpdateInfo.z = n2;
            imageComponentUpdateInfo.width = n3;
            imageComponentUpdateInfo.height = n4;
            this.sendMessage(2, imageComponentUpdateInfo);
        }
    }
}

