/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;

public abstract class IndexedGeometryArray
extends GeometryArray {
    public static final int ALLOW_COORDINATE_INDEX_READ = 9;
    public static final int ALLOW_COORDINATE_INDEX_WRITE = 10;
    public static final int ALLOW_COLOR_INDEX_READ = 11;
    public static final int ALLOW_COLOR_INDEX_WRITE = 12;
    public static final int ALLOW_NORMAL_INDEX_READ = 13;
    public static final int ALLOW_NORMAL_INDEX_WRITE = 14;
    public static final int ALLOW_TEXCOORD_INDEX_READ = 15;
    public static final int ALLOW_TEXCOORD_INDEX_WRITE = 16;
    public static final int ALLOW_VERTEX_ATTR_INDEX_READ = 24;
    public static final int ALLOW_VERTEX_ATTR_INDEX_WRITE = 25;
    private static final int[] readCapabilities = new int[]{11, 9, 13, 15, 24};

    IndexedGeometryArray() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public IndexedGeometryArray(int n2, int n3, int n4) {
        super(n2, n3);
        this.setDefaultReadCapabilities(readCapabilities);
        ((IndexedGeometryArrayRetained)this.retained).createIndexedGeometryArrayData(n4);
    }

    public IndexedGeometryArray(int n2, int n3, int n4, int[] nArray, int n5) {
        this(n2, n3, n4, nArray, 0, null, n5);
    }

    public IndexedGeometryArray(int n2, int n3, int n4, int[] nArray, int n5, int[] nArray2, int n6) {
        super(n2, n3, n4, nArray, n5, nArray2);
        this.setDefaultReadCapabilities(readCapabilities);
        ((IndexedGeometryArrayRetained)this.retained).createIndexedGeometryArrayData(n6);
    }

    public int getIndexCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray0"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getIndexCount();
    }

    public void setValidIndexCount(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray16"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setValidIndexCount(n2);
    }

    public int getValidIndexCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray17"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getValidIndexCount();
    }

    public void setInitialIndexIndex(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray18"));
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray20"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setInitialIndexIndex(n2);
    }

    public int getInitialIndexIndex() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray19"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getInitialIndexIndex();
    }

    public void setInitialVertexIndex(int n2) {
        throw new UnsupportedOperationException();
    }

    public void setInitialCoordIndex(int n2) {
        throw new UnsupportedOperationException();
    }

    public void setInitialColorIndex(int n2) {
        throw new UnsupportedOperationException();
    }

    public void setInitialNormalIndex(int n2) {
        throw new UnsupportedOperationException();
    }

    public void setInitialTexCoordIndex(int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public void setInitialVertexAttrIndex(int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public void setValidVertexCount(int n2) {
        throw new UnsupportedOperationException();
    }

    public void setCoordinateIndex(int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray1"));
        }
        int n4 = ((IndexedGeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x2000) != 0) {
            throw new IllegalStateException(J3dI18N.getString("IndexedGeometryArray31"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setCoordinateIndex(n2, n3);
    }

    public void setCoordinateIndices(int n2, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray1"));
        }
        int n3 = ((IndexedGeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x2000) != 0) {
            throw new IllegalStateException(J3dI18N.getString("IndexedGeometryArray31"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setCoordinateIndices(n2, nArray);
    }

    public void setCoordIndicesRef(int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((IndexedGeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x2000) == 0) {
            throw new IllegalStateException(J3dI18N.getString("IndexedGeometryArray32"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setCoordIndicesRef(nArray);
    }

    public void setColorIndex(int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray3"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setColorIndex(n2, n3);
    }

    public void setColorIndices(int n2, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray3"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setColorIndices(n2, nArray);
    }

    public void setNormalIndex(int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray5"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setNormalIndex(n2, n3);
    }

    public void setNormalIndices(int n2, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray5"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setNormalIndices(n2, nArray);
    }

    public void setTextureCoordinateIndex(int n2, int n3) {
        this.setTextureCoordinateIndex(0, n2, n3);
    }

    public void setTextureCoordinateIndex(int n2, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray7"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setTextureCoordinateIndex(n2, n3, n4);
    }

    public void setTextureCoordinateIndices(int n2, int[] nArray) {
        this.setTextureCoordinateIndices(0, n2, nArray);
    }

    public void setTextureCoordinateIndices(int n2, int n3, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray7"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setTextureCoordinateIndices(n2, n3, nArray);
    }

    public void setVertexAttrIndex(int n2, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray28"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setVertexAttrIndex(n2, n3, n4);
    }

    public void setVertexAttrIndices(int n2, int n3, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray28"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setVertexAttrIndices(n2, n3, nArray);
    }

    public int getCoordinateIndex(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray9"));
        }
        int n3 = ((IndexedGeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x2000) != 0) {
            throw new IllegalStateException(J3dI18N.getString("IndexedGeometryArray31"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getCoordinateIndex(n2);
    }

    public void getCoordinateIndices(int n2, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray9"));
        }
        int n3 = ((IndexedGeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x2000) != 0) {
            throw new IllegalStateException(J3dI18N.getString("IndexedGeometryArray31"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getCoordinateIndices(n2, nArray);
    }

    public int[] getCoordIndicesRef() {
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((IndexedGeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x2000) == 0) {
            throw new IllegalStateException(J3dI18N.getString("IndexedGeometryArray32"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getCoordIndicesRef();
    }

    public int getColorIndex(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray11"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getColorIndex(n2);
    }

    public void getColorIndices(int n2, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray11"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getColorIndices(n2, nArray);
    }

    public int getNormalIndex(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray13"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getNormalIndex(n2);
    }

    public void getNormalIndices(int n2, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray13"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getNormalIndices(n2, nArray);
    }

    public int getTextureCoordinateIndex(int n2) {
        return this.getTextureCoordinateIndex(0, n2);
    }

    public int getTextureCoordinateIndex(int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray15"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getTextureCoordinateIndex(n2, n3);
    }

    public void getTextureCoordinateIndices(int n2, int[] nArray) {
        this.getTextureCoordinateIndices(0, n2, nArray);
    }

    public void getTextureCoordinateIndices(int n2, int n3, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray15"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getTextureCoordinateIndices(n2, n3, nArray);
    }

    public int getVertexAttrIndex(int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray29"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getVertexAttrIndex(n2, n3);
    }

    public void getVertexAttrIndices(int n2, int n3, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray29"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getVertexAttrIndices(n2, n3, nArray);
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)nodeComponent.retained;
        IndexedGeometryArrayRetained indexedGeometryArrayRetained2 = (IndexedGeometryArrayRetained)this.retained;
        int n2 = indexedGeometryArrayRetained.getVertexFormat();
        int[] nArray = new int[indexedGeometryArrayRetained.getIndexCount()];
        if ((n2 & 1) != 0) {
            indexedGeometryArrayRetained.getCoordinateIndices(0, nArray);
            indexedGeometryArrayRetained2.setCoordinateIndices(0, nArray);
        }
        if ((n2 & 0x200) == 0) {
            int n3;
            if ((n2 & 2) != 0) {
                indexedGeometryArrayRetained.getNormalIndices(0, nArray);
                indexedGeometryArrayRetained2.setNormalIndices(0, nArray);
            }
            if ((n2 & 4) != 0) {
                indexedGeometryArrayRetained.getColorIndices(0, nArray);
                indexedGeometryArrayRetained2.setColorIndices(0, nArray);
            }
            if ((n2 & 0x1000) != 0) {
                for (n3 = 0; n3 < indexedGeometryArrayRetained.vertexAttrCount; ++n3) {
                    indexedGeometryArrayRetained.getVertexAttrIndices(n3, 0, nArray);
                    indexedGeometryArrayRetained2.setVertexAttrIndices(n3, 0, nArray);
                }
            }
            if ((n2 & 0x460) != 0) {
                for (n3 = 0; n3 < indexedGeometryArrayRetained.texCoordSetCount; ++n3) {
                    indexedGeometryArrayRetained.getTextureCoordinateIndices(n3, 0, nArray);
                    indexedGeometryArrayRetained2.setTextureCoordinateIndices(n3, 0, nArray);
                }
            }
        }
    }
}

