/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryStripArrayRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.IndexedLineStripArrayRetained;
import javax.media.j3d.IndexedTriangleFanArrayRetained;
import javax.media.j3d.IndexedTriangleStripArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LineStripArrayRetained;
import javax.media.j3d.TriangleFanArrayRetained;
import javax.media.j3d.TriangleStripArrayRetained;

abstract class IndexedGeometryStripArrayRetained
extends IndexedGeometryArrayRetained {
    int[] stripIndexCounts;
    int[] compileStripICOffset;
    int[] compileIndexLength;

    IndexedGeometryStripArrayRetained() {
    }

    void setStripIndexCounts(int[] nArray) {
        int n2;
        int n3 = nArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += nArray[n2];
            if (this instanceof IndexedLineStripArrayRetained) {
                if (nArray[n2] >= 2) continue;
                throw new IllegalArgumentException(J3dI18N.getString("IndexedLineStripArrayRetained1"));
            }
            if (this instanceof IndexedTriangleStripArrayRetained) {
                if (nArray[n2] >= 3) continue;
                throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleStripArrayRetained1"));
            }
            if (!(this instanceof IndexedTriangleFanArrayRetained) || nArray[n2] >= 3) continue;
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleFanArrayRetained1"));
        }
        if (this.initialIndexIndex + n4 > this.indexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryStripArrayRetained0"));
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int[] nArray2 = null;
        int[] nArray3 = null;
        n5 = this.computeMaxIndex(this.initialIndexIndex, n4, this.indexCoord);
        this.doErrorCheck(n5);
        if ((this.vertexFormat & 0x200) == 0) {
            if ((this.vertexFormat & 4) != 0) {
                n6 = this.computeMaxIndex(this.initialIndexIndex, n4, this.indexColor);
                this.doColorCheck(n6);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                nArray2 = new int[this.texCoordSetCount];
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    nArray2[n2] = this.computeMaxIndex(this.initialIndexIndex, n4, this.indexTexCoord[n2]);
                    this.doTexCoordCheck(nArray2[n2], n2);
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                nArray3 = new int[this.vertexAttrCount];
                for (n2 = 0; n2 < this.vertexAttrCount; ++n2) {
                    nArray3[n2] = this.computeMaxIndex(this.initialIndexIndex, n4, this.indexVertexAttr[n2]);
                    this.doTexCoordCheck(nArray3[n2], n2);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                n7 = this.computeMaxIndex(this.initialIndexIndex, n4, this.indexNormal);
                this.doNormalCheck(n7);
            }
        }
        this.geomLock.getLock();
        this.validIndexCount = n4;
        this.stripIndexCounts = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.stripIndexCounts[n2] = nArray[n2];
        }
        this.maxCoordIndex = n5;
        if ((this.vertexFormat & 0x200) == 0) {
            this.maxColorIndex = n6;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    this.maxTexCoordIndices[n2] = nArray2[n2];
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n2 = 0; n2 < this.vertexAttrCount; ++n2) {
                    this.maxVertexAttrIndices[n2] = nArray3[n2];
                }
            }
            this.maxNormalIndex = n7;
        } else {
            this.maxColorIndex = this.maxCoordIndex;
            this.maxNormalIndex = this.maxCoordIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    this.maxTexCoordIndices[n2] = this.maxCoordIndex;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n2 = 0; n2 < this.vertexAttrCount; ++n2) {
                    this.maxVertexAttrIndices[n2] = this.maxCoordIndex;
                }
            }
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(true);
        }
    }

    GeometryArrayRetained cloneNonIndexedGeometry() {
        GeometryStripArrayRetained geometryStripArrayRetained = null;
        switch (this.geoType) {
            case 14: {
                geometryStripArrayRetained = new LineStripArrayRetained();
                break;
            }
            case 13: {
                geometryStripArrayRetained = new TriangleFanArrayRetained();
                break;
            }
            case 12: {
                geometryStripArrayRetained = new TriangleStripArrayRetained();
            }
        }
        geometryStripArrayRetained.createGeometryArrayData(this.validIndexCount, this.vertexFormat & 0xFFFFF67F, this.texCoordSetCount, this.texCoordSetMap, this.vertexAttrCount, this.vertexAttrSizes);
        geometryStripArrayRetained.unIndexify(this);
        geometryStripArrayRetained.setStripVertexCounts(this.stripIndexCounts);
        return geometryStripArrayRetained;
    }

    int getNumStrips() {
        return this.stripIndexCounts.length;
    }

    void getStripIndexCounts(int[] nArray) {
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            nArray[i2] = this.stripIndexCounts[i2];
        }
    }

    void mergeGeometryArrays(ArrayList arrayList) {
        int n2;
        int n3 = arrayList.size();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained = (IndexedGeometryStripArrayRetained)arrayList.get(n2);
            n4 += indexedGeometryStripArrayRetained.stripIndexCounts.length;
        }
        this.stripIndexCounts = new int[n4];
        this.compileIndexLength = new int[n4];
        this.compileStripICOffset = new int[n3];
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained = (IndexedGeometryStripArrayRetained)arrayList.get(n2);
            this.compileStripICOffset[n2] = n5;
            this.compileIndexLength[n2] = indexedGeometryStripArrayRetained.stripIndexCounts.length;
            System.arraycopy(indexedGeometryStripArrayRetained.stripIndexCounts, 0, this.stripIndexCounts, n5, indexedGeometryStripArrayRetained.stripIndexCounts.length);
            n5 += indexedGeometryStripArrayRetained.stripIndexCounts.length;
        }
        super.mergeGeometryArrays(arrayList);
    }

    int getNumStrips(int n2) {
        return this.compileIndexLength[n2];
    }

    void getStripIndexCounts(int n2, int[] nArray) {
        int n3 = this.compileIndexLength[n2];
        int n4 = this.compileStripICOffset[n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = this.stripIndexCounts[n4 + 1];
        }
    }
}

