/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Geometry;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class OrientedShape3D
extends Shape3D {
    public static final int ROTATE_ABOUT_AXIS = 0;
    public static final int ROTATE_ABOUT_POINT = 1;
    public static final int ROTATE_NONE = 2;
    public static final int ALLOW_MODE_READ = 20;
    public static final int ALLOW_MODE_WRITE = 21;
    public static final int ALLOW_AXIS_READ = 22;
    public static final int ALLOW_AXIS_WRITE = 23;
    public static final int ALLOW_POINT_READ = 24;
    public static final int ALLOW_POINT_WRITE = 25;
    public static final int ALLOW_SCALE_READ = 26;
    public static final int ALLOW_SCALE_WRITE = 27;
    private static final int[] readCapabilities = new int[]{20, 22, 24, 26};

    public OrientedShape3D() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public OrientedShape3D(Geometry geometry, Appearance appearance, int n2, Vector3f vector3f) {
        super(geometry, appearance);
        this.setDefaultReadCapabilities(readCapabilities);
        ((OrientedShape3DRetained)this.retained).initAlignmentMode(n2);
        ((OrientedShape3DRetained)this.retained).initAlignmentAxis(vector3f);
    }

    public OrientedShape3D(Geometry geometry, Appearance appearance, int n2, Point3f point3f) {
        super(geometry, appearance);
        this.setDefaultReadCapabilities(readCapabilities);
        ((OrientedShape3DRetained)this.retained).initAlignmentMode(n2);
        ((OrientedShape3DRetained)this.retained).initRotationPoint(point3f);
    }

    public OrientedShape3D(Geometry geometry, Appearance appearance, int n2, Vector3f vector3f, boolean bl, double d2) {
        super(geometry, appearance);
        this.setDefaultReadCapabilities(readCapabilities);
        ((OrientedShape3DRetained)this.retained).initAlignmentMode(n2);
        ((OrientedShape3DRetained)this.retained).initAlignmentAxis(vector3f);
        ((OrientedShape3DRetained)this.retained).initConstantScaleEnable(bl);
        ((OrientedShape3DRetained)this.retained).initScale(d2);
    }

    public OrientedShape3D(Geometry geometry, Appearance appearance, int n2, Point3f point3f, boolean bl, double d2) {
        super(geometry, appearance);
        this.setDefaultReadCapabilities(readCapabilities);
        ((OrientedShape3DRetained)this.retained).initAlignmentMode(n2);
        ((OrientedShape3DRetained)this.retained).initRotationPoint(point3f);
        ((OrientedShape3DRetained)this.retained).initConstantScaleEnable(bl);
        ((OrientedShape3DRetained)this.retained).initScale(d2);
    }

    void createRetained() {
        this.retained = new OrientedShape3DRetained();
        this.retained.setSource(this);
    }

    public void setAlignmentMode(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D0"));
        }
        if (this.isLive()) {
            ((OrientedShape3DRetained)this.retained).setAlignmentMode(n2);
        } else {
            ((OrientedShape3DRetained)this.retained).initAlignmentMode(n2);
        }
    }

    public int getAlignmentMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D1"));
        }
        return ((OrientedShape3DRetained)this.retained).getAlignmentMode();
    }

    public void setAlignmentAxis(Vector3f vector3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D2"));
        }
        if (this.isLive()) {
            ((OrientedShape3DRetained)this.retained).setAlignmentAxis(vector3f);
        } else {
            ((OrientedShape3DRetained)this.retained).initAlignmentAxis(vector3f);
        }
    }

    public void setAlignmentAxis(float f2, float f3, float f4) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D2"));
        }
        if (this.isLive()) {
            ((OrientedShape3DRetained)this.retained).setAlignmentAxis(f2, f3, f4);
        } else {
            ((OrientedShape3DRetained)this.retained).initAlignmentAxis(f2, f3, f4);
        }
    }

    public void getAlignmentAxis(Vector3f vector3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D3"));
        }
        ((OrientedShape3DRetained)this.retained).getAlignmentAxis(vector3f);
    }

    public void setRotationPoint(Point3f point3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D4"));
        }
        if (this.isLive()) {
            ((OrientedShape3DRetained)this.retained).setRotationPoint(point3f);
        } else {
            ((OrientedShape3DRetained)this.retained).initRotationPoint(point3f);
        }
    }

    public void setRotationPoint(float f2, float f3, float f4) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D4"));
        }
        if (this.isLive()) {
            ((OrientedShape3DRetained)this.retained).setRotationPoint(f2, f3, f4);
        } else {
            ((OrientedShape3DRetained)this.retained).initRotationPoint(f2, f3, f4);
        }
    }

    public void getRotationPoint(Point3f point3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D5"));
        }
        ((OrientedShape3DRetained)this.retained).getRotationPoint(point3f);
    }

    public void setConstantScaleEnable(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(27)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D6"));
        }
        if (this.isLive()) {
            ((OrientedShape3DRetained)this.retained).setConstantScaleEnable(bl);
        } else {
            ((OrientedShape3DRetained)this.retained).initConstantScaleEnable(bl);
        }
    }

    public boolean getConstantScaleEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(26)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D7"));
        }
        return ((OrientedShape3DRetained)this.retained).getConstantScaleEnable();
    }

    public void setScale(double d2) {
        if (this.isLiveOrCompiled() && !this.getCapability(27)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D8"));
        }
        if (this.isLive()) {
            ((OrientedShape3DRetained)this.retained).setScale(d2);
        } else {
            ((OrientedShape3DRetained)this.retained).initScale(d2);
        }
    }

    public double getScale() {
        if (this.isLiveOrCompiled() && !this.getCapability(26)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D9"));
        }
        return ((OrientedShape3DRetained)this.retained).getScale();
    }

    public Node cloneNode(boolean bl) {
        OrientedShape3D orientedShape3D = new OrientedShape3D();
        orientedShape3D.duplicateNode(this, bl);
        return orientedShape3D;
    }

    public void duplicateNode(Node node, boolean bl) {
        this.checkDuplicateNode(node, bl);
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        OrientedShape3DRetained orientedShape3DRetained = (OrientedShape3DRetained)node.retained;
        OrientedShape3DRetained orientedShape3DRetained2 = (OrientedShape3DRetained)this.retained;
        orientedShape3DRetained2.setAlignmentMode(orientedShape3DRetained.getAlignmentMode());
        Vector3f vector3f = new Vector3f();
        orientedShape3DRetained.getAlignmentAxis(vector3f);
        orientedShape3DRetained2.setAlignmentAxis(vector3f);
        Point3f point3f = new Point3f();
        orientedShape3DRetained.getRotationPoint(point3f);
        orientedShape3DRetained2.setRotationPoint(point3f);
    }
}

