/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DepthComponent;
import javax.media.j3d.DepthComponentIntRetained;
import javax.media.j3d.DepthComponentRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture2DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point2d;
import javax.vecmath.Point2i;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point4d;

class RasterRetained
extends GeometryRetained {
    int type = 1;
    private int clipMode = 0;
    private Point3f position = new Point3f();
    private int xSrcOffset = 0;
    private int ySrcOffset = 0;
    private int width = 0;
    private int height = 0;
    private int xDstOffset = 0;
    private int yDstOffset = 0;
    ImageComponent2DRetained image = null;
    Texture2DRetained texture = null;
    DepthComponentRetained depthComponent = null;

    RasterRetained() {
        this.geoType = 15;
    }

    final void setPosition(Point3f point3f) {
        this.geomLock.getLock();
        this.position.x = point3f.x;
        this.position.y = point3f.y;
        this.position.z = point3f.z;
        this.geomLock.unLock();
        this.sendChangedMessage(64, null, null);
    }

    final void getPosition(Point3f point3f) {
        point3f.x = this.position.x;
        point3f.y = this.position.y;
        point3f.z = this.position.z;
    }

    final void setType(int n2) {
        this.geomLock.getLock();
        this.type = n2;
        this.geomLock.unLock();
    }

    final int getType() {
        return this.type;
    }

    final void setClipMode(int n2) {
        this.geomLock.getLock();
        this.clipMode = n2;
        this.geomLock.unLock();
        this.computeBoundingBox();
        if (this.source.isLive()) {
            int n3 = this.userLists.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                ArrayList arrayList = (ArrayList)this.userLists.get(i2);
                int n4 = arrayList.size();
                for (int i3 = 0; i3 < n4; ++i3) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)arrayList.get(i3);
                    Shape3DRetained shape3DRetained2 = (Shape3DRetained)shape3DRetained.sourceNode;
                    shape3DRetained2.setBoundsAutoCompute(false);
                    shape3DRetained2.setBounds(this.geoBounds);
                }
            }
        }
    }

    final int getClipMode() {
        return this.clipMode;
    }

    final void setSrcOffset(int n2, int n3) {
        this.geomLock.getLock();
        this.xSrcOffset = n2;
        this.ySrcOffset = n3;
        this.geomLock.unLock();
    }

    final void getSrcOffset(Point point) {
        point.setLocation(this.xSrcOffset, this.ySrcOffset);
    }

    final void setSize(int n2, int n3) {
        this.geomLock.getLock();
        this.width = n2;
        this.height = n3;
        this.geomLock.unLock();
    }

    final void getSize(Dimension dimension) {
        dimension.setSize(this.width, this.height);
    }

    final void setDstOffset(int n2, int n3) {
        this.geomLock.getLock();
        this.xDstOffset = n2;
        this.yDstOffset = n3;
        this.geomLock.unLock();
    }

    final void getDstOffset(Point point) {
        point.setLocation(this.xDstOffset, this.yDstOffset);
    }

    final void initImage(ImageComponent2D imageComponent2D) {
        int n2;
        if (imageComponent2D == null) {
            this.image = null;
            this.texture = null;
            return;
        }
        this.image = (ImageComponent2DRetained)imageComponent2D.retained;
        this.image.setEnforceNonPowerOfTwoSupport(true);
        switch (this.image.getNumberOfComponents()) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 5;
                break;
            }
            case 4: {
                n2 = 6;
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        Texture2D texture2D = new Texture2D(1, n2, imageComponent2D.getWidth(), imageComponent2D.getHeight());
        this.texture = (Texture2DRetained)texture2D.retained;
        this.texture.setUseAsRaster(true);
        this.image.addUser(this.texture);
        this.texture.initImage(0, imageComponent2D);
    }

    final void setImage(ImageComponent2D imageComponent2D) {
        if (imageComponent2D != null && imageComponent2D.getImageClass() == ImageComponent.ImageClass.NIO_IMAGE_BUFFER) {
            throw new IllegalArgumentException(J3dI18N.getString("Background14"));
        }
        Texture2DRetained texture2DRetained = this.texture;
        if (this.source.isLive() && this.texture != null) {
            this.texture.clearLive(this.refCount);
        }
        this.geomLock.getLock();
        this.initImage(imageComponent2D);
        this.geomLock.unLock();
        if (this.source.isLive()) {
            if (this.texture != null) {
                this.texture.setLive(this.inBackgroundGroup, this.refCount);
            }
            this.sendChangedMessage(1152, texture2DRetained, this.texture);
        }
    }

    final ImageComponent2D getImage() {
        return this.image == null ? null : (ImageComponent2D)this.image.source;
    }

    final void setDepthComponent(DepthComponent depthComponent) {
        this.geomLock.getLock();
        if (this.source.isLive()) {
            if (this.depthComponent != null) {
                this.depthComponent.clearLive(this.refCount);
            }
            if (depthComponent != null) {
                ((DepthComponentRetained)depthComponent.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        this.depthComponent = depthComponent == null ? null : (DepthComponentRetained)depthComponent.retained;
        this.geomLock.unLock();
    }

    final DepthComponent getDepthComponent() {
        return this.depthComponent == null ? null : (DepthComponent)this.depthComponent.source;
    }

    void setLive(boolean bl, int n2) {
        super.doSetLive(bl, n2);
        if (this.texture != null) {
            this.texture.setLive(bl, n2);
        }
        if (this.depthComponent != null) {
            this.depthComponent.setLive(bl, n2);
        }
        this.isEditable = this.source.getCapability(3) || this.source.getCapability(1) || (this.type & 1) != 0 && this.source.getCapability(5) || (this.type & 2) != 0 && this.source.getCapability(7) || this.source.getCapability(9);
        super.markAsLive();
    }

    void clearLive(int n2) {
        super.clearLive(n2);
        if (this.texture != null) {
            this.texture.clearLive(n2);
        }
        if (this.depthComponent != null) {
            this.depthComponent.clearLive(n2);
        }
    }

    void computeBoundingBox() {
        if (this.clipMode == 1) {
            Point3d point3d = new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            Point3d point3d2 = new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            this.geoBounds.setUpper(point3d2);
            this.geoBounds.setLower(point3d);
        } else {
            Point3d point3d = new Point3d();
            point3d.x = this.position.x;
            point3d.y = this.position.y;
            point3d.z = this.position.z;
            this.geoBounds.setUpper(point3d);
            this.geoBounds.setLower(point3d);
        }
    }

    void update() {
        this.computeBoundingBox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChangedMessage(int n2, Object object, Object object2) {
        Object object3 = this.liveStateLock;
        synchronized (object3) {
            if (this.source.isLive()) {
                ArrayList arrayList = this.universeList;
                synchronized (arrayList) {
                    int n3 = this.universeList.size();
                    J3dMessage[] j3dMessageArray = new J3dMessage[n3];
                    for (int i2 = 0; i2 < n3; ++i2) {
                        j3dMessageArray[i2] = new J3dMessage();
                        j3dMessageArray[i2].type = 17;
                        j3dMessageArray[i2].threads = n2;
                        j3dMessageArray[i2].args[0] = Shape3DRetained.getGeomAtomsArray((ArrayList)this.userLists.get(i2));
                        j3dMessageArray[i2].args[1] = this;
                        Object[] objectArray = new Object[]{object, object2};
                        j3dMessageArray[i2].args[2] = objectArray;
                        j3dMessageArray[i2].args[3] = new Integer(this.changedFrequent);
                        j3dMessageArray[i2].universe = (VirtualUniverse)this.universeList.get(i2);
                    }
                    VirtualUniverse.mc.processMessage(j3dMessageArray);
                }
            }
        }
    }

    void execute(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f2, int n2, boolean bl3) {
        Point3d point3d = new Point3d();
        point3d.set(this.position);
        Point2d point2d = new Point2d();
        Transform3D transform3D = new Transform3D();
        Point3d point3d2 = this.computeWinCoord(canvas3D, renderAtom, point2d, point3d, transform3D);
        if (point3d2 == null) {
            return;
        }
        if (this.clipMode == 0 && !this.isRasterClipPositionInside(point3d2)) {
            return;
        }
        point2d.x += (double)this.xDstOffset;
        point2d.y += (double)this.yDstOffset;
        if (this.type == 1 || this.type == 3) {
            float f3 = (float)(point3d2.z * 0.5 - 0.5);
            if (this.texture != null) {
                canvas3D.updateTextureForRaster(this.texture);
                canvas3D.textureFill(this, point2d, f3, f2);
                canvas3D.restoreTextureBin();
            }
        }
        if (this.type == 2 || this.type == 3) {
            Point2i point2i = new Point2i(this.xSrcOffset, this.ySrcOffset);
            if (this.clipMode == 1) {
                this.clipImage(canvas3D, renderAtom, point2d, point2i);
            }
            this.computeObjCoord(canvas3D, point2d, point3d, transform3D);
            canvas3D.executeRasterDepth(canvas3D.ctx, (float)point3d.x, (float)point3d.y, (float)point3d.z, point2i.x, point2i.y, this.width, this.height, this.depthComponent.width, this.depthComponent.height, this.depthComponent.type, ((DepthComponentIntRetained)this.depthComponent).depthData);
        }
    }

    private void clipImage(Canvas3D canvas3D, RenderAtom renderAtom, Point2d point2d, Point2i point2i) {
        if (point2d.x > 0.0 && point2d.y > 0.0) {
            return;
        }
        if (point2d.x < 1.0) {
            point2i.x = (int)(-point2d.x) + 1;
            point2d.x = 1.0;
        }
        if (point2d.y < 1.0) {
            point2i.y = (int)(-point2d.y) + 1;
            point2d.y = 1.0;
        }
        if (point2i.x < this.xSrcOffset) {
            point2i.x = this.xSrcOffset;
        }
        if (point2i.y < this.ySrcOffset) {
            point2i.y = this.ySrcOffset;
        }
    }

    private boolean isRasterClipPositionInside(Point3d point3d) {
        return point3d.x >= -1.0 && point3d.x <= 1.0 && point3d.y >= -1.0 && point3d.y <= 1.0;
    }

    private void computeObjCoord(Canvas3D canvas3D, Point2d point2d, Point3d point3d, Transform3D transform3D) {
        canvas3D.getPixelLocationInImagePlate(point2d.x, point2d.y, point3d.z, point3d);
        transform3D.invert();
        transform3D.transform(point3d);
    }

    private Point3d computeWinCoord(Canvas3D canvas3D, RenderAtom renderAtom, Point2d point2d, Point3d point3d, Transform3D transform3D) {
        RenderMolecule renderMolecule = renderAtom.renderMolecule;
        if (renderMolecule == null) {
            return null;
        }
        Transform3D transform3D2 = renderMolecule.localToVworld[renderMolecule.localToVworldIndex[0]];
        Point3d point3d2 = new Point3d();
        point3d2.set(point3d);
        Point4d point4d = new Point4d();
        transform3D2.transform(point3d2);
        canvas3D.vworldToEc.transform(point3d2);
        canvas3D.projTrans.transform(point3d2, point4d);
        if (point4d.w <= 0.0 || point4d.z > point4d.w || -point4d.z > point4d.w) {
            return null;
        }
        double d2 = 1.0 / point4d.w;
        point3d2.x = point4d.x * d2;
        point3d2.y = point4d.y * d2;
        point3d2.z = point4d.z * d2;
        canvas3D.getLastVworldToImagePlate(transform3D);
        transform3D.mul(transform3D2);
        transform3D.transform(point3d);
        canvas3D.getPixelLocationFromImagePlate(point3d, point2d);
        return point3d2;
    }

    int getClassType() {
        return 5;
    }

    void notifyImageComponentImageChanged(ImageComponentRetained imageComponentRetained, ImageComponentUpdateInfo imageComponentUpdateInfo) {
    }

    boolean intersect(PickShape pickShape, PickInfo pickInfo, int n2, Point3d point3d, GeometryRetained geometryRetained, int n3) {
        return false;
    }

    boolean intersect(Bounds bounds) {
        return false;
    }

    boolean intersect(Point3d[] point3dArray) {
        return false;
    }

    boolean intersect(Transform3D transform3D, GeometryRetained geometryRetained) {
        return false;
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        return false;
    }

    boolean intersect(Transform3D transform3D, Bounds bounds) {
        return false;
    }

    void handleFrequencyChange(int n2) {
        if (n2 == 5) {
            this.setFrequencyChangeMask(n2, 1);
        }
    }
}

