/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;

class RenderingAttributesRetained
extends NodeComponentRetained {
    static final int DEPTH_ENABLE = 1;
    static final int DEPTH_WRITE_ENABLE = 2;
    static final int ALPHA_TEST_VALUE = 4;
    static final int ALPHA_TEST_FUNC = 8;
    static final int VISIBLE = 16;
    static final int IGNORE_VCOLOR = 32;
    static final int RASTER_OP_ENABLE = 64;
    static final int RASTER_OP_VALUE = 128;
    static final int DEPTH_TEST_FUNC = 256;
    static final int STENCIL_ENABLE = 512;
    static final int STENCIL_OP_VALUES = 1024;
    static final int STENCIL_FUNC = 2048;
    static final int STENCIL_WRITE_MASK = 4096;
    boolean depthBufferEnable = true;
    boolean depthBufferWriteEnable = true;
    float alphaTestValue = 0.0f;
    int alphaTestFunction = 0;
    int depthTestFunction = 5;
    boolean visible = true;
    boolean ignoreVertexColors = false;
    boolean rasterOpEnable = false;
    int rasterOp = 3;
    boolean stencilEnable = false;
    int stencilFailOp = 1;
    int stencilZFailOp = 1;
    int stencilZPassOp = 1;
    int stencilFunction = 0;
    int stencilReferenceValue = 0;
    int stencilCompareMask = -1;
    int stencilWriteMask = -1;
    static final int LESS = 0;
    static final int LEQUAL = 1;

    RenderingAttributesRetained() {
    }

    final void initVisible(boolean bl) {
        this.visible = bl;
    }

    final void setVisible(boolean bl) {
        this.initVisible(bl);
        this.sendMessage(16, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getVisible() {
        return this.visible;
    }

    final void initIgnoreVertexColors(boolean bl) {
        this.ignoreVertexColors = bl;
    }

    final void setIgnoreVertexColors(boolean bl) {
        this.initIgnoreVertexColors(bl);
        this.sendMessage(32, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getIgnoreVertexColors() {
        return this.ignoreVertexColors;
    }

    final void initDepthBufferEnable(boolean bl) {
        this.depthBufferEnable = bl;
    }

    final void setDepthBufferEnable(boolean bl) {
        this.initDepthBufferEnable(bl);
        this.sendMessage(1, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getDepthBufferEnable() {
        return this.depthBufferEnable;
    }

    final void initDepthBufferWriteEnable(boolean bl) {
        this.depthBufferWriteEnable = bl;
    }

    final void setDepthBufferWriteEnable(boolean bl) {
        this.initDepthBufferWriteEnable(bl);
        this.sendMessage(2, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getDepthBufferWriteEnable() {
        return this.depthBufferWriteEnable;
    }

    final void initAlphaTestValue(float f2) {
        this.alphaTestValue = f2;
    }

    final void setAlphaTestValue(float f2) {
        this.initAlphaTestValue(f2);
        this.sendMessage(4, new Float(f2));
    }

    final float getAlphaTestValue() {
        return this.alphaTestValue;
    }

    final void initAlphaTestFunction(int n2) {
        this.alphaTestFunction = n2;
    }

    final void setAlphaTestFunction(int n2) {
        this.initAlphaTestFunction(n2);
        this.sendMessage(8, new Integer(n2));
    }

    final int getAlphaTestFunction() {
        return this.alphaTestFunction;
    }

    final void initDepthTestFunction(int n2) {
        this.depthTestFunction = n2;
    }

    final void setDepthTestFunction(int n2) {
        this.initDepthTestFunction(n2);
        this.sendMessage(256, new Integer(n2));
    }

    final int getDepthTestFunction() {
        return this.depthTestFunction;
    }

    final void initRasterOpEnable(boolean bl) {
        this.rasterOpEnable = bl;
    }

    final void setRasterOpEnable(boolean bl) {
        this.initRasterOpEnable(bl);
        this.sendMessage(64, new Boolean(bl));
    }

    final boolean getRasterOpEnable() {
        return this.rasterOpEnable;
    }

    final void initRasterOp(int n2) {
        this.rasterOp = n2;
    }

    final void setRasterOp(int n2) {
        this.initRasterOp(n2);
        this.sendMessage(128, new Integer(n2));
    }

    final int getRasterOp() {
        return this.rasterOp;
    }

    final void initStencilEnable(boolean bl) {
        this.stencilEnable = bl;
    }

    final void setStencilEnable(boolean bl) {
        this.initStencilEnable(bl);
        this.sendMessage(512, new Boolean(bl));
    }

    final boolean getStencilEnable() {
        return this.stencilEnable;
    }

    final void initStencilOp(int n2, int n3, int n4) {
        this.stencilFailOp = n2;
        this.stencilZFailOp = n3;
        this.stencilZPassOp = n4;
    }

    final void setStencilOp(int n2, int n3, int n4) {
        this.initStencilOp(n2, n3, n4);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(3);
        arrayList.add(new Integer(n2));
        arrayList.add(new Integer(n3));
        arrayList.add(new Integer(n4));
        this.sendMessage(1024, arrayList);
    }

    final void getStencilOp(int[] nArray) {
        nArray[0] = this.stencilFailOp;
        nArray[1] = this.stencilZFailOp;
        nArray[2] = this.stencilZPassOp;
    }

    final void initStencilFunction(int n2, int n3, int n4) {
        this.stencilFunction = n2;
        this.stencilReferenceValue = n3;
        this.stencilCompareMask = n4;
    }

    final void setStencilFunction(int n2, int n3, int n4) {
        this.initStencilOp(n2, n3, n4);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(3);
        arrayList.add(new Integer(n2));
        arrayList.add(new Integer(n3));
        arrayList.add(new Integer(n4));
        this.sendMessage(2048, arrayList);
    }

    final void getStencilFunction(int[] nArray) {
        nArray[0] = this.stencilFunction;
        nArray[1] = this.stencilReferenceValue;
        nArray[2] = this.stencilCompareMask;
    }

    final void initStencilWriteMask(int n2) {
        this.stencilWriteMask = n2;
    }

    final void setStencilWriteMask(int n2) {
        this.initStencilWriteMask(n2);
        this.sendMessage(4096, new Integer(n2));
    }

    final int getStencilWriteMask() {
        return this.stencilWriteMask;
    }

    void updateNative(Canvas3D canvas3D, boolean bl, boolean bl2) {
        Pipeline.getPipeline().updateRenderingAttributes(canvas3D.ctx, bl, bl2, this.depthBufferEnable, this.depthBufferWriteEnable, this.depthTestFunction, this.alphaTestValue, this.alphaTestFunction, this.ignoreVertexColors, this.rasterOpEnable, this.rasterOp, canvas3D.userStencilAvailable, this.stencilEnable, this.stencilFailOp, this.stencilZFailOp, this.stencilZPassOp, this.stencilFunction, this.stencilReferenceValue, this.stencilCompareMask, this.stencilWriteMask);
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                RenderingAttributesRetained renderingAttributesRetained = new RenderingAttributesRetained();
                renderingAttributesRetained.set(this);
                renderingAttributesRetained.source = this.source;
                this.mirror = renderingAttributesRetained;
            }
        } else {
            ((RenderingAttributesRetained)this.mirror).set(this);
        }
    }

    synchronized void initMirrorObject() {
        ((RenderingAttributesRetained)this.mirror).set(this);
    }

    synchronized void updateMirrorObject(int n2, Object object) {
        RenderingAttributesRetained renderingAttributesRetained = (RenderingAttributesRetained)this.mirror;
        if ((n2 & 1) != 0) {
            renderingAttributesRetained.depthBufferEnable = (Boolean)object;
        } else if ((n2 & 2) != 0) {
            renderingAttributesRetained.depthBufferWriteEnable = (Boolean)object;
        } else if ((n2 & 0x100) != 0) {
            renderingAttributesRetained.depthTestFunction = (Integer)object;
        } else if ((n2 & 4) != 0) {
            renderingAttributesRetained.alphaTestValue = ((Float)object).floatValue();
        } else if ((n2 & 8) != 0) {
            renderingAttributesRetained.alphaTestFunction = (Integer)object;
        } else if ((n2 & 0x10) != 0) {
            renderingAttributesRetained.visible = (Boolean)object;
        } else if ((n2 & 0x20) != 0) {
            renderingAttributesRetained.ignoreVertexColors = (Boolean)object;
        } else if ((n2 & 0x40) != 0) {
            renderingAttributesRetained.rasterOpEnable = (Boolean)object;
        } else if ((n2 & 0x80) != 0) {
            renderingAttributesRetained.rasterOp = (Integer)object;
        } else if ((n2 & 0x200) != 0) {
            renderingAttributesRetained.stencilEnable = (Boolean)object;
        } else if ((n2 & 0x400) != 0) {
            ArrayList arrayList = (ArrayList)object;
            renderingAttributesRetained.stencilFailOp = (Integer)arrayList.get(0);
            renderingAttributesRetained.stencilZFailOp = (Integer)arrayList.get(1);
            renderingAttributesRetained.stencilZPassOp = (Integer)arrayList.get(2);
        } else if ((n2 & 0x800) != 0) {
            ArrayList arrayList = (ArrayList)object;
            renderingAttributesRetained.stencilFunction = (Integer)arrayList.get(0);
            renderingAttributesRetained.stencilReferenceValue = (Integer)arrayList.get(1);
            renderingAttributesRetained.stencilCompareMask = (Integer)arrayList.get(2);
        } else if ((n2 & 0x1000) != 0) {
            renderingAttributesRetained.stencilWriteMask = (Integer)object;
        }
    }

    boolean equivalent(RenderingAttributesRetained renderingAttributesRetained) {
        return this == renderingAttributesRetained || renderingAttributesRetained != null && renderingAttributesRetained.depthBufferEnable == this.depthBufferEnable && renderingAttributesRetained.depthBufferWriteEnable == this.depthBufferWriteEnable && renderingAttributesRetained.alphaTestValue == this.alphaTestValue && renderingAttributesRetained.alphaTestFunction == this.alphaTestFunction && renderingAttributesRetained.visible == this.visible && renderingAttributesRetained.ignoreVertexColors == this.ignoreVertexColors && renderingAttributesRetained.rasterOpEnable == this.rasterOpEnable && renderingAttributesRetained.rasterOp == this.rasterOp && renderingAttributesRetained.depthTestFunction == this.depthTestFunction && renderingAttributesRetained.stencilEnable == this.stencilEnable && renderingAttributesRetained.stencilFailOp == this.stencilFailOp && renderingAttributesRetained.stencilZFailOp == this.stencilZFailOp && renderingAttributesRetained.stencilZPassOp == this.stencilZPassOp && renderingAttributesRetained.stencilFunction == this.stencilFunction && renderingAttributesRetained.stencilReferenceValue == this.stencilReferenceValue && renderingAttributesRetained.stencilCompareMask == this.stencilCompareMask && renderingAttributesRetained.stencilWriteMask == this.stencilWriteMask;
    }

    protected void set(RenderingAttributesRetained renderingAttributesRetained) {
        super.set(renderingAttributesRetained);
        this.depthBufferEnable = renderingAttributesRetained.depthBufferEnable;
        this.depthBufferWriteEnable = renderingAttributesRetained.depthBufferWriteEnable;
        this.alphaTestValue = renderingAttributesRetained.alphaTestValue;
        this.alphaTestFunction = renderingAttributesRetained.alphaTestFunction;
        this.depthTestFunction = renderingAttributesRetained.depthTestFunction;
        this.visible = renderingAttributesRetained.visible;
        this.ignoreVertexColors = renderingAttributesRetained.ignoreVertexColors;
        this.rasterOpEnable = renderingAttributesRetained.rasterOpEnable;
        this.rasterOp = renderingAttributesRetained.rasterOp;
        this.stencilEnable = renderingAttributesRetained.stencilEnable;
        this.stencilFailOp = renderingAttributesRetained.stencilFailOp;
        this.stencilZFailOp = renderingAttributesRetained.stencilZFailOp;
        this.stencilZPassOp = renderingAttributesRetained.stencilZPassOp;
        this.stencilFunction = renderingAttributesRetained.stencilFunction;
        this.stencilReferenceValue = renderingAttributesRetained.stencilReferenceValue;
        this.stencilCompareMask = renderingAttributesRetained.stencilCompareMask;
        this.stencilWriteMask = renderingAttributesRetained.stencilWriteMask;
    }

    final void sendMessage(int n2, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 10;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n2);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            if (n2 == 16) {
                j3dMessage.threads |= 0x40;
            }
            j3dMessage.type = 10;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(i2);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n2);
            j3dMessage.args[2] = object;
            ArrayList arrayList3 = (ArrayList)arrayList2.get(i2);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void handleFrequencyChange(int n2) {
        int n3 = 0;
        if (n2 == 1) {
            n3 = 4;
        }
        if (n2 == 3) {
            n3 = 8;
        }
        if (n2 == 6) {
            n3 = 16;
        }
        if (n2 == 10) {
            n3 = 32;
        }
        if (n2 == 8) {
            n3 = 64;
        }
        if (n2 == 11) {
            n3 = 2;
        }
        if (n2 == 13) {
            n3 = 256;
        }
        if (n2 == 15) {
            n3 = 256;
        }
        if (n2 == 13) {
            n3 = 7680;
        }
        if (n3 != 0) {
            this.setFrequencyChangeMask(n2, n3);
        }
    }
}

