/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;

public class RotationInterpolator
extends TransformInterpolator {
    float minimumAngle;
    float maximumAngle;
    private Transform3D rotation = new Transform3D();
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    RotationInterpolator() {
    }

    public RotationInterpolator(Alpha alpha, TransformGroup transformGroup) {
        super(alpha, transformGroup);
        this.minimumAngle = 0.0f;
        this.maximumAngle = (float)Math.PI * 2;
    }

    public RotationInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float f2, float f3) {
        super(alpha, transformGroup, transform3D);
        this.minimumAngle = f2;
        this.maximumAngle = f3;
    }

    public void setMinimumAngle(float f2) {
        this.minimumAngle = f2;
    }

    public float getMinimumAngle() {
        return this.minimumAngle;
    }

    public void setMaximumAngle(float f2) {
        this.maximumAngle = f2;
    }

    public float getMaximumAngle() {
        return this.maximumAngle;
    }

    public void setAxisOfRotation(Transform3D transform3D) {
        this.setTransformAxis(transform3D);
    }

    public Transform3D getAxisOfRotation() {
        return this.getTransformAxis();
    }

    public void computeTransform(float f2, Transform3D transform3D) {
        double d2 = (1.0 - (double)f2) * (double)this.minimumAngle + (double)(f2 * this.maximumAngle);
        this.rotation.rotY(d2);
        transform3D.mul(this.axis, this.rotation);
        transform3D.mul(transform3D, this.axisInverse);
    }

    public Node cloneNode(boolean bl) {
        RotationInterpolator rotationInterpolator = new RotationInterpolator();
        rotationInterpolator.duplicateNode(this, bl);
        return rotationInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        RotationInterpolator rotationInterpolator = (RotationInterpolator)node;
        this.setMinimumAngle(rotationInterpolator.getMinimumAngle());
        this.setMaximumAngle(rotationInterpolator.getMaximumAngle());
    }
}

