/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.PathInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Quat4f;

public class RotationPathInterpolator
extends PathInterpolator {
    private Transform3D rotation = new Transform3D();
    private Quat4f tQuat = new Quat4f();
    private Quat4f[] quats;
    private float prevInterpolationValue = Float.NaN;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    RotationPathInterpolator() {
    }

    public RotationPathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float[] fArray, Quat4f[] quat4fArray) {
        super(alpha, transformGroup, transform3D, fArray);
        if (fArray.length != quat4fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotationPathInterpolator0"));
        }
        this.setPathArrays(quat4fArray);
    }

    public void setQuat(int n2, Quat4f quat4f) {
        this.quats[n2].set(quat4f);
    }

    public void getQuat(int n2, Quat4f quat4f) {
        quat4f.set(this.quats[n2]);
    }

    public void setPathArrays(float[] fArray, Quat4f[] quat4fArray) {
        if (fArray.length != quat4fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotationPathInterpolator0"));
        }
        this.setKnots(fArray);
        this.setPathArrays(quat4fArray);
    }

    private void setPathArrays(Quat4f[] quat4fArray) {
        this.quats = new Quat4f[quat4fArray.length];
        for (int i2 = 0; i2 < quat4fArray.length; ++i2) {
            this.quats[i2] = new Quat4f();
            this.quats[i2].set(quat4fArray[i2]);
        }
    }

    public void getQuats(Quat4f[] quat4fArray) {
        for (int i2 = 0; i2 < this.quats.length; ++i2) {
            quat4fArray[i2].set(this.quats[i2]);
        }
    }

    public void setAxisOfRotation(Transform3D transform3D) {
        this.setTransformAxis(transform3D);
    }

    public Transform3D getAxisOfRotation() {
        return this.getTransformAxis();
    }

    public void computeTransform(float f2, Transform3D transform3D) {
        this.computePathInterpolation(f2);
        if (this.currentKnotIndex == 0 && this.currentInterpolationValue == 0.0f) {
            this.tQuat.x = this.quats[0].x;
            this.tQuat.y = this.quats[0].y;
            this.tQuat.z = this.quats[0].z;
            this.tQuat.w = this.quats[0].w;
        } else {
            double d2 = this.quats[this.currentKnotIndex].x * this.quats[this.currentKnotIndex + 1].x + this.quats[this.currentKnotIndex].y * this.quats[this.currentKnotIndex + 1].y + this.quats[this.currentKnotIndex].z * this.quats[this.currentKnotIndex + 1].z + this.quats[this.currentKnotIndex].w * this.quats[this.currentKnotIndex + 1].w;
            if (d2 < 0.0) {
                this.tQuat.x = this.quats[this.currentKnotIndex].x + (-this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.tQuat.y = this.quats[this.currentKnotIndex].y + (-this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.tQuat.z = this.quats[this.currentKnotIndex].z + (-this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                this.tQuat.w = this.quats[this.currentKnotIndex].w + (-this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
            } else {
                this.tQuat.x = this.quats[this.currentKnotIndex].x + (this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.tQuat.y = this.quats[this.currentKnotIndex].y + (this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.tQuat.z = this.quats[this.currentKnotIndex].z + (this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                this.tQuat.w = this.quats[this.currentKnotIndex].w + (this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
            }
        }
        this.tQuat.normalize();
        this.rotation.set(this.tQuat);
        transform3D.mul(this.axis, this.rotation);
        transform3D.mul(transform3D, this.axisInverse);
    }

    public Node cloneNode(boolean bl) {
        RotationPathInterpolator rotationPathInterpolator = new RotationPathInterpolator();
        rotationPathInterpolator.duplicateNode(this, bl);
        return rotationPathInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        RotationPathInterpolator rotationPathInterpolator = (RotationPathInterpolator)node;
        int n2 = rotationPathInterpolator.getArrayLengths();
        this.quats = new Quat4f[n2];
        Quat4f quat4f = new Quat4f();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.quats[i2] = new Quat4f();
            rotationPathInterpolator.getQuat(i2, quat4f);
            this.setQuat(i2, quat4f);
        }
    }
}

