/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Link;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;

public class SceneGraphPath {
    Locale root = null;
    Node[] interior = null;
    Node item = null;
    Transform3D transform = new Transform3D();
    Point3d intersectPoint = new Point3d();
    double pickDistance;

    public SceneGraphPath() {
    }

    public SceneGraphPath(Locale locale, Node node) {
        this.item = node;
        this.root = locale;
    }

    public SceneGraphPath(Locale locale, Node[] nodeArray, Node node) {
        this.item = node;
        this.root = locale;
        this.interior = new Node[nodeArray.length];
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            this.interior[i2] = nodeArray[i2];
        }
    }

    SceneGraphPath(SceneGraphPath sceneGraphPath) {
        this.set(sceneGraphPath);
    }

    public final void set(SceneGraphPath sceneGraphPath) {
        this.root = sceneGraphPath.root;
        this.item = sceneGraphPath.item;
        this.transform.set(sceneGraphPath.transform);
        if (sceneGraphPath.interior != null && sceneGraphPath.interior.length > 0) {
            this.interior = new Node[sceneGraphPath.interior.length];
            for (int i2 = 0; i2 < this.interior.length; ++i2) {
                this.interior[i2] = sceneGraphPath.interior[i2];
            }
        } else {
            this.interior = null;
        }
    }

    public final void setLocale(Locale locale) {
        this.root = locale;
    }

    public final void setObject(Node node) {
        this.item = node;
    }

    public final void setNodes(Node[] nodeArray) {
        if (nodeArray != null && nodeArray.length > 0) {
            this.interior = new Node[nodeArray.length];
            for (int i2 = 0; i2 < nodeArray.length; ++i2) {
                this.interior[i2] = nodeArray[i2];
            }
        } else {
            this.interior = null;
        }
    }

    public final void setNode(int n2, Node node) {
        if (this.interior == null) {
            throw new NullPointerException(J3dI18N.getString("SceneGraphPath0"));
        }
        this.interior[n2] = node;
    }

    public final void setTransform(Transform3D transform3D) {
        this.transform.set(transform3D);
    }

    public final Transform3D getTransform() {
        return new Transform3D(this.transform);
    }

    public final Locale getLocale() {
        return this.root;
    }

    public final Node getObject() {
        return this.item;
    }

    public final int nodeCount() {
        if (this.interior == null) {
            return 0;
        }
        return this.interior.length;
    }

    public final Node getNode(int n2) {
        if (this.interior == null) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("SceneGraphPath1"));
        }
        return this.interior[n2];
    }

    public boolean equals(SceneGraphPath sceneGraphPath) {
        boolean bl;
        block8: {
            bl = true;
            try {
                if (sceneGraphPath == null || this.root != sceneGraphPath.root || this.item != sceneGraphPath.item) {
                    return false;
                }
                bl = this.transform.equals(sceneGraphPath.transform);
                if (!bl) {
                    return false;
                }
                if (this.interior == null || sceneGraphPath.interior == null) {
                    if (this.interior != sceneGraphPath.interior) {
                        return false;
                    }
                    bl = this.root == sceneGraphPath.root && this.item == sceneGraphPath.item;
                    break block8;
                }
                if (this.interior.length == sceneGraphPath.interior.length) {
                    for (int i2 = 0; i2 < this.interior.length; ++i2) {
                        if (this.interior[i2] == sceneGraphPath.interior[i2]) continue;
                        return false;
                    }
                    break block8;
                }
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        try {
            SceneGraphPath sceneGraphPath = (SceneGraphPath)object;
            if (sceneGraphPath == null || this.root != sceneGraphPath.root || this.item != sceneGraphPath.item) {
                return false;
            }
            bl = this.transform.equals(sceneGraphPath.transform);
            if (!bl) {
                return false;
            }
            if (this.interior == null || sceneGraphPath.interior == null) {
                if (this.interior != sceneGraphPath.interior) {
                    return false;
                }
                bl = this.root == sceneGraphPath.root && this.item == sceneGraphPath.item;
            } else if (this.interior.length == sceneGraphPath.interior.length) {
                for (int i2 = 0; i2 < this.interior.length; ++i2) {
                    if (this.interior[i2] == sceneGraphPath.interior[i2]) continue;
                    return false;
                }
            } else {
                return false;
            }
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        HashKey hashKey = new HashKey(250);
        if (this.interior != null && this.item != null) {
            for (int i2 = 0; i2 < this.interior.length; ++i2) {
                hashKey.append(LinkRetained.plus).append(this.item.toString());
            }
        }
        return hashKey.hashCode() + this.transform.hashCode();
    }

    public final boolean isSamePath(SceneGraphPath sceneGraphPath) {
        int n2 = 0;
        if (sceneGraphPath == null || sceneGraphPath.item != this.item || this.root != sceneGraphPath.root) {
            return false;
        }
        if (this.interior != null && sceneGraphPath.interior != null) {
            block0: for (int i2 = 0; i2 < this.interior.length; ++i2) {
                if (!(this.interior[i2] instanceof Link)) continue;
                while (n2 < sceneGraphPath.interior.length) {
                    if (sceneGraphPath.interior[n2] instanceof Link) {
                        if (sceneGraphPath.interior[n2] != this.interior[i2]) {
                            return false;
                        }
                        ++n2;
                        continue block0;
                    }
                    if (++n2 != sceneGraphPath.interior.length) continue;
                    return false;
                }
            }
            while (n2 < sceneGraphPath.interior.length) {
                if (sceneGraphPath.interior[n2] instanceof Link) {
                    return false;
                }
                ++n2;
            }
        } else if (this.interior != sceneGraphPath.interior) {
            return false;
        }
        return true;
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.root == null && this.interior == null && this.item == null) {
            return super.toString();
        }
        if (this.root != null) {
            stringBuffer.append(this.root + " : ");
        }
        if (this.interior != null) {
            for (int i2 = 0; i2 < this.interior.length; ++i2) {
                stringBuffer.append(this.interior[i2].getClass().getName());
                object = this.interior[i2].getUserData();
                if (object == null) {
                    stringBuffer.append(" : ");
                    continue;
                }
                stringBuffer.append(", " + object + " : ");
            }
        }
        if (this.item != null) {
            stringBuffer.append(this.item.getClass().getName());
            object = this.item.getUserData();
            if (object != null) {
                stringBuffer.append(", " + object);
            }
            try {
                if (this.item.getClass().getName().equals("javax.media.j3d.Shape3D")) {
                    stringBuffer.append(((Shape3D)this.item).getGeometry());
                }
            }
            catch (CapabilityNotSetException capabilityNotSetException) {
                // empty catch block
            }
        }
        stringBuffer.append("\nLocalToVworld Transform:\n" + this.transform);
        return new String(stringBuffer);
    }

    boolean validate() {
        int n2;
        NodeRetained nodeRetained = (NodeRetained)this.item.retained;
        Locale locale = nodeRetained.locale;
        if (this.root != null) {
            if (this.item.isLive() && locale != this.root) {
                return false;
            }
        } else {
            this.root = locale;
        }
        int n3 = n2 = this.interior == null ? 0 : this.interior.length;
        do {
            if (nodeRetained instanceof SharedGroupRetained) {
                if (this.interior == null) {
                    return false;
                }
                while (--n2 > 0 && !((SharedGroupRetained)nodeRetained).parents.contains(this.interior[n2].retained)) {
                }
                if (n2 < 0) {
                    return false;
                }
                nodeRetained = (NodeRetained)this.interior[n2].retained;
                continue;
            }
            nodeRetained = nodeRetained.parent;
        } while (nodeRetained != null);
        return true;
    }

    void getHashKey(HashKey hashKey) {
        if (this.interior != null) {
            hashKey.reset();
            hashKey.append(this.root.nodeId);
            for (int i2 = 0; i2 < this.interior.length; ++i2) {
                Node node = this.interior[i2];
                if (!node.isLive()) {
                    throw new RuntimeException(J3dI18N.getString("SceneGraphPath3"));
                }
                NodeRetained nodeRetained = (NodeRetained)node.retained;
                if (nodeRetained.nodeType != 9) continue;
                hashKey.append("+").append(nodeRetained.nodeId);
            }
        }
    }

    boolean validate(HashKey hashKey) {
        NodeRetained nodeRetained;
        if (this.root == null) {
            throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath2"));
        }
        if (this.item == null) {
            throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath10"));
        }
        if (!this.item.isLive()) {
            throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath3"));
        }
        try {
            this.getHashKey(hashKey);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException(runtimeException.getMessage());
        }
        NodeRetained nodeRetained2 = null;
        boolean bl = false;
        NodeRetained nodeRetained3 = (NodeRetained)this.item.retained;
        if (this.interior != null) {
            for (int i2 = this.interior.length - 1; i2 >= 0; --i2) {
                nodeRetained2 = (NodeRetained)this.interior[i2].retained;
                nodeRetained = nodeRetained3.parent;
                if (nodeRetained == null && nodeRetained3 instanceof SharedGroupRetained) {
                    if (((SharedGroupRetained)nodeRetained3).parents.contains(nodeRetained2)) {
                        nodeRetained = nodeRetained2;
                    } else {
                        throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
                    }
                }
                while (nodeRetained != nodeRetained2) {
                    if (nodeRetained == null) {
                        throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath11"));
                    }
                    if (nodeRetained instanceof SharedGroupRetained) {
                        if (((SharedGroupRetained)nodeRetained).parents.contains(nodeRetained2)) {
                            nodeRetained = nodeRetained2;
                            continue;
                        }
                        throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
                    }
                    nodeRetained = nodeRetained.parent;
                }
                nodeRetained3 = nodeRetained;
            }
        }
        if ((nodeRetained = nodeRetained3.parent) == null && nodeRetained3 instanceof SharedGroupRetained) {
            throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
        }
        while (nodeRetained != null) {
            if (nodeRetained instanceof LinkRetained) {
                throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
            }
            nodeRetained3 = nodeRetained;
            nodeRetained = nodeRetained.parent;
            if (nodeRetained != null || !(nodeRetained3 instanceof SharedGroupRetained)) continue;
            throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
        }
        Node node = (Node)nodeRetained3.source;
        if (!this.root.branchGroups.contains(node)) {
            throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath9"));
        }
        return true;
    }

    double getDistanceFrom(Point3d point3d) {
        return this.intersectPoint.distance(point3d);
    }

    double getDistance() {
        return this.pickDistance;
    }

    final void setIntersectPoint(Point3d point3d) {
        this.intersectPoint.set(point3d);
    }

    final void setIntersectPointDis(Point4d point4d) {
        this.intersectPoint.x = point4d.x;
        this.intersectPoint.y = point4d.y;
        this.intersectPoint.z = point4d.z;
        this.pickDistance = point4d.w;
    }

    final Point3d getIntersectPoint() {
        return this.intersectPoint;
    }
}

