/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.ShaderAttributeObjectRetained;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point2i;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Point4i;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple2i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple3i;
import javax.vecmath.Tuple4f;
import javax.vecmath.Tuple4i;

class ShaderAttributeValueRetained
extends ShaderAttributeObjectRetained {
    ShaderAttributeValueRetained() {
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            ShaderAttributeValueRetained shaderAttributeValueRetained = new ShaderAttributeValueRetained();
            shaderAttributeValueRetained.createObjectData(this.getValue());
            this.mirror = shaderAttributeValueRetained;
            this.mirror.source = this.source;
        }
        this.initMirrorObject();
    }

    int computeClassType(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            throw new ClassCastException(clazz + " -- array class not allowed");
        }
        for (int i2 = 0; i2 < classTable.length; ++i2) {
            if (!classTable[i2].isInstance(object)) continue;
            return i2;
        }
        throw new ClassCastException(clazz + " -- unrecognized class");
    }

    Class getBaseClass(int n2) {
        return classTable[n2];
    }

    ShaderAttributeObjectRetained.AttrWrapper createAttrWrapper(Object object, int n2) {
        ValueWrapper valueWrapper = null;
        switch (n2) {
            case 0: {
                valueWrapper = new IntegerWrapper();
                break;
            }
            case 1: {
                valueWrapper = new FloatWrapper();
                break;
            }
            case 2: {
                valueWrapper = new Tuple2iWrapper();
                break;
            }
            case 3: {
                valueWrapper = new Tuple2fWrapper();
                break;
            }
            case 4: {
                valueWrapper = new Tuple3iWrapper();
                break;
            }
            case 5: {
                valueWrapper = new Tuple3fWrapper();
                break;
            }
            case 6: {
                valueWrapper = new Tuple4iWrapper();
                break;
            }
            case 7: {
                valueWrapper = new Tuple4fWrapper();
                break;
            }
            case 8: {
                valueWrapper = new Matrix3fWrapper();
                break;
            }
            case 9: {
                valueWrapper = new Matrix4fWrapper();
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        valueWrapper.set(object);
        return valueWrapper;
    }

    static class FloatWrapper
    extends ValueWrapper {
        private float[] value = new float[1];

        FloatWrapper() {
        }

        void set(Object object) {
            this.value[0] = ((Float)object).floatValue();
        }

        Object get() {
            return new Float(this.value[0]);
        }

        Object getRef() {
            return this.value;
        }
    }

    static class IntegerWrapper
    extends ValueWrapper {
        private int[] value = new int[1];

        IntegerWrapper() {
        }

        void set(Object object) {
            this.value[0] = (Integer)object;
        }

        Object get() {
            return new Integer(this.value[0]);
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Matrix3fWrapper
    extends ValueWrapper {
        private float[] value = new float[9];

        Matrix3fWrapper() {
        }

        void set(Object object) {
            Matrix3f matrix3f = (Matrix3f)object;
            this.value[0] = matrix3f.m00;
            this.value[1] = matrix3f.m01;
            this.value[2] = matrix3f.m02;
            this.value[3] = matrix3f.m10;
            this.value[4] = matrix3f.m11;
            this.value[5] = matrix3f.m12;
            this.value[6] = matrix3f.m20;
            this.value[7] = matrix3f.m21;
            this.value[8] = matrix3f.m22;
        }

        Object get() {
            return new Matrix3f(this.value);
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Matrix4fWrapper
    extends ValueWrapper {
        private float[] value = new float[16];

        Matrix4fWrapper() {
        }

        void set(Object object) {
            Matrix4f matrix4f = (Matrix4f)object;
            this.value[0] = matrix4f.m00;
            this.value[1] = matrix4f.m01;
            this.value[2] = matrix4f.m02;
            this.value[3] = matrix4f.m03;
            this.value[4] = matrix4f.m10;
            this.value[5] = matrix4f.m11;
            this.value[6] = matrix4f.m12;
            this.value[7] = matrix4f.m13;
            this.value[8] = matrix4f.m20;
            this.value[9] = matrix4f.m21;
            this.value[10] = matrix4f.m22;
            this.value[11] = matrix4f.m23;
            this.value[12] = matrix4f.m30;
            this.value[13] = matrix4f.m31;
            this.value[14] = matrix4f.m32;
            this.value[15] = matrix4f.m33;
        }

        Object get() {
            return new Matrix4f(this.value);
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Tuple2fWrapper
    extends ValueWrapper {
        private float[] value = new float[2];

        Tuple2fWrapper() {
        }

        void set(Object object) {
            ((Tuple2f)object).get(this.value);
        }

        Object get() {
            return new Point2f(this.value);
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Tuple2iWrapper
    extends ValueWrapper {
        private int[] value = new int[2];

        Tuple2iWrapper() {
        }

        void set(Object object) {
            ((Tuple2i)object).get(this.value);
        }

        Object get() {
            return new Point2i(this.value);
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Tuple3fWrapper
    extends ValueWrapper {
        private float[] value = new float[3];

        Tuple3fWrapper() {
        }

        void set(Object object) {
            ((Tuple3f)object).get(this.value);
        }

        Object get() {
            return new Point3f(this.value);
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Tuple3iWrapper
    extends ValueWrapper {
        private int[] value = new int[3];

        Tuple3iWrapper() {
        }

        void set(Object object) {
            ((Tuple3i)object).get(this.value);
        }

        Object get() {
            return new Point3i(this.value);
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Tuple4fWrapper
    extends ValueWrapper {
        private float[] value = new float[4];

        Tuple4fWrapper() {
        }

        void set(Object object) {
            ((Tuple4f)object).get(this.value);
        }

        Object get() {
            return new Point4f(this.value);
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Tuple4iWrapper
    extends ValueWrapper {
        private int[] value = new int[4];

        Tuple4iWrapper() {
        }

        void set(Object object) {
            ((Tuple4i)object).get(this.value);
        }

        Object get() {
            return new Point4i(this.value);
        }

        Object getRef() {
            return this.value;
        }
    }

    static abstract class ValueWrapper
    extends ShaderAttributeObjectRetained.AttrWrapper {
        ValueWrapper() {
        }
    }
}

