/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.ShaderId;

abstract class ShaderRetained
extends NodeComponentRetained {
    int shadingLanguage;
    int shaderType;
    ShaderData[] shaderData;
    boolean compileErrorOccurred = false;
    Object resourceLock = new Object();

    ShaderRetained() {
    }

    void initializeShader(int n2, int n3) {
        this.shadingLanguage = n2;
        this.shaderType = n3;
    }

    int getShadingLanguage() {
        return this.shadingLanguage;
    }

    int getShaderType() {
        return this.shaderType;
    }

    void setLive(boolean bl, int n2) {
        super.setLive(bl, n2);
    }

    void clearLive(int n2) {
        super.clearLive(n2);
    }

    synchronized void updateMirrorObject(int n2, Object object) {
        System.err.println("Shader.updateMirrorObject not implemented yet!");
    }

    void handleFrequencyChange(int n2) {
        System.err.println("Shader.handleFrequencyChange not implemented yet!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createShaderData(int n2, long l2) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.shaderData == null) {
                this.shaderData = new ShaderData[n2 + 1];
            } else if (this.shaderData.length <= n2) {
                ShaderData[] shaderDataArray = new ShaderData[n2 + 1];
                System.arraycopy(this.shaderData, 0, shaderDataArray, 0, this.shaderData.length);
                this.shaderData = shaderDataArray;
            }
            if (this.shaderData[n2] == null) {
                this.shaderData[n2] = new ShaderData();
            } else if (this.shaderData[n2].getCtxTimeStamp() != l2) {
                this.shaderData[n2].reset();
            }
            this.shaderData[n2].setCtxTimeStamp(l2);
        }
    }

    class ShaderData {
        private long ctxTimeStamp;
        private ShaderId shaderId = null;
        private boolean compiled = false;

        ShaderData() {
        }

        void reset() {
            this.ctxTimeStamp = 0L;
            this.shaderId = null;
            this.compiled = false;
        }

        long getCtxTimeStamp() {
            return this.ctxTimeStamp;
        }

        void setCtxTimeStamp(long l2) {
            this.ctxTimeStamp = l2;
        }

        ShaderId getShaderId() {
            return this.shaderId;
        }

        void setShaderId(ShaderId shaderId) {
            this.shaderId = shaderId;
        }

        boolean isCompiled() {
            return this.compiled;
        }

        void setCompiled(boolean bl) {
            this.compiled = bl;
        }
    }
}

