/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Context;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.RenderBin;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture2DRetained;
import javax.media.j3d.Texture3D;
import javax.media.j3d.Texture3DRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureCubeMap;
import javax.media.j3d.TextureCubeMapRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;

abstract class TextureRetained
extends NodeComponentRetained {
    static final int ENABLE_CHANGED = 1;
    static final int COLOR_CHANGED = 2;
    static final int IMAGE_CHANGED = 4;
    static final int STATE_CHANGED = 8;
    static final int UPDATE_IMAGE = 16;
    static final int IMAGES_CHANGED = 32;
    static final int BASE_LEVEL_CHANGED = 64;
    static final int MAX_LEVEL_CHANGED = 128;
    static final int MIN_LOD_CHANGED = 256;
    static final int MAX_LOD_CHANGED = 512;
    static final int LOD_OFFSET_CHANGED = 1024;
    static final int MIN_FILTER = 0;
    static final int MAG_FILTER = 1;
    int boundaryWidth = 0;
    int boundaryModeS = 3;
    int boundaryModeT = 3;
    int minFilter = 2;
    int magFilter = 2;
    int isDirty = 65535;
    Color4f boundaryColor = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    int objectId = -1;
    int mipmapMode = 1;
    int format = 5;
    int width = 1;
    int height = 1;
    private boolean widthOrHeightIsNPOT = false;
    ImageComponentRetained[][] images;
    int maxLevels = 0;
    private int maxMipMapLevels = 0;
    int numFaces = 1;
    int baseLevel = 0;
    int maximumLevel = 0;
    float minimumLod = -1000.0f;
    float maximumLod = 1000.0f;
    Point3f lodOffset = null;
    private boolean useAsRaster = false;
    boolean enable = true;
    boolean userSpecifiedEnable = true;
    boolean isAlphaNeedUpdate = false;
    int numSharpenTextureFuncPts = 0;
    float[] sharpenTextureFuncPts = null;
    float[] filter4FuncPts = null;
    int anisotropicFilterMode = 0;
    float anisotropicFilterDegree = 1.0f;
    int resourceCreationMask = 0;
    int resourceUpdatedMask = 0;
    int resourceLodUpdatedMask = 0;
    int resourceInReloadList = 0;
    ArrayList[][] imageUpdateInfo;
    int[] imageUpdatePruneMask;
    private HashMap<RenderBin, Integer> textureBinRefCount = new HashMap();
    private int texTimestamp = 0;
    Object resourceLock = new Object();

    TextureRetained() {
    }

    private static boolean isPowerOfTwo(int n2) {
        return (n2 & n2 - 1) == 0;
    }

    void initialize(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.mipmapMode = n7;
        this.format = n2;
        this.width = n3;
        this.height = n5;
        this.boundaryWidth = n8;
        if (!TextureRetained.isPowerOfTwo(n3) || !TextureRetained.isPowerOfTwo(n5)) {
            this.widthOrHeightIsNPOT = true;
        }
        this.maxMipMapLevels = n4 > n6 ? n4 + 1 : n6 + 1;
        if (n7 != 1) {
            this.baseLevel = 0;
            this.maximumLevel = this.maxMipMapLevels - 1;
            this.maxLevels = this.maxMipMapLevels;
        } else {
            this.baseLevel = 0;
            this.maximumLevel = 0;
            this.maxLevels = 1;
        }
        this.images = new ImageComponentRetained[this.numFaces][this.maxLevels];
        for (int i2 = 0; i2 < this.numFaces; ++i2) {
            for (int i3 = 0; i3 < this.maxLevels; ++i3) {
                this.images[i2][i3] = null;
            }
        }
    }

    final int getFormat() {
        return this.format;
    }

    final int getWidth() {
        return this.width;
    }

    final int getHeight() {
        return this.height;
    }

    final int numMipMapLevels() {
        return this.maximumLevel - this.baseLevel + 1;
    }

    final void initBoundaryModeS(int n2) {
        this.boundaryModeS = n2;
    }

    final int getBoundaryModeS() {
        return this.boundaryModeS;
    }

    final void initBoundaryModeT(int n2) {
        this.boundaryModeT = n2;
    }

    final int getBoundaryModeT() {
        return this.boundaryModeT;
    }

    final int getBoundaryWidth() {
        return this.boundaryWidth;
    }

    final void initMinFilter(int n2) {
        this.minFilter = n2;
    }

    final int getMinFilter() {
        return this.minFilter;
    }

    final void initMagFilter(int n2) {
        this.magFilter = n2;
    }

    final int getMagFilter() {
        return this.magFilter;
    }

    void initImage(int n2, ImageComponent imageComponent) {
        this.checkImageSize(n2, imageComponent);
        if (this.images == null) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureRetained0"));
        }
        if (this.source instanceof Texture2D) {
            if (imageComponent instanceof ImageComponent3D) {
                throw new IllegalArgumentException(J3dI18N.getString("Texture8"));
            }
        } else if (imageComponent instanceof ImageComponent2D) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture14"));
        }
        if (this.source.isLive()) {
            if (this.images[0][n2] != null) {
                this.images[0][n2].clearLive(this.refCount);
            }
            if (imageComponent != null) {
                ((ImageComponentRetained)imageComponent.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        this.images[0][n2] = imageComponent != null ? (ImageComponentRetained)imageComponent.retained : null;
    }

    final void checkImageSize(int n2, ImageComponent imageComponent) {
        if (imageComponent != null) {
            int n3 = ((ImageComponentRetained)imageComponent.retained).width;
            int n4 = ((ImageComponentRetained)imageComponent.retained).height;
            int n5 = this.width;
            int n6 = this.height;
            for (int i2 = 0; i2 < n2; ++i2) {
                n5 >>= 1;
                n6 >>= 1;
            }
            if (n5 < 1) {
                n5 = 1;
            }
            if (n6 < 1) {
                n6 = 1;
            }
            if (n5 != n3 - 2 * this.boundaryWidth || n6 != n4 - 2 * this.boundaryWidth) {
                throw new IllegalArgumentException(J3dI18N.getString("TextureRetained1"));
            }
        }
    }

    final void checkSizes(ImageComponentRetained[] imageComponentRetainedArray) {
        if (imageComponentRetainedArray != null) {
            int n2 = this.height;
            int n3 = this.width;
            for (int i2 = 0; i2 < imageComponentRetainedArray.length; ++i2) {
                int n4 = imageComponentRetainedArray[i2].width;
                int n5 = imageComponentRetainedArray[i2].height;
                assert (n3 == n4 - 2 * this.boundaryWidth && n2 == n5 - 2 * this.boundaryWidth);
                n2 /= 2;
                if ((n3 /= 2) < 1) {
                    n3 = 1;
                }
                if (n2 >= 1) continue;
                n2 = 1;
            }
        }
    }

    final void setImage(int n2, ImageComponent imageComponent) {
        this.initImage(n2, imageComponent);
        Object[] objectArray = new Object[]{new Integer(n2), imageComponent, new Integer(0)};
        this.sendMessage(4, objectArray);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            if (imageComponent != null && n2 >= this.baseLevel && n2 <= this.maximumLevel) {
                ImageComponentRetained imageComponentRetained = (ImageComponentRetained)imageComponent.retained;
                if (imageComponentRetained.isByReference()) {
                    if (imageComponentRetained.getRefImage(0) == null) {
                        this.enable = false;
                    }
                } else if (imageComponentRetained.getImageData(this.isUseAsRaster()).get() == null) {
                    this.enable = false;
                }
                if (!this.enable) {
                    this.sendMessage(1, Boolean.FALSE);
                }
            }
        }
    }

    void initImages(ImageComponent[] imageComponentArray) {
        if (imageComponentArray.length != this.maxLevels) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture20"));
        }
        for (int i2 = 0; i2 < imageComponentArray.length; ++i2) {
            this.initImage(i2, imageComponentArray[i2]);
        }
    }

    final void setImages(ImageComponent[] imageComponentArray) {
        int n2;
        this.initImages(imageComponentArray);
        ImageComponent[] imageComponentArray2 = new ImageComponent[imageComponentArray.length];
        for (n2 = 0; n2 < imageComponentArray.length; ++n2) {
            imageComponentArray2[n2] = imageComponentArray[n2];
        }
        Object[] objectArray = new Object[]{imageComponentArray2, new Integer(0)};
        this.sendMessage(32, objectArray);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            for (n2 = this.baseLevel; n2 <= this.maximumLevel && this.enable; ++n2) {
                if (imageComponentArray[n2] == null) continue;
                ImageComponentRetained imageComponentRetained = (ImageComponentRetained)imageComponentArray[n2].retained;
                if (imageComponentRetained.isByReference()) {
                    if (imageComponentRetained.getRefImage(0) != null) continue;
                    this.enable = false;
                    continue;
                }
                if (imageComponentRetained.getImageData(this.isUseAsRaster()).get() != null) continue;
                this.enable = false;
            }
            if (!this.enable) {
                this.sendMessage(1, Boolean.FALSE);
            }
        }
    }

    final ImageComponent getImage(int n2) {
        return this.images != null && this.images[0][n2] != null ? (ImageComponent)this.images[0][n2].source : null;
    }

    final ImageComponent[] getImages() {
        if (this.images == null) {
            return null;
        }
        ImageComponent[] imageComponentArray = new ImageComponent[this.images[0].length];
        for (int i2 = 0; i2 < this.images[0].length; ++i2) {
            imageComponentArray[i2] = this.images[0][i2] != null ? (ImageComponent)this.images[0][i2].source : null;
        }
        return imageComponentArray;
    }

    final void initMipMapMode(int n2) {
        if (this.mipmapMode == n2) {
            return;
        }
        int n3 = this.maxLevels;
        this.mipmapMode = n2;
        if (n2 != 1) {
            this.maxLevels = this.maxMipMapLevels;
        } else {
            this.baseLevel = 0;
            this.maximumLevel = 0;
            this.maxLevels = 1;
        }
        ImageComponentRetained[][] imageComponentRetainedArray = new ImageComponentRetained[this.numFaces][this.maxLevels];
        if (n3 < this.maxLevels) {
            for (int i2 = 0; i2 < this.numFaces; ++i2) {
                int n4;
                for (n4 = 0; n4 < n3; ++n4) {
                    imageComponentRetainedArray[i2][n4] = this.images[i2][n4];
                }
                for (n4 = n3; n4 < this.maxLevels; ++n4) {
                    imageComponentRetainedArray[i2][n4] = null;
                }
            }
        } else {
            for (int i3 = 0; i3 < this.numFaces; ++i3) {
                for (int i4 = 0; i4 < this.maxLevels; ++i4) {
                    imageComponentRetainedArray[i3][i4] = this.images[i3][i4];
                }
            }
        }
        this.images = imageComponentRetainedArray;
    }

    final int getMipMapMode() {
        return this.mipmapMode;
    }

    final void initEnable(boolean bl) {
        this.userSpecifiedEnable = bl;
    }

    final void setEnable(boolean bl) {
        this.initEnable(bl);
        if (bl == this.enable) {
            return;
        }
        this.enable = bl;
        for (int i2 = 0; i2 < this.numFaces && this.enable; ++i2) {
            for (int i3 = this.baseLevel; i3 <= this.maximumLevel && this.enable; ++i3) {
                if (this.images[i2][i3].isByReference()) {
                    if (this.images[i2][i3].getRefImage(0) != null) continue;
                    this.enable = false;
                    continue;
                }
                if (this.images[i2][i3].getImageData(this.isUseAsRaster()).get() != null) continue;
                this.enable = false;
            }
        }
        this.sendMessage(1, this.enable ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getEnable() {
        return this.userSpecifiedEnable;
    }

    final void initBaseLevel(int n2) {
        if (n2 < 0 || n2 > this.maximumLevel) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture36"));
        }
        this.baseLevel = n2;
    }

    final void setBaseLevel(int n2) {
        if (n2 == this.baseLevel) {
            return;
        }
        this.initBaseLevel(n2);
        this.sendMessage(64, new Integer(n2));
    }

    final int getBaseLevel() {
        return this.baseLevel;
    }

    final void initMaximumLevel(int n2) {
        if (n2 < this.baseLevel || n2 >= this.maxMipMapLevels) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture37"));
        }
        if (this.mipmapMode == 1 && n2 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture48"));
        }
        this.maximumLevel = n2;
    }

    final void setMaximumLevel(int n2) {
        if (n2 == this.maximumLevel) {
            return;
        }
        this.initMaximumLevel(n2);
        this.sendMessage(128, new Integer(n2));
    }

    final int getMaximumLevel() {
        return this.maximumLevel;
    }

    final void initMinimumLOD(float f2) {
        if (f2 > this.maximumLod) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture42"));
        }
        this.minimumLod = f2;
    }

    final void setMinimumLOD(float f2) {
        this.initMinimumLOD(f2);
        this.sendMessage(256, new Float(f2));
    }

    final float getMinimumLOD() {
        return this.minimumLod;
    }

    final void initMaximumLOD(float f2) {
        if (f2 < this.minimumLod) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture42"));
        }
        this.maximumLod = f2;
    }

    final void setMaximumLOD(float f2) {
        this.initMaximumLOD(f2);
        this.sendMessage(512, new Float(f2));
    }

    final float getMaximumLOD() {
        return this.maximumLod;
    }

    final void initLodOffset(float f2, float f3, float f4) {
        if (this.lodOffset == null) {
            this.lodOffset = new Point3f(f2, f3, f4);
        } else {
            this.lodOffset.set(f2, f3, f4);
        }
    }

    final void setLodOffset(float f2, float f3, float f4) {
        this.initLodOffset(f2, f3, f4);
        this.sendMessage(1024, new Point3f(f2, f3, f4));
    }

    final void getLodOffset(Tuple3f tuple3f) {
        if (this.lodOffset == null) {
            tuple3f.set(0.0f, 0.0f, 0.0f);
        } else {
            tuple3f.set(this.lodOffset);
        }
    }

    final void initBoundaryColor(Color4f color4f) {
        this.boundaryColor.set(color4f);
    }

    final void initBoundaryColor(float f2, float f3, float f4, float f5) {
        this.boundaryColor.set(f2, f3, f4, f5);
    }

    final void getBoundaryColor(Color4f color4f) {
        color4f.set(this.boundaryColor);
    }

    final void initAnisotropicFilterMode(int n2) {
        this.anisotropicFilterMode = n2;
    }

    final int getAnisotropicFilterMode() {
        return this.anisotropicFilterMode;
    }

    final void initAnisotropicFilterDegree(float f2) {
        this.anisotropicFilterDegree = f2;
    }

    final float getAnisotropicFilterDegree() {
        return this.anisotropicFilterDegree;
    }

    final void initSharpenTextureFunc(float[] fArray, float[] fArray2) {
        if (fArray == null) {
            this.sharpenTextureFuncPts = null;
            this.numSharpenTextureFuncPts = 0;
        } else {
            this.numSharpenTextureFuncPts = fArray.length;
            if (this.sharpenTextureFuncPts == null || this.sharpenTextureFuncPts.length != fArray.length * 2) {
                this.sharpenTextureFuncPts = new float[fArray.length * 2];
            }
            int n2 = 0;
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                this.sharpenTextureFuncPts[n2++] = fArray[i2];
                this.sharpenTextureFuncPts[n2++] = fArray2[i2];
            }
        }
    }

    final void initSharpenTextureFunc(Point2f[] point2fArray) {
        if (point2fArray == null) {
            this.sharpenTextureFuncPts = null;
            this.numSharpenTextureFuncPts = 0;
        } else {
            this.numSharpenTextureFuncPts = point2fArray.length;
            if (this.sharpenTextureFuncPts == null || this.sharpenTextureFuncPts.length != point2fArray.length * 2) {
                this.sharpenTextureFuncPts = new float[point2fArray.length * 2];
            }
            int n2 = 0;
            for (int i2 = 0; i2 < point2fArray.length; ++i2) {
                this.sharpenTextureFuncPts[n2++] = point2fArray[i2].x;
                this.sharpenTextureFuncPts[n2++] = point2fArray[i2].y;
            }
        }
    }

    final void initSharpenTextureFunc(float[] fArray) {
        if (fArray == null) {
            this.sharpenTextureFuncPts = null;
            this.numSharpenTextureFuncPts = 0;
        } else {
            this.numSharpenTextureFuncPts = fArray.length / 2;
            if (this.sharpenTextureFuncPts == null || this.sharpenTextureFuncPts.length != fArray.length) {
                this.sharpenTextureFuncPts = new float[fArray.length];
            }
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                this.sharpenTextureFuncPts[i2] = fArray[i2];
            }
        }
    }

    final int getSharpenTextureFuncPointsCount() {
        return this.numSharpenTextureFuncPts;
    }

    final void getSharpenTextureFunc(float[] fArray, float[] fArray2) {
        if (this.sharpenTextureFuncPts != null) {
            int n2 = 0;
            for (int i2 = 0; i2 < this.numSharpenTextureFuncPts; ++i2) {
                fArray[i2] = this.sharpenTextureFuncPts[n2++];
                fArray2[i2] = this.sharpenTextureFuncPts[n2++];
            }
        }
    }

    final void getSharpenTextureFunc(Point2f[] point2fArray) {
        if (this.sharpenTextureFuncPts != null) {
            int n2 = 0;
            for (int i2 = 0; i2 < this.numSharpenTextureFuncPts; ++i2) {
                point2fArray[i2].x = this.sharpenTextureFuncPts[n2++];
                point2fArray[i2].y = this.sharpenTextureFuncPts[n2++];
            }
        }
    }

    final void initFilter4Func(float[] fArray) {
        if (fArray == null) {
            this.filter4FuncPts = null;
        } else {
            if (this.filter4FuncPts == null || this.filter4FuncPts.length != fArray.length) {
                this.filter4FuncPts = new float[fArray.length];
            }
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                this.filter4FuncPts[i2] = fArray[i2];
            }
        }
    }

    final int getFilter4FuncPointsCount() {
        if (this.filter4FuncPts == null) {
            return 0;
        }
        return this.filter4FuncPts.length;
    }

    final void getFilter4Func(float[] fArray) {
        if (this.filter4FuncPts != null) {
            for (int i2 = 0; i2 < this.filter4FuncPts.length; ++i2) {
                fArray[i2] = this.filter4FuncPts[i2];
            }
        }
    }

    final float[] getSharpenTextureFunc() {
        return this.sharpenTextureFuncPts;
    }

    final float[] getFilter4Func() {
        return this.filter4FuncPts;
    }

    void setLive(boolean bl, int n2) {
        int n3;
        int n4;
        this.enable = this.userSpecifiedEnable;
        super.doSetLive(bl, n2);
        if (this.images != null) {
            for (n4 = 0; n4 < this.numFaces; ++n4) {
                for (n3 = 0; n3 < this.maxLevels; ++n3) {
                    if (this.images[n4][n3] == null) {
                        throw new IllegalArgumentException(J3dI18N.getString("TextureRetained3") + n3);
                    }
                    this.images[n4][n3].setLive(bl, n2);
                }
            }
        }
        if (this.images != null) {
            for (n4 = 0; n4 < this.numFaces; ++n4) {
                this.checkSizes(this.images[n4]);
            }
        }
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 15;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(16);
        j3dMessage.args[2] = null;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        if (this.userSpecifiedEnable) {
            if (this.images != null) {
                for (n3 = 0; n3 < this.numFaces && this.enable; ++n3) {
                    for (int i2 = this.baseLevel; i2 <= this.maximumLevel && this.enable; ++i2) {
                        if (this.images[n3][i2].isByReference()) {
                            if (this.images[n3][i2].getRefImage(0) != null) continue;
                            this.enable = false;
                            continue;
                        }
                        if (this.images[n3][i2].getImageData(this.isUseAsRaster()).get() != null) continue;
                        this.enable = false;
                    }
                }
            } else {
                this.enable = false;
            }
            if (!this.enable) {
                this.sendMessage(1, Boolean.FALSE);
            }
        }
        super.markAsLive();
    }

    void clearLive(int n2) {
        super.clearLive(n2);
        if (this.images != null) {
            for (int i2 = 0; i2 < this.numFaces; ++i2) {
                for (int i3 = 0; i3 < this.maxLevels; ++i3) {
                    this.images[i2][i3].clearLive(n2);
                    this.images[i2][i3].removeUser(this.mirror);
                }
            }
        }
    }

    void bindTexture(Context context, int n2, boolean bl) {
        Pipeline.getPipeline().bindTexture2D(context, n2, bl);
    }

    void updateTextureBoundary(Context context, int n2, int n3, float f2, float f3, float f4, float f5) {
        Pipeline.getPipeline().updateTexture2DBoundary(context, n2, n3, f2, f3, f4, f5);
    }

    void updateTextureFilterModes(Context context, int n2, int n3) {
        Pipeline.getPipeline().updateTexture2DFilterModes(context, n2, n3);
    }

    void updateTextureSharpenFunc(Context context, int n2, float[] fArray) {
        Pipeline.getPipeline().updateTexture2DSharpenFunc(context, n2, fArray);
    }

    void updateTextureFilter4Func(Context context, int n2, float[] fArray) {
        Pipeline.getPipeline().updateTexture2DFilter4Func(context, n2, fArray);
    }

    void updateTextureAnisotropicFilter(Context context, float f2) {
        Pipeline.getPipeline().updateTexture2DAnisotropicFilter(context, f2);
    }

    void updateTextureLodRange(Context context, int n2, int n3, float f2, float f3) {
        Pipeline.getPipeline().updateTexture2DLodRange(context, n2, n3, f2, f3);
    }

    void updateTextureLodOffset(Context context, float f2, float f3, float f4) {
        Pipeline.getPipeline().updateTexture2DLodOffset(context, f2, f3, f4);
    }

    int getTextureId() {
        return VirtualUniverse.mc.getTexture2DId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeTextureId(int n2) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.objectId == n2) {
                this.objectId = -1;
                VirtualUniverse.mc.freeTexture2DId(n2);
            }
        }
    }

    private boolean isEnabled(Canvas3D canvas3D) {
        if (this.widthOrHeightIsNPOT && !this.isUseAsRaster() && (canvas3D.textureExtendedFeatures & 0x8000) == 0) {
            return false;
        }
        return this.enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindTexture(Canvas3D canvas3D) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.objectId == -1) {
                this.objectId = this.getTextureId();
            }
            canvas3D.addTextureResource(this.objectId, this);
        }
        this.bindTexture(canvas3D.ctx, this.objectId, this.isEnabled(canvas3D));
    }

    void updateTextureDimensions(Canvas3D canvas3D) {
        if (this.images[0][0] != null) {
            this.updateTextureImage(canvas3D, 0, this.maxLevels, 0, this.format, this.images[0][0].getImageFormatTypeIntValue(false), this.width, this.height, this.boundaryWidth, this.images[0][0].getImageDataTypeIntValue(), null);
        }
    }

    void updateTextureLOD(Canvas3D canvas3D) {
        if ((canvas3D.textureExtendedFeatures & 0x1000) != 0) {
            int n2 = 0;
            n2 = this.mipmapMode == 1 ? this.maxMipMapLevels : this.maximumLevel;
            this.updateTextureLodRange(canvas3D.ctx, this.baseLevel, n2, this.minimumLod, this.maximumLod);
        }
        if (this.lodOffset != null && (canvas3D.textureExtendedFeatures & 0x2000) != 0) {
            this.updateTextureLodOffset(canvas3D.ctx, this.lodOffset.x, this.lodOffset.y, this.lodOffset.z);
        }
    }

    void updateTextureBoundary(Canvas3D canvas3D) {
        this.updateTextureBoundary(canvas3D.ctx, this.boundaryModeS, this.boundaryModeT, this.boundaryColor.x, this.boundaryColor.y, this.boundaryColor.z, this.boundaryColor.w);
    }

    void updateTextureFields(Canvas3D canvas3D) {
        int n2 = this.magFilter;
        int n3 = this.minFilter;
        if (n2 >= 9 && n2 <= 11) {
            if ((canvas3D.textureExtendedFeatures & 0x100) != 0) {
                this.updateTextureSharpenFunc(canvas3D.ctx, this.numSharpenTextureFuncPts, this.sharpenTextureFuncPts);
            } else {
                n2 = 3;
            }
        } else if (n2 >= 6 && n2 <= 8 && (canvas3D.textureExtendedFeatures & 0x200) == 0) {
            n2 = 3;
        }
        if (n3 == 12 || n2 == 12) {
            boolean bl = false;
            if ((canvas3D.textureExtendedFeatures & 0x400) != 0) {
                if (this.filter4FuncPts == null) {
                    bl = true;
                } else {
                    this.updateTextureFilter4Func(canvas3D.ctx, this.filter4FuncPts.length, this.filter4FuncPts);
                }
            } else {
                bl = true;
            }
            if (bl) {
                if (n3 == 12) {
                    n3 = 3;
                }
                if (n2 == 12) {
                    n2 = 3;
                }
            }
        }
        if (this.mipmapMode == 1 && (canvas3D.textureExtendedFeatures & 0x10000) == 0) {
            if (n3 == 1 || n3 == 5) {
                n3 = 3;
            } else if (n3 == 4) {
                n3 = 2;
            }
        }
        this.updateTextureFilterModes(canvas3D.ctx, n3, n2);
        if ((canvas3D.textureExtendedFeatures & 0x800) != 0) {
            if (this.anisotropicFilterMode == 0) {
                this.updateTextureAnisotropicFilter(canvas3D.ctx, 1.0f);
            } else {
                this.updateTextureAnisotropicFilter(canvas3D.ctx, this.anisotropicFilterDegree);
            }
        }
        this.updateTextureBoundary(canvas3D);
    }

    void updateTextureImage(Canvas3D canvas3D, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Object object) {
        Pipeline.getPipeline().updateTexture2DImage(canvas3D.ctx, n3, n4, n5, n6, n7, n8, n9, n10, object, this.useAutoMipMapGeneration(canvas3D));
    }

    void updateTextureSubImage(Canvas3D canvas3D, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, Object object) {
        Pipeline.getPipeline().updateTexture2DSubImage(canvas3D.ctx, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, object, this.useAutoMipMapGeneration(canvas3D));
    }

    void reloadTextureImage(Canvas3D canvas3D, int n2, int n3, ImageComponentRetained imageComponentRetained, int n4) {
        boolean bl = this.isUseAsRaster();
        ImageComponentRetained.ImageData imageData = imageComponentRetained.getImageData(bl);
        assert (imageData != null);
        this.updateTextureImage(canvas3D, n2, n4, n3, this.format, imageComponentRetained.getImageFormatTypeIntValue(bl), imageData.getWidth(), imageData.getHeight(), this.boundaryWidth, imageComponentRetained.getImageDataTypeIntValue(), imageData.get());
        if (imageData == null) {
            int n5 = 0;
            int n6 = 0;
            int n7 = imageComponentRetained.width;
            int n8 = imageComponentRetained.height;
            int n9 = imageComponentRetained.tilew;
            int n10 = imageComponentRetained.tileh;
            int n11 = n9;
            int n12 = n10;
            if (n7 < n11) {
                n11 = n7;
            }
            if (n8 < n12) {
                n12 = n8;
            }
            int n13 = n11;
            int n14 = imageComponentRetained.tilew - n11;
            int n15 = imageComponentRetained.tileh - n12;
            for (int i2 = 0; i2 < imageComponentRetained.numYTiles; ++i2) {
                n5 = 0;
                n7 = this.width;
                n11 = n13;
                n14 = imageComponentRetained.tilew - n11;
                for (int i3 = 0; i3 < imageComponentRetained.numXTiles; ++i3) {
                    Raster raster = ((RenderedImage)imageComponentRetained.getRefImage(0)).getTile(i3, i2);
                    byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
                    this.updateTextureSubImage(canvas3D, n2, n3, n5, n6, this.format, imageComponentRetained.getImageFormatTypeIntValue(false), n14, n15, imageComponentRetained.tilew, n11, n12, 4096, byArray);
                    n5 += n11;
                    n14 = 0;
                    n11 = (n7 -= n11) < imageComponentRetained.tilew ? n7 : imageComponentRetained.tilew;
                }
                n6 += n12;
                n15 = 0;
                n12 = (n8 -= n12) < imageComponentRetained.tileh ? n8 : imageComponentRetained.tileh;
            }
        }
    }

    void reloadTextureSubImage(Canvas3D canvas3D, int n2, int n3, ImageComponentUpdateInfo imageComponentUpdateInfo, ImageComponentRetained imageComponentRetained) {
        int n4 = imageComponentUpdateInfo.x;
        int n5 = imageComponentUpdateInfo.y;
        int n6 = imageComponentUpdateInfo.width;
        int n7 = imageComponentUpdateInfo.height;
        ImageComponentRetained.ImageData imageData = imageComponentRetained.getImageData(this.isUseAsRaster());
        if (imageData != null) {
            int n8 = n4;
            int n9 = n5;
            if (!imageComponentRetained.yUp) {
                n9 = imageComponentRetained.height - n9 - n7;
            }
            this.updateTextureSubImage(canvas3D, n2, n3, n8, n9, this.format, imageComponentRetained.getImageFormatTypeIntValue(false), n8, n9, imageComponentRetained.width, n6, n7, imageComponentRetained.getImageDataTypeIntValue(), imageData.get());
        } else {
            assert (false);
            int n10 = n4;
            int n11 = n5;
            float f2 = (float)n10 / (float)imageComponentRetained.tilew;
            int n12 = f2 < 0.0f ? (int)(f2 - 1.0f) : (int)f2;
            f2 = (float)n11 / (float)imageComponentRetained.tileh;
            int n13 = f2 < 0.0f ? (int)(f2 - 1.0f) : (int)f2;
            int n14 = n12 * imageComponentRetained.tilew;
            int n15 = n13 * imageComponentRetained.tilew;
            int n16 = n14 + imageComponentRetained.tilew - n10;
            int n17 = n15 + imageComponentRetained.tileh - n11;
            if (n16 > n6) {
                n16 = n6;
            }
            if (n17 > n7) {
                n17 = n7;
            }
            int n18 = n16;
            int n19 = n6;
            int n20 = n7;
            int n21 = n10 - n14;
            int n22 = n11 - n15;
            int n23 = (n6 + n21) / imageComponentRetained.tilew;
            int n24 = (n7 + n22) / imageComponentRetained.tileh;
            if ((float)(n6 + n21) % (float)imageComponentRetained.tilew > 0.0f) {
                ++n23;
            }
            if ((float)(n7 + n22) % (float)imageComponentRetained.tileh > 0.0f) {
                ++n24;
            }
            int n25 = n4;
            int n26 = n5;
            for (int i2 = n13; i2 < n13 + n24; ++i2) {
                n19 = n6;
                n16 = n18;
                n21 = n10 - n14;
                for (int i3 = n12; i3 < n12 + n23; ++i3) {
                    Raster raster = ((RenderedImage)imageComponentRetained.getRefImage(0)).getTile(i3, i2);
                    byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
                    this.updateTextureSubImage(canvas3D, n2, n3, n25, n26, this.format, imageComponentRetained.getImageFormatTypeIntValue(false), n21, n22, imageComponentRetained.tilew, n16, n17, 4096, byArray);
                    n25 += n16;
                    n21 = 0;
                    n16 = (n19 -= n16) < imageComponentRetained.tilew ? n19 : imageComponentRetained.tilew;
                }
                n26 += n17;
                n22 = 0;
                n17 = (n20 -= n17) < imageComponentRetained.tileh ? n20 : imageComponentRetained.tileh;
            }
        }
    }

    void reloadTexture(Canvas3D canvas3D) {
        int n2;
        int n3;
        if ((canvas3D.textureExtendedFeatures & 0x1000) == 0) {
            n3 = 0;
            n2 = this.maxLevels - 1;
        } else {
            n3 = this.baseLevel;
            n2 = this.maximumLevel;
        }
        if (n3 != 0) {
            this.updateTextureDimensions(canvas3D);
        }
        for (int i2 = 0; i2 < this.numFaces; ++i2) {
            for (int i3 = n3; i3 <= n2; ++i3) {
                ImageComponentRetained imageComponentRetained = this.images[i2][i3];
                if (imageComponentRetained == null) continue;
                imageComponentRetained.evaluateExtensions(canvas3D);
                this.reloadTextureImage(canvas3D, i2, i3, imageComponentRetained, this.maxLevels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTexture(Canvas3D canvas3D, int n2) {
        for (int i2 = 0; i2 < this.numFaces; ++i2) {
            for (int i3 = this.baseLevel; i3 <= this.maximumLevel; ++i3) {
                if (this.imageUpdateInfo[i2][i3] == null) continue;
                for (int i4 = 0; i4 < this.imageUpdateInfo[i2][i3].size(); ++i4) {
                    ImageComponentUpdateInfo imageComponentUpdateInfo = (ImageComponentUpdateInfo)this.imageUpdateInfo[i2][i3].get(i4);
                    Object object = this.resourceLock;
                    synchronized (object) {
                        if ((imageComponentUpdateInfo.updateMask & n2) == 0) {
                            continue;
                        }
                        imageComponentUpdateInfo.updateMask &= ~n2;
                        if ((imageComponentUpdateInfo.updateMask & this.resourceCreationMask) == 0) {
                            imageComponentUpdateInfo.updateMask = 0;
                            if (this.imageUpdatePruneMask == null) {
                                this.imageUpdatePruneMask = new int[this.numFaces];
                            }
                            this.imageUpdatePruneMask[i2] = 1 << i3;
                        }
                    }
                    if (imageComponentUpdateInfo.entireImage) {
                        this.reloadTextureImage(canvas3D, i2, i3, this.images[i2][i3], this.maxLevels);
                        continue;
                    }
                    this.reloadTextureSubImage(canvas3D, i2, i3, imageComponentUpdateInfo, this.images[i2][i3]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadTextureSharedContext(Canvas3D canvas3D) {
        if (!this.isEnabled(canvas3D)) {
            return;
        }
        this.bindTexture(canvas3D);
        this.updateTextureFields(canvas3D);
        this.updateTextureLOD(canvas3D);
        this.reloadTexture(canvas3D);
        Object object = this.resourceLock;
        synchronized (object) {
            this.resourceCreationMask |= canvas3D.screen.renderer.rendererBit;
            this.resourceUpdatedMask |= canvas3D.screen.renderer.rendererBit;
            this.resourceLodUpdatedMask |= canvas3D.screen.renderer.rendererBit;
            this.resourceInReloadList &= ~canvas3D.screen.renderer.rendererBit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateNative(Canvas3D canvas3D) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.bindTexture(canvas3D);
        if (!this.isEnabled(canvas3D)) {
            return;
        }
        if (canvas3D.useSharedCtx && canvas3D.screen.renderer.sharedCtx != null) {
            if ((this.resourceCreationMask & canvas3D.screen.renderer.rendererBit) == 0) {
                bl = true;
            } else {
                if ((this.resourceUpdatedMask & canvas3D.screen.renderer.rendererBit) == 0 && this.imageUpdateInfo != null) {
                    bl2 = true;
                }
                if ((this.resourceLodUpdatedMask & canvas3D.screen.renderer.rendererBit) == 0) {
                    bl3 = true;
                }
            }
            if (bl || bl2 || bl3) {
                canvas3D.makeCtxCurrent(canvas3D.screen.renderer.sharedCtx);
                this.bindTexture(canvas3D);
            }
        } else if ((this.resourceCreationMask & canvas3D.canvasBit) == 0) {
            bl = true;
        } else {
            if ((this.resourceUpdatedMask & canvas3D.canvasBit) == 0 && this.imageUpdateInfo != null) {
                bl2 = true;
            }
            if ((this.resourceLodUpdatedMask & canvas3D.canvasBit) == 0) {
                bl3 = true;
            }
        }
        if (VirtualUniverse.mc.isD3D()) {
            if (this.texTimestamp != VirtualUniverse.mc.resendTexTimestamp) {
                this.texTimestamp = VirtualUniverse.mc.resendTexTimestamp;
                bl = true;
            }
            if (!bl) {
                this.updateTextureFields(canvas3D);
            }
        }
        if (bl) {
            this.updateTextureFields(canvas3D);
            this.updateTextureLOD(canvas3D);
            this.reloadTexture(canvas3D);
            if (canvas3D.useSharedCtx) {
                canvas3D.makeCtxCurrent(canvas3D.ctx);
                Object object = this.resourceLock;
                synchronized (object) {
                    this.resourceCreationMask |= canvas3D.screen.renderer.rendererBit;
                    this.resourceUpdatedMask |= canvas3D.screen.renderer.rendererBit;
                    this.resourceLodUpdatedMask |= canvas3D.screen.renderer.rendererBit;
                }
            } else {
                Object object = this.resourceLock;
                synchronized (object) {
                    this.resourceCreationMask |= canvas3D.canvasBit;
                    this.resourceUpdatedMask |= canvas3D.canvasBit;
                    this.resourceLodUpdatedMask |= canvas3D.canvasBit;
                }
            }
        } else if (bl3 || bl2) {
            if (bl3) {
                this.updateTextureLOD(canvas3D);
            }
            if (bl2) {
                int n2 = 0;
                n2 = canvas3D.useSharedCtx ? canvas3D.screen.renderer.rendererBit : canvas3D.canvasBit;
                this.updateTexture(canvas3D, n2);
            }
            if (canvas3D.useSharedCtx) {
                canvas3D.makeCtxCurrent(canvas3D.ctx);
                Object object = this.resourceLock;
                synchronized (object) {
                    this.resourceUpdatedMask |= canvas3D.screen.renderer.rendererBit;
                    this.resourceLodUpdatedMask |= canvas3D.screen.renderer.rendererBit;
                }
            }
            Object object = this.resourceLock;
            synchronized (object) {
                this.resourceUpdatedMask |= canvas3D.canvasBit;
                this.resourceLodUpdatedMask |= canvas3D.canvasBit;
            }
        }
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this instanceof Texture3DRetained) {
                Texture3DRetained texture3DRetained = (Texture3DRetained)this;
                Texture3D texture3D = new Texture3D(texture3DRetained.mipmapMode, texture3DRetained.format, texture3DRetained.width, texture3DRetained.height, texture3DRetained.depth, texture3DRetained.boundaryWidth);
                this.mirror = (Texture3DRetained)texture3D.retained;
            } else if (this instanceof TextureCubeMapRetained) {
                TextureCubeMap textureCubeMap = new TextureCubeMap(this.mipmapMode, this.format, this.width, this.boundaryWidth);
                this.mirror = (TextureCubeMapRetained)textureCubeMap.retained;
            } else {
                Texture2D texture2D = new Texture2D(this.mipmapMode, this.format, this.width, this.height, this.boundaryWidth);
                this.mirror = (Texture2DRetained)texture2D.retained;
            }
            ((TextureRetained)this.mirror).objectId = -1;
        }
        this.initMirrorObject();
    }

    synchronized void initMirrorObject() {
        int n2;
        TextureRetained textureRetained;
        this.mirror.source = this.source;
        if (this instanceof Texture3DRetained) {
            textureRetained = (Texture3DRetained)this;
            ((Texture3DRetained)this.mirror).boundaryModeR = textureRetained.boundaryModeR;
            ((Texture3DRetained)this.mirror).depth = textureRetained.depth;
        }
        textureRetained = (TextureRetained)this.mirror;
        textureRetained.boundaryModeS = this.boundaryModeS;
        textureRetained.boundaryModeT = this.boundaryModeT;
        textureRetained.minFilter = this.minFilter;
        textureRetained.magFilter = this.magFilter;
        textureRetained.boundaryColor.set(this.boundaryColor);
        textureRetained.enable = this.enable;
        textureRetained.userSpecifiedEnable = this.enable;
        textureRetained.enable = this.enable;
        textureRetained.numFaces = this.numFaces;
        textureRetained.resourceCreationMask = 0;
        textureRetained.resourceUpdatedMask = 0;
        textureRetained.resourceLodUpdatedMask = 0;
        textureRetained.resourceInReloadList = 0;
        textureRetained.baseLevel = this.baseLevel;
        textureRetained.maximumLevel = this.maximumLevel;
        textureRetained.minimumLod = this.minimumLod;
        textureRetained.maximumLod = this.maximumLod;
        textureRetained.lodOffset = this.lodOffset;
        textureRetained.numSharpenTextureFuncPts = this.numSharpenTextureFuncPts;
        if (this.sharpenTextureFuncPts == null) {
            textureRetained.sharpenTextureFuncPts = null;
        } else {
            if (textureRetained.sharpenTextureFuncPts == null || textureRetained.sharpenTextureFuncPts.length != this.sharpenTextureFuncPts.length) {
                textureRetained.sharpenTextureFuncPts = new float[this.sharpenTextureFuncPts.length];
            }
            for (n2 = 0; n2 < this.sharpenTextureFuncPts.length; ++n2) {
                textureRetained.sharpenTextureFuncPts[n2] = this.sharpenTextureFuncPts[n2];
            }
        }
        if (this.filter4FuncPts == null) {
            textureRetained.filter4FuncPts = null;
        } else {
            if (textureRetained.filter4FuncPts == null || textureRetained.filter4FuncPts.length != this.filter4FuncPts.length) {
                textureRetained.filter4FuncPts = new float[this.filter4FuncPts.length];
            }
            for (n2 = 0; n2 < this.filter4FuncPts.length; ++n2) {
                textureRetained.filter4FuncPts[n2] = this.filter4FuncPts[n2];
            }
        }
        textureRetained.anisotropicFilterMode = this.anisotropicFilterMode;
        textureRetained.anisotropicFilterDegree = this.anisotropicFilterDegree;
        textureRetained.maxLevels = this.maxLevels;
        if (this.images != null) {
            for (n2 = 0; n2 < this.numFaces; ++n2) {
                for (int i2 = 0; i2 < this.maxLevels; ++i2) {
                    textureRetained.images[n2][i2] = this.images[n2][i2];
                    if (this.images[n2][i2] == null) continue;
                    this.images[n2][i2].addUser(textureRetained);
                }
            }
        }
    }

    boolean useAutoMipMapGeneration(Canvas3D canvas3D) {
        return this.mipmapMode == 1 && (this.minFilter == 1 || this.minFilter == 4 || this.minFilter == 5) && (canvas3D.textureExtendedFeatures & 0x10000) != 0;
    }

    void pruneImageUpdateInfo() {
        for (int i2 = 0; i2 < this.numFaces; ++i2) {
            for (int i3 = this.baseLevel; i3 <= this.maximumLevel; ++i3) {
                if ((this.imageUpdatePruneMask[i2] & 1 << i3) == 0) continue;
                if (this.imageUpdateInfo[i2][i3] != null) {
                    for (int i4 = 0; i4 < this.imageUpdateInfo[i2][i3].size(); ++i4) {
                        ImageComponentUpdateInfo imageComponentUpdateInfo = (ImageComponentUpdateInfo)this.imageUpdateInfo[i2][i3].get(i4);
                        if (imageComponentUpdateInfo.updateMask != 0) continue;
                        this.imageUpdateInfo[i2][i3].remove(i4);
                    }
                }
                int n2 = i2;
                this.imageUpdatePruneMask[n2] = this.imageUpdatePruneMask[n2] & ~(1 << i3);
            }
        }
    }

    void addImageUpdateInfo(int n2, int n3, ImageComponentUpdateInfo imageComponentUpdateInfo) {
        if (this.imageUpdateInfo == null) {
            this.imageUpdateInfo = new ArrayList[this.numFaces][this.maxLevels];
        }
        if (this.imageUpdateInfo[n3][n2] == null) {
            this.imageUpdateInfo[n3][n2] = new ArrayList();
        }
        ImageComponentUpdateInfo imageComponentUpdateInfo2 = new ImageComponentUpdateInfo();
        imageComponentUpdateInfo2.entireImage = imageComponentUpdateInfo == null;
        if (imageComponentUpdateInfo2.entireImage) {
            this.imageUpdateInfo[n3][n2].clear();
            if (this.imageUpdatePruneMask != null) {
                int n4 = n3;
                this.imageUpdatePruneMask[n4] = this.imageUpdatePruneMask[n4] & ~(1 << n2);
            }
        } else {
            imageComponentUpdateInfo2.x = imageComponentUpdateInfo.x;
            imageComponentUpdateInfo2.y = imageComponentUpdateInfo.y;
            imageComponentUpdateInfo2.z = imageComponentUpdateInfo.z;
            imageComponentUpdateInfo2.width = imageComponentUpdateInfo.width;
            imageComponentUpdateInfo2.height = imageComponentUpdateInfo.height;
        }
        imageComponentUpdateInfo2.updateMask = this.resourceCreationMask;
        this.imageUpdateInfo[n3][n2].add(imageComponentUpdateInfo2);
        if (this.imageUpdatePruneMask != null) {
            this.pruneImageUpdateInfo();
        }
    }

    void validate() {
        this.enable = true;
        for (int i2 = 0; i2 < this.numFaces && this.enable; ++i2) {
            for (int i3 = this.baseLevel; i3 <= this.maximumLevel && this.enable; ++i3) {
                if (this.images[i2][i3] != null) continue;
                this.enable = false;
            }
        }
    }

    synchronized void updateMirrorObject(int n2, Object object) {
        TextureRetained textureRetained = (TextureRetained)this.mirror;
        if ((n2 & 1) != 0) {
            textureRetained.enable = (Boolean)object;
        } else if ((n2 & 4) != 0) {
            Object[] objectArray = (Object[])object;
            int n3 = (Integer)objectArray[0];
            ImageComponent imageComponent = (ImageComponent)objectArray[1];
            int n4 = (Integer)objectArray[2];
            if (textureRetained.images[n4][n3] != null) {
                textureRetained.images[n4][n3].removeUser(this.mirror);
            }
            if (imageComponent == null) {
                textureRetained.images[n4][n3] = null;
            } else {
                textureRetained.images[n4][n3] = (ImageComponentRetained)imageComponent.retained;
                textureRetained.images[n4][n3].addUser(this.mirror);
            }
            textureRetained.resourceUpdatedMask = 0;
            textureRetained.addImageUpdateInfo(n3, n4, null);
        } else if ((n2 & 0x20) != 0) {
            Object[] objectArray = (Object[])object;
            ImageComponent[] imageComponentArray = (ImageComponent[])objectArray[0];
            int n5 = (Integer)objectArray[1];
            for (int i2 = 0; i2 < imageComponentArray.length; ++i2) {
                if (textureRetained.images[n5][i2] != null) {
                    textureRetained.images[n5][i2].removeUser(this.mirror);
                }
                if (imageComponentArray[i2] == null) {
                    textureRetained.images[n5][i2] = null;
                    continue;
                }
                textureRetained.images[n5][i2] = (ImageComponentRetained)imageComponentArray[i2].retained;
                textureRetained.images[n5][i2].addUser(this.mirror);
            }
            textureRetained.updateResourceCreationMask();
        } else if ((n2 & 0x40) != 0) {
            int n6 = (Integer)object;
            if (n6 < textureRetained.baseLevel) {
                for (int i3 = 0; i3 < this.numFaces; ++i3) {
                    for (int i4 = n6; i4 < textureRetained.baseLevel; ++i4) {
                        if (textureRetained.images[i3][i4] == null) {
                            textureRetained.enable = false;
                            continue;
                        }
                        textureRetained.addImageUpdateInfo(i4, i3, null);
                    }
                }
                textureRetained.baseLevel = n6;
                textureRetained.resourceUpdatedMask = 0;
            } else {
                textureRetained.baseLevel = n6;
                if (this.userSpecifiedEnable && !textureRetained.enable) {
                    textureRetained.validate();
                }
            }
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n2 & 0x80) != 0) {
            int n7 = (Integer)object;
            if (n7 > textureRetained.maximumLevel) {
                for (int i5 = 0; i5 < this.numFaces; ++i5) {
                    for (int i6 = textureRetained.maximumLevel; i6 < n7; ++i6) {
                        if (textureRetained.images[i5][i6] == null) {
                            textureRetained.enable = false;
                            continue;
                        }
                        textureRetained.addImageUpdateInfo(i6, i5, null);
                    }
                }
                textureRetained.maximumLevel = n7;
                textureRetained.resourceUpdatedMask = 0;
            } else {
                textureRetained.maximumLevel = n7;
                if (this.userSpecifiedEnable && !textureRetained.enable) {
                    textureRetained.validate();
                }
            }
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n2 & 0x100) != 0) {
            textureRetained.minimumLod = ((Float)object).floatValue();
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n2 & 0x200) != 0) {
            textureRetained.maximumLod = ((Float)object).floatValue();
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n2 & 0x400) != 0) {
            if (textureRetained.lodOffset == null) {
                textureRetained.lodOffset = new Point3f((Point3f)object);
            } else {
                textureRetained.lodOffset.set((Point3f)object);
            }
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n2 & 0x10) != 0) {
            textureRetained.updateResourceCreationMask();
        }
    }

    void notifyImageComponentImageChanged(ImageComponentRetained imageComponentRetained, ImageComponentUpdateInfo imageComponentUpdateInfo) {
        if (this.resourceCreationMask == 0) {
            if (this.imageUpdateInfo != null) {
                for (int i2 = 0; i2 < this.numFaces; ++i2) {
                    for (int i3 = 0; i3 < this.maxLevels; ++i3) {
                        if (this.imageUpdateInfo[i2][i3] == null) continue;
                        this.imageUpdateInfo[i2][i3].clear();
                    }
                    if (this.imageUpdatePruneMask == null) continue;
                    this.imageUpdatePruneMask[i2] = 0;
                }
            }
            return;
        }
        for (int i4 = 0; i4 < this.numFaces; ++i4) {
            boolean bl = false;
            for (int i5 = this.baseLevel; i5 <= this.maximumLevel && !bl; ++i5) {
                if (this.images[i4][i5] != imageComponentRetained) continue;
                this.resourceUpdatedMask = 0;
                this.addImageUpdateInfo(i5, i4, imageComponentUpdateInfo);
                bl = true;
            }
        }
    }

    void updateResourceCreationMask() {
        this.resourceCreationMask = 0;
    }

    void incTextureBinRefCount(TextureBin textureBin) {
        this.setTextureBinRefCount(textureBin, this.getTextureBinRefCount(textureBin) + 1);
        for (int i2 = 0; i2 < this.numFaces; ++i2) {
            for (int i3 = 0; i3 < this.maxLevels; ++i3) {
                ImageComponentRetained imageComponentRetained = this.images[i2][i3];
                if (imageComponentRetained == null || !imageComponentRetained.isByReference() && (imageComponentRetained.source == null || !imageComponentRetained.source.getCapability(3))) continue;
                textureBin.renderBin.addNodeComponent(imageComponentRetained);
            }
        }
    }

    void decTextureBinRefCount(TextureBin textureBin) {
        this.setTextureBinRefCount(textureBin, this.getTextureBinRefCount(textureBin) - 1);
        for (int i2 = 0; i2 < this.numFaces; ++i2) {
            for (int i3 = 0; i3 < this.maxLevels; ++i3) {
                ImageComponentRetained imageComponentRetained = this.images[i2][i3];
                if (imageComponentRetained == null || !imageComponentRetained.isByReference() && (imageComponentRetained.source == null || !imageComponentRetained.source.getCapability(3))) continue;
                textureBin.renderBin.removeNodeComponent(imageComponentRetained);
            }
        }
    }

    final void sendMessage(int n2, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 15;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n2);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 15;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(i2);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n2);
            j3dMessage.args[2] = object;
            ArrayList arrayList3 = (ArrayList)arrayList2.get(i2);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void handleFrequencyChange(int n2) {
        switch (n2) {
            case 1: 
            case 7: 
            case 11: {
                this.setFrequencyChangeMask(n2, n2);
            }
        }
    }

    void setUseAsRaster(boolean bl) {
        this.useAsRaster = bl;
    }

    boolean isUseAsRaster() {
        return this.useAsRaster;
    }

    int getTextureBinRefCount(TextureBin textureBin) {
        Integer n2 = this.textureBinRefCount.get(textureBin.renderBin);
        return n2 == null ? 0 : n2;
    }

    private void setTextureBinRefCount(TextureBin textureBin, int n2) {
        if (n2 == 0) {
            this.textureBinRefCount.remove(textureBin.renderBin);
        } else {
            this.textureBinRefCount.put(textureBin.renderBin, new Integer(n2));
        }
    }
}

