/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.text.ParseException;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XMLTokener;

public class XML {
    public static final Character AMP = new Character('&');
    public static final Character APOS = new Character('\'');
    public static final Character BANG = new Character('!');
    public static final Character EQ = new Character('=');
    public static final Character GT = new Character('>');
    public static final Character LT = new Character('<');
    public static final Character QUEST = new Character('?');
    public static final Character QUOT = new Character('\"');
    public static final Character SLASH = new Character('/');

    private XML() {
    }

    public static String escape(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
    }

    private static boolean parse(XMLTokener xMLTokener, JSONObject jSONObject, String string) throws ParseException {
        String string2;
        Object object = xMLTokener.nextToken();
        if (object == BANG) {
            char c = xMLTokener.next();
            if (c == '-') {
                if (xMLTokener.next() == '-') {
                    xMLTokener.skipPast("-->");
                    return false;
                }
                xMLTokener.back();
            } else if (c == '[') {
                xMLTokener.skipPast("]]>");
                return false;
            }
            int n = 1;
            do {
                if ((object = xMLTokener.nextMeta()) == null) {
                    throw xMLTokener.syntaxError("Missing '>' after '<!'.");
                }
                if (object == LT) {
                    ++n;
                    continue;
                }
                if (object != GT) continue;
                --n;
            } while (n > 0);
            return false;
        }
        if (object == QUEST) {
            xMLTokener.skipPast("?>");
            return false;
        }
        if (object == SLASH) {
            if (string == null || !xMLTokener.nextToken().equals(string)) {
                throw xMLTokener.syntaxError("Mismatched close tag");
            }
            if (xMLTokener.nextToken() != GT) {
                throw xMLTokener.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (object instanceof Character) {
            throw xMLTokener.syntaxError("Misshaped tag");
        }
        String string3 = (String)object;
        object = null;
        JSONObject jSONObject2 = new JSONObject();
        while (true) {
            if (object == null) {
                object = xMLTokener.nextToken();
            }
            if (!(object instanceof String)) break;
            string2 = (String)object;
            object = xMLTokener.nextToken();
            if (object == EQ) {
                object = xMLTokener.nextToken();
                if (!(object instanceof String)) {
                    throw xMLTokener.syntaxError("Missing value");
                }
                jSONObject2.accumulate(string2, object);
                object = null;
                continue;
            }
            jSONObject2.accumulate(string2, Boolean.TRUE);
        }
        if (object == SLASH) {
            if (xMLTokener.nextToken() != GT) {
                throw xMLTokener.syntaxError("Misshaped tag");
            }
            if (jSONObject2.length() == 0) {
                jSONObject.accumulate(string3, Boolean.TRUE);
            } else {
                jSONObject.accumulate(string3, jSONObject2);
            }
            return false;
        }
        if (object == GT) {
            while (true) {
                if ((object = xMLTokener.nextContent()) == null) {
                    if (string != null) {
                        throw xMLTokener.syntaxError("Unclosed tag " + string);
                    }
                    return false;
                }
                if (object instanceof String) {
                    string2 = (String)object;
                    if (string2.length() <= 0) continue;
                    jSONObject2.accumulate("content", string2);
                    continue;
                }
                if (object == LT && XML.parse(xMLTokener, jSONObject2, string3)) break;
            }
            if (jSONObject2.length() == 0) {
                jSONObject.accumulate(string3, Boolean.TRUE);
            } else if (jSONObject2.length() == 1 && jSONObject2.opt("content") != null) {
                jSONObject.accumulate(string3, jSONObject2.opt("content"));
            } else {
                jSONObject.accumulate(string3, jSONObject2);
            }
            return false;
        }
        throw xMLTokener.syntaxError("Misshaped tag");
    }

    public static JSONObject toJSONObject(String string) throws ParseException {
        JSONObject jSONObject = new JSONObject();
        XMLTokener xMLTokener = new XMLTokener(string);
        while (xMLTokener.more()) {
            xMLTokener.skipPast("<");
            XML.parse(xMLTokener, jSONObject, null);
        }
        return jSONObject;
    }

    public static String toString(Object object) {
        return XML.toString(object, null);
    }

    public static String toString(Object object, String string) {
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        if (object instanceof JSONObject) {
            if (string != null) {
                stringBuffer = new StringBuffer();
                stringBuffer.append('<');
                stringBuffer.append(string);
            }
            JSONObject jSONObject = (JSONObject)object;
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                Object object2 = jSONObject.get(string2);
                String string3 = object2 instanceof String ? (String)object2 : null;
                if (string == null || object2 instanceof JSONObject || string3 != null && string2 != "content" && (string3.length() > 60 || string3.indexOf(34) >= 0 && string3.indexOf(39) >= 0)) {
                    stringBuffer2.append(XML.toString(object2, string2));
                    continue;
                }
                if (string2.equals("content")) {
                    stringBuffer2.append(XML.escape(object2.toString()));
                    continue;
                }
                if (object2 instanceof JSONArray) {
                    JSONArray jSONArray = (JSONArray)object2;
                    int n = jSONArray.length();
                    for (int i = 0; i < n; ++i) {
                        stringBuffer2.append(XML.toString(jSONArray.get(i), string2));
                    }
                    continue;
                }
                stringBuffer.append(' ');
                stringBuffer.append(string2);
                stringBuffer.append('=');
                stringBuffer.append(XML.toString(object2));
            }
            if (string != null) {
                if (stringBuffer2.length() == 0) {
                    stringBuffer.append("/>");
                } else {
                    stringBuffer.append('>');
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append("</");
                    stringBuffer.append(string);
                    stringBuffer.append('>');
                }
                return stringBuffer.toString();
            }
            return stringBuffer2.toString();
        }
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                stringBuffer2.append(XML.toString(jSONArray.opt(i), string == null ? "array" : string));
            }
            return stringBuffer2.toString();
        }
        String string4 = object == null ? "null" : XML.escape(object.toString());
        return string == null ? "\"" + string4 + "\"" : "<" + string + ">" + string4 + "</" + string + ">";
    }
}

