/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffScrollButton;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class KunststoffScrollBarUI
extends MetalScrollBarUI {
    public static ComponentUI createUI(JComponent c2) {
        return new KunststoffScrollBarUI();
    }

    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new KunststoffScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new KunststoffScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    protected void paintThumb(Graphics g2, JComponent c2, Rectangle thumbBounds) {
        Rectangle rectShadow;
        Rectangle rectReflection;
        super.paintThumb(g2, c2, thumbBounds);
        ColorUIResource colorReflection = KunststoffLookAndFeel.getComponentGradientColorReflection();
        Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
        ColorUIResource colorShadow = KunststoffLookAndFeel.getComponentGradientColorShadow();
        Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
        if (this.scrollbar.getOrientation() == 1) {
            rectReflection = new Rectangle(thumbBounds.x + 1, thumbBounds.y, thumbBounds.width / 2, thumbBounds.height);
            rectShadow = new Rectangle(thumbBounds.x + thumbBounds.width / 2, thumbBounds.y, thumbBounds.width / 2 + 1, thumbBounds.height);
        } else {
            rectReflection = new Rectangle(thumbBounds.x, thumbBounds.y + 1, thumbBounds.width, thumbBounds.height / 2);
            rectShadow = new Rectangle(thumbBounds.x, thumbBounds.y + thumbBounds.height / 2, thumbBounds.width, thumbBounds.height / 2 + 1);
        }
        boolean isVertical = this.scrollbar.getOrientation() == 0;
        KunststoffUtilities.drawGradient(g2, colorReflection, colorReflectionFaded, rectReflection, isVertical);
        KunststoffUtilities.drawGradient(g2, colorShadowFaded, colorShadow, rectShadow, isVertical);
    }
}

