/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.io;

import com.itextpdf.text.io.RandomAccessSource;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamUtil {
    private StreamUtil() {
    }

    public static byte[] inputStreamToArray(InputStream is) throws IOException {
        int read;
        byte[] b2 = new byte[8192];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((read = is.read(b2)) >= 1) {
            out.write(b2, 0, read);
        }
        out.close();
        return out.toByteArray();
    }

    public static void CopyBytes(RandomAccessSource source, long start, long length, OutputStream outs) throws IOException {
        if (length <= 0L) {
            return;
        }
        long idx = start;
        byte[] buf = new byte[8192];
        while (length > 0L) {
            long n2 = source.get(idx, buf, 0, (int)Math.min((long)buf.length, length));
            if (n2 <= 0L) {
                throw new EOFException();
            }
            outs.write(buf, 0, (int)n2);
            idx += n2;
            length -= n2;
        }
    }
}

